;This file is copyright (c) 1992, Informant Communications Group and the 
;article author. The material here may be used in an application provided 
;that this copyright/disclaimer information is kept in the original source 
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assumes no responsibility 
;for the use or misuse of the material contained within.  
; 
;Contents        : Source file HILITE.SC 
;Author          : Brian McKinley - Motek Information Systems,
;                                   Beverly Hills, CA
;Informant Issue : August 1992
;Description     : Hilighting an entire field demo
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;-----------------------------------------------------------------------------

PROC FindFieldLength()
  PRIVATE
  FieldValue,                          ; Current value of the field
  AFieldType                           ; Field Type A,N,S,$

  CANVAS ON                            ; The canvas must be on for SYNCCURSOR to work
  FieldValue=[]                        ; Store the current value of the field.
  CtrlBackspace                        ; Clear the field
  AFieldType=SUBSTR(FieldType(),1,1)   ; Get the first letter of FieldType.
  SWITCH                               ; Fill the field with garbage.
    CASE FIELD()="#"    :
      SYNCCURSOR
      ColNum = COL(); Check for record number field in table view.
    CASE AFieldType="A":
      []=SPACES(NUMVAL(SUBSTR(FieldType(),2,LEN(FieldType())-1)))
    CASE AFieldType="D":
      []=12/22/2065                    ; Wife's 100th Birthday
    CASE AFieldType="S":
      []=-32000
    OTHERWISE           :
      []=-10000000000000000000000
  ENDSWITCH

  FieldView                            ; Enter Field View.
  Home                                 ; Move to the Beginning of the field.
  SYNCCURSOR
  COL1=COL()                           ; Save the upper left column.
  ROW1=ROW()                           ; Save the upper left row.
  End                                  ; Move to the End of the field.
  SYNCCURSOR
  COLN=COL()                           ; Save the lower right column.
  ROWN=ROW()                           ; Save the lower right row.
  IF ROW1<>ROWN THEN                   ; If the field is word wrapped, then
    Home  Right COLN=COL1              ; Move along the field until it drops
    SYNCCURSOR                         ; to the second line to determine the
    WHILE COL() > COLN                 ; right column.
      COLN=COL()
      Right
      SYNCCURSOR
    ENDWHILE
  ENDIF
  Enter                                ; Exit Fieldview

  IF NOT FIELD()="#" THEN              ; Check for the Number field in table view.
    CtrlBackspace                      ; Clear the field.
    []=FieldValue                      ; Restore the value of the field.
  ELSE
    COLN = ColNum
  ENDIF

ENDPROC

PROC SetFieldLengths(TableName,FormName,Scriptname)

  PRIVATE
 ; TableName       ; Name of the Table to use
 ; FormName        ; Name of the Form to use "F", "1" - "14" or "T" for Tableview
 ; ScriptName      ; Name of the Script to write the Array.
  maxfld,          ; The largest Colno() on the form.
  FieldLengths     ; Array of Field Lengths

  CREATE "Answer" LIKE TableName                     ; Make a temporary copy of the table
  IF FormName <> "T" THEN                            ; to avoid valchecks.
    COPYFORM TableName FormName "Answer" FormName    ; Copy the form
  ENDIF
  Edit "Answer"                                      ;
  IF FormName <> "T" THEN                            ; Pick the form
    PICKFORM FormName
  ENDIF
  CtrlHome
  maxfld=0
  WHILE RECNO()=1                                    ; Move through each field on the form
    IF COLNO()>maxfld                                ; in the first record, to find the
      THEN                                           ; max Column number.
      maxfld=COLNO()
    ENDIF
    Right
  ENDWHILE
  ARRAY FieldLengths[maxfld]        ; Define the array to store the field lengths.
  CtrlHome                          ; Move to the first field.
  WHILE RECNO()=2                   ; Move through each field on the form
    FindFieldLength()               ; in the second record and store the
                                    ; dimension in an array.

    FieldLengths[Colno()]=STRVAL(ROWN-ROW1)+","+STRVAL(COLN-COL1)
    Right
  ENDWHILE
  CancelEdit
  ClearAll
  Scriptname = ScriptName + ".SC"
  PRINT FILE Scriptname "  ARRAY FieldLengths[",maxfld,"]\n\n"
  FOR RETVAL FROM 1 TO maxfld                        ; write the array to a script.
  IF IsAssigned(FieldLengths[retval])
    THEN
    PRINT FILE ScriptName  "  FieldLengths[",RETVAL,"]=\""+FieldLengths[retval]+"\"\n"
  ENDIF
  ENDFOR

ENDPROC

PROC WaitTableHighlight(HighlightColor,CursorColor,Keypresses)
  PRIVATE
  ;HighlightColor  ; Color to Paint the Highlight Bar
  ;CursorColor     ; Color to Paint the Box Cursor
  ;Keypresses      ; Comma delimited string of numeric keycodes which will
                   ; end the wait. (Like an UNTIL statement for WAIT)
  ROW1,            ; Upper Left Row of Field
  COL1,            ; Upper Left Col of Field
  ROWN,            ; Lower Right Row of Field
  COLN,            ; Lower Right Col of Field
  CCol,            ; Cursor Col
  CRow,            ; Cursor Row
  ValidKeys,       ; Valid key presses
  Waitloop.b,      ; While loop variable
  Cursoroff.b,     ; Logical for Cursor control
  Fieldview.b      ; Logical for Fieldview()


  ECHO OFF
  Keypresses   = ","+Keypresses+","   ; Add comma's to the beginning and end of
                                      ; Keypresses so that the search will work
                                      ; properly.
  MovementKeys = ",13,-75,-77,-72,-80,-73,-81,-71,-79,9,-132,-118,-119,-117,-15,-82,-83"
                 ;Enter,Left,Right,Up,Down,PgUp,PgDn,Home,End,Tab,CtrlPgUp,CtrlPgDn,
                 ;CtrlHome,CtrlEnd,ReverseTab,Ins,Del
                 ;MovementKeys is used to determine when we leave a field.
  ValidKeys    = ",26,-44,6,-108,4,8,"
              ; Zoom Next, FieldView, Ctrl-D, BackSpace,
              ; Valid keys are ASCII keycodes less than 32 which you are
              ; allowed to press.
  ; Determine the size of the field.
  GetLength.b = True
  Cursoroff.b = False
  waitloop.b=True
  WHILE waitloop.b
    Fieldview.b = IsFieldView()
    Cursoroff.b = Fieldview.b AND Cursoroff.b
    CANVAS ON                 ; Canvas must be on for SYNCCURSOR to work.
    SYNCCURSOR                ; Canvas must be on for SYNCCURSOR to work.
    CANVAS OFF                ; Turn off the canvas
    CURSOR OFF                ; Turn the cursor off
    CRow=ROW()                ; Get the Cursor Row and Column locations
    CCol=COL()                ; to paint the cursor.
    IF GetLength.b THEN
      GetFieldLength()
    ENDIF
    GetLength.b = False
    ECHO NORMAL               ; Echo Normal followed by Echo Off will Paint
    ECHO OFF                  ; the workspace on canvas.
                              ; Highlight the field
    PaintCanvas ATTRIBUTE HighlightColor ROW1,COL1,ROWN,COLN
                              ; Paint the Cursor
    PaintCanvas ATTRIBUTE CursorColor CRow,CCol,CRow,CCol
    CANVAS ON                 ; Display the canvas
    SYNCCURSOR
    IF Cursoroff.b THEN       ; When in overwrite mode in field view, the
      CANVAS OFF              ; cursor is not displayed.
    ELSE
      CURSOR NORMAL           ; Display the cursor.
    ENDIF
    While not Charwaiting()
                              ; Screen Saver or inactivity routine.
    Endwhile
    kp=GETCHAR()              ; Get the next keypress
    key=","+STRVAL(kp)+","            ; Add comma's to the beginning and end of
                                      ; Kp so that the search will work
                                      ; properly.
    SWITCH
      ; Check for Keys in the KeyPresses List
      CASE kp = -82 and FieldView.b :        ; Insert
          Cursoroff.b = Cursoroff.b = False  ; If in overwrite mode in fieldview,
          KEYPRESS kp                        ; then turn the cursor off.  Press the insert Key
      CASE 0 < SEARCH(key,Keypresses) :      ; kp = a key in the Keypresses list.
        IF kp=27 THEN          ; Trap for the Esc key
          KEYPRESS kp          ; Press the Esc key and check the message window.
          IF WINDOW()="" THEN  ; If there is no message then we are in Zoom and
            LOOP               ; Do not want to exit the Wait loop.
          ENDIF
        ENDIF                  ; Otherwise the user has pressed a key in our list
        waitloop.b = False     ; and we should exit.
      CASE 0 < SEARCH(key,MovementKeys) :
        IF NOT IsFieldView() THEN     ; If we are in field view, then we have not
          GetLength.b = True          ; left the field. Otherwise, we have moved
        ENDIF                         ; moved to a new field and need the dimensions.
        KEYPRESS kp                   ; Press the movement key.
      CASE 0 < SEARCH(key,ValidKeys) :
        KEYPRESS kp                   ; Press the key.
        IF 0 < SEARCH(key,",-26,44,") THEN    ; Check for valid keys which move
          GetLength.b = True                  ; to a new field.
        ENDIF
      CASE kp > 31 :
        KEYPRESS kp                    ; If the ASCII keycode is greater than 31
                                       ; (Letters) or it is in the valid key list,
                                       ; then press the key.
    ENDSWITCH
  ENDWHILE
  IF IsFieldView() THEN
    Enter                              ; Exit field view.
  ENDIF
  RETURN kp
ENDPROC

PROC GetFieldLength()

  PRIVATE
  Fieldview.b,
  Undo.b

;Separate the Coordinates.
  RETVAL = MATCH(FieldLengths[ColNo()],"..,..",ROWS,COLUMNS)

  ROWS = NUMVAL(ROWS)   ; Convert the coordinates back to Numbers
  COLUMNS = NUMVAL(COLUMNS)
  Undo.b = Sysmode() = "CoEdit" and Not RecordStatus("Modified")
  FieldView.b = IsFieldView() ; Check for Fieldview
  FieldView
  Home                      ; Move to the beginning of the field
  CANVAS ON                 ; Canvas must be on for SYNCCURSOR to work.
  SYNCCURSOR                ; Canvas must be on for SYNCCURSOR to work.
  COL1 = COL()
  ROW1 = ROW()
  COLN = COL1 + COLUMNS
  ROWN = ROW1+ROWS
  IF FieldView.b THEN       ;If in fieldview then move back to the location.
    WHILE NOT (CRow = ROW() AND CCol = COL())
      Right
      SYNCCURSOR
    ENDWHILE
  ELSE
    Enter                   ; End FieldView.
    IF Undo.b THEN
      Undo                  ; Fieldview locks the record and sets it's status to
    ELSE                    ; modified. Undo unlocks the record and resets its status.
      Resynckey
    ENDIF
  ENDIF
  CANVAS OFF                ; Turn off the canvas

ENDPROC

;Example

TableName = "Cards"
FormName  = "F"
ScriptName= "Script"
SetFieldLengths(TableName,FormName,ScriptName)
PLAY ScriptName
VIEW TableName
PICKFORM FormName
Coeditkey
WaitTableHighlight(15,31,"-68,27")

