;This file is copyright (c) 1992, Informant Communications Group and the 
;article author. The material here may be used in an application provided 
;that this copyright/disclaimer information is kept in the original source 
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assumes no responsibility 
;for the use or misuse of the material contained within.  
; 
;Contents        : Source file GUIBUTON.SC 
;Author          : Tony Goodman - Ensemble Corporation
;Informant Issue : August 1992
;Description     : Buttons in a Wait Proc by ENSEMBLE CORPORATION
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;-----------------------------------------------------------------------------

; Buttons in a Wait Proc by ENSEMBLE CORPORATION

Createlib "ENSEMBLE"

Proc Button_Objects(ButtonDyn)
     Private I,WinAttrib,SystemInfo,WinHandle

     SysInfo to SystemInfo        ;We will want to know the Screen Height

     DynArray WinAttrib[]           ;Initalize Button Window Attributes
     WinAttrib["HasFrame"]=False    ;Remove the frame
     WinAttrib["HasShadow"]=False   ;3D GUI Buttons Look best with no shadow
     WinAttrib["Style"]=127         ;Canvas Color for button Text
     WinAttrib["Height"]=3          ;Button Height
     WinAttrib["CanvasHeight"]=3    ;Ditto
     WinAttrib["Width"]=8           ;Button Width (Up to 10 buttons will fit)
     WinAttrib["CanvasWidth"]=8     ;Ditto
     WinAttrib["OriginCol"]=(80 - DynArraysize(ButtonDyn)*WinAttrib["Width"])/2
                                    ;Left Column Button Panel
     WinAttrib["OriginRow"]=SystemInfo["ScreenHeight"]-4
                                    ;Place buttons near bottom of screen

     Foreach i in ButtonDyn

        ;Attach Button Method to Button via the Title Attribute;
        ;The title actually becomes a miniscript to be executed.
        WinAttrib["Title"]=ButtonDyn[i]+" ;METHOD"  ;Method Identifier

        Window Create  Floating
           Attributes WinAttrib
        To WinHandle

        GuiFrame(WinHandle,"Out")       ;Make a button look like a button
        ;Button Lable Text
        @ 1,1 ?? Format("W"+Strval(WinAttrib["Width"]-2)+",AC",I)

        ;Increment Origin Column for the next button
        WinAttrib["OriginCol"]=WinAttrib["OriginCol"]+WinAttrib["Width"]

    Endforeach

EndProc

Writelib "ENSEMBLE" Button_Objects
release Procs Button_Objects

Proc GuiFrame(WinHandle,In_Out)
     Private Color1,Color2,WinAttrib,H,W

     If In_Out="Out" then
        Color1=112   Color2=127
     else
        Color1=127   Color2=112
     endif

     Window Getattributes WinHandle to WinAttrib
     H=WinAttrib["CanvasHeight"]
     W=WinAttrib["CanvasWidth"]

     ;Draw The GUI Frame
     SetCanvas WinHandle
     Frame Single From 0,0  to H-1, W-1
     PaintCanvas Attribute Color2  0, 0, H-1, W-1
     PaintCanvas Attribute Color1  H-1, 1, H-1, W-2
     PaintCanvas Attribute Color1  0, W-1, H-1, W-1

EndProc
Writelib "ENSEMBLE" GUIFrame
Release Procs GUIFrame

Proc Button_Methods(TriggerType,EventRecord,CycleNumber)
     private WinHandle,WinAttrib

     ;Check to see if the mouse is clicking on a button Window
     WinHandle=WindowAt(EventRecord["Row"],EventRecord["Col"])
     If WinHandle >0 then
        Window Getattributes WinHandle to WinAttrib

        If Match(WinAttrib["Title"],"..;METHOD") then
           GUIFrame(WinHandle,"In")
             If EventRecord["Action"]="DOWN" then
               Sleep 100
             Endif
           GUIFrame(WinHandle,"Out")

           Execute WinAttrib["Title"]   ;Execute Button Method
           If isassigned(Retval) and
              (Retval=1 or Retval=2 or Retval=0) then
              Return Retval                ;Return a 0 or 1 or 2
           Else
              Return 1                     ;Return to Wait
           Endif
        Endif
     Endif
     Return 0                           ;Process the Mouse event normally
EndProc

Writelib "ENSEMBLE" Button_Methods
release Procs Button_Methods

;SAMPLE SCRIPT------------------------------------------------

;-- Define Buttons DynArray (10 Buttons Max)------------------
Dynarray Buttons[]

Dynarray Buttons[]
Buttons["Quit"]="Clearall Return 2"
Buttons["Monkey"]="Run \"C:\\\\DOS\\\\QBasic /Run C:\\\\DOS\\\\Gorilla\""
Buttons["Toggle"]="Formkey"
Buttons[">>"]="End"
Buttons[">"]= "PgDn"
Buttons["<"]= "PgUp"
Buttons["<<"]="Home"
Buttons["Find"]="Zoom"
Buttons["Sort"]= "OrderTable"
Buttons["Help"]="Help"

;-- Set Autolib --------------------------------------------
Autolib="ENSEMBLE"

;-- Put some images on the workspace ------------------------
Clearall
Menu {Tools} {Info} {Inventory} {Files} {*.*}
Formkey

;-- Put the Buttons on the workspace ------------------------
Button_Objects(Buttons)        ;Setup the Buttons

;-- Wait with an Event Proc ---------------------------------
WAIT Workspace
     Proc "Button_Methods"  Mouse "DOWN","AUTO"
ENDWAIT




