;2222222222222222222222222222222222222222222222222222222222222222222

Proc Guage()
;=======================================================================
;[                                                                     ]
;[   CopyRight Mark Horrocks, 1991                                     ]
;[   28 Parkside Cres, Leanyer, NT 0812                                ]
;[   Australia.                                                        ]
;[   Phone  country code 061 089 276 611.                              ]
;[   Compuserve mail number 100033,2533.                               ]
;[                                                                     ]
;[   This script may be freely used or distributed provided this       ]
;[   notice is retained.                                               ]
;[                                                                     ]
;[   A visual display of progress of long processes for people to      ]
;[   watch while they wait instead of staring at a blank screen.       ]
;[                                                                     ]
;[   This program consists of two sister procedures.                   ]
;[   The first proc is called guage(). It has no parameters.           ]
;[   Call guage() in your high level driver script for the process.    ]
;[   After each procedure completes, call update_guage(percent)        ]
;[   where percent_completed is your estimate of the time completed.   ]
;[                                                                     ]
;[   Your procedures should not clear the sceen.                       ]
;[                                                                     ]
;[                                                                     ]
;========================================================================

private i,                                 ; no pun intended
        n,                                 ; i and n are counters
        length,                            ; length of the guage
        trow,                              ; starting row
        tcol,                              ; starting column
        width                              ; width of the guage

; Initialise

length =  8
width  = 46
trow   =  8                                ; starting row
tcol   = 15                                ; starting column

Canvas Off                                 ; Turn the screen off

                                           ; Paint the background
PaintCanvas Fill Chr(222)                  ; top band
  Attribute 30
  0,0,1,79
PaintCanvas Fill Chr(176)                  ; band 2
  Attribute 78
  2,0,3,79
PaintCanvas Fill Chr(177)                  ; band 3
  Attribute 78
  4,0,6,79
PaintCanvas                                ; background
  Attribute 96
  7,0,24,79

x = 2
For N From 1 TO 23                         ; edges
   PaintCanvas Fill Chr(219)
     Attribute 4
     x,0,x,0
   PaintCanvas Fill Chr(219)
     Attribute 14
     x,1,x,1
   PaintCanvas Fill Chr(219)
     Attribute 4
     x,79,x,79
   PaintCanvas Fill Chr(219)
     Attribute 14
     x,78,x,78
   x = x + 1
Endfor

PainTcanvas Fill Chr(222)
   Attribute 30
   23,0,24,79

                                          ; Draw the guage
@ trow, tcol ?? Chr(201) + Fill(Chr(205),Width) + Chr(187)  ; Top Line

For i From 1 To Length - 1
  @ trow + i, tcol ?? Chr(186)             ; Edge lines
  @ trow + i, tcol + width + 1 ?? Chr(186)
Endfor
                                           ; Underline
@ trow + 2, tcol ?? Chr(204) + Fill(Chr(205),Width) + Chr(185)

@ trow+ length, tcol ?? Chr(200) + Fill(Chr(205),width) + Chr(188)

PaintCanvas Attribute 31 trow, tcol,        ; Paint the box
  trow + length, tcol + width + 1

PaintCanvas Fill("[") Attribute 16         ; Create the shadow
  trow + 1, tcol + width + 2,
  trow + length + 1, tcol + width + 2
PaintCanvas Fill("_") Attribute 96
  trow + length + 1, tcol + 1,
  trow + length + 1, tcol + width + 2

Style Attribute 30
@ trow + 1, tcol + 17 ?? "Process Guage"   ; Place the title
PaintCanvas Fill("0") Attribute 30         ; Paint guage background
  trow + 4, tcol + 3, trow + 4, tcol + width - 2

@ trow + 6, tcol + 3 ?? "0%"
@ trow + 6, tcol + width - 5 ?? "100%"

Style                                       ; reset style
Canvas On                                   ; admire our work
EndProc

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                        ; Sister script for guage, used to update guage.

Proc Update.Guage(Percent_Complete)

                        ; Copyright Mark Horrocks, 1991

Private
   trow,
   tcol,                ; starting point of guage
   ypoint,
   width                ; width of guage

; Initialise
                        ; variables must be the same as guage()
trow  =  8
tcol  = 15
width = 46

  If Type(percent_complete) <> "N" then
     beep
     message "Guage % parameter must be numeric!"
     sleep 2000 return
  Endif

  If percent_complete < 0 then
     percent_complete = 0
  Endif

  If percent_complete > 100 then
     percent_complete = 100
  Endif

ypoint = tcol + Int(((width - 2) * Percent_Complete/100))

PaintCanvas Fill("[")
   Attribute 21
   trow + 4, tcol + 3, trow + 4, ypoint

EndProc
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Guage()

For i From 1 To 100
Update.Guage(i)
Sleep 100
Endfor
x = Getchar()

