Createlib "Gold1"
Libname.a = "Gold1"
; ͻ
;                                                                           
;         Written By Harry Goldman                                          
;         DataBase Designs, Inc.                                            
;         (v) (708) 215-8318 (f) 708-215-0314 , Compuserve 72020,2321       
;         Copyright 1990                                                    
;         All Rights Resevered                                              
;                                                                           
;     This program  can be modifeid and enhanced freely as                  
;   long as the copyright and original program credits are maintained.      
;   If you enhance or modify this program, feel free to let me know,        
;   you will be credited in the next release. Resale of this program        
;   is prohibited without the written permission of the author              
;                                                                           
; ͹
; Special Thanks to Alan Zenreich, Dan Paolini and Phil Goulson for their   
; ideas and support.                                                        
; ͼ

Clearall
@ 0,0 ?? Format("W80,AC","Creating Gold1 Library")
@ 1,0 ?? Fill("\205",80)        ; IBM Graphics horizontal line

PaintCanvas Attribute 111 0,0, 1,79
@ 9,0 ?? "Playing Script GOLDUTL1 "

; ---------------------------------------------------------------------------
; Main Menu
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc GoldMain.u()
Private MainChoice.a                               ; Menu Choice

Procname.a = "GoldMain.u"

Array MenuItems.r[40]                             ; Store Menu seleections
                                                  ; in an array. Use a base
MenuItems.r[10] = "Main Menu"                     ; 10 system to identify
MenuItems.r[11] = "Table Size / Record Size"      ; nesting levels where
MenuItems.r[12] = "Objects"                       ; item LEVEL*10 is the
MenuItems.r[13] = "Field Descriptions"            ; menu title
MenuItems.r[14] = "Configure"
MenuItems.r[15] = "Quit"

MenuItems.r[20] = "Object Menu"
MenuItems.r[21] = "Forms"
MenuItems.r[22] = "Reports"
MenuItems.r[23] = "Previous Menu"

MenuItems.r[30] = "Print Menu"
MenuItems.r[31] = "Print Output File"
MenuItems.r[32] = "Do Not Print"
PW.l = False
ErrorCode.n = 0

While True                                        ; Loop until the user quits
   GoldHeader.u()

   Roll.l = True
   Level.n = 1
   Menu.u(8,20,35,Level.n,True)                         ; Menuing routine
   MenuChoice.a = Retval                          ; returns the menu choice

   Switch
      Case MenuChoice.a = 13 : Loop                     ; [Enter]
      Case MenuChoice.a = 27 Or MenuChoice.a = 5 Or     ; [Esc]
       MenuChoice.a < 1 :
         Cursor Normal                                  ; restore cursor
         Return
      Case MenuChoice.a = 1 : Recsize.u()        ; 1
      Case MenuChoice.a = 2 : ObjMain.u()        ; 2
      Case MenuChoice.a = 3 : ValCheck.u()       ; 3
      Case MenuChoice.a = 4 : Cfg.u()            ; 4
      Otherwise : Beep                           ; All other keys
                  Loop
   Endswitch
Endwhile
Endproc
Writelib LIBNAME.a GoldMain.u
Release Procs GoldMain.u
?? "."
; ---------------------------------------------------------------------------
; Object Menu
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc ObjMain.u()
Private ObjChoice.a                               ; Menu Choice

Procname.a = "ObjMain.u"

Cursor Off
While True                                        ; Loop until the user quits
   Canvas Off
   @ 17,0 Clear EOS
   PaintCanvas Attribute 111 17,0,24,79

   Level.n = 2
   Roll.l = True
   Menu.u(11,25,25,level.n,True)                  ; Menuing routine
   ObjChoice.a = Retval                           ; returns menu selection

   Switch
      Case ObjChoice.a = 13 : Loop                     ; [Enter]
      Case ObjChoice.a = 27 Or ObjChoice.a = 3 Or      ; [Esc]
       ObjChoice.a < 1 :
         Return
      Case ObjChoice.a = 1 :
         Print_Objects.u("Forms","*.f*")
      Case ObjChoice.a = 2 :
         Print_Objects.u("Report","*.r*")
      Otherwise : Beep                                  ; All other keys
                  Loop
   Endswitch
Endwhile
Cursor Normal
Endproc
Writelib LIBNAME.a ObjMain.u
Release Procs ObjMain.u
?? "."
;-------------------------------------------------------------------------
; Utility To Document Record and Block Sizes
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
;-------------------------------------------------------------------------
Proc Recsize.u()
   private DDir.a,                                ; New directory
           Origdir.a,                             ; Original directory
           LoopDir.l,
           DirCount.n,
           Skip.a

DDir.a     = Directory()                         ; Save the current directory
OrigDir.a  = DDir.a                              ; so that we can return to
WDir.a     = DDir.a                              ; it later
LoopDir.l  = False
Skip.a = ""
DirCount.n = 1
RecFile.a  = OrigDir.a + "RecFile"                ; Set up the output file
Dircontrol.l = True                               ; Determines if GetDir.u()
                                                  ; Should prompt for dir.
CkFile.u(RecFile.a)                               ; Check for the output file

While True                                        ; Check if the user has
   If Not LoopDir.l Then                          ; asked to loop through all
      GetDir.u(19,17,DirControl.l)                ; directories. If not, get
      DirControl.l = True
      If Not Retval Then                          ; an new data directory.
         Quitloop                                 ; User pressed [Esc], quit
      Endif                                       ; Looping is in effect :
   Else                                           ; increment the counter
      DirCount.n = DirCount.n + 1                 ; make sure that we are
      If Not Isassigned(Dirs.r[DirCount.n]) Then  ; on a valid array entry
         Quitloop                                 ; if we are, go ahead
      Else                                        ; otherwise we are done
         DDir.a = Dirs.r[DirCount.n] + "\\"
      Endif
   Endif

   GetTblNames.u("Tables")                        ; Get the table names

   If Isempty("List") Then                        ; No Tables found ?
      Message.u(RevMtr.n,
         "No Tables To Report On in "+DDir.a,2,-1,True)  ; Message the
      DirControl.l = False
      Loop                                        ; user and loop to the top
   Endif

   Clear                                          ; Clear the canvas
   Clearall                                       ; Clear the workspace
   CopyForm Path.a+"L1" 2 "List" 1                ; Get a form to use
   View "List"                                    ; View the data

   If LoopDir.l Then
      Scan
         GetTblInfo.u(DDir.a +[Name],True)
      Endscan
   Else
      WHILE true
         If Form() <> "1" Then                    ; Display the proper image
            PickForm 1
         Endif
         Wait Table
            Prompt Format("W80,AC",
                     "TABLE / RECORD SIZE UTILITY, Directory ="+ DDir.a),
                  Format("W80,AC",
                     "Press [Enter] To Select, [F2] Print All, [Esc] To Quit")
            Until "F2", "Enter", "Esc"
         Switch
            Case Retval = "Esc" :                    ; Quit
               Quitloop
            Case Retval = "Enter" :                  ; Select one record
               GetTblInfo.u(DDir.a + [Name],False)
            Case Retval = "F2" :                     ; Select all records
               Scan
                  GetTblInfo.u(DDir.a +[Name],True)
               Endscan
            Otherwise : Beep
         Endswitch
      EndWhile
      GoldHeader.u()
      Menu.u(8,20,35,1,False)
   Endif
Endwhile

If IsFile(RecFile.a) Then
   PrtFile.u(18,33,RecFile.a)                    ; Should the file be output
Endif                                            ; to the printer ??
SetDir OrigDir.a

Endproc
Writelib Libname.a Recsize.u
Release Procs Recsize.u
?? "."
; ---------------------------------------------------------------------------
; Get information on a Table and either display it or print it or both
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
proc GetTblInfo.u(Tbl.a,Prt.l)
private Tbl.a,                                ; Current Table
        Prt.l,                                ; Logical, Print A Report ?
        RecSize.n,                            ; Total Record Size
        Keyed.l,                              ; Logical, Is Table Keyed ?
        Fldsize.n,                            ; Size of Current Field
        Realsize.n,                           ; 'Real' Size Of Record
        BlkSize.n,                            ; Block Size
        Bytesover.n,                          ; # Bytes Over K
        Resp.n,                               ; User Response
        FldCount.n,                           ; Number Of Fields In Table
        BlkVersion.n,                         ; Min. Blk Size, Version Dependent
        Blocks.n,                             ; Number of blocks
        Index.l,
        Tblname.a,
        OldTbl.a,
        OldForm.n,
        OldRec.n

RemoteTbl.a = ""

If Skip.a = Tbl.a Then
   Return
Endif
Tblname.a = []
If PW.l Then
   OldTbl.a = Table()
   OldForm.n = Form()
   OldRec.n = Recno()
   Reset
   View OldTbl.a
   PickForm OldForm.n
   Moveto record OldRec.n
Endif
CheckTbl.l(Tbl.a,True)                        ; Check if we can access this
If Not Retval Then                            ; table
   Skip.a = Tbl.a
   Return
Endif

View Tbl.a
ClearImage
Clear
If Not IsBlank(RemoteTbl.a) Then
   Message.u(RegMtr.n,"Analyzing "+RemoteTbl.a+" table...",0,0,False)
Else
   Message.u(RegMtr.n,"Analyzing "+tbl.a+" table...",0,0,False)
Endif

{Tools} {Info} {Structure} Select Tbl.a           ; Get the table structure
Keyed.l = (Search("*",[Field Type]) > 0)          ; Is this table keyed ?
RecSize.n = 0
FldCount.n = 0

; Get the size in bytes of each field in the table based on the field
; type. If the field is Alpha, parse it to determine the size. Hold a
; copy of each record in an array using CopyToArray so that the detail
; can be printed later.

; ͻ
; An Alternate method proposed by Phil Goulson is:                         
; Get the field size, dependent on the type by stripping out the * if the  
; field in keyed, then match up against a list of field types to get the   
; number of bytes in a field.                                              
;                                                                          
; FldType.a = [Field Type]                                                 
; Sign.l = Match(FldType.a,"..*",FldType.a)       ; Remove the * if present
; If Not Match("$8N8S2D4","..+FldType.a+"@..",Trash.u,FldSize.n) Then      
;    FldSize.n = Substr(FldType.a,2,Len(Fldtype.a)-1)                      
; Endif                                                                    
; Fldsize.n = Numval(FldSize.n)                                            
;                                                                          
; ͼ

Scan
    Switch
      Case Search("$",[Field Type]) <> 0 : Fldsize.n = 8
      Case Search("N",[Field Type]) <> 0 : Fldsize.n = 8
      Case Search("S",[Field Type]) <> 0 : Fldsize.n = 2
      Case Search("D",[Field Type]) <> 0 : Fldsize.n = 4
      Otherwise :
         IF Search("*",[Field Type]) <> 0 Then
            Fldsize.n = Numval(Substr([Field Type],2,Len([Field Type])-2))
         Else
            Fldsize.n = Numval(Substr([Field Type],2,Len([Field Type])-1))
         Endif
   Endswitch
   RecSize.n = RecSize.n + Fldsize.n                 ; Accumulate record size
   FldCount.n = FldCount.n + 1                       ; Count the fields
   Execute "CopyToArray Fld" + Strval(FldCount.n)    ; Save the data
Endscan
ClearImage

IF Keyed.l Then                             ; If the table is keyed, the
   Realsize.n = RecSize.n * 3               ; blocksize will be based on
Else                                        ; the space 3 records will fit
   Realsize.n = RecSize.n                   ; into
Endif

If Version() < 3.5 Then                     ; Check the version number.
   BlkVersion.n = 1024                      ; In versions before 3.5 the
Else                                        ; smallest block was 1K. In 3.5
   BlkVersion.n = 2048                      ; the smallest block is 2K
Endif

; Determine the blocksize based on the record size. If the table is keyed,
; the block size willl be the smallest block that 3 records will fit in.

Switch
   Case Realsize.n <= BlkVersion.n - 6     : BlkSize.n = BlkVersion.n
   Case Realsize.n <= (BlkVersion.n*2) - 6 : BlkSize.n = 2048
   Case Realsize.n <= (BlkVersion.n*3)- 6  : BlkSize.n = 3072
   Otherwise                               : BlkSize.n = 4096
Endswitch

; Determine the number of bytes over the block size this record is.

IF Keyed.l Then
   Bytesover.n = ROUND((Realsize.n - (BlkSize.n - BlkVersion.n)) / 3,0) + 1
Else
   Bytesover.n = Realsize.n - (BlkSize.n - BlkVersion.n)
Endif

If Nrecords(Tbl.a) > 0 Then
   a = Int((BlkSize.n-6)/RecSize.n)
   b = NRecords(Tbl.a)
   c = Round(b/a+.5,0)
   Blocks.n=Round(NRecords(Tbl.a)/Int((BlkSize.n-6)/RecSize.n) +.5,0)
Else
   Blocks.n = 0
Endif

If ErrorCode() = 29 Then
   Return
Endif

Index.l = False
Isize1.u(Tblname.a)
If Retval Then
   Index.l = True
   ISize2.u(Tblname.a)
Endif
View "List"
Pickform "1"
Locate Tblname.a

; If the user wants to print all tables to the printer, do not display the
; data to the screen as it will confuse the user. Otherwise display the
; data on the screen and prompt the user.

If Not Prt.l Then
   Canvas Off
   Setmargin 15
   @ 3,15
   If Not IsBlank(RemoteTbl.a) Then
      ? "Table Name = ", RemoteTbl.a, "  REMOTE TABLE "
   Else
      ? "Table Name = ", Tbl.a
   Endif
   ? "Record Size        : ", RecSize.n, " bytes"
   ? "Keyed              : ", Format("LY",Keyed.l)
   ? "Secondary Indicies : ", Format("LY",Index.l)
   ? "Block Size         : ", BlkSize.n / 1024, "K"
   ? "Recs Per Block     : ", Int((BlkSize.n - 6) / RecSize.n)
   ? "There are ", Mod(BlkSize.n - 6, RecSize.n),
     " wasted bytes in the block."
   ? " Or ",Round((Mod(BlkSize.n - 6, RecSize.n) /
      Int((BlkSize.n - 6) / RecSize.n))+.05,2)," wasted bytes per record"
   If BlkSize.n > BlkVersion.n Then
      ? "Trim the record size by ", Bytesover.n,
         " bytes to reduce the "
      ? "block size by 1K."
   Endif
   ? " "
   If Not Keyed.l Then
      ? " "
   Endif
   ? "File Stats :            Records : ",
      Format("W14,AR,EC",Nrecords(Tbl.a))
   ? "                  Blocks In Use : ",
      Format("W14,AR,EC",Blocks.n)
   If Keyed.l Then
      ? "        Primary Index File Size : ",
         Format("W14,AR,EC", Filesize(Tbl.a + ".PX"))
   Endif
   ? "               Actual File Size : ",
      Format("W14,AR,EC",Filesize(Tbl.a + ".DB"))
   ? "            'Optimal' File Size : ",
      Format("W14,AR,EC",(BlkSize.n * Blocks.n) + BlkVersion.n)
   ? "     Total Unclaimed Disk Space : ",
      Format("W14,AR,EC",
      Max(0,Filesize(Tbl.a+".DB")-((BlkSize.n*Blocks.n)+BlkVersion.n)))
   ? "        Total Wasted Disk Space : " ,
      Format("W14,AR,EC",Mod(BlkSize.n - 6, RecSize.n) * Blocks.n)

   While Charwaiting()                     ; Clear the keyboard buffer
      Resp.n = Getchar()
   Endwhile
   Setmargin off

   @23,16 ?? "Press [P] To Print, Any Other Key To Continue"
   Style Blink
   ?? "..."
   Style
   Canvas On
   Cursor Normal
   Resp.n = GETCHAR()                          ; Get the users' response
   Cursor Off
Endif
                                                     ; Check if the user
If Prt.l Or Resp.n = 80 Or Resp.n = 112 Then         ; wants printed output
   If Not Isblank(RemoteTbl.a) Then
      Message.u(RegMtr.n,"Saving Table Structure For "+RemoteTbl.a+
        " To Print File",0,0,False)
   Else
      Message.u(RegMtr.n,"Saving Table Structure For "+Tbl.a+" To Print File",
             0,0,False)
   Endif
   PrtRpt.u()                                        ; Call the print routine
Endif
EndProc
Writelib Libname.a GetTblInfo.u
Release Procs GetTblnfo.u
?? "."
; ---------------------------------------------------------------------------
; Based in part on Objects.sc by Gordon W. Schaad
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------

Proc print_Objects.u(Object.a,Wild.a)
Private   Tbl.a,           ; The table containing the forms or reports
          Rpt.a,           ; The name of the form or report
          Title.a,         ; The description of the form or report
          Numrecs.n,       ; Number of reports or forms
          x.l,             ; Temp storage of match result
          Pattern.a,       ; Pattern for match function
          j,               ; Counter for loop
          Choice.a,        ; Result of menu selection
          Object.a,        ; Form or Report
          Wild.a,          ; Pattern for Filename list
          Rptfile.a,       ; Name of file to receive list
          Linked_Tables.r, ; Array to store linked table names
          DDir.a,          ; Name of directory with reports
          OrigDir.a,       ; Name of original orking directory
          OldTbl.a,        ; Previous Table Name
          LineCount.n,     ; Number of lines printed on a page
          Pobject.a,
          OldTbl.a, OldForm.n, OldRec.n, Skip.a

; Initialize

DDir.a = Directory()
OrigDir.a = DDir.a
WDir.a = DDir.a
LoopDir.l = False
DirCount.n = 1
Skip.a = ""

If Object.a = "Forms" Then
   Pattern.a = "\"..\\.F..\""
   Pobject.a = "Forms"
Else
   Pattern.a = "\"..\\.R..\""
   Pobject.a = "Reports"
Endif

DirControl.l = True

RptFile.a = OrigDir.a + "L" + Object.a
CkFile.u(RptFile.a)

While True
   Canvas Off
   If Not LoopDir.l Then                          ; asked to loop through all
      GetDir.u(19,17,DirControl.l)                ; directories. If not, get
      DirControl.l = True                         ; an new data directory.
      If Not Retval Then                          ; User pressed [Esc], quit
         Quitloop                                 ; Looping is in effect :
      Endif
   Else                                           ; increment the counter
      DirCount.n = DirCount.n + 1                 ; make sure that we are
      If Not Isassigned(Dirs.r[DirCount.n]) Then  ; on a valid array entry
         Quitloop                                 ; if we are, go ahead
      Else                                        ; otherwise we are done
         DDir.a = Dirs.r[DirCount.n] + "\\"
      Endif
   Endif

   Canvas On
   GetTblNames.u(Wild.a)          ; Get a list of table names

   If Isempty("List") Then
      Message.u(RevMtr.n," No " + Pobject.a + " found in " + DDir.a,2,-1,True)
      DirControl.l = False
      Loop
   Endif

   View "List"                                        ; Display the list

   Scan                                          ; Scan the directory
      Print File Rptfile.a "\f", GoldPSetup.a, "\n\n\n",
                Format("W80,AC",Pobject.a+" in "+Upper(DDir.a))+"\n"
      Print File Rptfile.a Format("W80,AC",Fill("\205",40)) + "\n\n"
      Numrecs.n = Nrecords(Table())
      OldTbl.a = ""                              ; initialize

      ErrorCode.n = 0
      Style Reverse                              ; Inform the user of progress
      @ 23,0 ?? Fill (" ",80)
      @ 23,0 ?? Format("W40,AR","Processing "+Object.a+" "+Strval(Recno())+
         " Of "+Strval(Numrecs.n))
      Style

      Execute "x.l = Match([Name],"+Pattern.a+",Tbl.a,Rpt.a)" ; Parse the file
      If Rpt.a = "" Then                                      ; name
         If Object.a = "Forms" Then              ; Is this a form or a
            Rpt.a = "F"                          ; Report we want ?
         Else
            Rpt.a = "R"
         Endif
      Endif

      If Upper(Rpt.a) = "PT" Then                ; Check for stray RPT files
         Loop
      Endif
                                                 ; Add the directory name to
      Tbl.a = DDir.a + Tbl.a                     ; the table name
      If Not Istable(tbl.a) Then                 ; make sure the table still
         Loop                                    ; exists. If not, loop
      Endif
      If Skip.a = Tbl.a Then                     ; If this is a table to skip
         Loop                                    ; do so by looping
      Endif
      If PW.l Then                               ;
         OldTbl.a = Table()                      ;
         OldForm.n = Form()                      ;
         OldRec.n = Recno()                      ;
         Reset                                   ;
         View OldTbl.a
         PickForm OldForm.n
         Moveto record OldRec.n
      Endif
      CheckTbl.l(Tbl.a,False)                    ; Check access to the table
      If Not Retval Then                         ; if we do not have access
         Skip.a = Tbl.a                          ; skip the table
         Loop
      Endif

      Menu Select Object.a                       ; Get the description
      If ErrorCode.n = 99 Then                   ; of the object we are
         CtrlBreak                               ; documenting
         Loop
      Endif
      {Change} Select Tbl.a Select Rpt.a
      Title.a = MenuChoice()                     ; Save the description
      CtrlBreak

      If Tbl.a <> OldTbl.a Then                      ; If this is a new table
         Print File Rptfile.a "\n"                   ; Print the table name
         Print File Rptfile.a Spaces(5) + "Table : " + Upper(Tbl.a) + "\n"
         Print File Rptfile.a Spaces(5) +  Fill("\196",Len(Tbl.a) + 9)+"\n\n"
      Endif
      OldTbl.a = Tbl.a
      Print File Rptfile.a Spaces(10) + Object.a + " " + Rpt.a +
      ": " + Title.a + "\n"
      Print File Rptfile.a Spaces(10)+Fill("\196",Len(Title.a) + 11)+"\n\n"
      Print_Reports()                                ; Check for multi table
      If Object.a = "Forms" Then
         GetFieldData.u(Tbl.a,Rpt.a,23)
      Else
         GetRptData.u(Tbl.a,Rpt.a)
         GetFieldData.u(Tbl.a,Rpt.a,0)
      Endif
   EndScan                                           ; objects
   Beep
   @ 23,0 Clear EOS
   PaintCanvas Attribute 111 23,0,23,79          ; Repaint the screen
Endwhile

If IsFile(RptFile.a) Then
   PrtFile.u(18,33,RptFile.a)                    ; Should the file be output
Endif
                                                 ; to the printer ??
Setdir OrigDir.a
Return
Endproc

Writelib Libname.a Print_Objects.u
Release Procs Print_Objects.u
?? "."
; ---------------------------------------------------------------------------
; Routine to print report information to an output file
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------

Proc Print_Reports()
   private j
If Object.a = "Report" Then                            ; Is this a multi-
   If IsMultiReport(Tbl.a,Rpt.a) Then                  ; table report ?
      ReportTables Tbl.a Rpt.a Linked_Tables.r         ; Capture the embeded
      Print File Rptfile.a "\n"                        ; Carrige Return
      Print File RptFile.a Spaces(24) + "Linked Tables : " + "\n"
      Print File Rptfile.a Spaces(24) +  Fill("\196",15) + "\n"
      For j From 1 to Arraysize(Linked_Tables.r)
         Print File RptFile.a Spaces(Int(40)) + Linked_Tables.r[j]+"\n"
      Endfor
      Print File Rptfile.a "\n"                        ; Carrige Return
   Endif
Else                                                   ; Is this a multi
   If IsMultiForm(Tbl.a,Rpt.a) Then                    ; table form ?
      FormTables Tbl.a Rpt.a Linked_Tables.r           ; Capture the embeded
      Lock Tbl.a FL                                    ; table names
      If Not Retval Then
         Message.u(BlkMtr.n,"Cannot Access Objects For "+Tbl.a,2,1,True)
         Message.u(BlkMtr.n,"Contuniung To The Next Objects",2,1,True)
      Else

; ---------------------------------------------------------------------------
; Make sure that there are no required fields while processing.
; Thanks To Stephen Urbach for catching this.
;
; Start Coedit mode. This will allow a form to be picked even if the
; table is empty
; ---------------------------------------------------------------------------

         CoEdit Tbl.a                               ; Get the table
         RequiredCheck Off                          ; turn off requiredcheck
         Pickform Rpt.a                             ; get the form
         Print File Rptfile.a "\n"                  ; print a Carrige Return
         Print File RptFile.a Spaces(24) + "Linked Tables : " + "\n"
         Print File Rptfile.a Spaces(24) +  Fill("\196",15)
         If Retval < 2 Then
            Print File RptFile.a Spaces(Int(40))
            Print File RptFile.a "Linked Files Cannot Be Determined"
            Print File Rptfile.a "\n"                    ; Carrige Return
            Print File RptFile.a Spaces(Int(40))
            Print File RptFile.a "Missing Linked Table Or Corrupted Form"
         Else
            For j From 1 to Arraysize(Linked_Tables.r) ; Loop through all
               Moveto Linked_Tables.r[j]               ; embeded tables and
               RequiredCheck Off
               Print File RptFile.a Spaces(Int(40)) +
                 Linked_Tables.r[j]+" - Form "+ Form()+"\n"
            Endfor
         Endif
         Do_It!
      Endif
      Unlock Tbl.a FL
      Clearimage
      Print File Rptfile.a "\n"                        ; Carrige Return
   Endif
Endif
RequiredCheck On
Return
EndProc
Writelib Libname.a Print_Reports
Release Procs Print_Reports
?? "."
; ---------------------------------------------------------------------------
; Procedure to document Value Checks for a given table
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc ValchkInfo.u(Tbl.a)
   private Tbl.a,                      ; Table Name
           Nf.n,                       ; Number of fields in the table
           Resp.n,                     ; User response
           Linecount.n,                ; Line counter
           LValue.a,                   ; Low value
           HValue.a,                   ; High value
           Default.a,                  ; Default value
           TLookup.a,                  ; Table Lookup
           Pic.a,                      ; Picture
           Req.a,                      ; Required field
           OldTbl.a, OldForm.n, OldRec.n,
           Format1.a, Format2.a, Format3.a

Procname.a = "ValchkInfo.u"

Message.u(RegMtr.n,"Analyzing "+Tbl.a+" Table...",0,0,False)
Linecount.n = 13
PrintValHeader.u()

If PW.l Then
   OldTbl.a = Table()
   OldForm.n = Form()
   OldRec.n = Recno()
   Reset
   View OldTbl.a
   PickForm OldForm.n
   Moveto record OldRec.n
Endif
CheckTbl.l(Tbl.a,False)             ; Make sure that we have access
                                    ; to the table. If we do not have access
If Not Retval Then                  ; message the user
   Print File OrigDir.a+"FldList" Fill(" ",15)
   Print File OrigDir.a+"FldList"
          "Table is password protected, cannot access" + "\n\n"
   Print File OrigDir.a+"FldList" "\f"
   Skip.a = Tbl.a
   Return False
Endif

Nf.n = Nfields(Tbl.a)                       ; Get the number of fields

Edit Tbl.a                                           ; Edit the table
If Errorcode() = 3                                   ; If we cannot access
   Or ErrorCode() = 4                                ; the table, message the
   Or ErrorCode() = 35 Then                          ; user and print a
   CtrlBreak                                         ; message in the print
   Print File OrigDir.a+"FldList" Fill(" ",15)       ; file and then return
   Print File OrigDir.a+"FldList"
          "Cannot Access The Table" + "\n\n"
   Print File OrigDir.a+"FldList" "\f"               ; Page Break
   Return
Endif

RequiredCheck Off
For n From 1 to Nf.n                              ; Loop through all fields
   @ 1,0 ?? "Field ", n, " Of ", Nf.n             ; Progress report
   Right
   Menu {Valcheck} {Define} Enter {LowValue}      ; Get the ValCheck Data
   LValue.a = MenuChoice()                        ; Low value
   Esc                                            ;
   {HighValue}                                    ; High value
   HValue.a = MenuChoice()                        ;
   Esc                                            ;
   {Default}                                      ; Default
   Default.a = MenuChoice()                       ;
   Esc                                            ;
   {TableLookup}                                  ; LookupHelpAndFill
   TLookup.a = MenuChoice()                       ;
   Esc                                            ;
   {Picture}                                      ; Picture
   Pic.a = MenuChoice()                           ;
   Esc                                            ;
   {Required}                                     ; Required
   Req.a = MenuChoice()                           ; [CtrlBreak] out of the
   CtrlBreak                                      ; Edit Menu and print the
                                                  ; information

   Switch
      Case GoldPWidth.n < 130 : Format1.a = "W15,AL,CC"
                                Format2.a = "W20,AL"
                                Format3.a = "W6,AR"
      Case GoldPWidth.n < 200 : Format1.a = "W30,AL,CC"
                                Format2.a = "W35,AL"
                                Format3.a = "W8,AR"
      Otherwise : Format1.a = "W45,AL,CC"
                  Format2.a = "W50,AL"
   Endswitch
   Print File OrigDir.a+"FldList" " ", Format(Format1.a,Lower(Field())) +
                                  Format("W4,AR",FieldType())
   If FieldNo(Field(),Tbl.a) <= NKeyFields(Tbl.a) Then
      Print File OrigDir.a+"FldList" "*"
   Else
      Print File OrigDir.a+"FldList" " "
   Endif
   Print File OrigDir.a+"FldList" Format("W4,AR",Req.a)," ",
                                  Format(Format3.a,LValue.a)," ",
                                  Format(Format3.a,HValue.a)," ",
                                  Format(Format3.a,Default.a)," ",
                                  Format(Format1.a,TLookup.a)," ",
                                  Format(Format2.a,Pic.a), "\n"
   LineCount.n = LineCount.n + 1

   If Linecount.n > GoldLines.n Then           ; Do we need a page break ?
      Linecount.n = 13
      PrintValHeader.u()
   Endif
Endfor

RequiredCheck On
CancelEdit                                  ; Leave Edit Mode
ClearImage
Endproc
Writelib Libname.a ValchkInfo.u
Release Procs ValchkInfo.u
?? "."
; ---------------------------------------------------------------------------
; 'Master' Proc to document field values
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc ValCheck.u()
   private DDir.a,
           Origdir.a, Skip.a

DDir.a = Directory()                               ; Save the current and
OrigDir.a = DDir.a                                 ; target directories
WDir.a = DDir.a
LoopDir.l = False
DirCount.n = 1
DirControl.l = True
Skip.a = ""

CkFile.u("FldList")

While True
   If Not LoopDir.l Then                          ; asked to loop through all
      GetDir.u(19,17,DirControl.l)                ; directories. If not, get
      DirControl.l = True
      If Not Retval Then                          ; an new data directory.
         Quitloop                                 ; User pressed [Esc], quit
      Endif                                       ; Looping is in effect :
   Else                                           ; increment the counter
      DirCount.n = DirCount.n + 1                 ; make sure that we are
      If Not Isassigned(Dirs.r[DirCount.n]) Then  ; on a valid array entry
         Quitloop                                 ; if we are, go ahead
      Else                                        ; otherwise we are done
         DDir.a = Dirs.r[DirCount.n] + "\\"
      Endif
   Endif

   GetTblNames.u("Tables")                       ; get a list of table names

   If Isempty("List") Then                       ; No tables - Tell the user
      Message.u(RevMtr.n,"No Tables To Report On",0,-1,True)
      Clear
      PaintCanvas Attribute 111 0,0,24,79        ; Entire screen
      Loop
   Endif

   Clear                                         ; Clear the canvas
   Clearall                                      ; Clear the workspace

   CopyForm Path.a + "L1" 2 "List" 1             ; Get a display form
   View "List"                                   ; View the data

   If LoopDir.l Then
      Scan
         ValchkInfo.u(DDir.a+[Name])
      Endscan
   Else

      WHILE true
         If Form() <> "1" Then
            Pickform "1"
         Endif
         Wait Table
            Prompt Format("W80,AC","FIELD DOCUMENTING UTILITY "+DDir.a),
                  Format("W80,AC",
                     "Press [Enter] To Select, [F2] Print All, [Esc] To Quit")
            Until "F2",                             ; Analyze all tables
                  "Enter",                          ; Select one table
                  "Esc",                            ; Quit
                  "Dos", "DosBig"
         Switch
            Case Retval = "Esc" :                   ; Quit
               Quitloop
            Case Retval = "Enter" :                 ; Select one table
               ValchkInfo.u(DDir.a+[Name])
            Case Retval = "F2" :                    ; Analyze all tables
               Scan
                  ValchkInfo.u(DDir.a+[Name])
               Endscan
            Otherwise : Beep
         Endswitch
         SyncCursor
      EndWhile
      GoldHeader.u()
      Menu.u(8,20,35,1,False)
      Menu.u(11,25,25,2,False)
   Endif
Endwhile

If IsFile(OrigDir.a+"FldList") Then
   Print File OrigDir.a+"FldList" "\f"
   PrtFile.u(18,33,OrigDir.a+"FldList")          ; Should the file be output
Endif                                            ; to the printer ??
SetDir OrigDir.a                                 ; Reset to the original
                                                 ; directory
Endproc
Writelib Libname.a ValCheck.u
Release Procs ValCheck.u
?? "."
; ---------------------------------------------------------------------------
; Print a header for the valchecks report
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
;
; Field          Type   Req.  Low  High  Dflt.  Lookup          Picture
; 
;12345678901234567890123456789012345678901234567890123456789012345678901234567890
;
; ---------------------------------------------------------------------------
Proc PrintValHeader.u()
   private Line.a

Procname.a = "PrintValHeader.u"

Print File OrigDir.a+"FldList" "\f", GoldPSetup.a
Print File OrigDir.a+"FldList" "\n\n\n\n\n\n"
Print File OrigDir.a+"FldList" Fill(" ",10)
Print File OrigDir.a+"FldList" "Table Name = "+ Upper(Tbl.a)
Print File OrigDir.a+"FldList" "\n\n\n\n"

Switch
   Case GoldPWidth.n < 130 : Spacer.n = 0
   Case GoldPWidth.n < 200 : Spacer.n = 15
   Otherwise : Spacer.n = 30
Endswitch

Line.a = " Field" + Fill(" ",10+Spacer.n) +
         "Type   Req.  Low  High  Dflt.  Lookup" +
         Fill(" ",10+Spacer.n) + "Picture"

Print File OrigDir.a+"FldList" Line.a + "\n"
Print File OrigDir.a+"FldList" " " + Fill("\196",GoldPwidth.n-4) + "\n"

Endproc
Writelib Libname.a PrintValHeader.u
Release Procs PrintValHeader.u
?? "."

Play "GoldUtl2"
Play "GoldUtl3"
