Libname.a = "Gold1"
@ 11,0 ?? "Playing Script GOLDUTL3 "
; ͻ
;                                                                           
;         Written By Harry Goldman                                          
;         DataBase Designs, Inc.                                            
;         (v) (708) 215-8318 (f) 708-215-0314 , Compuserve 72020,2321       
;         Copyright 1990                                                    
;         All Rights Resevered                                              
;                                                                           
;     This program  can be modifeid and enhanced freely as                  
;   long as the copyright and original program credits are maintained.      
;   If you enhance or modify this program, feel free to let me know,        
;   you will be credited in the next release. Resale of this program        
;   is prohibited without the written permission of the author              
;                                                                           
; ͹
; Special Thanks to Alan Zenreich, Dan Paolini and Phil Goulson for their   
; ideas and support.                                                        
; ͼ
; ---------------------------------------------------------------------------
; Error Routine for Print_objects.u()
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------

Proc Object_Error()
   private Error.n, Error.a, ErrorProc

Error.n = Errorcode()
Error.a = ErrorMessage()

ErrorCode.n = 99

Switch
   Case Error.n = 22 :
      Message.u(BlkMtr.n,"Table "+Tbl.a+" Is Write Protected",0,-1,True)
      Return 1
   Case Error.n = 29 :
      Message.u(BlkMtr.n,"Cannot Access Table "+Tbl.a,0,-1,True)
      Return 1
   Case Error.n = 35 :
      Message.u(RevMtr.n,"Table "+Tbl.a+" Has A Corrupt Report Or Form",2,1,True)
      Return 1
   Case Error.n = 35 Or Error.n = 17 :
      Message.u(RevMtr.n,"Table "+Tbl.a+" Is A Remote Table",2,1,True)
      Create "Answer" Like Tbl.a
      Menu {Tools} {Copy} {JustFamily} Select Tbl.a {Answer} {Replace}
      RemoteTbl.a = Tbl.a
      Tbl.a = "Answer"
      Return 0
    Otherwise :
      Message.u(BlkMtr.n,"Error # " + Strval(Error.n) + " " +
               Error.a + " Has Ocurred ",0,-1,True)
      Return 1
Endswitch
EndProc
Writelib Libname.a Object_Error
Release Procs Object_Error
?? "."
; ---------------------------------------------------------------------------
; Print a report of the table structure
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
proc PrtRpt.u()
Private n,
        Fld1.a,
        Fld2.a,
        LineCount.n

Linecount.n = 12
PrintHeader.u(0)

Print File RecFile.a Fill(" ",11) +
                     Format ("W18,AL","Field Name")+
                     Format ("W10,AL","Field Size")+ "\n"
Print File RecFile.a Format("W8"," ") +
                     Fill("=",35)+"\n"

; Print the field level detail that was stored in arrays

For n from 1 to FldCount.n
   Print File RecFile.a Fill(" ",11)
   Execute "Fld1.a = Fld" + Strval(n) + "[2]"
   Execute "Fld2.a = Fld" + Strval(n) + "[3]"
   Print File Recfile.a Format("W20,AL",Fld1.a)
   Print File Recfile.a Format("W10,AL",Fld2.a) + "\n"
   Linecount.n = Linecount.n + 1
   If Linecount.n > GoldLines.n Then
      PrintHeader.u(GoldLines.n)
   Endif
Endfor

Print File RecFile.a "\n\n\n"
Print File RecFile.a Format("W28,AR","Record Size   : ") +
   Format("W6,EC",RecSize.n) + " bytes" + "\n"
Print File RecFile.a Format("W28,AR","Keyed         : ") + "  " +
   Format("LY",Keyed.l) + "\n"
Print File RecFile.a Format("W28,AR","Block Size    : ") + "  ",
   BlkSize.n / 1024, "K" + "\n"
Print File RecFile.a Format("W28,AR","Recs Per Block: "),
   Format("W4,AR",Int((BlkSize.n - 6) / RecSize.n)),"\n\n\n"
Print File RecFile.a "          There are ",
   Mod(BlkSize.n - 6, RecSize.n)," wasted bytes in the block.", "\n"
Print File RecFile.a "          Or ",
   Round((Mod(BlkSize.n - 6,RecSize.n)/Int((BlkSize.n-6)/RecSize.n))+.05,2),
   " wasted bytes per record", "\n"
IF BlkSize.n > BlkVersion.n Then
   Print File RecFile.a "          Trim the record size by ", Bytesover.n,
     " bytes to reduce the ", "\n"
   Print File RecFile.a "          block size by 1K.", "\n"
Endif

If Not Keyed.l Then
   Print File Recfile.a "\n"
   LineCount.n = LineCount.n + 1
Endif

LineCount.n = LineCount.n + 12
PrintHeader.u(GoldLines.n)

Print File RecFile.a "\n\n\n"
Print File RecFile.a "          File Stats :            Records : ",
  Format("W15,AR,EC",Nrecords(Tbl.a)),"\n"
Print File RecFile.a "                            Blocks In Use : ",
  Format("W15,AR,EC",Blocks.n),"\n"
If Keyed.l Then
   Print File RecFile.a "                  Primary Index File Size : ",
   Format("W15,AR,EC",FileSize(Tbl.a+".PX")),"\n"
Endif
Print File RecFile.a "                         Actual File Size : ",
  Format("W15,AR,EC",Filesize(Tbl.a + ".DB")),"\n"
Print File RecFile.a "                      'Optimal' File Size : ",
  Format("W15,AR,EC",BlkSize.n * Blocks.n + BlkVersion.n),"\n"
Print File RecFile.a "               Total Unclaimed Disk Space : ",
  Format("W15,AR,EC",
   Max(0,Filesize(Tbl.a + ".DB")-((BlkSize.n * Blocks.n)
   + BlkVersion.n))),"\n"
Print File RecFile.a "                  Total Wasted Disk Space : ",
  Format("W15,AR,EC",Mod(BlkSize.n - 6, RecSize.n) * Blocks.n), "\n"
If Index.l Then
   LineCount.n = LineCount.n + 10
   PrintHeader.u(GoldLines.n)
   Print File RecFile.a "\n\n\n"
   Print File RecFile.a "       Secondary Index Information : \n"
   Print File RecFile.a "     ================================ \n\n"
   Print File RecFile.a "   Field                    Index File Size     ",
       "Index Type \n"
   Print File RecFile.a "-----------------------------------------------",
       "---------------- \n"
   View Path.a + "Isize"
   Scan
      Print File RecFile.a "   "
      Print File RecFile.a Format("W22,AL",[IField])," ",
         Format("W14,AR,EC",[IXsize] + [IYSize]), "      "
      If Not Isblank([IType]) Then
         Print File RecFile.a Format("W20,AL",[IType]), "\n"
      Else
         Switch
            Case Isblank([Ifield]) :
               Print File RecFile.a "**** POSSIBLE CORRUPT KEY *** \n"
            Case Isblank([IXsize]) Or [IXSize] < 1024 :
               Print File RecFile.a "**** POSSIBLE CORRUPT KEY *** \n"
            Case Isblank([IYsize]) Or [IYSize] < 1024 :
               Print File RecFile.a "**** POSSIBLE CORRUPT KEY *** \n"
            Otherwise :
               Print File RecFile.a "  Unkown \n"
         EndSwitch
      Endif
   Endscan
   ClearImage
Endif
Print File RecFile.a "\f"

Endproc
Writelib Libname.a PrtRpt.u
Release Procs PrtRpt.u
?? "."
; ---------------------------------------------------------------------------
; To determine what fields in a table have a secondary index (also known
; as a Query Speedup) we will need to process several peices of information.
; Secondary indicies are stored as part of a tables' family. Each index uses
; two files *.Xhh and *.Yhh where hh are the hex representaion of the field
; number.
;
; Step 1 - Get any information on DOS files for this table with an
; extension of either *.x* or *.y*
; If there are no DOS files, return false to avoid step 2
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc Isize1.u(Tbl.a)
   private FlName.a,                       ; Paradox Table name
           ILoc.a,                         ; Location of the index in ASCII
           ISize.n                         ; Size of the index in bytes

Procname.a = "Isize1.u"

If Not Isempty(Path.a +"ISize") Then       ; Make sure that we start with
   Empty Path.a + "Isize"                  ; an empty results table
Endif

; ---------------------------------------------------------------------------
; We will need to get a list of all *.X* and all *.Y* files that exist
; in the subdirectory, import them into Paradox and save that information.
; Even if no files are found a directory header will be imported into
; Paradox and processed, but that is expected.
; ---------------------------------------------------------------------------

Canvas off
Run NoRefresh "Dir "+Tbl.a+".x* > Listx"       ; Get a list of all secondary
Run NoRefresh "Dir "+Tbl.a+".y* > Listy"       ; index files and import it

{Tools} {ExportImport} {Import} {Ascii} {Text} {Listx.} {Answer}
If MenuChoice() = "Cancel" Then            ; A "LIST" table exists, replace
   {Replace}                               ; it
Endif

Sort "Answer" On "Text"                    ; Make sure that the list is
                                           ; sorted
View Path.a + "Isize"                      ; Bring the results table up
Moveto "Answer"                            ; Go back to LIST
CoEditKey                                  ; Enter CoEdit Mode

Scan For Search(" X",Substr([Text],9,2)) > 0  ; Look for " X" as file ext.
   FlName.a = SubStr([Text],1,8)              ; Found : get the file name
   While Match(Flname.a,".. ",Flname.a)       ; Remove trailing blanks
   Endwhile                                   ;
   ILoc.a = SubStr([Text],11,2)               ; Get the file extension
   ISize.n = Numval(SubStr([Text],15,8))      ; Get the file size
   Moveto Path.a + "ISize"                    ; Move to the results table
   End                                        ; Insert a new record
   Down                                       ;
   [FlName] = FlName.a                        ; Save the file name
   [Iloc] = Iloc.a                            ; Save the field location (ext.)
   [IXsize] = ISize.n                         ; Save the file size
   Moveto "Answer"                            ; Go back to LIST
EndScan                                       ; End the loop
Do_It!                                        ; Save changes
Clearall                                      ; Clear the workspace

; ---------------------------------------------------------------------------
; Import the "*.Y*" list into paradox and do the same procedure, matching
; "*.X*" files to "*.Y*" files
; ---------------------------------------------------------------------------

{Tools} {ExportImport} {Import} {Ascii} {Text} {Listy.} {Answer}

If MenuChoice() = "Cancel" Then               ; A "LIST" table exists, replace
   {Replace}                                  ; it
Endif                                         ;

Sort "Answer" On "Text"                       ; Make sure that the list is
View Path.a + "ISize"                         ; sorted
Moveto "Answer"                               ; Bring the results table up
CoEditKey                                     ; Go back to LIST
                                              ; Enter CoEdit Mode
Scan For Search(" Y",Substr([Text],9,2)) > 0  ; Look for " Y" as file ext.
   FlName.a = SubStr([Text],1,8)              ; Found : get the file name
   While Match(Flname.a,".. ",Flname.a)       ; Remove trailing blanks
   Endwhile                                   ;
   ILoc.a = SubStr([Text],11,2)               ; Get the file extension
   ISize.n = Numval(SubStr([Text],15,8))      ; Get the file size
   Moveto Path.a + "ISize"
   Moveto Field "Flname"                      ; Move to the results table
   Locate Flname.a, ILoc.a                    ; Find the matching file name
   If Retval Then                             ; and extension.
      [IYSize] = ISize.n                      ; Found : Save the Y file size
   Else                                       ; Not found add a new record
      End                                     ; Insert a new record
      Down                                    ;
      [FlName] = FlName.a                     ; Save the file name
      [Iloc] = Iloc.a                         ; Save the field location (ext.)
      [IYsize] = ISize.n                      ; Save the file size
   EndIf                                      ;
   Moveto "Answer"                            ; Go back to LIST
EndScan                                       ; End the loop
Do_It!                                        ; Save changes
Clearall                                      ; Clear the workspace
If IsEmpty(Path.a + "Isize") Then
   Return False
Else
   Return True
Endif
Endproc
Writelib Libname.a Isize1.u
Release Procs Isize1.u
?? "."
; ---------------------------------------------------------------------------
; Part 2 of the process, get the index information from Paradox and
; merge it with the information from step 1
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc Isize2.u(Tbl.a)
   private Flname.a,                        ; Paradox Table Name
           Fld.r, Type.r,                   ; Storage arrays
           n, i,                            ; counter
           Part2.a,                         ; Semi parsed text
           T1.a, T2.a,                      ; parsed text
           Fldloc.n,                        ; Field location in integer
           Loc1.a, Loc2.a, Loc3.a,          ; Digits of FldLoc.n
           FldHex.a,                        ; FldLoc.a in Hex
           Tbl.a                            ; Paradox Table Name

Procname.a = "Isize2.u"

   {Tools} {Info} {Family} Select Tbl.a       ; Get the family for the table
                                              ;
   Array Fld.r[Nrecords("Family")]            ; Create arrays for temporary
   Array Type.r[Nrecords("Family")]           ; storage
                                              ;
   n = 0                                      ; Set a counter
                                              ;
   Moveto [Name]                                     ; Scan the family list
   Scan For Match([],"Speedup for ..",Part2.a)       ; for speedup files

; ---------------------------------------------------------------------------
; Speedup file descriptions may or may not be present. If they are
; then we need to capture them. If present they will be indluded in []
; so look for []
; ---------------------------------------------------------------------------

      n = n + 1                            ; Increment the counter
      If Search("[", Part2.a) <> 0 Then
         l = Match(Part2.a,".. [..]..",T1.a,T2.a,T3.a)  ; parse desription
         If l Then                                      ;
            While Match(T1.a,".. ",T1.a,T3.a)
            Endwhile
            Fld.r[n] = T1.a                      ; Save the field name
            Type.r[n] = T2.a                     ; Save the speedup type
         Endif                                   ;
      Else
         Fld.r[n] = Part2.a                      ; No description was
         Type.r[n] = "Not Maintained"            ; found
      Endif
   Endscan                                    ; End the loop
                                              ;
   ClearImage                                 ; Clear the current image
   If n < 1 Then                              ; If no speedups were found
      Loop                                    ; loop back and get the next
   Endif                                      ; table name
                                              ;
   View Tbl.a                                 ; View the table
   Coedit Path.a + "ISize"                    ; Coedit the results table
                                              ;
   For i From 1 To n                          ; Loop through the arrays
      Moveto Tbl.a                            ; Make sure that we are on the
      Moveto Field Fld.r[i]                   ; table, then moveto the field
      FldLoc.n = Fieldno(Fld.r[i],Tbl.a)      ; store the field number

; ---------------------------------------------------------------------------
; Secondary incicies are stored in two files that have the table name as
; the file name, then Xhh and Yhh where hh are the hexadecimal representation
; of the field number. To match a 'speedup' type to the information that we
; have already stored on X and Y file sizes we will need to convert the
; field number from base 10 to hex.
; Paradox tables can be up to 255 fields wide thus we will need to
; accomodate up to 3 digits. If the field number is less than 10, the hex
; equivalent is the field number with a "0" in front. Otherwise we will need
; to calculate equivalent
; ---------------------------------------------------------------------------

      Switch
         Case Fldloc.n < 10 :
            FldHex.a = "0" + Strval(FldLoc.n)
         Case Fldloc.n < 100 :
            Loc1.a = Substr("0123456789ABCDEF",Substr(FldLoc.n),1,1)
            Loc2.a = Substr("0123456789ABCDEF",Substr(FldLoc.n),2,1)
            FldHex.a = Loc1.a + Loc2.a
         Otherwise :
            Loc1.a = Substr("0123456789ABCDEF",Substr(FldLoc.n),1,1)
            Loc2.a = Substr("0123456789ABCDEF",Substr(FldLoc.n),2,1)
            Loc3.a = Substr("0123456789ABCDEF",Substr(FldLoc.n),3,1)
            FldHex.a = Loc1.a + Loc2.a + Loc3.a
      EndSwitch

      Moveto Path.a + "Isize"                 ; Move to the results table
                                              ;
      Locate Upper(Tbl.a), FldHex.a           ; Find the file and location
      If Retval Then                          ; If found :
         [IType]  = Type.r[i]                 ; Save the index type
         [IField] = Fld.r[i]                  ; Save the field name
      Else                                    ; If not found we have a
         End                                  ; problem. Insert a new record
         Down                                 ;
         [FlName] = Tbl.a                     ; Save the Table name
         [IField] = Fld.r[i]                  ; Save the field name
         [ILoc]   = FldHex.a                  ; Save the field location
         [IType]   = Type.r[i]                ; Save the index type
      Endif                                   ;
   Endfor                                     ; End the loop
   Do_It!                                     ; Save the changes
   Clearall
Endproc
Writelib Libname.a Isize2.u
Release Procs Isize2.u
?? "."
; ---------------------------------------------------------------------------
; Routine to capture field level information from a form
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc GetFieldData.u(Tbl.a,Rpt.a,NLines.n)
private n, n1, n2,               ; For loop counters
        NLines.n,                ; number of lines to read
        Curpage.n,               ; Current Page of the image
        Tbl.a,                   ; Table to process
        Rpt.a,                   ; report or form number
        Top1.a,                  ; Header line for field positions
        Pos.n,                   ; Field position pointer
        Name.a,                  ; Field name
        Type.a,                  ; Field type
        l,                       ; Logical flag
        LineCount.n,             ; Lines Printed Per Page
        Line.u,                  ; Captured line to parse and use
        FldPos.n,                ; Current position in the line
        Width.n,                 ; width of the form or report
        Fld.a,                   ; Parsed current field
        NewLine.a,               ; next line to process
        TWidth.n                 ; Total object width

Procname.a = "GetFieldData.u"

Top1.a = "   Page  Line  Column    Field Type               Field"
Width.n = 80                                     ; Initialize page width
TWidth.n = 80                                    ; initialize total width

; Select the form that is to be processed

Menu Select Object.a {Change} Select Tbl.a Select Rpt.a {}

; ---------------------------------------------------------------------------
; Forms will always have 23 lines checked, even if there are less lines in
; use. The number of lines in a report can be determined with the NLines
; function.
;
; We will also need to check the total width of report specifications. If
; the total width is over 255 characters we can only trap and process the
; first 255.
; ---------------------------------------------------------------------------

If Nlines.n < 1 Then                             ; Nlines.n < 1 is a report
   Nlines.n = Nrows()                            ; get the number of rows
   Menu {Setting} {PageLayout} {Width}           ; get the page width
   Width.n = Numval(MenuChoice())
   CtrlBreak                                     ; leave the menus
Endif

If Object.a <> "Forms" Then                      ; calculate total width for
   TWidth.n = Width.n * NPages()                 ; reports
   If TWidth.n > 255 Then
      Message.u(BlkMtr.n,"Only The First 255 Charaters Of " + Tbl.a +
      ".R" + Rpt.a + " Will Be Processed",0,-1,True)
   Endif
Endif

Style Reverse

While True
   CurPage.n = Pageno()                          ; Set the current page #
   CaptureImage.u()                              ; Get the image
   CaptureDetail.u()                             ; get the detail
   CurPage.n = Pageno()                          ; reset the page number
   PgDn                                          ; try to move down to the
   If Pageno() = CurPage.n Then                  ; next page. If the page
      Quitloop                                   ; number does not change, we
   Endif                                         ; are done with this form
Endwhile
Style
Menu {Cancel} {Yes}                              ; leave the form
Endproc
Writelib Libname.a GetFieldData.u
Release Procs GetFieldData.u
?? "."
; ---------------------------------------------------------------------------
; Get Detailed information on the report specs
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc GetRptData.u(Tbl.a,Rpt.n)
   private Tbl.a,          ; The table to process
           Rpt.n,          ; The report number to use
           Item.u          ; The Item that we are checking

Procname.a = "GetRptData.u"

Print File RptFile.a "\n", Spaces(20), "Report Specifications", "\n"

Menu {Report} {Change} Select Tbl.a Select Rpt.n {}  ; get the report
Menu {Setting} {PageLayout} {Length}                 ; Page length
Item.u = MenuChoice()
Esc
Print File RptFile.a Spaces(20), "Page Length = ", Item.u, "\n"

{Width}
Item.u = MenuChoice()                                ; page width
Esc Esc
Print File RptFile.a Spaces(20), "Page Width  = ", Item.u, "\n"

{Margin}                                             ; Left margin
Item.u = MenuChoice()
Esc
Print File RptFile.a Spaces(20), "Page Margin = ", Item.u, "\n"

{Setup} {Custom} {LPT1}                              ; LPT1 setup string
Item.u = MenuChoice()
Esc
Print File RptFile.a Spaces(20), "LPT1 Setup  = ", Item.u, "\n"

{LPT2}                                               ; LPT2 setup string
Item.u = MenuChoice()
Esc
Print File RptFile.a Spaces(20), "LPT2 Setup  = ", Item.u, "\n"

{LPT3}                                               ; LPT3 setup string
Item.u = MenuChoice()
Esc
Print File RptFile.a Spaces(20), "LPT3 Setup  = ", Item.u, "\n\n\n"

CtrlBreak                                            ; Quit menus
Menu {Cancel} {Yes}                                  ; Quit the report
Endproc
Writelib Libname.a GetRptData.u
Release Procs GetRptData.u
?? "."
; ---------------------------------------------------------------------------
; Print a header for the report or form
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc PrintDataHeader.u()
   private Type.a

Procname.a = "PrintDataHeader.u"

If Object.a = "Forms" Then                         ; Based on the object
   LineCount.n = 35 + Arraysize(Linked_Tables.r)   ; set heline counter
   Type.a = " Form "
Else                                               ;
   LineCount.n = 25 + Arraysize(Linked_Tables.r)   ;
   Type.a = " Report "
Endif                                              ; trap the page number
                                                   ; If this a
If CurPage.n > 1 Then                              ; new page, do a page
   Print File Rptfile.a "\f\n\n\n"                 ; eject.
Endif                                              ;

Print File Rptfile.a Spaces(5),Tbl.a,Type.a, Rpt.a, ; print a header
    "  Page ",Curpage.n," Image", "\n"
Print File Rptfile.a Spaces(5),                    ; underline the header
    Fill("\196",Len(Tbl.a) + 23), "\n\n","  "

For i From 1 To Int(Width.n/10)                    ; print interval markers
   Print File Rptfile.a "    |   ", Format("W2,AR",Strval(i))
EndFor
Print File Rptfile.a "\n","  "                     ; Line feed
For i From 1 To Width.n                            ; Print place markers
   Print File RptFile.a Format("W1",Strval(Substr(i,Len(i),1)))
EndFor
Print File Rptfile.a "\n"                          ; Line feed
Endproc
Writelib Libname.a PrintDataHeader.u
Release Procs PrintDataHeader.u
?? "."
; ---------------------------------------------------------------------------
; Capture the image of the report or form, print to an output file
; Use the passed parameter TWidth.n to determine if we need to worry about
; total width of greater then 255 characters
;
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc CaptureImage.u()
Procname.a = "CaptureImage.u"

While True
   PrintDataHeader.u()                           ; Print a header
   @ 23,40                                       ; position the cursor
   ?? Format("W10,AR","  Page " + Strval(CurPage.n))  ; Message the user
   For n from 1 to NLines.n                      ; Loop through all lines
      @ 23,50                                    ; Position the cursor
      ?? Format("W12,AL","  Line " + Strval(n))  ; Message the user
      Line.u = Cursorline()                      ; capture the current line
      If Object.a <> "Forms" Then
         Line.u = Substr(Line.u,((CurPage.n-1)*Width.n)+1,Width.n)
      Endif
      Print File Rptfile.a Format("W2",Strval(n)), Line.u, "\n"
      Down                                       ; print the current line
   Endfor
   Print File Rptfile.a "\n\n"                   ; print 2 line feeds
   If Object.a <> "Forms" And NPages() > CurPage.n Then ; If this is not a
      CurPage.n = CurPage.n + 1                  ; form, move to the next
      Home                                       ; page width, and start over
   Else                                          ;
      CurPage.n = 1                              ; If this is a form
      Quitloop                                   ; we are done for now
   Endif
EndWhile
CtrlHome Home                                    ; Return to position 1,1
Endproc
Writelib Libname.a CaptureImage.u
Release Procs CaptureImage.u
?? "."
; ---------------------------------------------------------------------------
; When capturing a line from either a form or a report, a field will appear
; as one or more underscores "_". Thus to locate fields we will need to
; search down the line for the underscore character. This will present a
; special problem in that some field names or other text that could appear
; on the form or report could also include underscores. Thus after
; positioning the cursor we will have to test for the existence of a field
; at that location before continuing.
;
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc CaptureDetail.u()
   private CurFld.a,       ; Current field info
           Posadd.n,       ; field length counter
           FldPos1.n, FldPos2.n,
           FldPos3.n, FldPos4.n

Procname.a = "CaptureDetail.u"

Print File RptFile.a Top1.a, "\n"             ; print a header

For n from 1 to NLines.n                      ; loop through all lines
   Pos.n = 0                                  ; set the workspace cursor
   Line.u = Cursorline()                      ; capture the current line
   @ 23,50                                    ; set the canvas cursor
   ?? Format("W12,AL","  Line " + Strval(n))  ; Message the user
   While True                                 ;
      If Object.a = "Forms" Then              ; In forms look for underscores
         FldPos.n = Search("_",Line.u)        ;
      Else                                    ; in reports look for :
         FldPos1.n = Max(-1,Search("A",Line.u))  ; "A" - Alpha
         FldPos2.n = Max(-1,Search("9",Line.u))  ; "9" - Numeric / Currency
         FldPos3.n = Max(-1,Search("mm",Line.u)) ; "mm" - Date field
         FldPos4.n = Max(-1,Search("yy",Line.u)) ; "yy" - Date field

         If FldPos1.n > 0 And FldPos2.n > 0 Then ;
            FldPos1.n = Min(FldPos1.n,FldPos2.n) ;
         Else                                    ;
            FldPos1.n = Max(FldPos1.n,FldPos2.n) ;
         Endif                                   ;

         If FldPos3.n > 0 And FldPos4.n > 0 Then ;
            FldPos3.n = Min(FldPos3.n,FldPos4.n) ;
         Else                                    ;
            FldPos3.n = Max(FldPos3.n,FldPos4.n) ;
         Endif                                   ;

         If FldPos1.n > 0 And FldPos3.n > 0 Then ;
            FldPos.n = Min(FldPos1.n,FldPos3.n)  ;
         Else                                    ;
            FldPos.n = Max(FldPos1.n,FldPos3.n)  ;
         Endif
      Endif
      If FldPos.n > 0 Then                    ; If a field was found
         For n1 From 1 to FldPos.n - 1        ; move the workspace cursor
            Right                             ; to it
         Endfor                               ;
         If FieldInfo() <> "" Then            ; check for a valid field at
            Name.a = ""                       ; the cursor
            Type.a = ""                       ;
            If Linecount.n > Goldlines.n Then ; do we need a new page ?
                                              ; if so, print a header
               Print File Rptfile.a "\f", Spaces(5),Tbl.a,
                  " ", Object.a," ", Rpt.a," Page ",Curpage.n,
                  " Form Image", "\n"
               Print File Rptfile.a Spaces(5),
                  Fill("\196",Len(Tbl.a) + 23), "\n\n", Top1.a, "\n"
               LineCount.n = 5
            Endif

            Print File Rptfile.a Format("W5,AR",Strval(Pageno())),
                                 Format("W7,AR",Strval(n)),
                                 Format("W7,AR",Strval(FldPos.n+Pos.n))

; ---------------------------------------------------------------------------
; After printing the field position (page, line, column) we need to determine
; the field name and display characteristics. There is an anomoly with the
; use of the FIELDINFO() function. In a form it will return information in
; the format (Fieldtype,FieldName), while in a report this is reversed to
; the format (FieldName,Fieldtype). In addition this function will return
; only a single value when a Paradox reserved field is tested such as DATE
; RECORD# or PAGE#. Thus we will have to test for thefollowingissues when
; reporting on fields :
;    - Is this a form            Fieldinfo() = (Fieldtype,FieldName)
;    - Is this a report          Fieldinfo() = (FieldName,Fieldtype)
;    - Is this a reserved field  Fieldinfo() = (FieldName)
; ---------------------------------------------------------------------------

            l = Match(Fieldinfo(),"..,..",Type.a,Name.a)
            If l Then
               If Object.a = "Forms" Then
                  Print File Rptfile.a
                              Spaces(6), Format("W20,AL",Type.a),
                              Spaces(4), Format("W30,AL",Name.a), "\n"
               Else
                  Print File Rptfile.a
                              Spaces(5), Format("W20,AL",Name.a),
                              Spaces(6), Format("W30,AL",Type.a), "\n"
               Endif
            Else
               If Object.a = "Forms" Then
                  Print File Rptfile.a
                              Spaces(6), Format("W20,AL",FieldInfo()),"\n"
               Else
                  Print File Rptfile.a
                              Spaces(6), Format("W20,AL","Regular "),
                              Spaces(5), Format("W30,AL",FieldInfo()),"\n"
               Endif
            Endif
            LineCount.n = LineCount.n + 1     ; increment the line count

; ---------------------------------------------------------------------------
; After getting the field information, look for the end of the field.
; To do this reliably we will need to cursor to the right until either
; we come to a blank, or we come to a new field. Then we will need to
; parse the old line to get the new piece that we are looking for.
; ---------------------------------------------------------------------------

            CurFld.a = FieldInfo()             ; Capture the current field
            Posadd.n = 0                       ; information

            While FieldInfo() = CurFld.a       ; as long as we are on the
               Right                           ; current field, move to the
               Posadd.n = Posadd.n + 1         ; right. Add 1 to the counter
               If Pos.n + Posadd.n >= Width.n Then ; If we are at the right
                  Quitloop                     ; margin stop
               Endif
            Endwhile
                                               ; take a new substring
            Line.u = Substr(Line.u,FldPos.n+Posadd.n,Len(Line.u))
         Else
            Right                              ; Move the cursor 1 right,
            Line.u = Substr(Line.u,FldPos.n+1,Len(Line.u)) ; take a new
         Endif                                 ; substring
         Pos.n = colno() - 1                  ; move the workspace cursor
      Else                                    ;
         Quitloop                             ; If no more fields are
      Endif                                   ; found, move to the next
   EndWhile                                   ; line
   Down CtrlHome
Endfor
Print File Rptfile.a "\n\n"                   ; 2 line feeds
Endproc
Writelib Libname.a CaptureDetail.u
Release Procs CaptureDetail.u
?? "."
; ---------------------------------------------------------------------------
; Configuration Routine - Lookup Help For GOLD Utilities
; Copyright 1991 @ Harry Goldman, DataBase Deigns, Inc.
;            Permission is hereby granted by the author to re-distribute all
;            or part of this script, provided that this statement,
;            including the above copyright notice is included.
; ---------------------------------------------------------------------------
Proc LookupHelp.u()
   private Key.a

Procname.a = "LookupHelp.u"

Moveto "Printers"
Imagerights ReadOnly
While True
   Wait Table
   Prompt Format("W80,AC","Printer Setup "),
          Format("W80,AC","Press [F2] To Select [Esc] To Quit")
   Until "F2",
         "Esc",
         "Del",
         "Ins",
         -24, 15, 18,
         "PgUp", "PgDn"

   Key.a = retval

   Switch
      Case Key.a = "F2" : Moveto [Goldcfg->Abbrev]
                          [] = [Printers->Abbrev]
                          Quitloop
      Case Key.a = "Esc" : Moveto [GoldCfg->Abbrev]
                          Quitloop
      Otherwise : Beep
   Endswitch
Endwhile
Endproc
Writelib Libname.a LookupHelp.u
Release Procs LookupHelp.u
?? "."

