PROC getrecord.l (table.a, criteria.a, dynarray.l, varname.a)
;
;  this is a substitute for the unstable 4.5 GETRECORD function.  as you can
;  see, it has almost the same syntax as the native function:
;    native paradox:  GETRECORD "company" "COMPANY ID" TO DYNARRAY company  
;    r3 software:     getrecord.l ("company","COMPANY ID",TRUE,"company")
;
;  i have had many, MANY, many problems with GETRECORD, as my clients and
;  their pdoxinfo.zzz files will atest.  however, i have yet to been able
;  to package their problems and reproduce them in front of someone who
;  might be able to fix the problem.  that is why i wrote this utility.  i
;  use it wherever i would normally use GETRECORD.  many times, i leave the
;  GETRECORD call, in hopes that someday i may be able to use it...however,
;  until that day arrives, this is what does the dirty work.
;
;  table.a      target table
;  criteria.a   record criteria (use | to delimit multi-field criteria)
;  dynrrary.l   TRUE for COPYTODYNARRAY, FALSE for COPYTOARRAY
;  varname.a    target variable for found records
;
;  returns TRUE if record matching criteria is found, FALSE otherwise
;  also, unlike the PAL GETRECORD, which will ScriptBreak on invalid
;  criteria, getrecord.l will set the non-private var criteriaerror.l 
;  to TRUE and return FALSE
;
; the target table is placed on the workspace by calling the stand-alone,
; general purpose utility 'movetable.u'.  the initial workspace workspace
; is preserved, except when called from CoEdit mode and table.a is NOT 
; already on the workspace (movetable.u utilizes {TableAdd}, but 
; CLEARIMAGE cannot be called...).  also, be careful using this utility
; if the target table is already on the workspace, but WINDOWLESS...i have
; seen some inconsistent behavior that i have not worked out yet.  if this
; presents a problem to you, please document what you are doing, the problem,
; and let me know.  it doesn't get any better without feedback...

;  Copyright (1993,1994) Skip Rowland/r3 Software
;  All Rights Reserved.  This routine may be used freely as long as
;  this header is included.
;  (610) 797-7559  CID:  75260,2107
;----------------------------------------------------------------------
;
  PRIVATE
;   current workspace markers:  
      curwindow.h,        
      curtable.a,
      curfield.a,
      currec.n,
;   flag for whether or not target table was already on the workspace:
      onworkspace.l,
;   counter for number of fields with criteria:
      ct,
;   criteria value "pinched" off criteria.a string: 
      pinch.a,
;   possible variables assigned locate criteria:  
      v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12, v13,
;   structure of table.a (populated by TABLEINFO FIELDS):
      fieldnames.r, fieldtypes.r,
;   the locate string to execute:    
      locate.e

  PROC assigncriteria.l (var.s, fieldtype.a, value.a)
  
    ; make var assignments based on field type  
    SWITCH
      CASE SUBSTR (fieldtype.a,1,1) = "N" OR SUBSTR (fieldtype.a,1,1) = "S" : 
        IF NUMVAL (value.a) = "Error" THEN
          RETURN FALSE
        ENDIF
        VARASSIGN "v" + STRVAL (var.s) NUMVAL (value.a)
      CASE SUBSTR (fieldtype.a,1,1) = "D": 
        IF NUMVAL (value.a) = "Error" THEN
          RETURN FALSE
        ENDIF
        VARASSIGN "v" + STRVAL (var.s) DATEVAL (value.a) 
      OTHERWISE :  
        VARASSIGN "v" + STRVAL (var.s) value.a 
    ENDSWITCH
    RETURN TRUE
  ENDPROC  
  
  
  ;first, mark the current workspace
  IF NIMAGES () > 0 THEN
    curwindow.h = GETWINDOW ()
    curtable.a = TABLE ()
    curfield.a = FIELD ()
    currec.n = RECNO ()
    IF ISFORMVIEW () THEN
      WHILE FORMTYPE ("Detail") UPIMAGE ENDWHILE
      FORMKEY
    ENDIF
  ENDIF  

  onworkspace.l = ISONWORKSPACE (table.a)
  movetable.u (table.a,"N")     ;this utility moves focus to the target table
                                ;  if the table is not on the workspace, it 
                                ;  will place it without a window

  ;the locate string is populated by values corresponding to the
  ;  field types, from left to right, until all criteria has been
  ;  assigned
                                 
  CTRLHOME    
  ct = 0
  locate.e = "LOCATE "
  criteriaerror.l = FALSE
  TABLEINFO table.a FIELDS TO fieldnames.r, fieldtypes.r
  IF SEARCH ("|", criteria.a) <> 0 THEN
    WHILE MATCH (criteria.a, "..|..", pinch.a, criteria.a)
      ct = ct + 1
      l = assigncriteria.l (ct, fieldtypes.r [ct], pinch.a)
      IF NOT l THEN
        criteriaerror.l = TRUE
        QUITLOOP
      ENDIF
      locate.e = locate.e + "v" + STRVAL (ct) + ", "
    ENDWHILE
    ct = ct + 1
    l = assigncriteria.l (ct, fieldtypes.r [ct], criteria.a)
    IF NOT l THEN
      criteriaerror.l = TRUE
    ENDIF
    locate.e = locate.e + "v" + STRVAL (ct)
  ELSE
    ct = 1
    l = assigncriteria.l (ct, fieldtypes.r [ct], criteria.a)
    IF NOT l THEN
      criteriaerror.l = TRUE
    ENDIF
    locate.e = locate.e + "v1"
  ENDIF  

  IF NOT criteriaerror.l THEN
    CTRLHOME
    IF ct = 1 THEN
      RIGHT
    ENDIF

    EXECUTE locate.e
    IF dynarray.l THEN
      EXECUTE "COPYTODYNARRAY " + varname.a
    ELSE
      EXECUTE "COPYTOARRAY " + varname.a
    ENDIF
    retval.l = RETVAL
  ENDIF
  
  ;start restoring the workspace
    
  IF NOT onworkspace.l AND SYSMODE () <> "CoEdit" THEN
    CLEARIMAGE
  ENDIF
  
  IF ISASSIGNED (curwindow.h) THEN
    WINDOW SELECT curwindow.h
    MOVETO curtable.a
    MOVETO FIELD curfield.a
    MOVETO RECORD currec.n
  ENDIF  
  
  IF NOT retval.l OR criteriaerror.l THEN
    EXECUTE "RELEASE VARS " + varname.a
    RETURN FALSE
  ENDIF
  
  RELEASE VARS criteriaerror.l
  RETURN TRUE
  
ENDPROC  
WRITELIB libname.a getrecord.l
RELEASE PROCS getrecord.l


PROC movetable.u (table.a,action.a)
;
;  movetable.u is a utility for either placing a table on the workspace 
;    or moving focus to a table already on the workspace
;
;  Copyright (1993,1994) Skip Rowland/r3 Software
;  All Rights Reserved.  This routine may be used freely as long as
;  this header is included.
;
;  place   table.a (if NOT on workspace):  action.a = V or T or N
;  move to table.a (if on workspace):      action.a = V or T or is blank
;  move    table.a out of sight:           action.a = V or is blank
;  clear   table.a from the workspace:     action.a = C
;
;  V is for viewing a table whose tableview window will be hidden
;  T is for viewing a table and preserving its tableview
;  N is for placing a WINDOWLESS table on the workspace
;
; NOTE:  just like PAL, you'll get a script break if you try to clear
;        an image while in CoEdit mode
;
; NOTE:  this is a general purpose, standalone utility
;
; NOTE:  this utility populates a workspace management dynarray,
;        winhandle.y,
;        with the handles of 'windowed' tableviews.  (the 'tv' in the 
;        assignment indicates a tableview.)
;
  PRIVATE
    wa,         ;dynarray for resetting window attributes
    ontable.l   ;flag set if target table is already on the workspace

  ;winhandle.y collects window handles
  IF NOT ISASSIGNED (winhandle.y) THEN
    DYNARRAY winhandle.y []
  ENDIF
  
  IF ISFIELDVIEW () THEN
    FORMKEY
  ENDIF
  
  IF ISONWORKSPACE (table.a) THEN
    MOVETO table.a
    ontable.l = TRUE
  ENDIF
  
  IF ISASSIGNED (ontable.l) AND action.a = "C" THEN
    CLEARIMAGE
    RELEASE VARS winhandle.y [table.a + ".tv"], winhandle.y [table.a + ".fv"] 
    RETURN
  ENDIF  

  ;if not on table.a, then need to place table.a    
  IF NOT ISASSIGNED (ontable.l) THEN
    SWITCH
      CASE action.a = "V" OR action.a = "T" : 
        IF SYSMODE () = "CoEdit" THEN
          MENU {TableAdd} SELECT table.a
        ELSE
          VIEW table.a
        ENDIF  
        winhandle.y [table.a + ".tv"] = GETWINDOW () 
        IF action.a = "T" THEN  ;don't move the tableview window
          RETURN
        ENDIF
        ontable.l = TRUE
      CASE action.a = "N" :
        IF SYSMODE () = "CoEdit" THEN
          MENU {TableAdd} SELECT table.a
          WINDOW DESTROY 
        ELSE
          VIEW NOWINDOW table.a
        ENDIF  
        RETURN
    ENDSWITCH
  ENDIF  

  ;the last step is to hide the tableview window.  since there is
  ;  no way to tell if you are on a windowless table, operate under
  ;  the assumption that both winhandle.y and ontable.l must be
  ;  assigned for the current table to have a window.  if not, there
  ;  is no window to hide...
  
  IF NOT ISASSIGNED (winhandle.y [table.a + ".tv"]) 
     OR NOT ISASSIGNED (ontable.l) THEN
    RETURN
  ENDIF
  
  IF NOT ISWINDOW (winhandle.y [table.a + ".tv"]) THEN
    RELEASE VARS winhandle.y [table.a + ".tv"]
    RETURN
  ENDIF
  
  DYNARRAY wa []
  wa ["ORIGINROW"] = IIF (action.a = "T",0,-200)
  WINDOW SETATTRIBUTES winhandle.y [table.a + ".tv"]  FROM wa
  
ENDPROC  
WRITELIB LibName.a movetable.u 
RELEASE PROCS movetable.u 


