LIBNAME = "IN"

; DirDialog   This is the event handling procedure for the Directory
;             dialog box
Proc DirDialog(TT, TV, EVV, ELV)
   private ToDo, event, status
   dynarray ToDo[]

   ToDo["KEY.CTRL.M.ACCEPT.01"]      = "UpdatePick01"
   ToDo["KEY.CTRL.M.ACCEPT.02"]      = "UpdatePick02"
   ToDo["KEY.CTRL.M.PICK.02"]         = "NewPick01"
   ToDo["SELECT.ACCEPT.01"]         = "UpdatePick01"
   ToDo["SELECT.ACCEPT.02"]         = "UpdatePick02"
   ToDo["SELECT.PICK.02"]            = "NewPick01"
   ToDo["SELECT.PICK.01"]            = "SelectPick01"
   ToDo["KEY.CTRL.M.PICK.01"]         = "SelectPick01"
   ToDo["UPDATE.PICK.01"]            = "UpdateAccept01"
   ToDo["UPDATE.PICK.02"]            = "UpdateAccept02"
   ToDo["ACCEPT.OK"]                  = "SelectPick01"
   ToDo["CANCEL.CANCEL"]            = "DSCancel"

   status = True

   switch
      case TT = "SELECT" or TT = "UPDATE"   or TT = "ACCEPT" or TT = "CANCEL" :
         event = TT + "." + upper(TV)
      case TT = "EVENT"    : event = CodeEvent(EVV) + "." + upper(TV)
   endswitch

   if isassigned(ToDo[event]) then
      execproc ToDo[event]
   endif

   return status

endproc
writelib LIBNAME DirDialog

; Event handling procedures for the DirDialog procedure

proc UpdatePick01()
   PDirEntry = controlvalue("Accept.01")
   resynccontrol "Pick.01"
endproc
writelib LIBNAME UpdatePick01

proc UpdatePick02()
   PDrive = controlvalue("Accept.02")
   resynccontrol "Pick.02"
endproc
writelib LIBNAME UpdatePick02

proc UpdateAccept01()
   ADirEntry = tree[EVV]
   resynccontrol "Accept.01"
endproc
writelib LIBNAME UpdateAccept01

proc UpdateAccept02()
   ADrive = drives[EVV]
   resynccontrol "Accept.02"
endproc
writelib LIBNAME UpdateAccept02

proc NewPick01()
   selectDrive = controlvalue("Pick.02")
   NewDrive(selectDrive)
endproc
writelib LIBNAME NewPick01

proc SelectPick01()
   path = controlvalue("Pick.01")
   acceptdialog
   status = False
endproc
writelib LIBNAME SelectPick01

proc DSCancel()
   canceldialog
   path = "<NO DIR>"
   status = false
endproc
writelib LIBNAME DSCancel

; Process a new drive spec

proc NewDrive(SD)
   if SD <> CD then
      dirRefresh = iif(controlvalue("Radio.01")   = 2, True, False)
      ADrive = SD
      refreshcontrol "Accept.02"
      release vars tree
      dynarray tree[]
      BuildDirTree(SD, tree)
      PDirEntry = FD   ADirEntry = FD
      PDrive = SD ADrive = SD
      refreshcontrol "Pick.01"
      refreshcontrol "Accept.01"
      CD = SD
   endif
endproc
writelib LIBNAME NewDrive

; Build the actual directory tree

proc BuildDirTree(inDrive, tree)

   private drive, dirlist, treeFile, dosCommand

; If the inDrive is CURRENT, then get the current drive, otherwise
; set drive to first character in inDrive.

   if inDrive = "CURRENT" then
      drive = substr(sdir(), 1, 1)
   else
      drive = substr(inDrive, 1, 1)
   endif

; Costruct the dos command to execute and the name of the tempory tree file

   dosCommand = substr(autolib,1,11)+"IN\\DIRLIST " + drive + ": > \\$" + drive + "_TREE.TMP"
   treeFile = "\\$" + drive + "_TREE.TMP"

; If the Tree file for the selected dirve is not found, then build it

   if not(isfile(treeFile)) or dirRefresh then ; G.Salvestroni - modif.2.12.1992
      Message "Rescanning - please wait..."
      run norefresh dosCommand
      Message ""
   endif

; Read the contents of the tree file into a MEMO field.

   fileread treeFile to dirlist

;   Now load the DYNARRAY tree with all the records in the file.

   spos = 1
   afterFirst = False
   pos = search("\n", dirlist)
   while pos <> 0
      de = substr(dirlist, spos, pos-spos)
      tree[de] = de
      if not afterFirst then
         FD = de
         afterFirst = True
      endif
      spos = pos + 1
      pos = searchfrom("\n", dirlist, spos)
   endwhile

   release vars dirlist
endproc
writelib LIBNAME BuildDirTree

proc GetDir()

   private FD, path, drives, CD

   dynarray tree[]
   dynarray drives[]

   dirRefresh = False
   path = "<NO DIR>"
   FD = ""

   BuildDirTree("CURRENT", tree)

   PDirEntry = FD   ADirEntry = FD
   PDrive = substr(sdir(), 1, 2) ADrive = PDrive CD = PDrive
   Radio = 1

   ; Compose the logical drives list                                    ; 
   for i from 90 to 67 step -1                                          ;G.Salvestroni 
    if drivestatus(chr(i)) then disk=chr(i)+":" drives[disk]=disk endif ;modified 
   endfor                                                               ;on 2.12.92 
   drives["A:"] = "A:" drives["B:"] = "B:"                              ; 

   showdialog "Directory Selection"   proc "DirDialog"

      trigger "SELECT", "UPDATE", "ACCEPT", "CANCEL"
      key "ENTER" ;mouse "DOWN"
      @ 4,4 height 16 width 72

      frame single from 1,14 to 9,56
      frame single from 1,1 to 6,10

      label @ 1,15 "Directory ~T~ree" for "Pick.01"
      pickdynarray @ 2,15 height 7 width 40 tree tag "Pick.01" to PDirEntry

      label @ 1,2 "D~r~ives" for "Pick.02"
      pickdynarray @ 2,2 height 4 width 5 drives tag "Pick.02" to PDrive

      label @ 10,0 "Dri~v~e:" for "Accept.02"
      accept @10,8 width 5 "A4" picture "!;:" tag "Accept.02" to ADrive

      label @ 10,14 "~D~irectory:" for "Accept.01"
      accept @10,26 width 30 "A40" picture "*!" tag "Accept.01" to ADirEntry

      label @1, 58 "Re~f~resh" for "Radio.01"
      radiobuttons @2, 58 height 2 width 11 "Never","Always" tag "Radio.01" to Radio

      pushbutton @ 12,25 width 10 "~O~K" OK value "OK" tag "OK" to ok
      pushbutton @ 12,36 width 10 "~C~ancel" CANCEL value "CANCEL" tag "CANCEL" to cancel

   enddialog

   return path

endproc
writelib LIBNAME GetDir

;---------------------------------------------------------------------------
;
; CodeEvent      This procedure will code an event in the DYNARRAY into a
;                  string that can be used as an index into another DYNARRAY.
;
;                Event         Return Value
;                  ---------   ------------------------------
;                  MOUSE         MOUSE.LEFT.MOVE or MOUSE.NONE.MOVE
;                  KEY         KEY.ASC.27 or KEY.F30 or KEY.ALT.A
;                  MESSAGE      MSG.message or MSG.MENUSELECT.tagname
;                  IDLE         IDLE
;
; Inputs         EL the event list DYNARRAY
; Output         the coded event
; Privates         eix - work string for event coding
;                  KC  - the keycode from the event list
;                  CMKL - cursor movement key names (list)
;                  ALKL - ALT letter key codes
;
;---------------------------------------------------------------------------

proc CodeEvent(EL) private eix, KC, CMKL, ALKL

   CMKL = "HOME UP   PGUP      LEFT      RIGHT     END  DOWN PGDN INS  DEL"
   ALKL = "QWERTYUIOP    ASDFGHJKL     ZXCVBNM"

   switch
      case EL["type"] = "MOUSE" :
         eix = "MOUSE." + EL["buttons"] + "."
            if EL["DOUBLECLICK"] and EL["buttons"] <> "NONE" then
               eix = eix + "DC"
            else
               eix = eix + EL["action"]
            endif
      case EL["type"] = "MESSAGE" :
         if EL["message"] = "MENUSELECT" then
            eix = "MSG.MENU." + EL["MENUTAG"]
         else
            eix = "MSG." + EL["MESSAGE"]
         endif
      case EL["type"] = "IDLE" :   eix = "IDLE"
      case EL["type"] = "KEY" :
         eix = "KEY."
         KC = EL["KEYCODE"]
         switch
            case ((KC >= 27 and KC <= 32) or (KC >= 127 and KC <= 255)) :
               eix = eix + "ASC." + strval(KC)
            case KC >= 33 and KC <= 126 :
               eix = eix + chr(KC)
            case (KC >= 0 and KC <= 26) :
               eix = eix + "CTRL." + chr(KC + 64)
            case KC < 0 :
                KC = abs(KC)
               switch
                  case KC >= 59 and KC <= 68 :
                     eix = eix + "F" + strval(KC - 58)
                  case KC >= 84 and KC <= 113 :
                     eix = eix + "F" + strval(KC - 73)
                  case KC >= 71 and KC <= 83 :
                     eix = eix + substr(CMKL, ((KC-71)*5)+1, 5)
                  case KC >= 16 and KC <= 50 :
                     eix = eix + "ALT." + substr(ALKL, (KC-15), 1)
               endswitch
         endswitch
      otherwise : eix = ""
   endswitch
   return eix
endproc
writelib LIBNAME CodeEvent


