;------------------------------------------------------------------------;
; Written by Franklin Abril NYC 9/21/92                                  ;
; for no good reason other than to play with new Paradox 4.0             ;
;                                                                        ;
;                                                                        ;
; Any comments leave me a note on Compuserve 70573,1765                  ;
;                                                                        ;
; I only did this because I was bored and needed to learn the new        ;
; Paradox functions for PAL programming. I'm pretty sure there are       ;
; better ways to learn new PAL. But, this was a lot of fun.              ;
;                                                                        ;
;------------------------------------------------------------------------;

PROC Main()

   SYSINFO TO systemInfo

   IF NOT systemInfo["MOUSE"] THEN
      MESSAGE "No Mouse Detected"       ;if no mouse, no play
      sleep 2000
      QUIT
   ENDIF
   RELEASE VARS systemInfo              ;keep memory clean

   lastCol = 0
   ballCol = 39
   ballRow = 5
   deltaCol = 1
   deltaRow = -1
   deltaBall = 0
   deltaHit = 0
   deltaCorner = 0
   ball = ""

   CLEAR

   PAINTCANVAS ATTRIBUTE 26 0,0,4,79

   PaintText(0,"PARADOX 4.0 - FUN TIME")

   PAINTCANVAS ATTRIBUTE 32 3,0,3,79

   STYLE ATTRIBUTE 62

   IF NOT BeginSound() THEN               ;No Way, WAY!
      QUIT
   ENDIF

   CURSOR OFF

   thisCol = lastCol
   MoveRaquet(lastCol,thisCol)

   oldTime = TICKS()                      ;rudimentary timer

   WHILE TRUE
       GETEVENT ALL to mouseInfo
       IF mouseInfo["TYPE"] = "MOUSE" THEN
          IF mouseInfo["ACTION"] = "MOVE" THEN
             thisCol = mouseInfo["COL"]
             thisRow = mouseInfo["ROW"]
             thisCol = iif(thisCol>69,69,thisCol)
             IF NOT thisCol = lastCol THEN
                 MoveRaquet(lastCol,thisCol)
                 lastCol = thisCol
             ENDIF
             IF ballCol = thisCol AND
                ballRow = thisRow THEN
                ball = chr(asc(ball)+1)
                deltaBall = deltaBall + 1
             ENDIF
          ENDIF
          IF mouseInfo["DOUBLECLICK"] THEN
             QUITLOOP
          ENDIF
       ENDIF

       newTime = TICKS()
       IF newTime > oldTime+speed THEN
           oldTime = newTime
           @ ballRow,ballCol ??" "

           IF ballRow >= 23 THEN            ;ball is at edge
              areaHit =  ballCol-thisCol
              SWITCH
              CASE areaHit > 10 OR areaHit < 0:    ;was it hit?
                    QuitSound()                    ; nope
              CASE areaHit < 2:
                    deltaCol = ABS(deltaCol) * -2        ;bounce reverse
                    sound 300 20
                    deltaCorner = deltaCorner + 1
              CASE areaHit > 8:
                    deltaCol = ABS(deltaCol) * 2        ;bounce reverse
                    sound 300 20
                    deltaCorner = deltaCorner + 1
              OTHERWISE:
                    deltaCol = deltaCol / ABS(deltaCol)  ;neg or pos 1
              ENDSWITCH
              sound 400 100
              deltaRow = deltaRow * -1
              deltaHit = deltaHit + 1        ;incr number of hits
           ELSE IF ballRow <= 4 THEN
              sound 700 100
              deltaRow = deltaRow * -1
           ENDIF
           ENDIF

           ballRow = ballRow+deltaRow

           IF ballCol+deltaCol >= 79  OR ballCol+deltaCol <= 0 THEN
              deltaCol = deltaCol * -1
           ENDIF
           ballCol = ballCol+deltaCol

           @ ballRow, ballCol ??ball
       ENDIF
   ENDWHILE
   CURSOR NORMAL
ENDPROC

PROC MoveRaquet(lastCol, thisCol)
   delta = thisCol - lastCol  ;only paint what is needed
   IF delta < 0 THEN       ;moving right
      PAINTCANVAS ATTRIBUTE 76 24,thisCol,24,lastCol
      PAINTCANVAS ATTRIBUTE 48 24,thisCol+10,24,lastCol+10
   ELSE                    ;moving left
      PAINTCANVAS ATTRIBUTE 48 24,lastCol,24,thisCol
      PAINTCANVAS ATTRIBUTE 76 24,thisCol,24,thisCol+10
   ENDIF
   RETURN
ENDPROC

PROC PaintText(r1,txt)
PRIVATE r2,c1,c2
   r2=r1+2
   c1=40-int((len(txt)+4)/2)
   c2=c1+len(txt)+4
   PaintBox(r1,c1,r2,c2)
   style attribute 30
   @r1+1,c1+2 ??txt
   style
ENDPROC

PROC PaintBox(r1,c1,r2,c2)
PRIVATE i
   paintcanvas attribute 31 r1, c1, r2, c2
   style attribute 25
   @r1,c1 ??""+fill("", c2-c1-1)
   for i from r1+1 to r2-1
     @i,c1 ??""
   endfor
   style attribute 16
   @r2,c1 ??" "+fill("", c2-c1-1)+""
   for i from r1+1 to r2-1
     @i,c2 ??""
   endfor
   style
ENDPROC


PROC BeginSound()
   SOUND 1000 100
   ButtonValue = "x"
   speed = 50
   SHOWDIALOG "Let the games begin" @8,10 HEIGHT 10 WIDTH 60
       @0,0 ??format("w60,ac", "Full racket hits release 10 units.")
       @1,0 ??format("w60,ac", "When mouse cursor touches ball 30 units")
       @2,0 ??format("w60,ac", "Corner racket hits release 50 units.")

       @4,0 ??format("w25,ar", "Speed: ")
       ACCEPT @4,26 WIDTH 8
         "N"
         PICTURE "*#"
         REQUIRED
         MIN 20
         MAX 200
         TAG "acceptTag"
         TO speed

       PUSHBUTTON @6,30 WIDTH 10
         "~W~ay"
         OK
         DEFAULT
         VALUE "W"
         TAG "CancelTag"
         TO ButtonValue

       PUSHBUTTON @6,10 WIDTH 10
         "~N~o Way"
         CANCEL
         VALUE "M"
         TAG "OKTag"
         TO ButtonValue

   ENDDIALOG

   RETURN IIF((ButtonValue = "W"),TRUE,FALSE)
ENDPROC

PROC QuitSound()
   SOUND 100 100
   SOUND 300 100
   SOUND 500 100
   SOUND 300 500

   SOUND 8000 300
   SOUND 1000 500
   ButtonValue = "x"
   SHOWDIALOG "W a l l" @10,15 HEIGHT 10 WIDTH 50
       @0,0 ??format("w35,ar", strval(deltaHit)+" Full Hits(10) = "+strval(deltaHit*10))
       @1,0 ??format("w35,ar", strval(deltaBall)+" Ball Mutations(30) = "+strval(deltaBall*30))
       @2,0 ??format("w35,ar", strval(deltaCorner)+" Corner Hits(50) = "+strval(deltaCorner*50))

       @4,0 ??format("w35,ar", " Total = "+strval((deltaHit*10)+(deltaBall*30)+(deltaCorner*50)))

       PUSHBUTTON @6,30 WIDTH 10
         "~N~o Mas"
         OK
         DEFAULT
         VALUE "N"
         TAG "CancelTag"
         TO ButtonValue

       PUSHBUTTON @6,10 WIDTH 10
         "~M~as"
         CANCEL
         VALUE "M"
         TAG "OKTag"
         TO ButtonValue

   ENDDIALOG

   IF (ButtonValue = "N") THEN
      RELEASE PROCS ALL
      RELEASE VARS ALL
      QUIT
   ELSE
      RELEASE PROCS ALL
      RELEASE VARS ALL
      PLAY "Racket"
   ENDIF
ENDPROC
Main()
