;FoneUp.sc                     April 1, 1992
;Ed Cuneo
;Renaissance Software and systems
;71620,2211
;
; = Documentation ==================================================================
cursor off
canvas off
clear
@24,1
??" [F1] -> help, [Esc] -> quit, Any other key to continue...."
paintcanvas border attribute 112
0,0,24,79
@1,2
setmargin 2
??" I like being able to call this robust proc after accessing a record where"
 ?" a phone number with an unknown format is expected to be found in some"
 ?" field. It's not mode sensitive. I don't know if there's an advantage to"
 ?" using the SETPRINTER command to assign the communications port. I set up a"
 ?" MODE command in my autoexec.bat file to define primary modem parameters,"
 ?" e.g MODE COM1:9600,E,7,1,p. See your DOS manual for more on MODE."
 ?" This auto-dialing procedure expects phone numbers to be passed in any"
 ?" 1 of the following 5 formats where the alpha character 'a' is any ascii"
 ?" symbol normally used in depicting phone numbers, including acronyms."
 ?"   1)  aaa-aaaa"
 ?"   2)  (aaa) aaa-aaaa"
 ?"   3)  aaa-aaa-aaaa"
 ?"   4)  1-aaa-aaa-aaaa"
 ?"   5)  1-aaa-aaaa"
 ?" The proc will insert a leading \"1-\" prolog if necessary."
 ?" Communications ports 1 through 4 are valid."
 ?" Use: dialer(Number,Port)"
 ?" The \"Number\" is derived from some source such as a table or a query"
 ?" and \"Port\" is the communications port you wish to send the echo to."
 ?" Modem presets will determine timeouts, response to busy, etc."
 ?""
 ?" Ed Cuneo, Renaissance software and Systems, 71620,2211, 407-896-1206"
setmargin off

paintcanvas attribute 48
1,1,23,78
paintcanvas attribute 240
24,56,24,60
canvas on

char=getchar()
if char=27
   then
     clear
     return
endif
if char=-59
   then
      canvas off
      paintcanvas fill chr(255)
      0,0,24,79
      paintcanvas border attribute 112
      0,0,24,79
      Lp=61
      Sc=40-int(Lp/2)
      Ec=40+int(Lp/2)
      @3,Sc
      setmargin Sc
      text
After the modem dials and is off hook:

1. To activate the phone, pickup the phone and press [Enter].

2. If you leave the phone on the cradle and press a key, the
   modem will hang up and the program will continue.

3. If the phone is off the cradle and you press a key, the
   program will continue, and you will have control of the
   phone.

      endtext
      paintcanvas attribute 112
      3,Sc-1,14,Ec+1
      Setmargin off
      style attribute 112
      @24,2
      ??"[Esc] to quit, Any other key continues...."
      paintcanvas attribute 240
      24,40,24,43
      canvas on
      char=getchar()
      if char=27
         then
           clear
           return
      endif
endif

; = Take in data for demo purposes only ==============================
clear
style reverse
@10,03??"Enter communications port number: "
style attribute 112
accept "s" to Port
if retval=false
   then
      clear
      return
endif
style reverse
@12,03??"            Enter number to dial: "
style attribute 112
accept "a14"  to PNumber
if retval=false
   then
      clear
      return
endif
; = End documentation ===============================================

; = Operative routines ==============================================
; The next conversion proc was stolen from:
; Michael Ax
; AX-SYSTEMS
; CServ# 71560,1754

proc convert_alpha(TNumbr)         ; convert all alpha strings to phone number
; TNumbr    -> phone number from calling routine
; n         -> loop counter
; c         -> character obtained from phone number
; newnumber -> phone number after conversion
private n,c,newnumber,ok
newnumber=""  ok=true
for n from 1 to len(TNumbr)        ;
 c=substr(TNumbr,n,1)              ; get a single character from the number
 switch                            ; if the char is valid, keep it
 case search(c,"0123456789-)( ")>0:
 case search(c,"ABC")>0:c="2"      ; convert alpha strings to appropriate
 case search(c,"DEF")>0:c="3"      ; digits
 case search(c,"GHI")>0:c="4"
 case search(c,"JKL")>0:c="5"
 case search(c,"MNO")>0:c="6"
 case search(c,"PRS")>0:c="7"
 case search(c,"TUV")>0:c="8"
 case search(c,"WXY")>0:c="9"
 case search(c," /")>0: quitloop   ; terminate phone number (must be " " or "/")
 otherwise: ok=False               ; non phone number char means error
 endswitch
 newnumber=newnumber+c             ; add converted char to string
endfor
if ok then return newnumber        ; return converted number part of string
 else return ""                    ; signal error / nothing to dial
endif
endproc

proc check_length(p1,p2,p3)            ;check phone number parts for proper
if (isblank(p1)=false and len(p1)<>3)  ;number of digits
   or len(p2)<>3 or len(p3)<>4         ;p1 could be blank if TNumbr is local
      then                             ;the length of p2 is always 3
        return false                   ;the length of p3 is always 4
      else
        return true
endif
endproc

; == Main routine ===================================================
clear
proc Dialer(TNumbr,ComPort)
  ;TNumbr   -> Telephone number as received
  ;ComPort  -> Active modem port
  ;y        -> boolean
  ;x        -> dummy reciever
  ;pnum     -> Number after its set up to dial
  ;p1,p2,p3 -> number sections
private ComPort,x,y,pnum,p1,p2,p3
If ComPort<1 or ComPort>4
   then
      message "Communications port not specified. Any key continues.."
      char=getchar()
      return
   else
      ComPort="COM"+strval(ComPort)+":"
endif
TNumbr=convert_alpha(TNumbr)
if isblank(TNumbr)=false           ;this check allows you to pass a number
  then                             ;from a field where you are not sure a
     p1=""                         ;number actually exists.
     p2=""
     p3=""                         ;the next series of matches is ordered
                                   ;so that subsets don't create invalid
                                   ;traps
     y=match(TNumbr,"(..) ..-..",p1,p2,p3)       ;(aaa) aaa-aaaa
     if y=false
        then
           y=match(TNumbr,"1-..-..-..",p1,p2,p3)          ;1-aaa-aaa-aaaa
           if y=false
                then
                  y=match(TNumbr,"1-..-..",p2,p3)         ;1-aaa-aaaa
                  if y=false
                     then
                        y=match(TNumbr,"..-..-..",p1,p2,p3) ;aaa-aaa-aaaa
                        if y=false
                           then
                              y=match(TNumbr,"..-..",p2,p3) ;aaa-aaaa
                              if y=false
                                 then
; === You could ask for a valid phone number to be entered at this point ===
; === or you could shell to a communication program.                     ===
                                    message TNumbr+" is an invalid phone number. Any key continues..."
                                    x=getchar()
                                    return
                                 else
                                    pnum=TNumbr          ;make it so
                              endif
                           else
                             pnum="1"+p1+p2+p3           ;insert prologue
                        endif
                     else
                        pnum=TNumbr                      ;make it so
                  endif
              else
                  pnum=TNumbr                            ;make it so
           endif
        else
           pnum="1"+p1+p2+p3                             ;insert prologue
     endif
     if Check_length(p1,p2,p3)=false     ;trap phone number parts with
        then                             ;improper number of digits
           message Pnum+" is an invalid phone number. Any key continues..."
           x=getchar()
           return
     endif
     run norefresh  "ECHO ATL1>"+ComPort                 ;lower volume
     message "Dialing: "+pnum
     run norefresh  "ECHO ATDT"+pnum+" >"+ComPort        ;dial number
  else
     message "No phone number available! Any key continues..."
     x=getchar()
     return
endif
x=getchar()
run norefresh "ECHO ATH>"+ComPort
return
endproc


; = Sample call using test data : data could have been obtained =====
; = from a record

dialer(PNumber,Port)
release procs all
return

; ===================================================================

;End FoneUp.sc
