/*
 * 	tcvideo.h   header file for tcvideo.c
 */

/* ------- function prototypes --------*/
int  	Vidtext		(int row, int col, int attrib, char *msg);
int  	Vidchar		(int row, int col, int attrib, char ch);
int 	Vidattrib	(int fore,int back);
int	Videditfield	(char *buf, int length, int attrib);
int 	Cursput		(int row, int col);	/* moves cursor */
int  	Cursread	(int *row, int *col);	/* returns location */

int 	getkey		();
void 	tickwait	(unsigned int);
void 	tone		(unsigned int, unsigned int);	/* for beeps */

/*------  functions defined as macros --------*/
#define beepshort()		tone(880,1);
#define beeplow()		tone(440,1);

/*------  global variable flag --------*/
extern int Videditchanged;

/***********************  VIDEO DEFINES ***********************/
#define BLANK  32

/* primary video attributes */
#define BLU	1
#define GRN	2
#define RED	4

/* composite colors */
#define BLK	0
#define CYAN	(BLU | GRN )
#define MAG	(BLU | RED )
#define BRN	(GRN | RED )
#define WHT	(BLU | GRN | RED )
#define GRAY	(BLK | BRIGHT )
#define LBLU	(BLU | BRIGHT )
#define LGRN	(GRN | BRIGHT )
#define LRED	(RED | BRIGHT )
#define LMAG	(MAG | BRIGHT )
#define YEL	(BRN | BRIGHT )
#define BWHT	(WHT | BRIGHT )
#define REVERSE 112

/* video attribute modifiers */
#define BRIGHT	8
#define BLINK	128

/*********************** KEYBOARD DEFINES *******************/

/* extended key flag */
#define XF            0x100

/* function keys */
#define K_F1        ( 59 | XF )
#define K_F2        ( 60 | XF )
#define K_F3        ( 61 | XF )
#define K_F4        ( 62 | XF )
#define K_F5        ( 63 | XF )
#define K_F6        ( 64 | XF )
#define K_F7        ( 65 | XF )
#define K_F8        ( 66 | XF )
#define K_F9        ( 67 | XF )
#define K_F10       ( 68 | XF )
#define K_FKEY      ( 58 | XF )

/* cursor keypad (NumLock off) */
#define K_HOME      ( 71 | XF )
#define K_END       ( 79 | XF )
#define K_PGUP      ( 73 | XF )
#define K_PGDN      ( 81 | XF )
#define K_LEFT      ( 75 | XF )
#define K_RIGHT     ( 77 | XF )
#define K_UP        ( 72 | XF )
#define K_DOWN      ( 80 | XF )
#define K_INS       ( 82 | XF )
#define K_DEL       ( 83 | XF )

#define K_ENTER       13
#define K_ESC         27
#define K_SPACE       32
#define K_BKSPACE      8
#define K_RTAB         9
#define K_LTAB      ( 15 | XF )


