/**-------------------------------------------------------**/
/**  TCVIDEO.C   Copyright (C) 1991, Steve Jackson        **/
/**-------------------------------------------------------**/

/*
 *	tcvideo.c 	video routines using Turbo C routines
 *			keyboard, cursor, and beep using BIOS routines
 */

#include <dos.h>		/* registers for BIOS calls */
#include <stddef.h>		/* defines for NULL, etc. */
#include "tcvideo.h"		/* our stuff */

int	Videditchanged;		/* flag that something changed in edit */

/*
 *   vidtext	Write a null-delimited string to the screen with attribute
 *		using writes to video memory
 */

int Vidtext( row, col, attrib, msg )
	int row, col, attrib;
	char *msg;
{
	struct msgstruc {
		char msgchar;
		char msgattrib;
	} ourmsg[80];

	char buf[160];
	register i, j;
	int right;

	i = j = 0;

	while ( *msg ) {
		if (i > 79)
			break;
		buf[j++] = *msg;
		buf[j++] = attrib;
		i++;
		msg++;
	}

	right = col + i - 1;
	if (right > 80)
		right = 80;
	puttext(col, row, right, row, buf);
	return(i);
}

/*
 *   vidchar    Write a character attribute pair to the screen
 *              using writes to video memory
 */

int Vidchar( row, col, attrib, ch )
	int row, col, attrib;
	char ch;
{
	char buf[2];

	buf[0] = ch;
	buf[1] = attrib;
	puttext(col, row, col, row, (char *)buf);

	return(1);
}

/*---------- Routine used for allowing user edit of a field---------*/
/*---------- Also see MAPS.C for full screen edit manager  ---------*/


int   Videditfield(buf, maxleng, attr)
	char 	buf[];
	int	maxleng;
	int	attr;
{
	int 	keystroke, i,j;
	int	startrow, startcol;
	int	ins_on;
	char	ch;

	maxleng--;	/* adjust for length without NULL end */
	ins_on = Videditchanged = 0;
	i = 0;
	Cursread(&startrow, &startcol);

	while ( 1 ) 				/* until ENTER or ESC */
	{
	    keystroke = getkey ();		/* get a keystroke  */
	    /*---------------- check keys pressed ----------------*/
	    switch ( keystroke ) {
		case K_RIGHT:	i++;
				break;

		case K_LEFT:	i--;
				break;

		case K_INS:	ins_on = ins_on ? 0 : 1 ;
				break;

		case K_DEL:     for (j=i; j<maxleng; j++)
					if ( buf[j+1] == 0 )
						buf[j] = BLANK;
					else
						buf[j] = buf[j+1];
				Vidtext(startrow, startcol, attr, buf);
				break;

		case K_BKSPACE:	if (i)
				{
				i--;
				for (j=i; j<maxleng; j++)
					if ( buf[j+1] == 0 )
						buf[j] = BLANK;
					else
						buf[j] = buf[j+1];
				Vidtext (startrow, startcol, attr, buf);
				}
				break;
		default:

		if ( keystroke < 127  &&  keystroke > 31 )   /* ASCII? */
		{
			++Videditchanged;
			ch = keystroke;
			/**  beyond max length?  beep and ignore **/
			if ( i >= maxleng) {
				beepshort();
				break;		/* get next keystroke */
			}

			/**  if INS toggle on, shift right, redisplay **/
			if ( ins_on) {
				for (j=maxleng; j>i; j--)
				buf[j] = buf[j-1];
				buf[maxleng] = 0;
				Vidtext(startrow, startcol, attr, buf);
			}

			if ( buf[i] == 0 ) {	/* if end of string, */
				buf[i+1] = 0;	/* make new end next char */
			}

			/** put the char in the buffer, echo to screen **/
			buf[i] = ch;
			Vidchar(startrow,startcol+i,attr,ch);

			/** advance index, check for max later and adjust **/
			i++;

		}  /* end IF alpha keystroke */
		else
			return(keystroke);

		break;
		}   /*-------------- end of switch ( keystroke ) --------*/

	if (i < 0)
		i = 0;
	if (i > maxleng)
		i = maxleng;
	Cursput (startrow, startcol + i);

	}  /*--------------  end of while loop  -------------------*/
}

/*---------- Miscellaneous video routines for cursor, etc. ---*/

/*
 *    cursread	  return the location of the cursor (row, column)
 *		  on a specified video page
 */

int Cursread(r, c)
	int *r, *c; 			   /* row, column */
{
	*r = wherey();
	*c = wherex();
	return(0);
}

/*
 *   cursput	move the cursor to a location on the screen (row, column)
 *		for a specfified video page
 */

int  Cursput(r, c)
	int r, c;                          /* row, column */
{
	gotoxy(c,r);
	return(0);
}

/*
 *	cursgetlines	get start and end cursor scan lines
 *			be SURE to call like:
 *				Cursgetlines( &start, &end );
 */

int Cursgetlines(s,e)
	int *s, *e;
{
	union REGS inregs, outregs;
	int p;
	p = Vidgetpage();


	inregs.h.bh = Vidgetpage();	/* video page */
	inregs.h.ah = 3;

	int86(0x10, &inregs, &outregs);

	*e = outregs.h.cl & 0x0F;	/* end   scan line */
	*s = outregs.h.ch & 0x0F;	/* start scan line */

	return(outregs.x.cflag);
}

/*
 *	curssetlines	       Set cursor start and end scan lines
 *			       Useful for hiding/unhiding the cursor
 */

int Curssetlines(s,e)
	int s, e;
{
	union REGS inregs, outregs;
	int vidpage;

	inregs.h.ah = 1;		/* set cursor line function */
	inregs.h.ch = s & 0x0F;
	inregs.h.cl = e & 0x0F;

	int86(0x10, &inregs, &outregs);

	return(outregs.x.cflag);
}





/*
 *  vidclear		clear the entire screen using BIOS function
 */

int Vidclear(attrib)
	int attrib;
{
	union REGS inregs, outregs;

	inregs.h.ah = 0x06;			/* scroll up function */
	inregs.h.al = 0x00;			/* clear entire window */
	inregs.h.bh = attrib;			/* set to this attribute*/
	inregs.h.bl = 0x00;
	inregs.x.cx = 0x0000;			/* upper left row 0 col 0 */
	inregs.h.dh = 24;			/* bottom row */
	inregs.h.dl = 79;			/* rightmost column */

	int86( 0x10, &inregs, &outregs);        /* BIOS video call */

	return ( outregs.x.cflag );             /* return carry flag */
}


/*
 *  Vidboxclear		clear a portion if the screen using BIOS function */

int Vidboxclear(top,left,bottom,right,attrib)
	int top,left,bottom,right,attrib;
{
	union REGS inregs, outregs;

	/** adjust all the coordinates, 			**/
	/**	since we start XY at 1,1 and BIOS starts at 0,0 **/
	top--;
	left--;
	bottom--;
	right--;

	inregs.h.ah = 0x06;			/* scroll up function */
	inregs.h.al = 0x00;			/* clear entire window */
	inregs.h.bh = attrib;			/* set to this attribute*/
	inregs.h.bl = 0x00;
	inregs.h.ch = top;			/* upper left row */
	inregs.h.cl = left;			/* leftmost column */
	inregs.h.dh = bottom;			/* bottom row */
	inregs.h.dl = right;			/* rightmost column */

	int86( 0x10, &inregs, &outregs);        /* BIOS video call */

	return ( outregs.x.cflag );             /* return carry flag */
}


/*
 *   Vidgetmode	   determine the DOS mode ( 7 = mono, others = color)
 */

int  Vidgetmode()
{
	union REGS inregs, outregs;

	/* get mode, width, active page from BIOS */
	inregs.h.ah = 15;
	int86(0x10, &inregs, &outregs);
	return(outregs.h.al);
}

/*
 *   Vidgetpage	   get current active video page number (usually is 1)
 */

int  Vidgetpage()
{
	union REGS inregs, outregs;
	int p;

	/* get mode, width, active page from BIOS */
	inregs.h.ah = 15;
	int86(0x10, &inregs, &outregs);

	p = outregs.h.bh;	/* al = mode, ah = width, bh = page */
	return(p);
}


int Vidattrib(fore,back)
	int fore,back;
{
	return ( (back*16) + fore );	/* probably faster with shift? */
}


int getkey()
{
    union REGS inregs, outregs;
    int  ch;

    inregs.x.ax = 0x0000;                   /* get key from buffer */
    int86( 0x16, &inregs, &outregs);        /* BIOS keyboard call */

    if ( outregs.h.al != '\0' )      /* if its ascii */
	return ( outregs.h.al );     /* return it */
				     /* otherwise it's IBM extended   */
    return ( outregs.h.ah | 0x100 );    /* return scan code + 256 */
}

void  setfreq(unsigned int);
void  tickwait(unsigned int);
void  tone(unsigned int, unsigned int);

#define  TIMER_CLK      1193180L
#define  TIMER_MAX      65536L
#define  TICKRATE       TIMER_CLK  /  TIMER_MAX

void tone(freq, dur)
	unsigned int freq, dur;
{
	sound(freq);
	tickwait(dur);
	nosound();
	return;
}



void  tickwait(d)
	unsigned int d;
{
	long ticks, donetick;
	long getticks();

	ticks = d * TICKRATE / 10;
	donetick = getticks() + ticks;
	while (1) {
		if (getticks() >= donetick)
			break;
	}
}

long  getticks()
{
	long count;
	union REGS inregs, outregs;

	/* get BIOS time of day as number of ticks since midnight */
	inregs.h.ah = 0;
	int86(0x1A, &inregs, &outregs);

	/* correct for possible rollover at 24 hours */
	count = ( outregs.h.al != 0) ? 0x01800B0L : 0;

	/* add current day ticks */
	count += (outregs.x.dx + (outregs.x.cx << 16) );

	return(count);
}

