/**-------------------------------------------------------**/
/**  FONEDEX2.C   Copyright (C) 1991, Steve Jackson       **/
/**-------------------------------------------------------**/
/**
  *	This program was written by Steve Jackson as
  *	an alternative to the FONEDEX program included
  *	in the PARADOX ENGINE product from BORLAND.  It
  *	must be compiled with TCVIDEO.C and MAPS.C which were
  *	also written by Steve Jackson.  It is meant as a learning
  *	experience in video and mapping routines.
  *
  *	The source code is free to all, and may be freely
  *	distributed.  The only restriction is that if you
  *	do distribute to bulletin boards or otherwise, you keep
  *	them intact and include my copyright notice, etc.  You
  *	may include portions of the source code with your programs
  *	in which case you should remove my copyright notice.
  *
  *	Please keep in mind that since this is free, I do not
  *	plan to provide support for the source code (I have a
  *	real job and some kids to keep me busy).  If you have
  *	comments, brief questions, or ideas for other
  *     programming ventures, please contact me at:
  *		Steve Jackson
  *		9152 Brabham Drive
  *		Huntington Beach, CA  92646
  *
  *	I don't get on compuserve much (due to connect $),
  *	but will try to check from time to time.
  *
  *	This program requires use of PARADOX ENGINE libraries
  *	which MUST be purchased from BORLAND.  They are NOT
  *	included with this program, and should NOT be distributed
  *	with this program source code under any circumstances.
  *
  ****/

#if !defined(__LARGE__)
#error Must compile LARGE memory model to use Paradox Engine
#endif


#include <stddef.h>
#include "tcvideo.h"
#include "maps.h"

/**----------------  Paradox engine stuff  ------------------  **/

#include "pxengine.h"
#define USERNAME	"Engine"
#define	NETTYPE		NOTONNET
#define NETDIR		""
#define DB_OK		0

char	dbname[] = "fonedex";
int	TableIsOpen = 0;
RECORDHANDLE	rechandle;
TABLEHANDLE	tblhandle;

int	hName 	= 1;
int	hAddress = 2;
int	hCity	= 3;
int	hZip	= 4;
int	hPhone	= 5;
int	hDate	= 6;

char	tName	= 'A';
char	tAddress = 'A';
char	tCity	= 'A';
char	tZip	= 'N';
char	tPhone	= 'A';
char	tDate	= 'D';

int	NumFields = 6;
int	KeyFields = 1;

/**----------------  Database fields ------------------------ **/

char name[21];
char address[51];
char city[16];
char zip[6];
char phone[16];
char date_called[11];

/**----------------  Mapping and menus ---------------------- **/

#include "fonedex2.map"

char *MainMenu[] = {
	"1. View records on the database",
	"2. Add records to the database",
	"3. Change records on the database",
	"Q. Quit this program"
	};
#define MENU_ITEMS 4

/** -------------  Miscellaneous global colors, etc. -------------**/
int	attr_norm;		/* various video attributes */
int	attr_brite;		/* set in setcolor() */
int	attr_rev;
int	attr_title;
int	attr_menu;
int	attr_shadow;

int	curs_start, curs_end;

/**--- #define CURSOR_HIDE 	Curssetlines(curs_start,curs_end+2); \ ---**/
#define CURSOR_HIDE   	Cursput(1,1);
#define CURSOR_UNHIDE	Curssetlines(curs_start, curs_end);

main()
{
	char choice;
	int  menu_choice;
	int  done;

	setcolors();

	/** Initialize the paradox engine **/
	db(PXNetInit(NETDIR, NETTYPE, USERNAME));


	startup();

	done = 0;
	while ( !done ) {
		Vidclear(attr_norm);
		CURSOR_HIDE
		Vidboxclear(3,21,5,47,attr_shadow);
		Vidboxclear(2,20,4,46,attr_title);
		Vidtext(3,22,attr_title,"Database Update System");
		Vidboxclear(22,21,24,41,attr_shadow);
		Vidboxclear(21,20,23,40,attr_title);
		Vidtext(22,22,attr_title,"Make yer choice...");

		Vidboxclear(9,18,11+MENU_ITEMS,72,attr_shadow);
		Vidboxclear(8,17,10+MENU_ITEMS,71,attr_menu);
		Vidtext(8,20,attr_menu,"THE MAIN MENU");
		menu_choice = getmenuchoice(MainMenu, MENU_ITEMS, 10, 20);
		switch (menu_choice) {
			case (-1):
			case (MENU_ITEMS):	/* last choice = QUIT */
					done = 1;
					break;
			case (1):	View_Records();
					break;
			case (2):       Add_Records();
					break;
			case (3):       Change_Records();
					break;
		} /* end switch */
	} /* end while */

	CURSOR_UNHIDE
	/** Close table if open, and terminate the paradox engine **/
	if (TableIsOpen) {
		db(PXRecBufClose(rechandle));
		db(PXTblClose(tblhandle));
	}
	db(PXExit());


	Vidclear(Vidattrib(WHT,BLK));
	Cursput(1,1);
	exit(0);
}

/*-----------------------------------------------------------------*/
/*
 *	check the return code of each paradox engine call
 *	display some dire message if it fails
 */

int db(err_count)
	int err_count;
{
	int	a;
	char	buf[10];
	int	r,c;

	if (err_count == 0)		/* was database call OK ? */
		return(0);		/* if so, continue */

	a = Vidattrib(BLK,WHT);		/* else create error msg */
	itoa(err_count,buf,10);

	r=8;
	c=20;

	Vidboxclear(r,c-2,r+10,c+40,a);
	Vidtext(r+1,c,a,"Big trouble!  Paradox engine error!");
	Vidtext(r+2,c,a,"Paradox code: ");
	Vidtext(r+2,c+15,a,buf);
	Vidtext(r+4,c,a,"Press a key to end the program...");
	getkey();
	Vidclear(Vidattrib(WHT,BLK));
	Cursput(1,1);
	exit(1);
}

/*
 *	startup housekeeping
 */


int setcolors()
{
	Cursgetlines(&curs_start, &curs_end);	/* save orig cursor size */

	if ( Vidgetmode() == 7) { 	/* MONO */
		MapColorNorm = Vidattrib(WHT,BLK);
		MapColorData = Vidattrib(BLU,BLK);	/* underline */
		MapColorEdit = Vidattrib(BLK,WHT);	/* reverse vid */
		attr_title   = Vidattrib(BLK,WHT);
		attr_menu    = Vidattrib(WHT,BLK);
	}
	else if ( Vidgetmode() == 3) {	/* COLOR */
		MapColorNorm = Vidattrib(WHT,BLU);
		MapColorData = Vidattrib(BLK,CYAN);
		MapColorEdit = Vidattrib(BLK,WHT);
		attr_title   = Vidattrib(BLK,GRN);
		attr_menu    = Vidattrib(BLK,CYAN);
	}
	else {
		puts("Sorry! Cannot run in this video mode!");
		exit(1);
	}
	attr_norm  = MapColorNorm;
	attr_brite = MapColorData;
	attr_rev   = MapColorEdit;
	attr_shadow = Vidattrib(WHT,BLK);
}

/*-------------------------------------------------------------
 *
 *	Menu returns number of item chosen (first item = 1)
 */

int getmenuchoice(desc, maxnum, row, col)
	char 	*desc[];
	int	maxnum;
	int	row, col;
{
	int	i, j, maxi;
	int	keystroke, k;
	char	choice_key[40];		/* 1st letter of each menu item */

	for (i=0; i<maxnum; i++) {
		Vidtext(row + i, 20, attr_menu, desc[i]);
		choice_key[i] = toupper(desc[i][0]);
	}

	i = 0;
	while (1) {
		Vidtext(row + i, 20, attr_rev, desc[i]);
		keystroke = getkey();
		Vidtext(row + i, 20, attr_menu, desc[i]);
		switch (keystroke) {
			case K_ESC:	return(-1);
			case K_ENTER:   return(i+1);
			case K_DOWN:	i++;
					break;
			case K_UP:	i--;
					break;
			default:	k = toupper(keystroke);
					for(j=0; j<maxnum; j++)
					   if (k == choice_key[j])
						    return(j+1);
					beepshort();
					break;
		} /* end switch */
		if (i < 0)
			i = maxnum - 1;
		if (i >= maxnum)
			i = 0;
	}

	return(0);
}

/* ==================================================================
 *
 *		MAIN DATABASE ROUTINES
 *
 * ==================================================================
 */

int	Add_Records()
{
	int keystroke;
	int done;

	Vidclear(attr_norm);
	Vidtext(25,58,attr_norm,"F2 Update  ESC Cancel");

	if ( open_table() != DB_OK ) {
		do_msg("Cannot open database.");
		return(1);
	}

	done = 0;
	clear_fields();
	while ( !done ) {
		Mapout(testflds, testmsgs);
		CURSOR_UNHIDE
		keystroke = Mapin(testflds);
		CURSOR_HIDE
		bottom_msg(" ");
		switch (keystroke) {
			case K_ESC:	done = 1;
					break;
			case K_ENTER:
			case K_F2:      put_fields();
					if (PXRecAppend(tblhandle,rechandle)
							== DB_OK) {
						clear_fields();
						bottom_msg("Record added");
					}
					else {
						bottom_msg("Duplicate key!");
						beepshort();
					}
					break;
			default:	beepshort();
					break;
		} /*** end switch ***/
	} /*** end While ***/

	close_table();
	return(0);
}



int	Change_Records()
{
	int keystroke;
	int done;

	Vidclear(attr_norm);
	Vidtext(25,58,attr_norm,"           ESC Cancel");

	if ( open_table() != DB_OK ) {
		do_msg("Cannot open database.");
		return(1);
	}

	done = 0;
	clear_fields();
	while ( !done ) {
		/*-------------  get the key --------*/
		Mapout(keyflds,  keymsgs);
		CURSOR_UNHIDE
		if (Mapin(keyflds) == K_ESC) {
			done = 1;
			break;
		}
		bottom_msg(" ");

		/*------------- get the record -------------*/
		put_keyfields();
		if (PXSrchKey(tblhandle, rechandle,
				KeyFields,
				SEARCHFIRST) == PXERR_RECNOTFOUND)
			if (PXSrchKey(tblhandle, rechandle,
				KeyFields,
				CLOSESTRECORD) == PXERR_RECNOTFOUND)
					bottom_msg("Closest record");
			else
					bottom_msg("End of table");

		get_fields();	/* get the record, and move field buffers*/

		/*------------- get changes to the record --------*/
		Mapout(testflds, testmsgs);
		CURSOR_UNHIDE
		keystroke = Mapin(testflds);
		CURSOR_HIDE
		bottom_msg(" ");
		switch (keystroke) {
			case K_ESC:	done = 1;
					break;
			case K_ENTER:
			case K_F2:      put_fields();
					if (PXRecUpdate(tblhandle,rechandle)
							== DB_OK) {
						clear_fields();
						bottom_msg("Record changed");
					}
					else {
						bottom_msg("Duplicate key!");
						beepshort();
					}
					break;
			default:	beepshort();
					break;
		} /*** end switch ***/
	} /*** end While ***/

	close_table();
	return(0);
}


int 	View_Records()
{
	int keystroke;
	int done;

	Vidclear(attr_norm);
	Vidtext(25,61,attr_norm,"ESC Main Menu");

	if ( open_table() != DB_OK ) {
		do_msg("Cannot open database.");
		return(1);
	}

	if ( PXRecFirst(tblhandle) != DB_OK ) {
		do_msg("Sorry!  Database is empty.");
		return(1);
	}

	done = 0;
	while ( !done ) {
		get_fields();
		Mapout(testflds, testmsgs);
		keystroke = getkey();
		bottom_msg(" ");
		switch (keystroke) {
			case K_ESC:	done = 1;
					break;
			case K_PGDN:    if ( PXRecNext(tblhandle) != DB_OK)
						bottom_msg("END OF DATA");
					break;
			case K_PGUP:	if ( PXRecPrev(tblhandle) != DB_OK)
						bottom_msg("START OF DATA");
					break;
			case K_HOME:	db( PXRecFirst(tblhandle) );
					break;
			case K_END:	db( PXRecLast(tblhandle) );
					break;
			default:	break;
		} /*** end switch ***/
	} /*** end While ***/

	close_table();
	return(0);
}

/* ----------------------------------------------------------------
 *
 *		UTILITY ROUTINES CALLED FROM VARIOUS PLACES
 *
 * ----------------------------------------------------------------
 */


int open_table()
{
	if (PXTblOpen(dbname, &tblhandle, 0, 0) != DB_OK)
		return(1);
	TableIsOpen = 1;
	db(PXRecBufOpen(tblhandle, &rechandle));
	return(0);
}

int close_table()
{
	db(PXRecBufClose(rechandle));
	db(PXTblClose(tblhandle));
	TableIsOpen = 0;
	return(0);
}

int get_fields()
{
	int i;

	db(PXRecGet(tblhandle,rechandle));
	get_PXfield(hName, 	tName, 		name,	sizeof(name));
	get_PXfield(hAddress,	tAddress,	address,sizeof(address));
	get_PXfield(hCity,	tCity,		city,	sizeof(city));
	get_PXfield(hZip,	tZip,		zip,	sizeof(zip));
	get_PXfield(hDate,	tDate,		date_called,
							sizeof(date_called));
	get_PXfield(hPhone,	tPhone,		phone,	sizeof(phone));

	return(0);
}

int	get_PXfield( hField, typeField, pfield, ifieldsize )
	int 	hField;
	char	typeField;
	char 	*pfield;
	int 	ifieldsize;
{
	int     FieldIsBlank;
	char	workbuf[80];
	DATE	theDate;
	int	mo,day,yr;
	double	doublenum;
	short	shortnum;

	FieldIsBlank = 0;
	/* if field is blank, return a blank string */
	db(PXFldBlank(rechandle, hField, &FieldIsBlank));

	if (FieldIsBlank) {
		strcpy(pfield," ");
		return(0);
	}

	memset(workbuf,BLANK,sizeof(workbuf));
	switch(typeField) {
		case 'a':
		case 'A':
			if (PXGetAlpha(rechandle, hField, ifieldsize, pfield)
				!= PXSUCCESS)
					return(1);
			break;
		case 'd':
		case 'D':
			if (PXGetDate(rechandle, hField, &theDate)
				!= PXSUCCESS)
					return(1);
			PXDateDecode(theDate, &mo, &day, &yr);
			sprintf(workbuf, "%d/%d/%d", mo, day, yr);
			memcpy(pfield,workbuf,ifieldsize);
			*(pfield+ifieldsize-1) = 0;
			break;
		case 'n':
		case 'N':
			if (PXGetDoub(rechandle, hField, &doublenum)
				!= PXSUCCESS)
					return(1);
			sprintf(workbuf, "%5.01f", doublenum);
			memcpy(pfield,workbuf,ifieldsize);
			*(pfield+ifieldsize-1) = 0;
			break;
		default:
			return(2);
	}
	return(0);
}


int put_fields()
{
	int num;
	long longnum;
	double doublenum;
	DATE date;
	int mo, day, yr;
	char buf[20];

	PXPutAlpha(rechandle,hName,name);
	PXPutAlpha(rechandle,hAddress,address);
	PXPutAlpha(rechandle,hCity,city);
	PXPutAlpha(rechandle,hPhone,phone);

	sscanf(zip, "%lf", &doublenum);
	if (num == 0)
		db(PXPutBlank(rechandle,hZip));
	else {
		db(PXPutDoub(rechandle,hZip,doublenum));
	}

	sscanf(date_called, "%d/%d/%d", &mo, &day, &yr);
	if (PXDateEncode(mo, day, yr, &date) != PXSUCCESS)
		PXPutBlank(rechandle,hDate);
	else
		PXPutDate(rechandle,hDate,date);

	return(0);
}

int put_keyfields()
{
	PXPutAlpha(rechandle,hName,name);
	return(0);
}

int clear_fields()
{
	name[0] = 0;
	address[0] = 0;
	city[0] = 0;
	zip[0] = 0;
	phone[0] = 0;
	date_called[0] = 0;
	return(0);
}

/*-----------------------  Miscellaneous ------------------------*/

/*
 *	Display a message in a box, ask for keypress to continue
 */

int do_msg(msg)
	char *msg;
{
	int r,c;

	r = 8;
	c = 20;

	Vidboxclear(r,c-2,r+10,c+40,attr_menu);
	Vidtext(r+2,c,attr_menu,msg);
	Vidtext(r+4,c,attr_menu,"Press any key to continue...");
	getkey();

}

int bottom_msg(msg)
	char *msg;
{
	Vidboxclear(25,1,25,50,attr_norm);
	Vidtext(25,1,attr_norm,msg);
	return(0);
}

int startup()
{
	int 	i, j, fieldhandle;
	char 	typebuf[10];

	if ( open_table() != DB_OK ) {
		do_msg("Cannot open database.");
		return(1);
	}

	/**  Get the handle number and type for each field **/
	PXFldHandle(tblhandle, "Name",		&hName);
	PXFldHandle(tblhandle, "Address",	&hAddress);
	PXFldHandle(tblhandle, "City",		&hCity);
	PXFldHandle(tblhandle, "Zip",		&hZip);
	PXFldHandle(tblhandle, "Phone number",	&hPhone);
	PXFldHandle(tblhandle, "Date last phoned",  &hDate);

	close_table();
	return(0);
}
