CREATELIB "FmtLib"

PROC GetTabName()
  CLEARALL
  ;
  ; get name of table to convert
  ; and check for its existence
  ;
  WHILE True
    CANVAS OFF
    CURSOR OFF
    CLEAR
    STYLE ATTRIBUTE 112
    SETMARGIN 10
    @8,10

TEXT
A L P H A N U M E R I C    F I E L D    F O R M A T T I N G

 Ŀ
  Enter name of table for which field formats are to be 
  modified.  Press [ENTER] only for a list of tables in 
  the current directory or use [ESC] to quit:           
 
ENDTEXT

    STYLE ATTRIBUTE 23
    CANVAS ON
    CURSOR NORMAL
    WHILE True
      @13,57 ??"         "
      @13,57
      ACCEPT "A8" PICTURE "*!" TO TabName
      SYNCCURSOR
      IF Retval AND ISBLANK(TabName)
        THEN IF NOT LookUpTab()
               THEN QUITLOOP
               ELSE RETURN True
             ENDIF
      ENDIF
      IF NOT Retval
        THEN CLEARALL
             CLEAR
             RETURN False
        ELSE IF NOT ISTABLE(TabName)
               THEN BEEP
                    MESSAGE "Table '"+TabName+
                            "' does not exist; reenter or quit..."
               ELSE RETURN True
             ENDIF
      ENDIF
    ENDWHILE
  ENDWHILE
ENDPROC

WRITELIB "FmtLib" GetTabName
