;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure GetFmtOptions
;Source File     : FLDFORMT.SC
;Author          : Jim Schwarz
;
;Informant Issue : September 1991
;
;Description     : A utility to reformat data that already exists in a table.
;                  Such uses might be to convert alphanumeric fields from all
;                  upper case to all lower case or to having just the first
;                  letter capitalized, etc.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740


CREATELIB "FmtLib"

PROC GetTabName()
  CLEARALL
  ;
  ; get name of table to convert
  ; and check for its existence
  ;
  WHILE True
    CANVAS OFF
    CURSOR OFF
    CLEAR
    STYLE ATTRIBUTE 112
    SETMARGIN 10
    @8,10

TEXT
A L P H A N U M E R I C    F I E L D    F O R M A T T I N G

 Ŀ
  Enter name of table for which field formats are to be 
  modified.  Press [ENTER] only for a list of tables in 
  the current directory or use [ESC] to quit:           
 
ENDTEXT

    STYLE ATTRIBUTE 23
    CANVAS ON
    CURSOR NORMAL
    WHILE True
      @13,57 ??"         "
      @13,57
      ACCEPT "A8" PICTURE "*!" TO TabName
      SYNCCURSOR
      IF Retval AND ISBLANK(TabName)
        THEN IF NOT LookUpTab()
               THEN QUITLOOP
               ELSE RETURN True
             ENDIF
      ENDIF
      IF NOT Retval
        THEN CLEARALL
             CLEAR
             RETURN False
        ELSE IF NOT ISTABLE(TabName)
               THEN BEEP
                    MESSAGE "Table '"+TabName+
                            "' does not exist; reenter or quit..."
               ELSE RETURN True
             ENDIF
      ENDIF
    ENDWHILE
  ENDWHILE
ENDPROC

PROC GetFmtOptions()
  PRIVATE TotFlds,FldName,CurrRec,Key,Option

  AlphaTot=0

  VIEW "FldFormt"
  VIEW TabName
  EDITKEY
  ;
  ; get number of data fields
  ; by moving to last field
  ;
  CTRLEND
  TotFlds=COLNO()-1
  CTRLHOME
  ARRAY FieldName[TotFlds]
  ARRAY FieldForm[TotFlds]
  ;
  ; loop for number of
  ; data fields
  ;
  FOR i FROM 1 TO TotFlds
    ;
    ; move out of record
    ; number field; move to
    ; next data field with
    ; each succeeding loop
    ;
    RIGHT
    ;
    ; if current field is
    ; type "A", store field
    ; name in format data table
    ;
    IF SUBSTR(FIELDTYPE(),1,1)="A"
      THEN FldName=FIELD()
           MOVETO "FldFormt"
           [Field name]=FldName
           DOWN
           AlphaTot=AlphaTot+1
           MOVETO TabName
    ENDIF
  ENDFOR
  ;
  ; edit format data table for
  ; type of field format needed
  ;
  MOVETO "FldFormt"
  HOME
  PICKFORM 1
  WHILE True
    CurRec=RECNO()
    PROMPT " [F2]  Format    [F6] Option all       "+
           " Enter format option or leave blank",
           " [Esc] Cancel                          "+
           " for no change"
    WAIT FIELD
      UNTIL "Enter","Up","Down","F2","F6","Esc"
    Key=Retval
    IF NOT ISBLANK([])
      THEN IF []<"1" OR []>"4"
             THEN IF Key<>"Esc"
                    THEN BEEP
                         MESSAGE "Option choice not "+
                                 "in expected range..."
                         SLEEP 1500
                         LOOP
                  ENDIF
           ENDIF
    ENDIF
    SWITCH
      CASE Key="Enter" OR Key="Down":
        IF CurRec=AlphaTot
          THEN BEEP
          ELSE KEYPRESS Key
        ENDIF
        LOOP
      CASE Key="Up":
        IF CurRec=1
          THEN BEEP
          ELSE KEYPRESS Key
        ENDIF
        LOOP
      CASE Key="F2":
        IF LoadFmtTab()
          THEN ChgFmt()
        ENDIF
        QUITLOOP
      CASE Key="F6":
        Option=[]
        HOME
        FOR i FROM 1 TO AlphaTot
          []=Option
          DOWN
        ENDFOR
        UP
        LOOP
      CASE Key="Esc":
        CANCELEDIT
        QUITLOOP
    ENDSWITCH
  ENDWHILE
ENDPROC

PROC LoadFmtTab()
  PRIVATE i,Change
  ;
  ; scan format data table into
  ; 'name' and 'format' arrays;
  ; use 'change' var to indicate
  ; entry of a format change for
  ; at least one field
  ;
  Change=False
  HOME
  FOR i FROM 1 TO AlphaTot
    FieldName[i]=[Field name]
    FieldForm[i]=[Format]
    IF NOT ISBLANK([Format])
      THEN Change=True
    ENDIF
    DOWN
  ENDFOR
  ;
  ; terminate program if no
  ; format changes entered
  ;
  IF NOT Change
    THEN BEEP
         MESSAGE "No format changes entered; terminating program..."
         SLEEP 1200
         CANCELEDIT
         RETURN False
  ENDIF
  RETURN True
ENDPROC

PROC ChgFmt()
  PRIVATE i,TotRecs
  ;
  ; make field format changes
  ;
  MOVETO TabName
  TotRecs=STRVAL(NIMAGERECORDS())
  SCAN
    MESSAGE "Formatting "+STRVAL(RECNO())+" of "+TotRecs+" records..."
    ECHO OFF
    CURSOR OFF
    FOR i FROM 1 TO AlphaTot
      MOVETO FIELD FieldName[i]
      SWITCH
        CASE FieldForm[i]="1":
          []=UPPER([])
        CASE FieldForm[i]="2":
          []=LOWER([])
        CASE FieldForm[i]="3":
          []=LOWER([])
          []=FORMAT("cc",[])
        CASE FieldForm[i]="4":
          String=[]
          CTRLBACKSPACE
          TYPEIN String
      ENDSWITCH
    ENDFOR
  ENDSCAN
  DO_IT!
ENDPROC

WRITELIB "FmtLib" GetTabName,GetFmtOptions,LoadFmtTab,ChgFmt


CREATELIB "TabLkUp"
;
; LookUpTab() provides a "lookup" of tables in the
; current directory; it calls TabLkUpScr() to open
; a window then displays the list of tables and
; manages user input
;
PROC LookUpTab()
  PRIVATE CurrRec,LineCount,CurrLine,NextLine,
          TopRec,RecCount,TotalRecs

  CurrRec  =1
  LineCount=1
  CurrLine =1
  NextLine =2
  TopRec   =1
  RecCount =0

  CURSOR OFF
  TabLkUpScr()
  ;
  ; remove tables List and Fldformt from list
  ; of table choices and get record count
  ;
  MOVETO [List->Name]
  EDITKEY
  LOCATE "List"
  DEL
  LOCATE "Fldformt"
  DEL
  DO_IT!
  HOME
  TotalRecs=NRECORDS("List")

  WHILE True
    RecCount=TopRec
    MOVETO RECORD TopRec
    STYLE ATTRIBUTE 31
    @6,0
    ;
    ; write table names and file dates to the
    ; scrollable window
    ;
    WHILE RecCount<=TotalRecs AND LineCount<9
      ?"   "+FORMAT("w15,al",[Name])+STRVAL([Date])+"  "
      RecCount=RecCount+1
      LineCount=LineCount+1
      DOWN
    ENDWHILE
    ;
    ; if more than one screen (8 records), display
    ; markers indicating scroll direction for more
    ;
    IF TotalRecs>8
      THEN IF TopRec>1
             THEN @7,25 ??CHR(30)
           ENDIF
           IF LineCount=9
             THEN IF RecCount<=TotalRecs
                    THEN @14,25 ??CHR(31)
                  ENDIF
             ELSE @5+LineCount,25
           ENDIF
    ENDIF
    ;
    ; if less than one screen full, clear remaining
    ; display of unwanted lines
    ;
    WHILE LineCount<9
      ?SPACES(28)
      LineCount=LineCount+1
    ENDWHILE
    LineCount=1
    ;
    ; highlight current selection and get user input
    ;
    WHILE True
      MOVETO RECORD CurrRec
      PAINTCANVAS ATTRIBUTE 113
        6+CurrLine,26,6+CurrLine,51
      CANVAS ON
      c=GETCHAR()
      SWITCH
        CASE c=-80:  ;Down
          IF CurrRec<TotalRecs
            THEN CurrRec=CurrRec+1
                 NextLine=CurrLine+1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-72:  ;Up
          IF CurrRec>1
            THEN CurrRec=CurrRec-1
                 NextLine=CurrLine-1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-81:  ;PgDn
          IF TotalRecs>TopRec+7
            THEN TopRec=TopRec+7
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-73:  ;PgUp
          IF TopRec>10
            THEN TopRec=TopRec-7
            ELSE IF TopRec=1
                   THEN BEEP
                        LOOP
                   ELSE TopRec=1
                 ENDIF
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-71:  ;Home
          IF TopRec>1
            THEN TopRec=1
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          QUITLOOP
        CASE c=-79:  ;End
          IF TopRec<TotalRecs-7
            THEN TopRec=TotalRecs-7
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TotalRecs
          CurrLine=TotalRecs-TopRec+1
          QUITLOOP
        CASE c=13:   ;Enter
          SETMARGIN OFF
          TabName=[Name]
          RETURN True
        CASE c=27:   ;Esc
          SETMARGIN OFF
          RETURN False
        OTHERWISE:
          BEEP
          LOOP
      ENDSWITCH
      IF NextLine<1
        THEN TopRec=TopRec-1
             CurrLine=1
             QUITLOOP
        ELSE IF NextLine>8
               THEN TopRec=TopRec+1
                    CurrLine=8
                    QUITLOOP
             ENDIF
      ENDIF
      CANVAS OFF
      ;
      ; return highlighted option to original color
      ;
      PAINTCANVAS ATTRIBUTE 31
        6+CurrLine,26,6+CurrLine,51
      CurrLine=NextLine
    ENDWHILE
    CANVAS OFF
  ENDWHILE
ENDPROC

PROC TabLkUpScr()
  ;
  ; create list of tables in current directory
  ;
  MESSAGE "Creating list of tables..."
  CANVAS OFF
  MENU {Tools} {Info} {Inventory} {Tables} ENTER
  ;
  ; paint window on canvas
  ;
  PAINTCANVAS FILL CHR(177)
    ATTRIBUTE 112
    5,25,18,54
  STYLE ATTRIBUTE 31
  SETMARGIN 24
  @4,24

TEXT
CURRENT DIRECTORYĿ
     Table         Date     
Ĵ
                            
                            
                            
                            
                            
                            
                            
                            
Ĵ
 [] Select   [Esc] Cancel 

ENDTEXT

  SETMARGIN 25
ENDPROC

WRITELIB "TabLkUp" LookUpTab,TabLkUpScr
