;  ͻ
;   APPLICATION: Menu driven search rotuine. Allows the operator to    
;                search a table for the first or last occurrence       
;                of a search value, then previous or next occurrance,  
;                until found value is accepted or search is cancelled. 
;                                                                      
;        AUTHOR: (C) Copyright Raymond O. Templin 1990, 1991           
;                Portions of code borrowed from PAL by Example         
;                (C) Copyright by Alan Zenreich and James M. Kocis     
;                                                                      
;           USE: These programs may be used and/or modified for any    
;                purpose; or, made part of a larger application for    
;                commercial or non-commercial use, provided the        
;                author(s) and their copyrights are acknowleded; and,  
;                as long as they are not sold in whole or in part as   
;                a separate commercial product.                        
;                                                                      
;     LIABILITY: These programs are provided as is! There is           
;                no guarantee of any kind, either express or           
;                implied as to the results obtained using              
;                these programs. The entire risk as to the             
;                performance and results of these programs is          
;                yours. R.O.T.                                         
;  ͼ

;***************************************************************
; This application can be run as-is and can be set up as a     *
; SETKEY operation for interactive use.                        *
;                                                              *
;        To run:                                               *
;                                                              *
;           1) view a table,                                   *
;           2) move to a field where you want to search,       *
;           3) play the script "Find_It!" by: Press [F10],     *
;                                             Press [S]cripts, *
;                                             Press [P]lay,    *
;                                             Type: Find_It!,  *
;                                             Press [Enter].   *
;                                                              *
;    Four procedures will load, then a short script at the     *
;    end of this application will play and call the main       *
;    procedure.                                                *
;***************************************************************

;=========================================================================
; NAME: TopMsg()                                                          |
; AUTHOR: Borrowed from PAL by example (C) Alan Zenreich & James M. Kocis |
; CREATED:                                                                |
; PARAMETERS: line1.a, line2.a, delay.n                                   |
; RETURNS: No value                                                       |
; DESCRIPTION: Centers messages on the top two lines of the display.      |
;=========================================================================

PROC TopMsg(line1.a, Line2.a, delay.n)

PRIVATE line1.a,     ;Text to display at top of screen.
        line2.a,     ;Text to display at second line of screen.
        delay.n      ;Amount of delay between beeps.

IF delay.n<2 THEN
   STYLE REVERSE
ELSE
   STYLE ATTRIBUTE SYSCOLOR(3)
ENDIF

@ 0,0 ?? FORMAT("w80,ac",line1.a)   ;Center & display top line.

IF LEN(line2.a)<2 THEN
   SWITCH
      CASE line2.a="": line2.a="Press any key"
      CASE UPPER (line2.a)="X": line2.a="Press any key to exit"
      CASE UPPER(line2.a)="C": line2.a="Press any key to continue"
      CASE UPPER(line2.a)="D": line2.a="Press [Enter] to continue, [Esc] to exit"
   ENDSWITCH
ENDIF

?? FORMAT("w80,ac",line2.a)    ;Center & display second line.
STYLE
CANVAS ON CURSOR OFF CANVAS OFF
ENDPROC

;=========================================================================
; NAME: Working()                                                         |
; AUTHOR: Borrowed from PAL by example (C) Alan Zenreich & James M. Kocis |
; CREATED:                                                                |
; PARAMETERS: msg.u                                                       |
; RETURNS: No value                                                       |
; DESCRIPTION: Notifies the user of what operation is taking place.       |
;=========================================================================

PROC Working(msg.u)

   @ 1,0 CLEAR EOL ?? msg.u         ;Display the message on line 2.
   @ 0,0 CLEAR EOL ??"Working"      ;Display "Working" message on top line.
   STYLE BLINK                      ;Blinking for dots.
   ??"..."                          ;Add three dots.
   STYLE
   CANVAS ON CURSOR OFF CANVAS OFF
   @ 0,0

ENDPROC

;=========================================================================
; NAME: Fint_It!()                                                        |
; AUTHOR: (C) Copyright Raymond O. Templin (516) 957-5813                 |
; CREATED: 5/1/90         LAST REVISED: 06/9/91                           |
; PARAMETERS: findval.u, route.a, b.p, e.p                                |
; RETURNS: True of False; depending on search results.                    |
; PROCEDURES USED: TopMsg(), Working()                                    |
; DESCRIPTION: Search for the value "findval.u" in any direction          |
;              depending on the parameter "route.a"                       |
; KNOWN PROBLEMS: See comment at: "Searchs backwards to find..." at line  |
;                 155.  (Not really a problem.)                           |
;=========================================================================

PROC Find_It!(findval.u, route.a, b.p, e.p)

    PRIVATE record.n,    ;Stores & returns record number of True search.
            index.n,     ;Used for reverse search.
            route.a,     ;Indicates direction & type (1st - last) of search.
            b.p,         ;Beginning wild card.
            e.p          ;Ending wild card.

    @ 0,0 Clear EOL
    @ 0,1 Clear EOL
    SWITCH

;------------------------------------------------------------
;  Finds the last occurrence of a findval.u (search pattern).
;------------------------------------------------------------

    CASE route.a="Last":
        Working("Searching for last")
        LOCATE PATTERN b.p+findval.u+e.p
        IF NOT retval THEN
            TopMsg("** Match not found **"," ",0)
            SLEEP 1500
            RETURN False
        ENDIF
        WHILE (True)
            IF ATLAST() THEN
                RETURN True
            ENDIF
            MOVETO RECORD RECNO()+1
            LOCATE NEXT PATTERN B.P+findval.u+e.p
            IF NOT retval THEN
                MOVETO RECORD RECNO()-1
                RETURN True
            ELSE
                LOOP
            ENDIF
        ENDWHILE

;------------------------------------------------------------
; Searchs backwards to find previous occurrence of findval.u.
;-------------------------------------------------------------------------
; Paradox3.5 and earlier does not have a reverse LOCATE or ZOOM command.
; Therefore, to try to speed things up, I use two methods of searching
; a table backwards.  The first one does a stright record by record search.
; I use this method when under 500 records.  The second method uses the
; skip type search I use for Search Last.  You can rearrange this to suit
; your needs.  However, the choice is not always simple.  On my 16 MHz-286,
; it takes approximately one second (un-official time) to search each 100
; records, using the first method.  This is the best method to use if the
; search value is within the previous 100 records.  But how do you know?
; It takes approximately one second to search each 1000 records using the
; second method (on an un-keyed and un-indexed field). This is the best
; method to use if the search value is 1000 or so records away.
; Good luck!  ROT
;
; PS: Another method would be to put all the record numbers of previous
; finds in an array.  But that's a project for someone else.
;-------------------------------------------------------------------------

    CASE route.a="Back":
        Working("Searching previous")
        IF RECNO()<500 THEN                 ;Record by record backward search.
             record.n=RECNO()
             FOR index.n FROM record.n-1 TO 1 STEP -1
                  MOVETO RECORD index.n
                  IF MATCH([],b.p+findval.u+e.p) THEN
                       RETURN True
                  ENDIF
             ENDFOR
             MOVETO RECORD record.n
             TopMsg("** No previous match **"," ",0)
             BEEP BEEP BEEP SLEEP 1500
             RETURN False
        ELSE                                ;Skip method backward search.
             index.n=0
             record.n=RECNO()
             LOCATE PATTERN b.p+findval.u+e.p
             IF RECNO()=record.n THEN
                  TopMsg("** No previous match **"," ",0)
                  BEEP BEEP BEEP SLEEP 1500
                  RETURN False
             ENDIF
             WHILE (True)
                  index.n=RECNO()
                  MOVETO RECORD RECNO()+1
                  LOCATE NEXT PATTERN B.P+findval.u+e.p
                  IF record.n=RECNO() THEN
                       MOVETO RECORD index.n
                       RETURN True
                  ELSE
                       LOOP
                  ENDIF
             ENDWHILE
        ENDIF

;-----------------------------------------
;  Finds the frist occurrence of findval.u
;------------------------------------------

    CASE route.a="First":
        Working("Searching first occurrence")
        LOCATE PATTERN b.p+findval.u+e.p
        IF NOT retval THEN
            TopMsg("** Match not found **"," ",0)
            BEEP BEEP BEEP SLEEP 1500
            RETURN False
        ELSE
            RETURN True
        ENDIF

;-----------------------------------------------------------
; Finds the next (forward direction) occurrence of findval.u
;-----------------------------------------------------------

    CASE route.a="Next":
        Working("Searching next")
        MOVETO RECORD RECNO()+1
        LOCATE NEXT PATTERN B.P+findval.U+e.p
        IF NOT retval THEN
            TopMsg("** Match not found **"," ",0)
            BEEP BEEP BEEP SLEEP 1500
            MOVETO RECORD RECNO()-1
            RETURN False
        ELSE
            RETURN True
        ENDIF
    ENDSWITCH
ENDPROC

;=========================================================================
; NAME: FindMenu()                                                        |
; AUTHOR: (C) Copyright Raymond O. Templin (516) 957-5813                 |
; CREATED: 5/1/90         LAST REVISED: 8/5/91                            |
; PARAMETERS: findval.u; if findval.u is null ("") FindMenu() will prompt |
;             for an input value. Otherwise it will use the passed value. |
; RETURNS: Record number                                                  |
; PROCEDURES USED: Find_It!(), TopMsg()                                   |
; DESCRIPTION: Menu driven procedure. Allows operator to input a value    |
;              and select the direction for the search. Then, accept or   |
;              cancel the results. Wild cards are automatic or manual.    |
;                                                                         |
; KNOWN PROBLEMS: An attribute of reverse blink, then reverse, is used to |
;                 high light successful find results in the table. But,   |
;                 there are four conditions (that I know of so far) where |
;                 the highlight does not work properly. 1) In table view, |
;                 the column has been resized and is less than the length |
;                 of the found value; 2) In formview, the field size is   |
;                 less than the length of the found value; 3) wrapped     |
;                 fields; 4) long fields on forms.  I do not know how,    |
;                 using PAL, to determine any of these four conditions.   |
;                 You will have to take them on a case by case basis.     |
;=========================================================================

PROC FindMenu(findval.u)

    PRIVATE findval.u,      ;Holds the search value received or imputted by user.
            find.l,         ;Returns True or False depending on search results.
            b.p,            ;Wild card for beginning of search value.
            e.p,            ;Wild card for end of search value.
            choice,         ;User's menu choice.
            col.n,          ;Column position of True search result. \
            colw.n,         ;Width of True search result.            > Used to indicate the on screen position of a true search.
            row.n,          ;Row position of True search result.    /
            fieldval.a,     ;findval without wild cards.
            oldrecno.n,     ;Holds original record number in case find is cancelled.
            x.u,            ;Adjust the day-of-date (no 0 input) and tracking single finds.
            y.u,            ;   "    "   "   "   "    " "   "     "      "       "     "
            z.a             ;Adjust the day-of-date (no 0 input for day).

    oldrecno.n=RECNO()
;--------------------------------------------------------------------
; First, check that we are displaying an image, but not in column #. |
;--------------------------------------------------------------------
    SWITCH
        CASE IMAGETYPE() <> "Display":
            BEEP BEEP BEEP SLEEP 25 BEEP BEEP BEEP
            TopMsg("You can only execute Find while displaying an image","c",1)
            RETURN oldrecno.n
        CASE FIELD()="#":
            BEEP BEEP BEEP SLEEP 25 BEEP BEEP BEEP
            TopMsg("You cannot execute Find in the record number column","c",1)
            RETURN oldrecno.n
    ENDSWITCH

;-----------------------------------------------------
; Accept an input from the keyboard if findval.u = "" |
;-----------------------------------------------------

  IF findval.u="" THEN
    @ 1,0 ?? "Enter the value to find in field \""+FIELD()+"\"." CLEAR EOL
    @ 0,0 CLEAR EOL ?? "Value: "
    @ 0,7 CURSOR NORMAL
    SWITCH
      CASE FIELDTYPE()="N" OR FIELDTYPE()="S":
         ACCEPT FIELDTYPE() TO findval.u
         findval.u=STRVAL(findval.u)
      CASE FIELDTYPE()= "$":
         ACCEPT "A23" PICTURE "{*#[.]}{[#[#]]}" TO findval.u
      CASE FIELDTYPE() = "D":            ;NOTE: Does not check for legal date.
         ACCEPT "A8" PICTURE "{[#[#]]}{/[#[#]]}[/[#[#]]]" TO findval.u
         IF MATCH(findval.u, "../@/..", x.u,y.u,z.a) THEN
            findval.u=x.u+"/0"+y.u+"/"+z.a
         ENDIF
      OTHERWISE:
         fieldval.a=FIELDTYPE()
         IF NUMVAL(SUBSTR(fieldval.a, 2, 3)) > 73 THEN
            fieldval.a="A73"                 ;Limit characters to end of line.
         ENDIF
         ACCEPT fieldval.a TO findval.u
    ENDSWITCH
  ENDIF
  IF findval.u="" THEN
     RETURN RECNO()
  ENDIF
  fieldval.a=findval.u
  x.u=True y.u=True

;--------------------------------------------
; Check for the type of search (wildcards?) |
;--------------------------------------------

    IF SEARCH("..",findval.u)=0 AND SEARCH("@",findval.u)=0 THEN
      b.p=".." e.p=".."
   ELSE
      b.p="" e.p=""
    ENDIF

;----------------------------------------------------
; Present menu for the direction of the first search |
;----------------------------------------------------

    SHOWMENU
        "First" : "Find the first occurrence of \""+findval.u+"\"",
        "Last" : "Find the last occurrence of \""+findval.u+"\"",
        "Quit" : "Quit"
    TO choice
    SWITCH
        CASE choice = "First": find.l=find_it!(findval.u, "First", b.p, e.p)
        CASE choice = "Last": find.l=find_it!(findval.u, "Last", b.p, e.p)
        CASE choice = "Quit" OR choice = "Esc": RETURN RECNO()
    ENDSWITCH

            ;------------------------------------------------
            ; *** This is where we return after a search *** |
            ;------------------------------------------------

    WHILE (True)
       CANVAS ON
       ;----------------------------------------------------
       ; Set the canvas up for the operator if find is true |
       ;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
       ; Remember the four (known) problems? |
       ;-------------------------------------
       IF find.l THEN                   ;If find is True.
          MOVETO RECORD RECNO()
          IF ISRUNTIME() THEN
             RefreshCanvas()
          ELSE
             ECHO NORMAL ECHO OFF
          ENDIF
            SYNCCURSOR
            CURSOR OFF
            row.n=ROW()
            col.n=COL()
            SWITCH
               CASE FIELDTYPE()="N" OR FIELDTYPE()="S":
                  colw.n=LEN(FIELDSTR())+2
               CASE FIELDTYPE()="$":
                  colw.n=LEN(FIELDSTR())
                  col.n=col.n-2
               OTHERWISE: colw.n=LEN(FIELDSTR())
            ENDSWITCH
            IF col.n-colw.n<0 THEN             ;For long fields in tableview.
               col.n=SEARCH(fieldval.a,[])+LEN(fieldval.a)+2
               colw.n=LEN(findval.u)
               IF col.n>78 THEN
                  col.n=78 colw.n=77
               ENDIF
            ENDIF
          ;-----------------------------------------------------
          ; Attribute of reverse-blink on the found record/field
          ; for a short interval, then reverse attribute.
          ;-----------------------------------------------------
            PAINTCANVAS REVERSE, BLINK row.n, col.n-colw.n, row.n, col.n-1
            SLEEP 1000
            PAINTCANVAS REVERSE row.n, col.n-colw.n, row.n, col.n-1
            x.u=True y.u=True                          ;Set to keep searching.
       ENDIF

;-------------------------------------
; End of display set up for true find |
;-------------------------------------

;---------------------------------------------------------------------
; Check wheather findval.u found or not and determine what to do next.|
;---------------------------------------------------------------------

       SWITCH
            CASE (choice="First" OR choice="Last") AND NOT find.l:
                RETURN RECNO()                     ;Match was not found during
                                                   ;the initial search.

;---------------------------------------
; If "First" find ended at end of table |
;---------------------------------------

            CASE choice="First" AND AtLast():
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Accept"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                ENDSWITCH

;--------------------------------------------
; If "Last" find ended at beginning of table |
;--------------------------------------------

            CASE choice="Last" AND AtFirst():
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Accept"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                ENDSWITCH

;-------------------------------------------------------
; If a find ended at the beginning or end of the table, |
;  or it was an intitial First or Last find.            |
;-------------------------------------------------------

            CASE choice="First" OR Atfirst():
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Next" : "Find the next occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Next"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Next":
                        find.l=find_it!(findval.u, "Next", b.p, e.p)
                ENDSWITCH
            CASE choice="Last" OR Atlast():
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Previous" : "Find the previous occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Previous"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Previous":
                        find.l=find_it!(findval.u, "Back", b.p, e.p)
                ENDSWITCH

;------------------------
; After a forward search |
;------------------------

            CASE choice="Next" AND NOT find.l:
                x.u=False
                IF NOT y.u THEN
                    SHOWMENU
                         "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                         "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                    TO choice
                    SWITCH
                         CASE choice = "Accept": RETURN RECNO()
                         CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    ENDSWITCH
                ENDIF
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Previous" : "Find the previous occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Previous"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Previous":
                        find.l=find_it!(findval.u, "Back", b.p, e.p)
                ENDSWITCH
            CASE choice="Next" OR choice="First":
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Next" : "Find the next occurrence of \""+fieldval.a+"\"",
                    "Previous" : "Find the previous occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Next"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Next":
                        find.l=find_it!(findval.u, "Next", b.p, e.p)
                    CASE choice = "Previous":
                        find.l=find_it!(findval.u, "Back", b.p, e.p)
                ENDSWITCH

;-------------------------
; After a backward search |
;-------------------------

            CASE choice="Previous" AND NOT find.l:
                y.u=False
                IF NOT x.u THEN
                    SHOWMENU
                         "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                         "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                    TO choice
                    SWITCH
                         CASE choice = "Accept": RETURN RECNO()
                         CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    ENDSWITCH
                ENDIF
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Next" : "Find the next occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Next"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Next":
                        find.l=find_it!(findval.u, "Next", b.p, e.p)
                ENDSWITCH
            CASE (choice="Last" OR choice="Previous"):
                SHOWMENU
                    "Accept" : "Accept this occurrence of \""+fieldval.a+"\" at record # "+STRVAL(RECNO()),
                    "Next" : "Find the next occurrence of \""+fieldval.a+"\"",
                    "Previous" : "Find the previous occurrence of \""+fieldval.a+"\"",
                    "Cancel" : "Return to original record # "+STRVAL(oldrecno.n)
                     DEFAULT "Previous"
                TO choice
                SWITCH
                    CASE choice = "Accept": RETURN RECNO()
                    CASE choice = "Cancel" OR choice = "Esc": RETURN oldrecno.n
                    CASE choice = "Next":
                        find.l=find_it!(findval.u, "Next", b.p, e.p)
                    CASE choice = "Previous":
                        find.l=find_it!(findval.u, "Back", b.p, e.p)
                ENDSWITCH
            OTHERWISE: RETURN RECNO()
       ENDSWITCH
    ENDWHILE
    QUIT
ENDPROC

;==================================================================
;    The following script is for running Find_It! interactively.   |
;------------------------------------------------------------------
; By calling the procedure "FindMenu()" with a null string parameter
; "FindMenu()" will prompt for an input. If "FindMenu()" is called
; with a value for the parameter, Find_It! will use that value to find.
; This is to allow different input schemes; like using a form, etc.
;----------------------------------------------------------------------

MOVETO RECORD FindMenu("")  ;Call Procedure "FindMenu()" using a null string,
RELEASE PROCS ALL           ;then move to the returned record number, release
QUIT                        ;the procedures and quit.
