;;******************************************************************************
;
;    The FINDIT.SC is an interactive SEARCH and (optional) REPLACE utility
;    for Paradox tables.  I've made extensive use of such a utility since I
;    seem to spend a great deal of time "massaging" data that originated in
;    other formats.  While the code may not be the "purtiest" you ever saw,
;    it is quite effective and fast.  It has extensive error-checking (didn't
;    say it was bulletproof)...there are four things that this script will NOT
;    allow you to do:
;
;    1) You are not allowed to change values in KEYed fields...this is done
;       on purpose, to prevent a user from scrambling a table.
;
;    2) You can't SEARCH or REPLACE on MEMO fields (cuz I haven't figured
;       that one out yet).
;
;    3) You can't WILDCARD search on DATE fields, despite the prompt to the
;       contrary.  This could be coded but I haven't found a real need for
;       such a capability.
;
;    4) You can't REPLACE anything found on a WILDCARD SEARCH...this is done
;       on purpose...you could add your own code to enable such a feature,
;       but I find that this can be dangerous in the wrong hands.  Example:
;       You decide to change EVERY occurrence of "SMITH" to "SMYTHE"...in
;       this case, "BLACKSMITH" would become "BLACKSMYTHE"...not exactly
;       what you intended.
;
;    Okay, so what CAN you do with FINDIT.SC?  Just about anything ELSE you
;    desire...except for dates, you can WILDCARD search for ANY value in ANY
;    field...and you can GLOBALLY -or- SELECTIVELY replace any value found
;    with your NEW value.  The script allows you to find EACH and EVERY
;    occurrence of your search value sequentially.
;
;    I have even used code similar to this in applications (such as unlinked 
;    lookups) to speed up the selection process for users.  FINDIT.SC works
;    in Paradox 3.5 and 4.xx (for DOS).  Feedback regarding improvements,
;    additional functionality, etc. would be greatly appreciated.  Enjoy!
;
;
;    Dickford Cohn
;    PC CONSULTANT
;    1829 W. Schaumburg Road
;    Schaumburg, IL 60194
;    December 18, 1993
;    October 22, 1994 
;============================================================================== 
PROC FindIt()
  CLEAR
  RUN "Amer_fnt"
  WHILE TRUE
    CURSOR NORMAL CURSOR OFF
    BEEP SLEEP 50 BEEP
    STYLE ATTRIBUTE 112
    @10,12??"Ŀ Ŀ ĿĿ Ŀ       Ŀ Ŀ Ŀ"
    @11,12??" ; Ȼ վ  ջ   Ȼ ͻ        Ȼ վ ͻ ;  "
    @12,12??" Ŀ                                 "
    @13,12??" ;                                ;"
    @14,12??"      ֽ      ֽ Ľ        ֽ        Ŀ"
    @15,12??";     ; ;; ;       ;   ;   ;"
    STYLE ATTRIBUTE 15
    @17,6??FORMAT("W68,AC","  A GLOBAL SEARCH AND REPLACE UTILITY FOR PARADOX FIELD VALUES  ")
    STYLE ATTRIBUTE 113
    @18,6??FORMAT("W68,AC","by Dickford Cohn")
    mtable1=""
    BEEP SLEEP 50 BEEP SLEEP 500 
    STYLE ATTRIBUTE 78
    @ 8,6??FORMAT("W68,AC","   Select TABLE to SEARCH   ")
    STYLE ATTRIBUTE 207
    @ 8,27??""
    @ 8,52??""
    CURSOR NORMAL CURSOR OFF
    SHOWTABLES
    DIRECTORY()
    FORMAT("W80,AC","Highlight the TABLE to SEARCH and Press <Enter> ...or <Esc>ape to QUIT")
    TO mtable1
    IF mtable1 = "Esc"
      THEN
      BEEP
      STYLE ATTRIBUTE 206
      @20,0??FORMAT("W80,AC","You pressed <Esc>ape...returning to Paradox")
      SLEEP 1000
      CLEAR ClearAll
      RETURN
    ENDIF
    CLEAR
    VIEW mtable1
    TableName=mtable1                                                ;Assign default values to variables
    ftype  =""
    alfer  =""
    yesno  =""
    srepl  =""
    newval =""
    lookval=""
    chek1  =""
    chek2  =""
    chek3  =""
    limbo  =0
    Menu{Tools}{Info}Enter Enter Enter Right BEEP
    PROMPT FORMAT("W80,AC","Move to the FIELD you want to search on...and press <Enter> to select it"),""
    WAIT TABLE
    UNTIL "Enter","Esc"
    IF RETVAL="Esc"
      THEN
      CLEAR ClearAll
      RETURN
    ENDIF

    IF RETVAL="Enter"
      THEN
      fielder=[Field Name]                  ;Doesn't make any difference which
      ftype  =[Field Type]                  ;which field cursor is in...
      IF SUBSTR(ftype,1,1)="A" THEN         ;If it's an ALPHA field
        alfer="A"
      ENDIF
      IF SUBSTR(ftype,1,1)="M" THEN         ;If it's a MEMO field
        alfer="M"
      ENDIF
      chek1=SUBSTR(ftype,2,1)               ;Check field type to see if there
      chek2=SUBSTR(ftype,3,1)               ;is an asterisk (*) in the string...
      chek3=SUBSTR(ftype,4,1)

      IF                                                                              ;Evaluate field type to determine
        chek1="*"                                                                ;if it is keyed
        THEN
        limbo=1                                                                    ;Variable "limbo" is evaluated
      ENDIF                                 ;below...if it is "1" then skip the
                                                                                  ;option to REPLACE any values because
      IF                                                                              ;this is a KEYED field
        chek2="*"
        THEN
        limbo=1
        IF alfer="A" THEN                   ;Strip the asterisk from a keyed
          ftype=SUBSTR(ftype,1,2)           ;alpha field string...example A6*
        ENDIF
      ENDIF

      IF
        chek3="*"
        THEN
        limbo=1                             ;Strip the asterisk (*) from a keyed
        ftype=SUBSTR(ftype,1,3)             ;alpha field string...example A12*
      ENDIF

      SWITCH
        CASE alfer="M" :BEEP MESSAGE "I haven't figured MEMO fields out yet...sorry!"
          SLEEP 1500 CLEAR ClearAll RETURN
        CASE ftype="N" :Prompter3=" NUMBER you're looking for"
          Axcept="N"
        CASE ftype="S" :Prompter3=" NUMBER you're looking for"
          Axcept="S"
        CASE ftype="$" :Prompter3=" AMOUNT you're looking for"
          Axcept="$"
        CASE ftype="N*":Prompter3=" NUMBER you're looking for"
          Axcept="N"
        CASE ftype="S*":Prompter3=" NUMBER you're looking for"
          Axcept="S"
        CASE ftype="D" :Prompter3=" DATE you're looking for"
          Axcept="D"
        CASE alfer="A" :Prompter3=" Alpha VALUE you're looking for"
          Axcept=ftype
      ENDSWITCH
      Prompter1="Type in the ["+fielder+"]"
      Prompter2="...then press <Enter> "
      BEEP
      SLEEP 50 BEEP
      STYLE ATTRIBUTE 112
      @0,0??Prompter1+Prompter3 CLEAR EOL
      @1,0??Prompter2 CLEAR EOL
      STYLE ATTRIBUTE 79
      IF alfer="A" THEN
        ACCEPT Axcept  ;PICTURE "*!"        ;You can include a PICTURE clause
        TO lookval
      ELSE
        ACCEPT Axcept
        TO lookval
      ENDIF
      IF RETVAL=FALSE
        THEN
        CLEAR ClearAll
        RETURN
      ENDIF
      IF limbo=0
        THEN
        CLEAR
        RELEASE VARS x
        WHILE NOT ISASSIGNED(x)
        BEEP SLEEP 50 BEEP
        STYLE ATTRIBUTE 112
        @0,0??"Do you want to SEARCH -or- SEARCH and REPLACE?"CLEAR EOL
        @1,0??"Press EITHER <S>earch or <R>eplace..." CLEAR EOL
        STYLE ATTRIBUTE 79
        x=GETCHAR()
        IF x=83 OR x=115
          THEN
          srepl="S"
        ENDIF
        IF x=82 OR x=114 
          THEN
          srepl="R"
        ENDIF
        IF RETVAL=FALSE
          THEN
          CLEAR ClearAll
          RETURN
        ENDIF
        IF x<>82 AND x<>83 AND x<>114 AND x<>115
         THEN BEEP
         RELEASE VARS x
        ENDIF
        ENDWHILE
      ENDIF
      IF srepl="R"
        THEN
        CLEAR
        CURSOR NORMAL CURSOR OFF
        BEEP
        SLEEP 50 BEEP
        STYLE ATTRIBUTE 112
        @0,0??"Type in the NEW VALUE you want in the ["+fielder+"] field"CLEAR EOL
        @1,0??"and press <Enter>..." CLEAR EOL
        STYLE ATTRIBUTE 79
        IF alfer="A" THEN
          ACCEPT Axcept  ;PICTURE "*!"          ;You can include a PICTURE clause
          TO newval
        ELSE
          ACCEPT Axcept
          TO newval
        ENDIF
        IF RETVAL=FALSE
          THEN
          CLEAR ClearAll
          RETURN
        ENDIF

        IF srepl="R"
          THEN
          RELEASE VARS x
          WHILE NOT ISASSIGNED(x)
          BEEP SLEEP 50 BEEP
          STYLE ATTRIBUTE 112
          @0,0??"Replace ALL VALUES -or- PROMPT at EACH value located?"CLEAR EOL
          @1,0??"Press EITHER <A>ll or <P>rompt..." CLEAR EOL
          STYLE ATTRIBUTE 79
          x=GETCHAR()
          IF x=65 OR x=97
            THEN
            aprom="A"
          ENDIF
          IF x=80 OR x=112 
            THEN
            aprom="P"
          ENDIF
          IF RETVAL=FALSE
            THEN
            CLEAR ClearAll
            RETURN
          ENDIF
          IF x<>65 AND x<>80 AND x<>97 AND x<>112
           THEN BEEP
           RELEASE VARS x
          ENDIF
          ENDWHILE 
        ENDIF
        IF aprom="A"
          THEN
          counter=0
          CoEdit TableName
          MOVETO FIELD fielder
          SCAN
            IF []=lookval
              THEN
              CLEAR
              counter=counter+1
              []=newval
              CURSOR NORMAL CURSOR OFF
              STYLE ATTRIBUTE 79
              @20,0??FORMAT("W80,AC","CHANGING...record "+StrVal(RECNO())+" of "+StrVal(NRecords(TableName))+"")
            ENDIF
          ENDSCAN
          DO_IT!
          CURSOR NORMAL CURSOR OFF
          STYLE ATTRIBUTE 79 BEEP
          @20,0??FORMAT("W80,AC",StrVal(counter)+" records CHANGED in ["+fielder+"] from "
          +StrVal(lookval)+" to "+StrVal(newval)+"!")
          SLEEP 5000
          CLEAR ClearAll
          RETURN
        ENDIF
      ENDIF
      IF srepl<>"R" THEN
        RELEASE VARS x
        WHILE NOT ISASSIGNED(x)
        BEEP SLEEP 50 BEEP
        STYLE ATTRIBUTE 112
        @0,0??"Do you want to do a WILDCARD SEARCH?"CLEAR EOL
        @1,0??"Press EITHER <Y>es or <N>o..." CLEAR EOL
        STYLE ATTRIBUTE 79
        x=GETCHAR()
        IF x=89 OR x=121 
          THEN
          yesno="Y"
        ENDIF
        IF x=78 OR x=110 
          THEN
          yesno="N"
        ENDIF
        IF RETVAL=FALSE
          THEN
          CLEAR ClearAll
          RETURN
        ENDIF
        IF x<>78 AND x<>89 AND x<>110 AND x<>121 
         THEN BEEP
         RELEASE VARS x
        ENDIF
        ENDWHILE 
      ENDIF

      IF srepl="R" THEN
        CoEdit TableName
      ELSE
        VIEW TableName
      ENDIF
      MOVETO FIELD fielder
      IF yesno="Y" THEN
        LOCATE PATTERN ".."+StrVal(lookval)+".."
      ELSE
        LOCATE lookval
      ENDIF
      counter=0
      IF RETVAL THEN
        WHILE TRUE
          BEEP
          IF srepl="R" THEN
            Prompter1=FORMAT("W80,AC","Here is the value ("+StrVal(lookval)+") you were"+
            " looking for...record "+StrVal(RECNO())+" of "+StrVal(NRecords(TableName))+" ")
            Prompter2=FORMAT("W80,AC","PRESS  <R> to REPLACE, <N> for NEXT occurrence, "+
            "<F2> to SAVE...<Esc>ape to QUIT")
          ELSE
            Prompter1=FORMAT("W80,AC","Here is the value ("+StrVal(lookval)+") you were"+
            " looking for...record "+StrVal(RECNO())+" of "+StrVal(NRecords(TableName))+"")
            Prompter2=FORMAT("W80,AC","press <N> to look for the NEXT occurrence, "+
            "or <Esc>ape to QUIT")
          ENDIF
          PROMPT Prompter1,
                 Prompter2
          WAIT RECORD
          UNTIL "Esc",78,110,82,114,"F2"
          IF RETVAL="Esc"
            THEN
            IF srepl="R" THEN
              Menu{Undo}{Yes}{Do-It!}
              CLEAR ClearAll
              QUITLOOP
            ELSE
              CLEAR ClearAll
              QUITLOOP
            ENDIF
          ENDIF
          IF RETVAL="F2"
            THEN
            Do_It!
            IF IsAssigned(counter) THEN
              CURSOR NORMAL CURSOR OFF
              STYLE ATTRIBUTE 79
              BEEP
              @20,0??FORMAT("W80,AC",StrVal(counter)+" records CHANGED in ["+fielder
              +"] from "+StrVal(lookval)+" to "+StrVal(newval)+"!")
              SLEEP 3000
            ENDIF
            CLEAR ClearAll
            QUITLOOP
          ENDIF
          IF RETVAL=82 OR RETVAL=114 AND yesno=""  ;Replace
            THEN
            MOVETO FIELD fielder
            []=newval
            counter=counter+1
            ECHO NORMAL ECHO OFF
            DOWN 
            MOVETO FIELD fielder
            LOCATE NEXT lookval
            IF NOT RETVAL
              THEN
              UP 
              STYLE ATTRIBUTE 206
              @16,0??FORMAT("W80,AC","This is the Last of the Mohicans!")
              SLEEP 1000
              LOOP
            ENDIF
            LOOP
          ENDIF
          IF RETVAL=78 OR RETVAL=110                            ;LOCATE next matching value
            THEN
            MOVETO FIELD fielder
            DOWN 
            IF yesno="Y" THEN
              LOCATE NEXT PATTERN ".."+StrVal(lookval)+".."
            ELSE
              LOCATE NEXT lookval
            ENDIF
            IF ATLAST()=TRUE THEN
              BEEP
              STYLE ATTRIBUTE 206
              @16,0??FORMAT("W80,AC","This is the Last of the Mohicans!")
              SLEEP 1500
              LOOP
            ENDIF

            IF NOT RETVAL THEN
              BEEP UP BEEP
              STYLE ATTRIBUTE 206
              @16,0??FORMAT("W80,AC","This is the Last of the Mohicans!")
              SLEEP 1500
            ELSE
              BEEP
              LOOP
            ENDIF
          ENDIF
        ENDWHILE
      ELSE
        Do_It!
        BEEP
        SLEEP 50 BEEP
        CURSOR NORMAL CURSOR OFF
        STYLE ATTRIBUTE 78 BEEP
        @20,0??FORMAT("W80,AC","Value "+StrVal(lookval)+" isn't in the ["+fielder+"] field in the "+UPPER(TableName)+" table!")
        SLEEP 4000
        CLEAR ClearAll
      ENDIF
    ENDIF
  ENDWHILE
ENDPROC
FindIt()


