; **************************** Filter.SC **************************************
;
; =============================================================================
;       TITLE:  Filter.u
;      AUTHOR:  Steven W. Erbach, Scientific Marketing
;     CREATED:  11/19/91 1:11 pm, revised 8/17/92
;     RETURNS:  No value
; DESCRIPTION:  Emulates a dBASE BROWSE with a SET FILTER TO
; -----------------------------------------------------------------------------
;
; This script came about as a result of a question from one of our users in
; our newly formed Paradox SIG.
;
; He is a reformed dBASEr and truly WANTS to believe that PAL is superior in
; every way to dBASE.  He became frustrated by PAL's lack of a SET FILTER TO
; command.  He wants to browse through a subset of the records in a table,
; edit them to his heart's content, and not have to perform a query first.
;
; He has a 50,000 record file that he wants to search based on a substring of
; a description field.  Therefore a secondary index really won't help him
; unless the substring comes at the very beginning of the field: abc.. .
;
; I wrote this PROC to simulate a BROWSE and FILTER combination.  It allows
; the user to hit the Down or PgDn keys to locate the next record that matches
; and the Up and PgUp keys to move to the previously located record.  The Home
; key will jump to the first match and the End key will move to the last one
; located so far.
;
; The script uses a counter table with one Numeric field.  When the LOCATE
; command finds a match, a record is added to the counter table with the RECNO
; of the LOCATEd record.  The user is then placed in a WAIT RECORD until he
; hits a record-leaving navigation key (Up, Down, PgUp, PgDn, Home, End).
;
; The counter table is used to jump to records that have been already located.
; This is just skeleton code, but it seems to work.  Just edit the script with
; the parameters for your CounterTable and SearchTable.  I would appreciate
; any suggestions.
; =============================================================================

PROC InitializeSearch.u()
  @ 1,0 CLEAR EOL
  @ 0,0 CLEAR EOL
  @ 0,0 ?? "Enter pattern to search for: "
  STYLE ATTRIBUTE 78
  ACCEPT "A20" TO search.a
  STYLE
  IF search.a = "" THEN   ; If no search string is entered then quit.
    Do_It!
    CLEAR
    CLEARALL
    RETURN
  ENDIF
  LOCATE PATTERN search.a
  IF RETVAL THEN                   ; If initial LOCATE is successful then
    rec.n = RECNO()                ; capture the current record number,
    MOVETO CounterTable.a          ; MOVETO the counter table,
    MOVETO FIELD CounterField.a    ; MOVETO the counter field,
    [] = rec.n             ; write the record number into the first record &
    Down                   ; create a new record ready for the next number.
    MOVETO SearchTable.a
  ELSE
    MESSAGE "No records found with that pattern"
    SLEEP 2000
    Do_It!
    CLEAR
    CLEARALL
    RETURN
  ENDIF
ENDPROC

PROC Filter.u(CounterTable.a, CounterField.a, SearchTable.a, SearchField.a)
                          ;   CounterTable.a is the table containing the record
                          ; numbers of the LOCATEd records.
                          ;   CounterField.a is the field in CounterTable.a
                          ; that will contain the record numbers.
                          ;   SearchTable.a is the table to search.
                          ;   SearchField.a is the field in SearchTable to search.
  PRIVATE
    search.a,             ; The substring that is being searched for.
    rec.n                 ; The record number of the LOCATEd record.
  EMPTY CounterTable.a
  VIEW CounterTable.a
  COEDIT SearchTable.a
  MOVETO FIELD SearchField.a   ; Position the cursor for the LOCATE.
  InitializeSearch.u()
  WHILE TRUE
    WAIT RECORD
      PROMPT "[Ctrl]Z-New search   []/[PgDn]-Next match   [Home]-Goto first match found",
             "[]/[PgUp]-Previous match  [End]-Goto last match so far"
           + "  [F2]-Done"
    UNTIL "Zoom", "F2", "Up", "PgUp", "Down", "PgDn", "Home",
          "End", "Dos", "DosBig"
    SWITCH
      CASE RETVAL = "Dos" OR RETVAL = "DosBig" :
        BEEP
      CASE RETVAL = "Zoom":
        Do_It!                       ; Suspend the coediting session
        EMPTY Countertable.a         ; Empty out the record number table
        MOVETO Searchtable.a         ; Move back to the table to be searched
        CoeditKey
        Home                         ; Make sure we're at the 1st record
        MOVETO FIELD SearchField.a   ; Move to the search field
        InitializeSearch.u()
      CASE RETVAL = "F2" :
        Do_It!
        CLEAR
        CLEARALL
        RETURN
      CASE RETVAL = "Up" OR RETVAL = "PgUp" :  ; If user wants to move up
        MOVETO CounterTable.a    ; jump to the counter table,
        SKIP -1                  ; move to the previous record number and
        rec.n = []               ; capture it.
        MOVETO SearchTable.a     ; Then jump to the search table
        MOVETO RECORD rec.n      ; and jump back to the previously located
        MOVETO FIELD SearchField.a    ; record.
      CASE RETVAL = "Down" OR RETVAL = "PgDn" :  ; User wants to move down.
        MOVETO FIELD SearchField.a
        IF RECNO() <> NRECORDS(SearchTable.a) THEN  ; If not at the last record
          Down                             ; then skip to the next record for
          LOCATE NEXT PATTERN search.a     ; the LOCATE NEXT to work.
          IF NOT RETVAL THEN               ; If there are no more matches then
            Up                             ; move back up.
          ELSE                             ; If there is another match then
            rec.n = RECNO()                ; capture that record number and
            MOVETO CounterTable.a          ; jump to the counter table.
            IF ISBLANK([]) THEN        ; If we're in a blank record (that is,
              [] = rec.n               ; the empty record at the end of the
              Down                     ; table) then write the rec.n and Down
            ELSE                       ; to prep a fresh record; Else if there's
              Down                     ; a number there already, move to the
              IF ISBLANK([]) THEN      ; next record.  If THAT one is blank
                [] = rec.n             ; then dump the record number there
                Down                   ; and move down to create a new one.
                ; I did this to try to account for the user moving around in
                ; the table a lot; i.e., if the 2nd counter record we look at
                ; is blank, we know that the user had been browsing back up
                ; through the table and then back down to the last LOCATE.
                ; So therefore, since he's arrived back at the last LOCATE
                ; by this method, the counter table is NOT positioned at the
                ; blank record normally created if the user just rolls on down
                ; thru the table finding records in simple succession.
              ENDIF
            ENDIF
            MOVETO SearchTable.a ; Now move back to the Customer table to allow
          ENDIF                  ; the user to continue editing if he wishes.
        ENDIF
      CASE RETVAL = "Home" :         ; If the Home key is pressed
        MOVETO FIELD SearchField.a   ; make sure we're in the Street field.
        MOVETO CounterTable.a        ; Moveto the counter table and
        Home                         ; jump to the first record number.
        rec.n = []                   ; Capture that number and
        MOVETO SearchTable.a         ; move back to the Customer table to
        MOVETO RECORD rec.n      ; then move to the first record LOCATEd.
      CASE RETVAL = "End" :          ; If the End key is pressed
        MOVETO FIELD SearchField.a   ; make sure we're in the Street field.
        MOVETO CounterTable.a        ; Moveto the counter table and
        End                          ; jump to the last record in the file.
        rec.n = []                   ; Capture the field value and
        MOVETO SearchTable.a         ; move back to the Customer table.
        IF NOT ISBLANK(rec.n) THEN   ; If rec.n has a value then
          MOVETO RECORD rec.n        ; move to the last record LOCATEd.  (If
        ENDIF                    ; the value was blank, then we know that the
    ENDSWITCH                    ; cursor was already positioned at the blank
                                 ; record at the end of the counter table when
                                 ; End was pressed.  We know that because when-
                                 ; ever we move out of a blank record in CoEdit
                                 ; mode, the record closes up.  If the cursor
                                 ; can "move" to a blank record in a CoEdited
                                 ; table, therefore the cursor had never left
                                 ; that record.)
  ENDWHILE
ENDPROC

Filter.u("Zzzcount", "Recnum", "Customer", "Street")
; Zzzcount is the name of the table I used for keeping track of the record
; numbers LOCATEd.
; Recnum is the Numeric field in that table that holds the record numbers.
; Customer is a table from the Paradox samples supplied with the software.
; Street is the field in Customer that I used to test this code.
