;This file is copyright (c) 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedures inErrorHandler.n(),
;                             inErrorLog.u(),
;                             msAlertDialog.u(),
;                             msConfirm.l(),
;                             msContinue.u(),
;                             msShortcuts.a(),
;                             msWorking.u(),
;                             msWorkingClear.u(),
;                             quExecute.l()
;
;Source File     : ERRUTIL1.SC
;Author          : Dan Paolini
;                  DataStar International
;                  dp Solutions
;
;Informant Issue : November 1992
;
;Description     : Error-handling procedures
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

===========================================================================
;      AUTHOR: Copyright (c) 1992 - Daniel J. Paolini II
;                                   DataStar International
;                                   dp Solutions
;     CREATED: 09-21-92 04:03 am    Version 4.03
;
===========================================================================
;       TITLE: inErrorHandler.n
;     RETURNS: Error Continuation Code
; DESCRIPTION: Main Error Handling Procedure - calls inErrorLog.u
; ---------------------------------------------------------------------------
PROC inErrorHandler.n()          ; Main Error Handler
Private  errorproc,              ; Keeps errorproc from being recursive
         error.y,                ; DynArray from ErrorInfo
         message.a,              ; Formatted message to user
         script.a,               ; Concatonated re-named Savevars.sc
         errorwin.a,             ; Paradox Window()
         y.a                     ; Counter for FOREACH command
;Global  g.sysinfo.y             ; System info dynarray
;        g.debug.l               ; Development DEBUG flag
;        g.y                     ; Dynarray of Passwords
;        ok.v                    ; Used by the wsPickForm.l procedure
;        g.startmemleft.n        ; Memory at Startup
; ---------------------------------------------------------------------------
; The following switch deals with specific errors, and attempts to continue
; the application.  You should do this only when you are sure it won't end
; up breaking something else (e.g.  If you continue from a query error, and
; later code expects that the query will have performed successfully, you are
; just postponing the inevitable.  That is one reason to use a Query Execute
; procedure, so that you can interrupt the process in the event of an error.
; While embedded specialized error procedures are still useful (witness the
; ErrorReset code, Paradox is much more flexible and capable of procedure
; swapping.  You may want to, instead, add specialized error conditions to
; this Switch, such as:
;                          Ditto Error handler
;                          Fieldview Error handler
;                          Pickform Error handler
;                          Startup Error handler
; ---------------------------------------------------------------------------
   errorwin.a = Window()                     ; Capture the Paradox Window
   ErrorInfo to error.y                      ; Capture the error info bag
   retval.n = 2                              ; Initialize returned value
   SWITCH
      CASE error.y["Code"] = 27              ; Using quExecute.l proc
       AND ImageType() = "Query"
       AND error.y["Proc"] = "QUEXECUTE.L" : ; Note proc name in ALL CAPS
         qerror.l = true                     ; Set Query Error flag
         retval.n = 1                        ; Skip over error command
      CASE error.y["Code"] = 27              ; Not using quExecute.l proc
       AND ImageType() = "Query" :           ; Might want to return 2 here
         msContinue.u("Query Error - " +Window(),79,999,999,"",3)
         retval.n = 1                        ; Skip over error command
      CASE error.y["Code"] = 43
        OR error.y["Message"] = "Printer not ready" :
         ioPrinterStatus.l()
         IF retval THEN
            retval.n = 0
         ELSE
            msWorking.u("Attempting to Continue with Application",42,1,2)
            retval.n = 1
         ENDIF
   ENDSWITCH

   IF retval.n = 2 THEN                      ; Error still not resolved
      IF NOT IsAssigned(g.sysinfo.y) THEN
         SysInfo to g.sysinfo.y              ; Capture System Info
      ENDIF

      IF g.sysinfo.y["UIMode"] = "COMPATIBLE" THEN
         Canvas ON                           ; Just in case
      ENDIF

      IF IsAssigned(g.y) THEN                ; Deassign any password variables
         FOREACH y.a In g.y                  ;  stored in Dynarray g.y
            UnPassword g.y[y.a]
            g.y[y.a] = "********"
         ENDFOREACH
      ENDIF

      IF NOT Match(error.y["Message"],"..run Error..",a,message.a) THEN
         IF NOT Match(error.y["Message"],"..Syntax Error..",a,message.a) THEN
               message.a = error.y["Message"]
         ENDIF
      ENDIF

      IF NOT IsAssigned(error.y["Proc"]) THEN   ; In case it is not assigned
         error.y["Proc"]   = "***Not Available***"
      ENDIF

      msWorking.u(message.a,79,0,0)
      msContinue.u("Error in Procedure: " + error.y["Proc"],79,999,999,"",2)
      msWorkingClear.u()

      IF NOT IsAssigned(g.debug.l) OR NOT g.debug.l THEN
         IF DirExists("ERR") = 0 THEN        ; Create an ERR directory if none
            Run NOREFRESH "MD ERR"           ; Store error logs in separate Dir
         ENDIF                               ; Log the error info
         script.a = "ERR\\"+StrVal(Ticks())  ; Easy Unique Name

         inErrorLog.u(error.y,g.sysinfo.y)   ; Log the error to disk and printer

         msWorking.u("Saving Current Variable Assignments to Disk",93,0,0)
         SaveVars ALL                        ; Rename Savevars.sc for posterity
         IF Sysmode() <> "Main" Then
            RUN NOREFRESH "REN "+PrivDir()+"savevars.sc"+Directory()+"\\"+script.a
         ELSE
            {Tools} {Rename} {Script} Select "Savevars" Select script.a
            IF MenuChoice() = "Cancel" THEN     ; VERY unlikely
               {Replace}
            ENDIF
         ENDIF

         IF PrinterStatus() THEN             ; Lets print the savevars.sc
            msWorking.u("Printing Current Variable Assignments",42,0,0)
            Run NOREFRESH "Copy " +script.a+ ".SC LPT1: > NUL"
            Open PRINTER
               Print "\f"                    ; Formfeed
            Close PRINTER
         ENDIF
      ENDIF
      msWorkingClear.u()                     ; Removes message window

      IF NOT IsAssigned(g.debug.l) OR NOT g.debug.l THEN
         msContinue.u("Log Complete - Please Contact Technical Support",31,
                       999,999,"",1)
         Reset
         {Tools} {More} {Protect} {Clearpasswords}
         SetColors DEFAULT
      ELSE                                   ; Allow access to DEBUG prompt
         msConfirm.l("IF <Debug>, Use <Ctrl><T> to Trace Back to Error",79,
                      999,999,"",3,"~D~ebug","~C~ancel",true)
         IF retval THEN
            Debug                            ; Must <Ctrl><T> back to error
            retval.n = 0
         ELSE
            Reset
            {Tools} {More} {Protect} {Clearpasswords}
            SetColors DEFAULT
            QUIT "You have Canceled the Application from the Error Prompt..."
         ENDIF
      ENDIF
   ELSE
      PROC emErrorHandlerReset.n()           ; Reset the ErrorCode
      Private errorproc
         Return 1
      ENDPROC
      errorproc = "emErrorHandlerReset.n"    ; Specialized errorproc
      retval = 1 + "A"                       ; Create errorcode 30
      errorproc = ""                         ; Deassign errorproc
      Release Procs emErrorReset.n           ; Release procedure
   ENDIF
   Return retval.n                           ; 0, 1 or 2
ENDPROC
;
===========================================================================
;       TITLE: inErrorLog.u
;     RETURNS: No value
; DESCRIPTION: Error Logging Procedure - called by inErrorHandler.n
;              Creates a Memo Variable and writes it to disk from the
;              contents of error.y (ErrorInfo, SysInfo & selected info).
; ---------------------------------------------------------------------------
PROC inErrorLog.u(               ; Logs Error to file and printer
         error.y,                ; ErrorInfo DynArray
         g.sysinfo.y)            ; SysInfo DynArray
Private  y.a,                    ; Tag of error.y in FOREACH loop
         error.m                 ; Memo variable holding errorlog
;Global  g.debug.l               ; Development DEBUG flag
;        ok.v                    ; Used by the wsPickForm.l procedure
;        g.startmemleft.n        ; Memory at Startup
   msWorking.u("An Error has occurred, please wait while it is logged",79,3,0)

   error.y["Date of Error"] = Today()
   error.y["Working Directory"] = Directory()
   error.y["Working Drivespace"] = DriveSpace(SubStr(Directory(),1,1))
   error.y["Current MemLeft"] = MemLeft()
   error.y["Private Directory"] = PrivDir()
   error.y["Private Drivespace"] = DriveSpace(SubStr(PrivDir(),1,1))
   error.y["Printer Status"] = Format("LO",PrinterStatus())
   error.y["RunTime"] = Format("LY",IsRunTime())
   error.y["Current SysMode"] = SysMode()
   error.y["Time of Error"] = Time()
   error.y["Paradox version"] = Version()

   error.y["Paradox Build"] = g.sysinfo.y["Build"]
   error.y["Current Extended Memory"] = g.sysinfo.y["Extended"]
   error.y["Current Expanded Memory"] = g.sysinfo.y["Expanded"]
   error.y["Mouse Available"] = g.sysinfo.y["Mouse"]
   error.y["Screen Height"] = StrVal(g.sysinfo.y["ScreenHeight"]) + " Rows"
   error.y["Screen Width"] = StrVal(g.sysinfo.y["ScreenWidth"]) + " Columns"
   error.y["UI Mode"] = g.sysinfo.y["UIMode"]

   IF NImages() <> 0 THEN                    ; occurred on image on workspace
      error.y["Number of Images"] = NImages()
      error.y["Current Table"] = Table()
      error.y["Current Image Type"] = ImageType()
      error.y["Current Field"] = Field()
      error.y["Current Field Value"] = []
      error.y["Shared Table"] = IsShared(Table())
      IF error.y["Current Image Type"] = "Query" THEN
         IF CheckMarkStatus() <> "" THEN ; store checkmark if appropriate
            error.y["Current Field Value"] = CheckMarkStatus()+" "+[]
         ENDIF
         error.y["Formview"] = "N/A"
         error.y["Record Number"] = "N/A"
      ELSE
         error.y["Formview"] = Format("LN",IsFormView())
         error.y["Record Number"] = RecNo()
      ENDIF
      error.y["Number of Records"] = NRecords(TABLE())
   ELSE                                      ; not in an image
      error.y["Number of Images"] = "N/A"
      error.y["Current Table"] = "N/A"
      error.y["Current Image Type"] = "N/A"
      error.y["Current Field"] = "N/A"
      error.y["Current Field Value"] = "N/A"
      error.y["Shared Table"] = "N/A"
      error.y["Number of Records"] = "N/A"
      error.y["Formview"] = "N/A"
      error.y["Record Number"] = "N/A"
   ENDIF

   IF IsAssigned(g.startmemleft.n) THEN
      error.y["Starting MemLeft"] = g.startmemleft.n
   ELSE
      error.y["Starting MemLeft"] = "UA"
   ENDIF

   IF error.y["User"] = "" THEN
      error.y["User"] = "N/A"
   ENDIF

   error.m = "\n\n" + Format("w80,ac","*** Error while in Procedure " +
                                       error.y["Proc"] + " ***") + "\n" +
              Spaces(8) + "Error: #" + StrVal(error.y["Code"]) + " - " +
              error.y["Message"] + "\n" + Fill("-",72) + "\n"
   FOREACH y.a In error.y
      error.m = error.m + Spaces(8) + y.a + ":  " + StrVal(error.y[y.a]) + "\n"
   ENDFOREACH
                                             ; Write memo variable to diskfile
   msWorking.u("Writing Error Log to Disk",31,0,0)
   FileWrite APPEND "ERR\\Errorlog.sc" From error.m

   IF NOT IsAssigned(g.debug.l) OR NOT g.debug.l THEN
      IF PrinterStatus() THEN             ; prints log if printer is available
         msWorking.u("Writing Error Log to Printer",42,0,0)
         Open PRINTER
         Print error.m, "\f"
         Close PRINTER
      ENDIF
   ENDIF
   Return
ENDPROC
;
===========================================================================
;       TITLE: msAlertDialog.u
;     RETURNS: No Value
; DESCRIPTION: Dialog PROC for IDLE events in Messages
; ---------------------------------------------------------------------------
PROC msAlertDialog.u(            ; Alert Siren in Idle Dialog Box
         type.a,                 ; EVENT or TRIGGER
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null
Private  w
;Global  alert.n                 ; Alert Value from dBox (0 - 5)
;Global  onceflag.l              ; For non-continuous Alert (1, 2)
   IF NOT IsAssigned(onceflag.l) THEN
      onceflag.l = true
   ENDIF
   SWITCH
      CASE alert.n = 1 AND onceflag.l :
         Beep Sleep 50
         Beep Sleep 50
         Beep
         onceflag.l = false                  ; Turns off subsequent Alerts
      CASE alert.n = 2 AND onceflag.l :
         Sound 770 150
         Sound 440 150
         Sound 770 150
         Sound 440 150
         Sound 770 150
         onceflag.l = false                  ; Turns off subsequent Alerts
      CASE alert.n = 3  :
         Beep Sleep 50 Beep Sleep 300
      CASE alert.n = 4  :
         Sound 300 50 Sleep 100
         Sound 300 50 Sleep 100
         Sound 150 50 Sleep 100
         Sound 150 50 Sleep 100
         Sleep 200
      CASE alert.n = 5  :
         Sound 770 150
         Sound 440 150
   ENDSWITCH
   Return
ENDPROC
;
===========================================================================
;       TITLE: msConfirm.l
;     RETURNS: Logical true/false if User Confirmed/Canceled
; DESCRIPTION: Generic Continue-or-Cancel Message routine
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
; ---------------------------------------------------------------------------
PROC msConfirm.l(                ; Confirmation DialogBox
         message.a,              ; Message to display (< 70 chars)
         msgcolor.n,             ; Color for message (not DialogBox!)
         toprow.n,               ; Top Row (999 = Row 7, not true center)
         leftcol.n,              ; Left Column (999 = Centered Horizontally)
         colors.y,               ; Dynarray of custom colors
         alert.n,                ; Sound level of Alert (0 - 4)
         oklabel.a,              ; Label of CONTINUE Pushbutton
         cxlabel.a,              ; Label of CANCEL Pushbutton
         confirm.l)              ; Should Confirm be default?
Private  width.n,                ; Width of Dialog Box
         a1, a2,                 ; Match variables
         n1, n2,                 ; Button length comparisons
         buttonlength.n,         ; Width of Pushbuttons
         button.l,               ; Value of selected Pushbutton
         onceflag.l              ; True = Non-continuous Alert
   SetCanvas DEFAULT
   IF NOT IsAssigned(g.colorsapp.y) THEN
      GetColors To g.colorsapp.y
   ENDIF
   IF Type(colors.y) = "DY" THEN             ; Must be a DynArray, or ignore
      SetColors From colors.y                ;  to control dBox colors
   ENDIF

   IF NOT IsAssigned(g.sysinfo.y) THEN
      SysInfo to g.sysinfo.y
   ENDIF

   onceflag.l = alert.n < 3
   button.l = false
   message.a = " " + message.a + " "

   width.n = Max(Len(message.a) + 4,Len(oklabel.a) + Len(cxlabel.a) + 24)
   a1 = ""
   a2 = oklabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE

   n1 = Len(a1+a2)
   a1 = ""
   a2 = cxlabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE

   n2 = Len(a1+a2)
   buttonlength.n = Max(n1,n2)+4

   IF toprow.n = 999 THEN
      toprow.n = 7                           ; Keep near top, not true center
   ENDIF

   IF leftcol.n = 999 THEN
      leftcol.n = Int((g.sysinfo.y["ScreenWidth"]-width.n)/2)
   ENDIF

   IF confirm.l THEN                         ; Confirm button is DEFAULT
      SHOWDIALOG "Press <Enter> to Confirm"
         Proc "msAlertDialog.u" IDLE
         @ toprow.n, leftcol.n  Height 7 Width width.n
         PaintCanvas Fill Format("w"+StrVal(width.n-4)+",ac",message.a)
                     Attribute msgcolor.n  1, 1, 1, width.n - 4
         PushButton  @ 3,5
            Width buttonlength.n oklabel.a
            OK DEFAULT Value true Tag "OK"
         To button.l
         PushButton  @ 3,width.n-buttonlength.n-7
            Width buttonlength.n cxlabel.a
            CANCEL Value false Tag "Cancel"
         To button.l
      ENDDIALOG
   ELSE                                      ; Cancel button is DEFAULT
      SHOWDIALOG "Press <Enter> to Cancel"
         Proc "msAlertDialog.u" IDLE
         @ toprow.n, leftcol.n  Height 7 Width width.n
         PaintCanvas Fill Format("w"+StrVal(width.n-4)+",ac",message.a)
                     Attribute msgcolor.n  1, 1, 1, width.n - 4
         PushButton  @ 3,5
            Width buttonlength.n cxlabel.a
            CANCEL DEFAULT Value false Tag "Cancel"
         To button.l
         PushButton  @ 3,width.n-buttonlength.n-7
            Width buttonlength.n oklabel.a
            OK Value true Tag "OK"
         To button.l
      ENDDIALOG
   ENDIF
   SetColors From g.colorsapp.y
   msWorkingClear.u()
   Return button.l
ENDPROC
;
===========================================================================
;       TITLE: msContinue.u
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
; ---------------------------------------------------------------------------
PROC msContinue.u(               ; Generic Continue DialogBox
         message.a,              ; Message to display
         msgcolor.n,             ; Color for Message (not DialogBox!)
         toprow.n,               ; Top Row (999 = row 7, not true center)
         leftcol.n,              ; Left Column (999 = Centered Horizontally)
         colors.y,               ; Dynarray of custom colors
         alert.n)                ; Sound level of Alert (0 - 5)
Private  width.n,                ; Width of Dialog Box
         button.a,               ; Value of selected Pushbutton
         onceflag.l              ; True = non-continuous alert
   SetCanvas DEFAULT
   IF NOT IsAssigned(g.colorsapp.y) THEN
      GetColors To g.colorsapp.y
   ENDIF
   IF Type(colors.y) = "DY" THEN             ; Must be a DynArray, or ignore
      SetColors From colors.y
   ENDIF

   IF NOT IsAssigned(g.sysinfo.y) THEN
      SysInfo to g.sysinfo.y
   ENDIF

   onceflag.l = alert.n < 3
   message.a = " " + message.a + " "
   width.n = Max(Len(message.a) + 4, 35)

   IF toprow.n = 999 THEN
      toprow.n = 7                           ; Keep near top, not true center
   ENDIF

   IF leftcol.n = 999 THEN
      leftcol.n = Int((g.sysinfo.y["ScreenWidth"]-width.n)/2)
   ENDIF

   SHOWDIALOG "Press <Enter> to Continue"
      Proc "msAlertDialog.u" Idle            ; Wait for Key Alert
      @ toprow.n,leftcol.n
      Height 7 Width width.n

      PaintCanvas Fill Format("w"+StrVal(width.n-4)+",ac",message.a)
                  Attribute msgcolor.n  1, 1, 1, width.n - 4

      PushButton @ 3,Int(width.n/2)-7
         Width 12 "~C~ontinue"
         OK Default Value "OK" Tag "OK"
      To button.a
   ENDDIALOG
   SetColors From g.colorsapp.y
   msWorkingClear.u()
   Return
ENDPROC
;
===========================================================================
;       TITLE: msShortcuts.a
;     RETURNS: Expanded Message Value
; DESCRIPTION: Shortcuts for Generic Information Messages
; ---------------------------------------------------------------------------
PROC msShortcuts.a(              ; Shortcuts for Messages
         message.a)              ; Message Code
   SWITCH                                 ; shortcuts
      CASE message.a = "C": message.a = "Operation Canceled - Returning"
      CASE message.a = "M": message.a = "One Moment - Returning to MENU"
      CASE message.a = "P": message.a = "P R I N T I N G  -  This will take a few moments"
      CASE message.a = "Q": message.a = "Q U E R Y I N G  -  This will take a few moments"
      CASE message.a = "R": message.a = "Report NOT Printed - Returning"
      CASE message.a = "W": message.a = "W O R K I N G  -  One Moment"
      CASE message.a = "K": message.a = "Key Violation!  Do You Want to
Overwrite the Existing Record?"
      CASE message.a = "A": message.a = "A R E   Y O U   S U R E ?"
      CASE message.a = "U": message.a = "Unable to Lock Necessary Tables, Please Try Later"
   ENDSWITCH
   Return message.a
ENDPROC
;
===========================================================================
;       TITLE: msWorking.u
;     RETURNS: No value
; DESCRIPTION: Generic Information Message Window.  Uses msWorkingClear.u().
; ---------------------------------------------------------------------------
PROC msWorking.u(                ; Generic information message window
         message.a,              ; Message to display
         color.n,                ; Color for message window
         beep.n,                 ; Number of beeps
         sleep.n)                ; # of Seconds to pause (-1 to 5)
                                 ;     0 Seconds must be manually cleared
                                 ;     1 - 5 Seconds self-clears
                                 ;    -1 waits for a Keypress w/o beeping
                                 ;        and then self-clears
Private  y,                      ; Temporary window dynarray
         width.n,                ; Width of window
         oldcanvas.w,            ; Previous canvas
         oldwindow.w,            ; Previous window
         offset.n                ; Location for ellipsis (...)
;Global  g.message.w             ; Message window handle
;        g.sysinfo.y             ; System info dynarray

   IF Len(message.a) = 1 THEN
      message.a = msShortcuts.a(message.a)
   ENDIF
   message.a = message.a + "..."

   IF NOT IsAssigned(g.sysinfo.y) THEN
      SysInfo To g.sysinfo.y                 ; Determine Screen Size
   ENDIF

   msWorkingClear.u()

   DynArray y[]
      y["CanClose"] = False                  ; Denies closing
      y["CanMaximize"] = False               ; Denies maximizing
      y["CanMove"] = False                   ; Denies dragging
      y["CanResize"] = False                 ; Denies Tiling/cascading
      y["HasFrame"] = False                  ; If Framed, window is *5* rows!!!
      y["Style"] = color.n                   ; Default color

   width.n = Max(50,Min(Len(message.a)+4,g.sysinfo.y["ScreenWidth"]-4))
   offset.n = Max(5,Int((width.n-Len(message.a)+1)/2)+3)
   oldcanvas.w = GetCanvas()                 ; Where were we, so we can return
   oldwindow.w = GetWindow()
   Window Create  Floating @ -200,-200
                  Height 1 Width width.n
                  Attributes y To g.message.w
   Style Attribute color.n
   PaintCanvas Fill Format("w"+StrVal(width.n)+",ac",message.a)
               Attribute color.n  0,0,0,width.n-1
   PaintCanvas Attribute color.n + 128  0,width.n - offset.n,0,width.n-offset.n+2

   Window Move g.message.w To 1, Int((g.sysinfo.y["ScreenWidth"]-width.n)/2)

   FOR n from 1 to Min(5,beep.n)
      Beep Sleep 100                         ; Beep for desired # of Beeps
   ENDFOR

   SWITCH
      CASE sleep.n > 0  :
         Sleep Min(sleep.n,5) * 1000   ; Sleep for desired # of seconds
         Window Select g.message.w
         Window Close
      CASE sleep.n < 0  :                    ; Probably should use msContinue.u
         Message "Mouseclick or Press Any Key to Continue..."
         WHILE true
            GetEvent ALL To y
            IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
               y["Type"] = "KEY" THEN
               QUITLOOP
            ENDIF
         ENDWHILE
         Window Select g.message.w
         Window Close
   ENDSWITCH

   IF IsWindow(oldwindow.w) THEN             ; Return to where we were
      Window Select oldwindow.w
   ENDIF
   IF IsWindow(oldcanvas.w) THEN
      SetCanvas oldcanvas.w
   ENDIF
   Return
ENDPROC
;
===========================================================================
;       TITLE: msWorkingClear.u
;     RETURNS: No value
; DESCRIPTION: Generic Information Message Window Clearing routine
; ---------------------------------------------------------------------------
PROC msWorkingClear.u()
;Global  g.message.w
   IF IsAssigned(g.message.w) AND IsWindow(g.message.w) THEN
      Window Select g.message.w
      Window Close
   ENDIF
   Return
ENDPROC
;
===========================================================================
;       TITLE: quExecute.l
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
; DESCRIPTION: Generic Query processor
; ---------------------------------------------------------------------------
PROC quExecute.l(                ; Generic Query Processor
         clear.l)                ; Should resultant table be cleared?
Private  qerror.l,               ; Error routine flag
         retval.l                ; Value to return
   qerror.l = false                          ; Initialize flag
   Do_It!                                    ; Main Errorproc checks if Query
                                             ;  Completes and sets flag=true
                                             ;  if the Query fails
   IF qerror.l OR Window() <> "" THEN        ; We had a problem
      msContinue.u("Query Error - " + Window(),79,999,999,"",3)
      retval.l = false                       ; Value to return
      IF IsAssigned(g.debug.l) AND g.debug.l THEN
         DEBUG                               ; Development flag, sneak a peek
      ENDIF
   ELSE
      IF clear.l THEN
         ClearImage
      ENDIF
      IF NImages() >= 1 THEN                 ; Remove all Query images
         MoveTo 1
         WHILE ImageType() = "Query"
            ClearImage
         ENDWHILE
      ENDIF
      retval.l = true                        ; Value to return
      msWorkingClear.u()                     ; Clear the Message Window
   ENDIF
   Return retval.l                           ; True if all is well
ENDPROC
