;ͻ
;                                                                          
;                                                                          
;                                 EOPEN.SC                                 
;                                                                          
;                              E. Scott Jones                              
;                             November 16, 1992                            
;                                                                          
;                       Written in PAL with PARADOX 4.0                    
;                                                                          
;ͼ
;
; This script quickly opens the editor and maximizes the window without
; going thru the menu machinations.  You can open an existing script or
; a new script - makes no difference.
;
; I set it up in INIT.SC as SETKEY "F4" PLAY "C:\\PDOX\\EOPEN"
;
;
;                                 PROC EOpen()
;
PROC EOpen()
PRIVATE new_file

new_file = ""

        ECHO NORMAL
        SHOWDIALOG "Script Editor" @ 5,10 HEIGHT 8 WIDTH 60
        @ 2,3 ?? "Enter Script Name: "

        ACCEPT @ 2,22 WIDTH 33 "A50" TAG "" TO new_file

        PUSHBUTTON @ 4,26 WIDTH 10
        "OK"
        OK
        DEFAULT
        VALUE "Say yes"
        TAG "OKTag"
        TO ButtonValue

        PUSHBUTTON @ 4, 41 WIDTH 10
        "Cancel"
        CANCEL
        VALUE "Say no"
        TAG "CancelTag"
        TO ButtonValue

        ENDDIALOG

ECHO OFF

IF new_file = "" OR RETVAL = False
        THEN CloseDown("")
ENDIF
        
new_file = new_file + ".sc"

IF new_file = "eopen.sc"
        THEN CloseDown("Can't open EOPEN - Active Script")
ENDIF        

IF MATCH(new_file, ".. ..") = True
        THEN CloseDown("Filename Can't Contain Spaces")
ENDIF
        
IF ISFILE(new_file)
        THEN EDITOR OPEN new_file
        CloseDown("")
ELSE
        EDITOR NEW new_file
        CloseDown("")
ENDIF
ENDPROC
;
;                                 PROC CloseDown()
;
PROC CloseDown(msg)
WINDOW HANDLE CURRENT TO ewin
IF ISWINDOW(ewin)
        THEN WINDOW MAXIMIZE ewin
ENDIF        
ECHO NORMAL
RELEASE VARS ALL
RELEASE PROCS ALL
QUIT msg
ENDPROC
;
;                                 Begin EOpen.SC
;
EOpen()
;
;
; EOF() EOpen
;
;
