; This Scirpt is a collection of proceedures for using the Paradox 4.0 File
; editor like you would Readme com in your script
;
;             Written 1/25/92
;             Brian Bushay
;             1715 Emerson Ave N
;             Minneapolis, MN 55411
;             CIS 76711,516
;
;
proc_lib = "File_lib"
Createlib proc_lib
? " File_lib.sc"
Message "Compiling procedures in script \"file_lib.sc\""

; ================================================================================
; ==============================ViewFileEditorWin()  ==============================
; ================================================================================
; View a report in the Editor Window
Proc ViewFileEditorWin(file.a            ;file name to edit
                      ;the followning paramaters can be blank strings ""
                      ,title.a           ;title of window
                      ,startup.proc      ;procedure to call on startup
                      ,close.proc        ;procedure on close
                      ,menuhandler.proc) ;procedure to evaluate menu choices
  Private ret,procname.a
                  ,startkeys.y ;keyboard state on entry to this Proc
                  ,wind.y     ;dynarray holding attributes of editor Window
                  ,editor.w   ;holds handle of editor window
                  ,scroll.y   ;dynarray to hold state of Scroll lock
  procname.a = "ViewFileEditorWin"
  ;Echo Off
  Editor Open file.a      ;open the edit session
  editor.w = GetWindow()  ;try to get editor window handle
  Window GetAttributes editor.w to wind.y
     ;check if the handle GetWindow() returned is for an editor session
     If Search(Upper(file.a),Upper(wind.y["Title"])) = 0  Then  ;oops not the correct handle
        editor.w = GetEditorWindow(wind.y,file.a)
     Endif
  If isAssigned(windowlbl.a) Then   ;If a custom window title is to be used
    wind.y["Title"] = windowlbl.a
  Else
    wind.y["Title"] = "" ;Use no title for window
  Endif
  {Options} {WordWrap} {Clear}    ;remove default WordWrap behavior
  GetKeyBoardState to startkeys.y ;record current keyboard state
  Dynarray scroll.y[]  ;create dynarray
           scroll.y["Scroll Lock"]= true  ;start out with scroll lock on
  SetKeyBoardState from scroll.y
  Window Setattributes editor.w From wind.y  ;sets new window title
  WinMax  ;Maximize editor window
  ;IF you don't want the following default Prompt then use the startUp.proc
  ;paramater to set up a custom prompt
  Prompt "*Print to Screen*    "
  Message ""
  If not IsBlank(startup.proc) then   ;use startup proceedure to set custom
    ExecProc startup.proc             ;showPullDown and Promts ect
  Endif
  Echo Normal
  If Nimages() > 0 Then ;images on workspace use WAIT
    Wait Workspace
    Proc "FileEditWaitHandler"
    ; no event argument traps for all events except Idle
    EndWait
  Else                     ;No images so use GetEvent
    While true
     GetEvent to event.y
     FileEditWaitHandler("EVENT",event.y,0)    ;event Processing procedure
     Switch                                    ;can be shared with WAIT
       Case retval = 0 :   ExecEvent event.y
       Case retval = 1 :  ;do nothing
       OtherWise:          Quitloop
     EndSwitch
    EndWhile
  Endif
  Echo Off
  SetKeyBoardState From startkeys.y ;Restore keyboard state on entry
  Window Select editor.w  ;make sure the editor window is current
  Window close

  If not IsBlank(close.proc) then   ;Use close.proc to reset menus and Prompt if desired
    ExecProc close.proc             ;ect
  Endif

EndProc

  WriteLib proc_lib ViewFileEditorWin
  Release Procs ViewFileEditorWin
  ?? ""


; ================================================================================
; ==============================GetEditorWindow()  ==============================
; ================================================================================
; Gets a window handle of an Edit session even when floating window is on workspace
; Thanks to Dan Paolini for this technique
Proc GetEditorWindow(winAtt.y ;dynarray to hold window attributes
                     ,fileNm.a);file name same as Window title
  private ret,procname.a,
              windows.r,
              elements.n,
              cntr
  procname.a = "GetEditorWindow"
    Window List to windows.r ;Get a list of all Windows
    elements.n = ArraySize(windows.r)
    FOR cntr From 1 To elements.n
      Window Select windows.r[cntr]
      Window GetAttributes windows.r[cntr] To winAtt.y
      IF Search(Upper(file.a),Upper(wind.y["Title"])) >0 THEN
        QUITLOOP
      ENDIF
    ENDFOR
    Return IIF(cntr>elements.n,0,windows.r[cntr]) ; 0 no Editor Window found
Endproc

  Writelib proc_lib GetEditorWindow
  Release procs GetEditorWindow
  ?? ""

; ================================================================================
; ==============================FileEditWaitHandler()  ==============================
; ================================================================================
; Handles keys passed from Wait sessions on the Editor
Proc FileEditWaitHandler(triger.a,event.y,cycle.n)
  private ret,procname.a
  procname.a = "FileEditWaitHandler"
    ret = 1
    switch
       Case triger.a <> "EVENT":
         Switch
          Case triger.a = "ARRIVEWINDOW" :
           ;if a different window is selected the Editor window will be closed
            If GetWindow() <> editor.w And GetWindow() <> 0 Then
               ret = 2  ;2 leaves Wait
            Endif
          OtherWise:  ret = 0
         EndSwitch
       case event.y["Type"] = "MOUSE" : ret = 0
       case event.y["Type"] = "KEY" :
          Switch
            Case event.y["KEYCODE"] =-24    : ;don't allow  ;to DOS keys
            Case event.y["KEYCODE"] =15     : ;don't allow
            ;Internal windows like Zoom have handle of 0
            ;so no more key strokes excluded if handle is 0
            Case GetWindow() = 0            : ret = 0
            Case event.y["KEYCODE"] <= -71  And        ;Home, Up, PgUp, Left
                 event.y["KEYCODE"] >= -81  : ret = 0  ;End,Down,PgDn,Right
            Case event.y["KEYCODE"] <= -115  And       ;Ctrl/Left Ctrl/Right
                 event.y["KEYCODE"] >= -119 : ret = 0  ;Ctrl/Home Ctrl/End Ctrl/PgDn
            Case event.y["KEYCODE"] =  -132 : ret = 0  ;Ctrl/PgUp
            Case event.y["KEYCODE"] =    26 : ret = 0  ;Zoom
            Case event.y["KEYCODE"] =   -44 : ret = 0  ;ZoomNext
            Case event.y["KEYCODE"] =    27 : ret = 2  ;Esc
            OtherWise:                        ret = 1  ;All other keys do not process
          EndSwitch
       Case event.y["Type"] = "MESSAGE" :
          Switch
            Case event.y["Message"] = "MENUSELECT"
                 or event.y["Message"] = "MENUKEY" :
              ;check if a Proc is defined to handle Menu selections
              If not IsBlank(menuhandler.proc) then   ;use menu handling proceed ure if
                ExecProc menuhandler.proc             ;it is defined
                ret = retval
              Endif
            Case event.y["Message"] = "CLOSE" :  Return 2  ;user moused close Bar
            OtherWise:   ret = 0
          EndSwitch
      Otherwise: Message event.y["type"]  ;just incase anything slips by
    EndSwitch
    Return ret
Endproc

  Writelib proc_lib FileEditWaitHandler
  Release procs FileEditWaitHandler
  ?? ""

; ================================================================================
; ==============================FileEditWaitMenu()  ==============================
; ================================================================================
; Menu to put up for File Edit Session
Proc FileEditWaitMenu()
  Private ret,procname.a
  procname.a = "FileEditWaitMenu"
  ;puts up single choice show Pulldown
  ShowPullDown
  "Quit"          : "Leave File Viewer "                : "27",
  "Scroll_Toggel" : "Toggel Scroll Lock"                : "Scroll"
  EndMenu
EndProc

  WriteLib proc_lib FileEditWaitMenu
  Release Procs FileEditWaitMenu
  ?? ""

; ================================================================================
; ==============================FileEditWaitMenuHandler()  ==============================
; ================================================================================
; Proceedure to handle Menu selections while in File editor
Proc FileEditWaitMenuHandler()
  Private ret,procname.a
  procname.a = "FileEditWaitMenuHandler"
    Switch
       Case event.y["MENUTAG"] = "27" : ret = 2 ;leave the wait
       Case event.y["MENUTAG"] = "Scroll" :
          GetKeyBoardState to scroll.y  ;make sure information is current
          scroll.y["Scroll Lock"]= (Not scroll.y["Scroll Lock"])
          SetKeyBoardState from scroll.y
          ret = 1
       OtherWise: ret = 1            ;Do nothhing
    EndSwitch
    Return ret
EndProc

  WriteLib proc_lib FileEditWaitMenuHandler
  Release Procs FileEditWaitMenuHandler
  ?? ""
