;------------------------------------------------------------------------------
; Author: Chuck Summers
; Date:   9/08/92  11:56:19
; Description: This is a library of tools to be used with the editor
;              to make it work well.
;------------------------------------------------------------------------------

If IsFile("EditUtil.Lib") Then
  Proc YesNoKeys(EventType, Tag, Sel, Value)
    ReturnProc = True
    If EventType="EVENT" Then
      If Sel["KeyCode"]= 78 or Sel["KeyCode"]= 110 Then
        PButton="No"
      Else
        PButton="Yes"
      EndIf
    EndIf 
    AcceptDialog
    Return True
  EndProc

  SysInfo To Bag
  c = Int((Bag["ScreenWidth"]-35)/2)
  r = Int(Bag["ScreenHeight"]/2)-4
  PButton="Cancel"
  ShowDialog "Yes/No"
  Proc "YesNoKeys" Key 78, 89, 110, 121
  
    @ r,c Height 7 Width 35
 
    @ 1,2 Style Reverse ?? " Library exists, rebuild it? " Style

    PushButton @ 3,5  Width 10  
      "~Y~es"
      Default
      OK
      Value "Yes"
      Tag "pushbutton"
      To PButton

    PushButton @ 3,17 Width 10
      "~N~o"
      OK
      Value "No"
      Tag "PushButton"
      To PButton
  EndDialog

  If PButton="Yes" Then
    Play "EditLib"
  EndIf
Else
  Play "EditLib"
Endif

;------------------------------------------------------------------------------
; These next lines are set for the global variables that might be used in
; Replace() they are set in EditUtil.Sc and in Replace() just in case the
; library is accessed without running EditUtil.Sc
;------------------------------------------------------------------------------
If Not IsAssigned(FindVal) then
  FindVal = ""
Endif
If Not IsAssigned(ReplaceVal) then
  ReplaceVal = ""
Endif
If Not IsAssigned(ReplaceMethod) then
  ReplaceMethod = 1
Endif
If Not IsAssigned(ReplaceRange) then
  ReplaceRange = 1
Endif
If Not IsAssigned(ReplaceCase) then
  ReplaceCase = 1
Endif
If Not IsAssigned(ReplaceType) then
  ReplaceType = "Basic"
Endif

DynArray BookMarks[]   ; for the bookmark proc - location storage
BookMark = ""
;------------------------------------------------------------------------------
; EditTabLength is set here from EditOpts.Sc saved by the proc EditOpts().
; It is the number of spaces used to represnt a Tab Character.  If set
; to 0, the Tab Character Char(9) is actually used.
;------------------------------------------------------------------------------
If IsFile("EditOpts.Sc") Then
  Play "EditOpts"
Else
  EditTabLength = 0
  SaveVars EditTabLength

  Editor Info To rBag
  If InEditor() Then                     ; rename savevars.sc to editopts.sc
    MiniEdit {Open} {SaveVars.Sc} Menu {File} {CopyToFile} {EditOpts.Sc}
    Menu {Cancel} {Yes}
  Else
    Menu {Tools} {Rename} {Script} {SaveVars} {EditOpts}
  EndIf
Endif

;------------------------------------------------------------------------------
; These next lines setup the keys that will be used to call EditUtil Procs
;------------------------------------------------------------------------------
;alt-r
  SetKey -19 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif ReplaceBox()
;alt-u
  SetKey -22 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif UnComment()
;alt-c
  SetKey -46 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif Comment()
;alt-j
  SetKey -36 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif EditAdj()
;alt-x
  SetKey -45 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif Message "" Return EditOpts()
;Alt-Y
  SetKey -21 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif DelToEndOfLine()
;^-Bks
  SetKey 127 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif KillWord()
;alt-b
  SetKey -48 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif BookMark()
;alt-t
  SetKey -20 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif TimeDateStamp()

If IsAssigned(AutoLib) Then
  AutoLib=AutoLib+", EditUtil"
Else
  AutoLib="EditUtil"
EndIf
Return EditOpts()
