;------------------------------------------------------------------------------
; Author: Chuck Summers
; Date:   9/08/92  11:56:19
; Description: This script creates the EditUtil library.
;------------------------------------------------------------------------------

CREATELIB "EditUtil"
Message "Creating EditUtil Library..."

;------------------------------------------------------------------------------
; Procedure: InEditor
; Description: This program returns True if in editor session and 
;              not in a dialog, otherwise, it returns False
;------------------------------------------------------------------------------
Proc InEditor()
  Private rBag
  Editor Info To rBag
  Return (Retval And MenuChoice() = "Error" And 
                     MenuPrompt() = "Error" And 
                     GetWindow() <> 0)
       
EndProc ; InEditor
WriteLib "EditUtil" InEditor

;------------------------------------------------------------------------------
; Procedure: EditAdj
; Description: This program is used to adjust text right or left when in
;              an editor session.  I would suggest using a hotkey to call this.
;              My setkey is: SETKEY -36 PLAY "EDITADJ", which maps to alt-j.
; Note: I copy the text into a memo variable and work with that to build
;       the new text.  This is about 5 to 8 times faster than the original 
;       method of accessing either the editor session or the clipboard.
;------------------------------------------------------------------------------
Proc Closed EditAdj()
  UseVars EditTabLength, AutoLib
  
  If Not InEditor() Then         ;must not be in an editor session
    Beep
    Quit "Editor block operations not valid in this context"
  EndIf
  
  Editor Info To bag             ;get current editor Info
  
  If Bag["SELSTART"] = 0 Then    ;Is there a marked area?
    Quit "No marked area"		
  EndIf
  
  EscPressed = False             ;flag for escape being pressed

  CursorAtSelStart = Bag["SelStart"] = Bag["CharPos"]

  While Not escpressed
    If EditTabLength <> 0 Then              ; turn off tab setkeys
      Message "Use right or left arrows or tabs to move selected text, Esc aborts"
    Else
      Message "Use right or left arrows to move selected text, Esc aborts"
    EndIf
    key=GetChar()
    Switch
      Case key=27:
        EscPressed = True
  
      Case key=-77 Or                         ; shift text right
          (key=  9 And EditTabLength <> 0):

        Editor Info To Bag
        RealStart=Bag["SelStart"]          ;save the real start of the block
        RealEnd=Bag["SelEnd"]              ;save the real end of the block
  
        Editor GoTo Position RealStart
        Home                               ;get the start of the 1st line
        Editor Info To Bag
        SelStart=Bag["CharPos"]            ;this is the start for adjusting
  
        Editor GoTo Position RealEnd
        End                                ;get the end of the last line
        Editor Info To Bag
        SelEnd=Bag["CharPos"]              ;this is the end for adjusting
  
        Editor Select SelStart SelEnd      ;select all text
        Editor Extract To FromBlock        ;extract text into a memovar
        
        ToBlock = ""                       ;this is the replace text
        x=Search(Chr(10),FromBlock)        ;get the position of CR

        SpacesToInsert = IIf(Key=-77, " ", Spaces(EditTabLength))
        ; while there is text and there is a CR, repeat this loop
        While Len(FromBlock) > 0 And x > 0

          ; this line to the end of the replace text
          ToBlock = ToBlock + SpacesToInsert + SubStr(FromBlock, 1, x)
          
          ; one to the length of the selection
          RealEnd = RealEnd + Len(SpacesToInsert)
          
          ; the 1st line of text from the memovar
          FromBlock = SubStr(FromBlock, x+1, Len(FromBlock)-x)
          x=Search(Chr(10),FromBlock)      ;get the position of CR

        EndWhile
        
        If Len(FromBlock) > 0 Then         ;if there is text left over
          ToBlock = ToBlock + SpacesToInsert + FromBlock
          RealEnd = RealEnd + Len(SpacesToInsert)
        EndIf
        Del                                ;delete selection
        Editor Insert ToBlock              ;paste the memovar to the editor
  
        Echo Normal
        If CursorAtSelStart Then           ;select what the user had selected
          Editor Select RealEnd RealStart
        Else
          Editor Select RealStart RealEnd
        Endif
        Echo Off
        
      Case key=-75:                        ;left arrow

        Editor Info To bag
        RealStart=bag["SelStart"]          ;save the real start of the block
        RealEnd=bag["SelEnd"]              ;save the real end of the block
  
        Editor GoTo Position RealStart
        home                               ;get the start of the 1st line
        Editor Info To bag
        SelStart=bag["CharPos"]            ;this is the start for adjusting
  
        Editor GoTo Position RealEnd
        End                                ;get the end of the last line
        Editor Info To bag
        SelEnd=bag["CharPos"]              ;this is the end for adjusting
  
        Editor Select SelStart SelEnd      ;select all text
        Editor Extract To FromBlock        ;extract text into a memovar
        
        ToBlock = ""                       ;this is the replace text
        While Len(FromBlock) > 0
          x = Search(Chr(10),FromBlock)      ;get the position of the next CR
          If x = 0 Then
            x = Len(FromBlock) 
          Endif
          z=SubStr(FromBlock,1,1)
          Switch
            Case Asc(z)=32:                ;space at the start of the line
              ToBlock = ToBlock + SubStr(FromBlock, 2, x-1)
              RealEnd = RealEnd - 1
            Case Asc(z)=9:                 ;tab at the start of the line
              ToBlock = ToBlock + "       " + SubStr(FromBlock, 2, x-1)
              RealEnd = RealEnd + 6
            OtherWise:                     ;blank line or non-blank character at the start of the line
              ToBlock = ToBlock + SubStr(FromBlock, 1, x)
          EndSwitch
          FromBlock = SubStr(FromBlock, x+1, len(FromBlock)-x)
        EndWhile
        Del                                ;delete selection
        Editor Insert ToBlock              ;paste the memovar to the editor
  
        Echo Normal
        If CursorAtSelStart Then           ;select what the user had selected
          Editor Select RealEnd RealStart
        Else
          Editor Select RealStart RealEnd
        Endif
        Echo Off

      Case key=-15 And EditTabLength <> 0: ;left tab

        Editor Info To bag
        RealStart=bag["SelStart"]          ;save the real start of the block
        RealEnd=bag["SelEnd"]              ;save the real end of the block
  
        Editor GoTo Position RealStart
        Home                               ;get the start of the 1st line
        Editor Info To bag
        SelStart=bag["charpos"]            ;this is the start for adjusting
  
        Editor GoTo Position RealEnd
        End                                ;get the end of the last line
        Editor Info To bag
        SelEnd=bag["charpos"]              ;this is the end for adjusting
  
        Editor Select SelStart SelEnd      ;select all text
        Editor Extract To FromBlock        ;extract text into a memovar
        
        ToBlock = ""                       ;this is the replace text

        While Len(FromBlock) > 0
          x = Search(Chr(10),FromBlock)      ;get the position of the next CR
          If x = 0 Then
            x = Len(FromBlock) 
          EndIf
          FromLine = SubStr(FromBlock, 1, x)
          If SubStr(FromLine,1,EditTabLength) = Spaces(EditTabLength) Then
            ToBlock = ToBlock + SubStr(FromLine, EditTabLength + 1, x)
            RealEnd = RealEnd - EditTabLength
            FromBlock = SubStr(FromBlock, x+1, Len(FromBlock)-x)
          Else
            For i From 1 To EditTabLength
              z=SubStr(FromLine, 1, 1)
              Switch
                Case Asc(z)=32:                ;space at the start of the line
                  FromLine = SubStr(FromLine, 2, x)
                  RealEnd = RealEnd - 1
                Case Asc(z)=9:                 ;tab at the start of the line
                  FromLine = "       " + SubStr(FromLine, 2, x)
                  RealEnd = RealEnd + 6
                OtherWise:                     ;blank line or non-blank character at the start of the line
                  QuitLoop
              EndSwitch
            EndFor
            ToBlock = ToBlock + FromLine
            FromBlock = SubStr(FromBlock, x+1, Len(FromBlock)-x)
          EndIf
        EndWhile
        Del                                ;delete selection
        Editor Insert ToBlock              ;paste the memovar to the editor
  
        Echo Normal
        If CursorAtSelStart Then           ;select what the user had selected
          Editor Select RealEnd RealStart
        Else
          Editor Select RealStart RealEnd
        Endif
        Echo Off

    EndSwitch
  
  EndWhile
  Return
EndProc ; EditAdj
WriteLib "EditUtil" EditAdj

;------------------------------------------------------------------------------
; Procedure: Comment
; Description: This program is used to comment selected text.
;------------------------------------------------------------------------------
PROC CLOSED Comment()
  UseVars AutoLib

  If Not InEditor() Then                    ;must not be in an editor session
    Beep
    Quit "Editor block operations not valid in this context"
  EndIf
  
  Editor Info To Bag            ;get current editor info
  
  If bag["SelStart"] = 0 Then           ;Is there a marked area?
    Quit "No marked area"		
  EndIf
  
  CursorAtSelStart = Bag["SelStart"] = Bag["CharPos"]
  RealStart=bag["SelStart"]          ;save the real start of the block
  RealEnd=bag["SelEnd"]              ;save the real end of the block

  Editor GoTo Position RealStart
  Home                               ;get the start of the 1st line
  Editor Info To bag
  SelStart=bag["charpos"]            ;this is the start for adjusting

  Editor GoTo Position RealEnd
  End                                ;get the end of the last line
  Editor Info To bag
  SelEnd=bag["charpos"]              ;this is the end for adjusting

  Editor Select SelStart SelEnd      ;select all text
  Editor Extract To FromBlock        ;extract text into a memovar
  
  ToBlock = ""                       ;this is the replace text
  x=Search(Chr(10),FromBlock)        ;get the position of CR
  ; while there is text and there is a CR, repeat this loop
  While Len(FromBlock) > 0 And x > 0
    If x = 1 Then
      ToBlock = ToBlock + Chr(10)
    Else
      ToBlock = ToBlock + ";" + SubStr(FromBlock, 1, x)
      RealEnd = RealEnd + 1
    EndIf
    FromBlock = SubStr(FromBlock, x+1, len(FromBlock)-x)
    x=Search(Chr(10),FromBlock)      ;get the position of CR
  EndWhile
  If Len(FromBlock) > 0 Then         ;if there is text left over
    ToBlock = ToBlock + ";" + FromBlock
    RealEnd = RealEnd + 1
  EndIf
  Del                                ;delete selection
  Editor Insert ToBlock              ;paste the memovar to the editor

  Echo Normal
  If CursorAtSelStart Then           ;select what the user had selected
    Editor Select RealEnd RealStart
  Else
    Editor Select RealStart RealEnd
  Endif
  Echo Off

EndProc ; Comment
WriteLib "EditUtil" Comment

;------------------------------------------------------------------------------
; Procedure: UnComment
; Description: This program is used to comment selected text.
;------------------------------------------------------------------------------
PROC CLOSED UnComment()
  UseVars AutoLib
  If Not InEditor() Then                    ;must not be in an editor session
    Beep
    Quit "Editor block operations not valid in this context"
  EndIf
  
  Editor Info To bag            ;get current editor info
  
  If Bag["SelStart"] = 0 then           ;Is there a marked area?
    Quit "No marked area"		
  EndIf
  
  CursorAtSelStart = Bag["SelStart"] = Bag["CharPos"]
  RealStart=bag["SelStart"]          ;save the real start of the block
  RealEnd=bag["SelEnd"]              ;save the real end of the block

  Editor GoTo Position RealStart
  Home                               ;get the start of the 1st line
  Editor Info To bag
  SelStart=bag["charpos"]            ;this is the start for adjusting

  Editor GoTo Position RealEnd
  End                                ;get the end of the last line
  Editor Info To bag
  SelEnd=bag["charpos"]              ;this is the end for adjusting

  Editor Select SelStart SelEnd      ;select all text
  Editor Extract To FromBlock        ;extract text into a memovar
  
  ToBlock = ""                       ;this is the replace text
  x=Search(Chr(10),FromBlock)
  ; while there is text and there is a CR, repeat this loop
  While Len(FromBlock) > 0
    x=Search(Chr(10),FromBlock)
    If SubStr(FromBlock,1,1) = ";" Then
      ToBlock = ToBlock + SubStr(FromBlock, 2, x-1)
      RealEnd = RealEnd - 1
    Else
      ToBlock = ToBlock + SubStr(FromBlock, 1, x) 
    EndIf
    FromBlock = SubStr(FromBlock, x+1, Len(FromBlock)-x)
  EndWhile
  If Len(FromBlock) > 0 Then         ;if there is text left over
    If SubStr(FromBlock,1,1) = ";" Then
      ToBlock = ToBlock + SubStr(FromBlock,2,len(FromBlock-1))
      RealEnd = RealEnd - 1
    Else
      ToBlock = ToBlock + FromBlock 
    EndIf
  EndIf
  Del                                ;delete selection
  Editor Insert ToBlock              ;paste the memovar to the editor

  Echo Normal
  If CursorAtSelStart Then           ;select what the user had selected
    Editor Select RealEnd RealStart
  Else
    Editor Select RealStart RealEnd
  Endif
  Echo Off

EndProc ; UnComment
WriteLib "EditUtil" UnComment

;------------------------------------------------------------------------------
; Procedure: ReplaceBox
; Description: This is a "better" replace than the Paradox editor's replace.
;------------------------------------------------------------------------------
PROC CLOSED ReplaceBox()
UseVars FindVal, ReplaceVal, ReplaceMethod, ReplaceRange, ReplaceCase,
        ReplaceType, AutoLib

  ;------------------------------------------------------------------------------
  ; Procedure: ReplaceBoxDefProc   - only called within ReplaceBox()
  ; Description: This is the basic replace box.
  ;------------------------------------------------------------------------------
  Proc ReplaceBoxDefProc(TriggerType, TagValue, EventValue, ElementValue)
    Private wBag, WH, NewColors
    Window Handle Dialog To WH
    Switch
      Case TriggerType = "OPEN":
        Window GetColors WH To NewColors
        NewColors[1] = 78
        Window SetColors WH From NewColors
      Case TriggerType = "CLOSE":
        Window GetAttributes WH To wBag
        r = wBag["OriginRow"]
        c = wBag["OriginCol"]
    EndSwitch
      
  EndProc

  ;------------------------------------------------------------------------------
  ; Procedure: BasicReplaceBox   - only called within ReplaceBox()
  ; Description: This is the basic replace box.
  ;------------------------------------------------------------------------------
  Proc BasicReplaceBox()

    ReplaceType = "Basic"
    h = 9
    w = 56

    PButton="Cancel"

    ShowDialog "Search/Replace" 
      Proc "ReplaceBoxDefProc"    
      @ r,c Height h Width w
   
      @ 1,1 ?? "Find Value:"
      Accept @ 1, 16 
        Width 37 "A80"
        Tag "FindVal"
        To FindVal

      @ 3,1 ?? "Replace Value:"
      Accept @ 3, 16 
        Width 37 "A80"
        Tag "ReplaceVal"
        To ReplaceVal
  
      PushButton @ 5,4  Width 10  
        "~S~earch"
        Default
        OK
        Value "Search"
        Tag "pushbutton"
        To PButton
  
      PushButton @ 5,17  Width 20  
        "~A~dvanced Options"
        OK
        Value "Advanced"
        Tag "pushbutton"
        To PButton
  
      PushButton @ 5,39 Width 10
        "~C~ancel"
        CANCEL
        Value "Cancel"
        Tag "PushButton"
        To PButton

    EndDialog
  
    Return PButton
  EndProc ; BasicReplaceBox()
  
;------------------------------------------------------------------------------
; Procedure: AdvancedReplaceBox  - only called within ReplaceBox()
; Description: This is the advanced replace box.  It lets users set:
;              Method: Manual/Automatic
;              Range:  To End/All
;              Case:   InSensitive/Sensitive
;------------------------------------------------------------------------------
  Proc AdvancedReplaceBox()
    ReplaceType = "Advanced"
    h = 13
    w = 56

    PButton="Cancel"

    ShowDialog "Advanced Search/Replace"
    
      Proc "ReplaceBoxDefProc"    
      @ r,c Height h Width w
   
      @ 1,1 ?? "Find Value:"
      Accept @ 1, 16 Width 37 "A80"
        Tag "FindVal"
        To FindVal
      
      @ 3,1 ?? "Replace Value:"
      Accept @ 3, 16 Width 37 "A80"
        Tag "ReplaceVal"
        To ReplaceVal
  
      PushButton @ 5,4  Width 10  
        "~S~earch"
        Default
        OK
        Value "Search"
        Tag "pushbutton"
        To PButton
  
      PushButton @ 5,17  Width 20  
        "~B~asic Options"
        OK
        Value "Basic"
        Tag "pushbutton"
        To PButton
  
      PushButton @ 5,39 Width 10
        "~C~ancel"
        CANCEL
        Value "Cancel"
        Tag "PushButton"
        To PButton
  
      @ 7,1 ?? "Method:"
      RadioButtons @ 8,1 Height 2 Width 15
        "Manual","Automatic"
        Tag "ReplaceMethod"
        To ReplaceMethod
  
      @ 7,19 ?? "Range:"
      RadioButtons @ 8,19 Height 2 Width 14
        "To End","All"
        Tag "ReplaceRange"
        To ReplaceRange
  
      @ 7,36 ?? "Case:"
      RadioButtons @ 8,36 Height 2 Width 17
        "InSensitive","Sensitive"
        Tag "ReplaceCase"
        To ReplaceCase
  
    EndDialog
  
    Return PButton
  EndProc ; AdvancedReplaceBox()
  
  ;------------------------------------------------------------------------------
  ; Procedure: ResetCase  - only called within ReplaceBox()
  ; Description: This resets Options|CaseSensitive
  ;------------------------------------------------------------------------------
  Proc ResetCase()
    If ReplaceType = "Advanced" Then               
      Menu {Options} {CaseSensitive}         ; get the CaseSensitive setting
      If CaseSave = "Clear" Then
        {Clear}
      Else
        {Set}
      Endif
    Endif
  EndProc ; ResetCase()  

;------------------------------------------------------------------------------
; Actual work begins here
;------------------------------------------------------------------------------

  If Not InEditor() Then                ;must not be in an editor session
    Quit "Editor operations not valid in this context"
  EndIf

  h = 9
  w = 56

  SysInfo To rBag                       ; setup dialogbox based on screen size
  c = Int((rBag["ScreenWidth"]-w)/2)-5
  r = Int(rBag["ScreenHeight"]/2)-8

  Editor Info To Bag                    ;get current editor Info

;------------------------------------------------------------------------------
; These next lines are set for the global variables that might be used in
; Replace() they are set in EditUtil.Sc and in Replace() just in case the
; library is accessed without running EditUtil.Sc
;------------------------------------------------------------------------------
  If Not IsAssigned(FindVal) then
    FindVal = ""
  Endif
  If Not IsAssigned(ReplaceVal) then
    ReplaceVal = ""
  Endif
  If Not IsAssigned(ReplaceMethod) then
    ReplaceMethod = 1
  Endif
  If Not IsAssigned(ReplaceRange) then
    ReplaceRange = 1
  Endif
  If Not IsAssigned(ReplaceCase) then
    ReplaceCase = 2
  Endif
  
  DynArray AcceptKeys[]                   ; This is a list of keys that is 
  AcceptKeys[27]  = "Cancel"              ; acceptable, each value is what
  AcceptKeys[82]  = "Replace"             ; the key command is.
  AcceptKeys[114] = "Replace"
  AcceptKeys[83]  = "Skip"
  AcceptKeys[115] = "Skip"
  AcceptKeys[65]  = "All"
  AcceptKeys[97]  = "All"
   
  RetVal = ReplaceType
  While RetVal <> "Search" And RetVal <> "Cancel"  ; keep executing a box until
    If RetVal = "Advanced" Then                    ; cancel or search is selected
      RetVal = AdvancedReplaceBox()
    Else
      RetVal = BasicReplaceBox()
    EndIf
  EndWhile
  
  If RetVal = "Cancel" Then
    Quit "Canceled"
  Endif

  If FindVal = "" Then
    Quit "Canceled - No Find Value specified"
  Endif
  
  If ReplaceType = "Advanced" And ReplaceRange = 2 Then    ; This is for search all
    Editor GoTo Position 1
  Endif

  If ReplaceType = "Advanced" Then
    Menu {Options} {CaseSensitive}                  ; get the CaseSensitive setting
    CaseSave = MenuChoice()
    If ReplaceCase = 1 Then
      {Clear}
    Else
      {Set}
    Endif
  Endif
  
  If (ReplaceType = "Advanced" And ReplaceMethod = 2) Then      ; automatic replace

    Message "Working..."

    ReplaceCount = 0
    Editor Find FindVal

    While RetVal
      ReplaceCount = ReplaceCount + 1
      Editor Insert ReplaceVal
      Editor Find FindVal
    EndWhile          

    ResetCase()
    Quit StrVal(ReplaceCount)+ " Replacement" + 
      IIf(ReplaceCount = 1, "", "s") + " done"
  
  Else
    Editor Info To rBag

    Editor Find FindVal               ; find the text

    If Not RetVal Then
      Switch                                       ; if text was selected, retain it
        Case rBag["SelStart"] = rBag["CharPos"]:
          Editor Select rBag["SelEnd"] rBag["SelStart"] 
        Case rBag["SelEnd"]+1 = rBag["CharPos"]:
          Editor Select rBag["SelStart"] rBag["SelEnd"] 
      EndSwitch
      ResetCase()
      Quit "Find Value not found"

    Else
      While RetVal                       ; if found echo normal to display selection
        Echo Normal                      ; if echo was normal all the time
        Editor Info To rBag              ; the screen would go wild
        Editor Select rBag["SelStart"] rBag["SelEnd"]
        Prompt " "  
        Echo Off
    
        Message "Found!  R = Replace, S = Skip, A = Replace to End, Esc = Cancel"
        KeyCode = GetChar()
    
        While Not IsAssigned(AcceptKeys[KeyCode])                ; key in the list?
          Message "Found!  R = Replace, S = Skip, A = Replace to End, Esc = Cancel"
          KeyCode = GetChar()
        EndWhile
    
        Switch
          Case AcceptKeys[KeyCode] = "Cancel":  
            ResetCase()
            Quit "Canceled"
    
          Case AcceptKeys[KeyCode] = "Skip":  
            Editor Find FindVal
            
          Case AcceptKeys[KeyCode] = "Replace":  
            Editor Insert ReplaceVal
            Editor Find FindVal
    
          Case AcceptKeys[KeyCode] = "All":  
  
            Message "Working..."
  
            ReplaceCount = 1
            Editor Insert ReplaceVal
            Editor Find FindVal
  
            While RetVal
              ReplaceCount = ReplaceCount + 1
              Editor Insert ReplaceVal
              Editor Find FindVal
            EndWhile          
  
            ResetCase()
            Quit StrVal(ReplaceCount)+ " Replacement" + 
              IIf(ReplaceCount = 1, "", "s") + " done"
    
        EndSwitch
    
      EndWhile
    EndIf
    ResetCase()
    Quit "Find Value not found"
 
  Endif  

EndProc ; ReplaceBox()
WriteLib "EditUtil" ReplaceBox

;------------------------------------------------------------------------------
; Procedure: KillWord  
; Description: This proc deletes the entire word you are on, suggested
;              hot key is Ctrl-Bks
;------------------------------------------------------------------------------
Proc KillWord()
  Private rBag1, rBag2, Line, Pointer
  If InEditor() Then
    Editor Info To rBag1
    If rBag1["SelStart"] + rBag1["SelEnd"] = 0 Then     ; if no text selected
      ShiftPress "Home"
      Editor Extract To Line
      For Pointer From(rBag1["Col"] - 1) To 1 Step -1
        If Search(SubStr(Line, Pointer, 1)," ,.") > 0 Then
          If SubStr(Line, (Pointer - 1), 2) <> ".." Then
            QuitLoop
          Else 
            Pointer =  Pointer - 1
          EndIf
        EndIf
      EndFor
      Editor Select 
        (rBag1["CharPos"]+1-(rBag1["Col"]-Pointer)) rBag1["CharPos"]
      ShiftPress "CtrlRight"
    Endif
    Del
  Else
    CtrlBackSpace
  EndIf
EndProc ; KillWord
WriteLib "EditUtil" KillWord
  

;------------------------------------------------------------------------------
; Procedure: ControlRight
; Description: This proc is a better ^Right
;------------------------------------------------------------------------------
Proc ControlRight()
  Private Line,rBag,LineLen,LinePoint,   ; LinePoint is the new offset
          Point1, Point2, Point3, Point4, KeyBoardBag
  If InEditor() Then
    Editor Info To rBag
    GetKeyBoardState To KeyBoardBag
    Editor Select rBag["CharPos"] rBag["CharPos"]+250
    Editor Extract To Line
    LineLen = Len(Line)

    Point1 = Search(",",Line)                     ; search for ,
    Point2 = Search(".",Line)                     ; search for .

    ; in the event of word...  all .'s are counted as one word

    While SubStr(Line, Point2 + 1, 1) = "."
      Point2 = Point2 + 1
    EndWhile
    
    Point3 = Search(" ",Line)                     ; search for space
    Point4 = Search("\n",Line)                    ; search for CR

    Point1 = IIf(Point1 = 0, 9999999, Point1 + 1)
    Point2 = IIf(Point2 = 0, 9999999, Point2 + 1)
    Point3 = IIf(Point3 = 0, 9999999, Point3 + 1)
    Point4 = IIf(Point4 = 0, 9999999, Point4 + 1)

    Switch                         

      ; case: when you have  _ word
      Case Match(Line," .."):            
        LinePoint = 1

      ; case: cursor below    word1 word2
      ;                        ^
      Case (Point3 < Point1) And (Point3 < Point2) And (Point3 < Point4):
        LinePoint = Point3

      ; case: cursor below    word1, word2
      ;                        ^
      Case (Point1 < Point3) And (Point1 < Point2) And (Point1 < Point4):
        LinePoint = Point1 

      ; case: cursor below    word1.  Word2
      ;                        ^
      Case (Point2 < Point1) And (Point2 < Point3) And (Point2 < Point4):
        LinePoint = Point2 

      ; case: cursor below    word1\n Word2
      ;                        ^
      Case (Point4 < Point1) And (Point4 < Point3) And (Point4 < Point3):
        LinePoint = Point4

      ; otherwise: solidtext(without-spaces-commas-or-periods)
      OTHERWISE:
        LinePoint = LineLen

    EndSwitch

    Line = SubStr(Line,LinePoint,255)

    While                         ; strip all spaces
      Match(Line," ..",Line)
    EndWhile

    While                         ; if CR, go to next line
      Match(Line,"\n..",Line)
    EndWhile

    While                         ; strip all leading spaces in new line
      Match(Line," ..",Line)
    EndWhile
    If KeyBoardBag["Left Shift"] Or KeyBoardBag["Right Shift"] Then
      If rBag["SelStart"] = 0 Then
        Editor Select  rBag["CharPos"]   rBag["CharPos"] + (LineLen - Len(Line)) - 1
      Else
        Editor Select  rBag["SelStart"]   rBag["CharPos"] + (LineLen - Len(Line)) - 1
      Endif
    Else
      Editor GoTo Position rBag["CharPos"] + (LineLen - Len(Line))
    Endif
    Return True
  Else
    Return False 
  EndIf
EndProc ;ControlRight
WriteLib "EditUtil" ControlRight

;------------------------------------------------------------------------------
; Procedure: EditTab
; Description: This proc is for filling the tab with spaces
; Uses: EditTabLength
;------------------------------------------------------------------------------
Proc EditTab()
  Private rBag1, rBag2, NewCol
  If InEditor() Then
    Editor Info To rBag1
    If IsInsertMode() Then
      Typein Spaces(EditTabLength - Mod(rBag1["Col"], EditTabLength))
    Else
      NewCol = (Int(rBag1["Col"]/EditTabLength)+1) * EditTabLength
      End 
      Editor Info To rBag2
      If NewCol < rBag2["Col"] Then
        Editor GoTo Position rBag2["CharPos"] - (rBag2["Col"] - NewCol)
      Else
        Typein Spaces(NewCol - rBag2["Col"])
      Endif
    EndIf
  Else
    Tab
  EndIf
  Return
EndProc ; EditTab
WriteLib "EditUtil" EditTab

;------------------------------------------------------------------------------
; Procedure: EditBackTab
; Description: This proc is for backtab in the editor
; Uses: EditTabLength
;------------------------------------------------------------------------------
Proc EditBackTab()
  Private rBag1, NewCol
  If InEditor() Then
    Editor Info To rBag1
    NewCol = Max(1, Int((rBag1["Col"]-1)/EditTabLength) * EditTabLength)
    Editor GoTo Position rBag1["CharPos"] - (rBag1["Col"] - NewCol)
  Else
    ReverseTab
  EndIf
  Return
EndProc ; EditBackTab
WriteLib "EditUtil" EditBackTab

;------------------------------------------------------------------------------
; Procedure: DelToEndOfLine
; Description: This proc deletes from the cursor to the end of the line
;------------------------------------------------------------------------------
Proc DelToEndOfLine()
  Private rBag
  If InEditor() Then
    ShiftPress "End"
    Del
  Else
    KeyPress -21
  EndIf
  Return
EndProc ; DelToEndOfLine
WriteLib "EditUtil" DelToEndOfLine

;------------------------------------------------------------------------------
; Procedure: TimeDateStamp
; Description: This proc inserts the date and time at the cursor
;------------------------------------------------------------------------------
Proc TimeDateStamp()
  Private rBag
  If InEditor() Then
    Editor Insert Format("D1",Today())+"  "+Time()
  Else
    KeyPress -20
  EndIf
  Return
EndProc ; TimeDateStamp
WriteLib "EditUtil" TimeDateStamp

;------------------------------------------------------------------------------
; Procedure: BookMark
; Description: This proc is used to mark your place in an editor session.
;------------------------------------------------------------------------------
Proc Closed BookMark()
  UseVars BookMarks, BookMark, AutoLib
  
  If Not InEditor() Then         ;must not be in an editor session
    KeyPress -48
    Return
  EndIf
  
  ;------------------------------------------------------------------------
  ; Procedure: GoToBookMark
  ; Description: This proc is used to goto a bookmark
  ;------------------------------------------------------------------------
  Proc GoToBookMark()
    If BookMark = "" Then
      Quit "You need to set a bookmark before you can goto one"
    Endif   
    WH = NumVal(SubStr(BookMark,21,10))
    If WH <> GetWindow() Then
      If Not IsWindow(WH) Then
        If IsFile(SubStr(BookMark,1,Search(" ",BookMark)-1)) Then
          Editor Open SubStr(BookMark,1,Search(" ",BookMark)-1)
          WH = GetWindow()
          LineNumber = SubStr(BookMark,16,5)
          Editor Goto Line NumVal(LineNumber)
          Release Vars BookMarks[BookMark]
          Window GetAttributes WH to xBag
          SlashPos=1
          While SlashPos > 0
            Mark = SlashPos + 1
            SlashPos = SearchFrom("\\", xBag["Title"], SlashPos + 1)
          EndWhile
          
          BookMark=SubStr(xBag["Title"],Mark,15)
          BookMark = BookMark + Fill(" ",20-Len(BookMark+LineNumber)) +
            LineNumber + Format("W10", WH)
          Home ShiftPress "End"              ; select line
          Editor Extract To Line
          BookMarks[BookMark] = Line         ; reset the bookmark, new handle
        Else
          Quit "Original editor session closed and file not found in directory"
        EndIf
      Else
        Window Select WH
      Endif
    EndIf   
    Editor Goto Line NumVal(SubStr(BookMark,16,5))
    Return
  EndProc
  
  ;------------------------------------------------------------------------
  ; Procedure: SetBookMarkDialogs
  ; Description: This proc is used to set the color of the border,
  ; accept the dialog upon double clicking on a setting, and
  ; to process the different events in the case of an update.
  ;------------------------------------------------------------------------
  Proc BookMarkDiagProc(TriggerType, TagValue, EventValue, ElementValue)
    Private wBag, WH, NewColors
    Switch
      Case TriggerType = "OPEN":
        Window Handle Dialog To WH
        Window GetColors WH To NewColors
        NewColors[1] = 78
        Window SetColors WH From NewColors
        If DynArraySize(BookMarks) = 0 Then
          SelectControl "SetPushButton"
        Endif

      Case TriggerType = "SELECT":
        AcceptDialog      
        GotoBookMark()

      Case TriggerType = "UPDATE":
        Message ""
        Switch
          Case EventValue = "DeleteAll":            ; clean out the array
            DynArray BookMarks[]
            RefreshDialog

          Case EventValue = "Erase":                ; remove one element
            Release Vars BookMarks[BookMark]
            RefreshDialog

          Case EventValue = "GoTo":                 ; goto a location
            GotoBookMark()

          Case EventValue = "Set":                   ; set a bookmark
            WH = GetWindow()
            Window GetAttributes WH to xBag
            SlashPos=1
            While SlashPos > 0
              Mark = SlashPos + 1
              SlashPos = SearchFrom("\\", xBag["Title"], SlashPos + 1)
            EndWhile

            BookMark=SubStr(xBag["Title"],Mark,15)
            
            Editor Info Complete to yBag

            LineNumber = StrVal(yBag["CurLine"])
            BookMark = BookMark + Fill(" ",20-Len(BookMark+LineNumber)) +
              LineNumber + Format("W10", WH)
            Home ShiftPress "End" ; select line
            Editor Extract To Line
            BookMarks[BookMark] = Line
            Switch
              Case yBag["SelStart"] = 0:
                Editor Goto Position yBag["CharPos"]
              Case yBag["SelStart"] = yBag["CharPos"]:
                Editor Select yBag["SelEnd"] yBag["SelStart"]
              OtherWise:
                Editor Select yBag["SelStart"] yBag["SelEnd"]
            EndSwitch
        EndSwitch
    EndSwitch
  EndProc

  h = 15
  w = 50
  SysInfo To rBag                       ; setup dialogbox based on screen size
  c = Int((rBag["ScreenWidth"]-w)/2)-5
  r = Int(rBag["ScreenHeight"]/2)-8

  PButton="Set"

  ShowDialog "BookMark"
    Proc "BookMarkDiagProc" Trigger "Open", "Select", "Update"
    @  r,c Height h Width w
    
    @ 0,1 ?? "Book Mark List:"
    PickDynArrayIndex
      @ 1,5 Height h-6 Width 22
      BookMarks
      Tag "BookMarks"
      To BookMark

    @ h-5, 1 ?? "Text:"
    @ h-4, 1 Style Attribute 7
      ?? Format("W46", IIf(BookMark <> "", BookMarks[BookMark], ""))
    
    PushButton @ 1,32 Width 14
      "~G~oTo"
      Default
      OK
      Value "GoTo"
      Tag "pushbutton"
      To PButton

    PushButton @ 3,32 Width 14
      "~S~et"
      OK
      Value "Set"
      Tag "SetPushButton"
      To PButton

    PushButton @ 9,32 Width 14
      "~C~ancel"
      CANCEL
      Value "Cancel"
      Tag "PushButton"
      To PButton

    PushButton @ 5,32 Width 14
      "~E~rase"
      Value "Erase"
      Tag "pushbutton"
      To PButton

    PushButton @ 7,32 Width 14 
      "~D~elete All"
      Value "DeleteAll"
      Tag "pushbutton"
      To PButton

  EndDialog

EndProc ; BookMark
WriteLib "EditUtil" BookMark

;------------------------------------------------------------------------------
; Procedure: EditOpts
; Description: This proc is an information screen and lets the user
;              set how many spaces the tab character represents.
;------------------------------------------------------------------------------
PROC EditOpts()
PRIVATE h, w, c, r, PButton, StartTicks

  Message ""
  
  ;------------------------------------------------------------------------------
  ; Procedure: EditOptsEvent   - only called within EditOpts
  ; Description: This program is an information screen and lets the user
  ;              set how many spaces the tab character represents.
  ;------------------------------------------------------------------------------
  Proc EditOptsEvent(TriggerType, TagValue, EventValue, ElementValue)
    Private wBag, WH, NewColors
    Window Handle Dialog To WH
  
    Switch
      Case TriggerType = "OPEN":
        Window GetColors WH To NewColors
        NewColors[1] = 78                  ;frame yellow on red
        Window SetColors WH From NewColors
        GetColors to NewColors
        TextStyle = NewColors[1036]
        RepaintDialog
      Case EventValue["Type"] = "KEY":
        NewDialogSpec Key 23 ; Picking anything to end idle event processing
      Case EventValue["Type"] = "IDLE":    
        If Ticks() > StartTicks + 20000 Then
          CancelDialog
        Endif
    EndSwitch
  EndProc ; EditOptsEvent
  
  h = 21
  w = 66
  
  SysInfo To rBag                    ; setup dialogbox based on screen size
  c = Int((rBag["ScreenWidth"]-w)/2)
  r = Int((rBag["ScreenHeight"]-h)/2)
  
  PButton="OK"
  
  StartTicks = Ticks()
  TextStyle = 112                    ; standard text style for dialog boxes
  
  ShowDialog "Editor Options" 
  
    Proc "EditOptsEvent" Idle Key "All" Trigger "Open"
    
    @ r,c Height h Width w
  
    @ 1,1 ?? "Spaces to Represent a Tab:" Style
    Accept @ 1, 29
      Width 5 "S"
      Tag "EditTabLength"
      To EditTabLength
  
    @ 3,1 Style Attribute TextStyle ?? "New function keys:"
    @ 4,1 Style Attribute TextStyle ?? fill("",62)
    @ 5,3  Style Reverse     ?? "Alt-R"
      @ 5,10 Style Attribute TextStyle ?? "Search/Replace"
    @ 5,35 Style Reverse     ?? "Alt-C" 
      @ 5,42 Style Attribute TextStyle ?? "Comment Selection"
    @ 6,3  Style Reverse     ?? "Alt-J" 
      @ 6,10 Style Attribute TextStyle ?? "Adjust Selection" 
    @ 6,35 Style Reverse     ?? "Alt-U" 
      @ 6,42 Style Attribute TextStyle ?? "UnComment Selection"
    @ 7,3  Style Reverse     ?? "Alt-X" 
      @ 7,10 Style Attribute TextStyle ?? "EditUtil Info"
    @ 7,35 Style Reverse     ?? "Alt-Y" 
      @ 7,42 Style Attribute TextStyle ?? "Delete To End Of Line"
    @ 8,3  Style Reverse     ?? "^-Bks" 
      @ 8,10 Style Attribute TextStyle ?? "Delete Word"
    @ 8,35 Style Reverse     ?? "Alt-B" 
      @ 8,42 Style Attribute TextStyle ?? "BookMarks"
    @ 9,3  Style Reverse     ?? "Alt-T" 
      @ 9,10 Style Attribute TextStyle ?? "Time & Date Stamp"

    @ 11,1 Style Attribute TextStyle ?? "Keys with 'better' implementations:"
    @ 12,1 Style Attribute TextStyle ?? fill("",62)
    @ 13,3 Style Reverse ?? "Tab" Style Attribute TextStyle
              ?? "         Insert spaces and move in overwrite"
    @ 14,3 Style Reverse ?? "BackTab" Style Attribute TextStyle
              ?? "     Moves back to previous tab stop"


    PushButton @ 17,21  Width 10  
      "~O~K"
      Default
      OK
      Value "OK"
      Tag "pushbutton"
      To PButton
  
    PushButton @ 17,33  Width 10  
      "~U~nload"
      OK
      Value "Unload"
      Tag "pushbutton"
      To PButton
  
  EndDialog
  
  If Not RetVal Then
    Return "Press [Alt-X] to display the Editor Utilities Options"
  Endif
  
  If Pbutton = "Unload" Then
    If Len(AutoLib) > 8 Then
      x = Search(", EditUtil",AutoLib)
      If x > 0 Then
        AutoLib = Substr(AutoLib,1,x-1)+Substr(AutoLib,x+10,Len(AutoLib))
      Else
        AutoLib = Substr(AutoLib,10,Len(AutoLib))
      EndIf
    Else
      AutoLib = ""
    EndIf
    SetKey   9
    SetKey -15
    SetKey -19
    SetKey -22
    SetKey -46
    SetKey -36
    SetKey -45
    SetKey -21
    SetKey 127
    SetKey -48
    SetKey -20
    Return "EditUtil Unloaded"
  EndIf
  
  If IsBlank(EditTabLength) Then
    EditTabLength = 0
  Endif
  
  SaveVars EditTabLength

  Editor Info To rBag
  If InEditor() Then        ; rename savevars.sc to editopts.sc
    MiniEdit {Open} {SaveVars.Sc} Menu {File} {CopyToFile} {EditOpts.Sc}
    If MenuChoice() = "Cancel" Then {Replace} EndIf Menu {Cancel} {Yes}
  Else
    Menu {Tools} {Rename} {Script} {SaveVars} {EditOpts}
    If MenuChoice() = "Cancel" Then {Replace} EndIf
  EndIf
 
  If EditTabLength <> 0 Then
    ; tab
      SetKey   9 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif EditTab()       
    ; reversetab
      SetKey -15 If Search("EditUtil",AutoLib)=0 Then AutoLib="EditUtil" Endif EditBackTab() 
  Else
    SetKey   9
    SetKey -15
  EndIf
  
  Return ""
  
EndProc ; EditOpts
WriteLib "EditUtil" EditOpts

; EOF EditLib.Sc