; CopyRight 1989 by Direct Information Decisions, Inc.
;
; MkMenu.SC - Script to create the menu's.

;   DATE        BY     Description
; --------  --------   --------------------------------------------------
;  1/21/89  McIntosh   Initial
;

;=============================================================================
; Edit existing transactions a table as well as inserting and deleting.
; The code is generic so that it doesn't matter what table is being edited.
; Once the correct tables have been selected the routines should work for all.
;=============================================================================
;
;   12/15/88  Fixed ErrorCode() with Modify Record
;

Proc Edit_Table( xTable, FormNum )
    Private Ret, MultiForm

    If Version() >= 3 Then
        Execute "MultiForm = IsMultiForm( xTable, FormNum )"
    Else
        MultiForm = False
    EndIf

    If IsEmpty( xTable ) Then
        Beep
        @ 0,0 Clear EOL
        @ 0,0 ?? "There are NO Records for ", xTable, " Table. Forced into Insert."
        Sleep 1000
        CoEdit xTable
        Ins_Table( xTable, FormNum )
        Do_It!
        Return
    EndIf

    CoEdit xTable
    FirstShow          ; Show xTable as the first table

    Ret = True

    While True
        ImageRights ReadOnly ; user can't modify records
        Wait Table
            Prompt "F1 -Search,           F2 -Search Next,      F9 -Edit",
                   "Ins-Insert a Record,  Del-Delete a Record,  Esc-Return To Menu"
              Until  "F1", "F2", "F9", "Esc", "Ins", "Del", 15, -24, -37, -38

        Switch
            Case RetVal = "F1"  : Ret = Field_Search()
            Case RetVal = "F2"  : Next_Search( Ret )
            Case RetVal = "Esc" : QuitLoop
            Case RetVal = "Ins" : Ins_Table( xTable, FormNum )
                                  FormKey
                                  MoveTo [#] Right
            Case RetVal = "Del" : ImageRights    ; reset rights so records may be modified
                                  If are_you_sure( "Do you want to Delete this Record?" ) THEN
                                      Del        ; delete record
                                  EndIf
            Case RetVal = "F9"  : ImageRights    ; reset rights so records may be modified
                                  Modify_Table( xTable, FormNum )
                                  CtrlHome
        EndSwitch

    EndWhile

    Release Vars WhichField, x       ; Used by Field_Search/Next_Search

    Do_It!

EndProc

;;WriteLib ApName Edit_Table
;;Release Procs Edit_Table

Proc Ins_Table( xTable, FormNum )
    Private Prompt2, MultiRecord, SaveRetVal, SaveLockCode
   
    Prompt2 = "Ins- To Insert this record and Add another."
    If MultiForm Then
        Prompt2 = "F3 to move to MultiForm, " + Prompt2
    EndIf

    ImageRights ; reset rights so records may be modified
    Ins  ; Insert new record
    PickForm FormNum

    CtrlHome
    SaveLockCode = 0
    While True
        Wait Record
            Prompt "F1 - Lookup On * Fields, F2 -to Insert Record and Quit, Esc-Return To Menu",
                   Prompt2
                Until  "F2", "Esc", "Ins", "F3", "Down", "Up", "Del",
                        15, -24, -37, -38

        SaveRetVal = RetVal
        Switch
            Case SaveRetVal = "Del"   :
                 If MultiForm and MultiRecord Then
                     If Are_You_Sure( "Delete this record" ) Then
                         Del
                     EndIf
                 Else
                     Beep
                 EndIf
            Case SaveRetVal = "Up"   :
                 If MultiForm and MultiRecord Then
                     LockRecord     ;post the record and stay with it
                     If ErrorCode() = 53 Then
                         Update_The_Record()
                     EndIf
                 EndIf
                 KeyPress SaveRetVal
            Case SaveRetVal = "Down"   :
                 If MultiForm and MultiRecord Then
                     LockRecord     ;post the record and stay with it
                     If ErrorCode() = 53 Then
                         Update_The_Record()
                     EndIf
                 EndIf
                 KeyPress SaveRetVal
            Case SaveRetVal = "F3"   :
                 If MultiForm Then
                     If Not MultiRecord Then
                         Lockrecord
                         SaveLockCode = ErrorCode()
                         If SaveLockCode <> 55 Then     ;; Record Already locked
                             UnLockRecord
                         EndIf
                     Else
                         If SaveLockCode = 0 Then
                             UnLockRecord
                         EndIf
                     EndIf
                     KeyPress SaveRetVal
                     MultiRecord = Not MultiRecord
                 EndIf
            Case SaveRetVal = "Esc"  :      ; quit without Update
                 QuitLoop
            Case SaveRetVal = "F2"   :      ; save and quit
                 QuitLoop
            Case SaveRetVal = "Ins"  :      ; Insert this record and continue.
                 LockRecord     ;post the record and stay with it

                 If ErrorCode() = 53 Then
                     Update_The_Record()
                 EndIf

                 UnLockRecord
                 ImageRights
                 Ins
                 CtrlHome
        EndSwitch

    EndWhile

    If SaveRetVal = "Esc" Then
        Del
        Return
    EndIf

    If IsAssigned( EditProcExit ) Then
        ExecProc EditProcExit
    EndIf

    LockRecord     ;post the record and stay with it

    If ErrorCode() = 53 Then
        Update_The_Record()
    EndIf

    UnLockRecord

EndProc

;;WriteLib ApName Ins_Table
;;Release Procs Ins_Table

;=============================================================================
; MODIFY_Table
;
; This script is called by Edit_Table.
; This script hops around from table to table while maintaining
; which table it was last on.  Also, the routines are generic so
; that no matter which table the user is on, the search, modify,
; and other code still works.
;=============================================================================

Proc Modify_Table( xTable, FormNum )
    Private Prompt2, MultiRecord, SaveRetVal, SaveLockCode

    If MultiForm Then
        Prompt2 = "F3 to move to MultiForm."
    Else
        Prompt2 = ""
    EndIf

    MultiRecord = False
    SaveLockCode = 0

    While True

        If Not IsFormView() Then
            PickForm FormNum
            CtrlHome
        EndIf

        Wait Record
            Prompt "F1 -Lookup On * Fields,  F2 -Save and Return,    Esc-Exit without Saving",
                    Prompt2
                Until "F2", "Esc", "F3", "Down", "Up", "Del",
                      15, -24, -37, -38

        SaveRetVal = RetVal
        Switch
            Case SaveRetVal = "Del"   :
                 If MultiForm and MultiRecord Then
                     If Are_You_Sure( "Delete this record" ) Then
                         Del
                     EndIf
                 Else
                     Beep
                 EndIf
            Case SaveRetVal = "Up"   :
                 If MultiForm and MultiRecord Then
                     LockRecord     ;post the record and stay with it
                     If ErrorCode() = 53 Then
                         Update_The_Record()
                     EndIf
                     UnLockRecord
                 EndIf
                 KeyPress SaveRetVal
            Case SaveRetVal = "Down"   :
                 If MultiForm and MultiRecord Then
                     LockRecord     ;post the record and stay with it
                     If ErrorCode() = 53 Then
                         Update_The_Record()
                     EndIf
                     UnLockRecord
                 EndIf
                 KeyPress SaveRetVal
            Case SaveRetVal = "F3"   :
                 If MultiForm Then
                     If Not MultiRecord Then
                         Lockrecord
                         SaveLockCode = ErrorCode()
                         If SaveLockCode <> 55 Then     ;; Record Already locked
                             UnLockRecord
                         EndIf
                     EndIf
                     KeyPress SaveRetVal
                     If MultiRecord and SaveLockCode = 0 Then
                         UnLockRecord
                     EndIf
                     MultiRecord = Not MultiRecord
                 EndIf
            Case SaveRetVal = "Esc"  :     ; quit without Update
                 LockRecord            ; Determine if user updated record
                 If ErrorCode() = 0 Then
                     UnLockRecord
                     FormKey
                     If SaveLockCode = 0 Then
                         QuitLoop          ; User didn't so just quit
                     EndIf
                 EndIf

                 If Are_You_Sure( "Do you want to Quit WithOut Updating?" ) THEN
                     Menu {Undo} {Yes}
                     FormKey
                     QuitLoop
                 EndIf

            Case SaveRetVal = "F2"  :      ; save and quit
                 If IsAssigned( EditProcExit ) Then
                     ExecProc EditProcExit
                 EndIf
                 Do_It!
                 If ErrorCode() = 53 Then
                     Update_The_Record()
                     Do_It!
                 EndIf

                 FormKey
                 CoEdit xTable
                 QuitLoop

        EndSwitch
    EndWhile

EndProc

;;WriteLib ApName Modify_Table
;;Release Procs Modify_Table

Proc Update_The_Record()
    Private NewRecord, MoreText1, MoreText2

    Beep
    ImageRights ReadOnly
    NewRecord = True
    While True
        If NewRecord Then
            MoreText1 = "New"
            MoreText2 = "Existing"
        Else
            MoreText1 = "Existing"
            MoreText2 = "New"
        EndIf

        CtrlHome
        Wait Field
            Prompt "Duplicate Record for this Key - This is the " + MoreText1 + " Record",
                   "F1 -to see " + MoreText2 + " Record, F2 -to Accept this Record, Esc-Return To Menu"
               Until  "F1", "F2", "Esc", 15, -24, -37, -38

         Switch
            Case RetVal = "F1"  : KeyLookUp
                                  NewRecord = Not NewRecord
            Case RetVal = "F2"  : LockKey
                                  QuitLoop
            Case RetVal = "Esc" : Menu {UnDo} {Yes}
                                  ImageRights
;;                                  Del
                                  QuitLoop
            OtherWise           : Beep
        EndSwitch

    EndWhile

EndProc

;;WriteLib ApName Update_The_Record
;;Release Procs Update_The_Record
