;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure IntroScr, DisplayMenu, ViewRecs, EditRecs
;Source File     : EASYWAIT.SC
;Author          : Jim Schwarz
;
;Informant Issue : Februery 1992
;
;Description     : In introduction to the WAIT command and its simple use.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;-----------------------------------------------------------------------------

;Script "PersInit"

  ; PersInit defines PersProg as the procedure library for
  : the application, calls the procedure to display the
  ; introductory screen and then calls the menu procedure.

  Autolib = "PersProg"

  IntroScr( )

  DisplayMenu( )              ; manage program activity until exit.


;Script to create procedure library used by PersInit

CREATELIB "PersProg"

PROC IntroScr( )

   CANVAS OFF
   CURSOR OFF
   CLEARALL                              ; create a clean screen by
   CLEAR                                 ; clearing everything off

   @10,29 ?? "     HELLO WORLD"          ; display opening message and
   @12,29 ?? "WELCOME TO MY PROGRAM"     ; pause for a few seconds
   CANVAS ON
   SLEEP 2000

   CLEAR                                 ; clear opening message from the
                                         ; screen; cursor will automatically
                                         ; reset to NORMAL with SHOWMENU
ENDPROC

PROC DisplayMenu( )

   PRIVATE Choice

   WHILE True
      SHOWMENU                               ; create and display menu
         "View" : "View personnel records",
         "Edit" : "Edit personnel records",
         "Quit" : "Exit program"
         DEFAULT "View"
      TO Choice

      SWITCH                                 ; perform activity associated with
         CASE Choice = "View": ViewRecs( )   ; specified menu choice
         CASE Choice = "Edit": EditRecs( )
         CASE Choice = "Quit": QUITLOOP
      ENDSWITCH

      CLEARALL           ; clear workspace and canvas before
      CLEAR              ; looping for next menu choice

   ENDWHILE

ENDPROC

PROC ViewRecs( )

   IF NRECORDS("Pers") = 0
     THEN BEEP
          MESSAGE "No records present; " +
                  "use Edit option to add ..."
          CURSOR OFF
          SLEEP 2000
          RETURN
   ENDIF

   VIEW "Pers"       ; place required table on workspace and
   PICKFORM 1        ; switch to form view

   PROMPT " [Esc] Quit    [Ctrl][Z] Locate",
          " View existing records"
   WAIT TABLE
   UNTIL "Esc"

ENDPROC

PROC EditRecs( )

   VIEW "Pers"       ; place required table on workspace, change
   COEDITKEY         ; to edit mode and switch to form view
   PICKFORM 1

   PROMPT " [F2] Save/Quit    [Ins] Add  " +
          "  [Del] Delete   [Ctrl][Z] Locate",
          " Edit or delete existing records;" +
          " add new records"
   WAIT TABLE
   UNTIL "F2"

   DO_IT!            ; save changes and leave edit mode

ENDPROC

WRITELIB "PersProg" IntroScr, DisplayMenu, ViewRecs, EditRecs
