;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure inPathDouble.a(),
;                            dsQueryToPalDialogDB.l(),
;                            dsQueryToPalDialog.u(),
;                            AllChecks.l(),
;                            GetProcName.v(),
;                            dsQueryToPal.l()
;
;Source File     : DSQ2PAL.SC
;
;Author          : Micah Bleecher
;                  DataStar International
;                  Larchmont Commons
;                  Suite 129
;                  3111 Route 38, #11
;                  Mount Laurel, NJ  08054
;                  (800) 742-3614
;
;Informant Issue : December 1992
;
;Description     : A Paradox 4.0 query image-to-PAL code generator
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

; ***************************************************************************
; SCRIPT NAME: dsQ2PAL.sc (c) 1992 Micah Bleecher - DataStar International
; APPDEV TEAM: Micah Bleecher, Dan Paolini
;
; DESCRIPTION: Contains the following Information procedures:
;
;              inPathDouble.a          ;Doubles backslashes for printing
;              dsQueryToPalDialogDB.l  ;Dialog event proc
;              dsQueryToPalDialog.u    ;Primary interface dialog
;              AllChecks.l             ;Determines if every field is checked
;              GetProcName.v           ;Gets procedure name from user
;              dsQueryToPal.l          ;Primary conversion procedure
;
;              PadQuotes.a             ;Pads quoted strings with backslashes
;
; Permission is grantet to use all or a part of these procedures free of
; charge, provided the copyright notices remain intact.
;
; dsQuery2PAL Instructions
;
; Interactivly place desired query images on the Paradox 4.0 workspace and
; play the dsq2pal.sc script.  The result will be a conversion of the
; workspace query images to PAL code. You may find that it works best
; to attach it to a SETKEY command in your init.sc script:
;
;     IE:      SETKEY -16 PLAY "C:\\PDOX40\\DSQ2PAL"  ; AltQ
;
; The default output file name is INSTANT.SC but you may change that as
; needed.
;
; NOTE: PadQuotes.a() did not make it into the PI article. The procedure
;       determines if a query image field contains quoted "" strings and
;       inserts the appropriate backslash characters.
; ============================================================================

; ===========================================================================
;       TITLE: inPathDouble.a
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No Value
; DESCRIPTION: Doubles backslashes in a Path String
; ---------------------------------------------------------------------------

PROC inPathDouble.a(             ; Doubles backslashes in a string
         path.a)                 ; Path to double
Private  a1, a2, a3             ; Transient string variables
   a1 = path.a
   a2 = ""
   WHILE Match(a1,"..\\..",a3,a1)
      a2 = a2 + a3 +"\\\\"
   ENDWHILE
   IF a1 <> path.a THEN
      Return a2 + a1
   ELSE
      Return path.a
   ENDIF
ENDPROC

; ===========================================================================
;       TITLE: PadQuotes.a
;      AUTHOR: (c) 1992 - Micah J. Bleecher - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: Alphanumeric
; DESCRIPTION: Adds escape characters (backslashes) to quoted strings
; ---------------------------------------------------------------------------
PROC PadQuotes.a(string.a)
Private len.n, ;origional length of string
        n      ;numeric counter var
   IF Search("\"",string.a) > 0 THEN
    len.n = Len(string.a)
    FOR n FROM len.n TO 1 STEP -1         ;step backwords to account for 
      IF SubStr(string.a,n,1) = "\"" THEN ;increasing length of string
         string.a = SubStr(string.a,1,n-1) +"\\"+SubStr(string.a,n,LEN(string.a))
      ENDIF
    ENDFOR
   ENDIF
   RETURN string.a
ENDPROC

; ===========================================================================
;       TITLE: dsQueryToPALDialogDB.l()
;      AUTHOR: (c) 1992 Micah J. Bleecher - DataStar International
;     CREATED: 10-12-92 : 01:33:52am
;     RETURNS: Logical
; DESCRIPTION: Dialog event proc. Controls GUI animation as the user tabs
;              through the dialog box.
; ---------------------------------------------------------------------------
PROC dsQueryToPalDialogDB.l(
         type.a,                 ; EVENT or TRIGGER
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null


;GLOBAL  top1.n,                 ;top frame color group 1
;        bot1.n,                 ;bottom frame color group 1
;        top2.n,                 ;top frame color group 2
;        bot2.n,                 ;bottom frame color group 2
;        bot3.n,                 ;bottom frame color group 3
;        top3.n,                 ;top frame color group 3


    SWITCH
      CASE type.a = "ARRIVE" :
         SWITCH
            CASE Search(".1",tag.a) > 0 :

               top1.n = 112
               bot1.n = 127
               top2.n = 127
               bot2.n = 112
               top3.n = 127
               bot3.n = 112

            CASE Search(".2",tag.a) > 0 :

               top1.n = 127
               bot1.n = 112
               top2.n = 112
               bot2.n = 127
               top3.n = 127
               bot3.n = 112

            CASE Search(".3",tag.a) > 0 :

               top1.n = 127
               bot1.n = 112
               top2.n = 127
               bot2.n = 112
               top3.n = 112
               bot3.n = 127

         ENDSWITCH

    ENDSWITCH

   RepaintDialog
   Return TRUE


ENDPROC

; ===========================================================================
;       TITLE: dsQueryToPALDialog.u()
;      AUTHOR: (c) 1992 Micah J. Bleecher - DataStar International
;     CREATED: 10-12-92 : 02:34:44am
;     RETURNS: Nothing
; DESCRIPTION: Dialog box user interface to present utility options
;              and control execution.
; ---------------------------------------------------------------------------
PROC dsQueryToPalDialog.u()

Private  top1.n,    ;top frame color group 1
         bot1.n,    ;bottom frame color group 1
         top2.n,    ;top frame color group 2
         bot2.n,    ;bottom frame color group 2
         bot3.n,    ;bottom frame color group 3
         top3.n,    ;top frame color group 3
         butvar.l,  ;button variable
         just.n,    ;output justification type
         outfile.a, ;output file name
         proc.n     ;proceduralize flag


     top1.n = 112
     bot1.n = 127
     top2.n = 127
     bot2.n = 112
     top3.n = 127
     bot3.n = 112
   butvar.l = FALSE
  outfile.a = "INSTANT"
     just.n = 1
     proc.n = 1


  WHILE (True)

  IF NImages() = 0 THEN
    BEEP
    Message "There Are No Images Present"
  ENDIF

  ShowDialog ""

     PROC "dsQueryToPalDialogDB.l"

       TRIGGER "ARRIVE"

     @4,14 Height 15 Width 53

     ; PaintPAL_Frame_Begin
     Frame Single From 2,1 To 4,49
     PaintCanvas Attribute top1.n 2,1,2,49
     PaintCanvas Attribute top1.n 2,1,4,1
     PaintCanvas Attribute bot1.n 4,2,4,49
     PaintCanvas Attribute bot1.n 2,49,4,49
     ; PaintPAL_Frame_End

     ; PaintPAL_Frame_Begin
     Frame Single From 5,1 To 8,49
     PaintCanvas Attribute top2.n 5,1,5,49
     PaintCanvas Attribute top2.n 5,1,8,1
     PaintCanvas Attribute bot2.n 8,2,8,49
     PaintCanvas Attribute bot2.n 5,49,8,49
     ; PaintPAL_Frame_End


     ; PaintPAL_Frame_Begin
     Frame Single From 9,1 To 12,49
     PaintCanvas Attribute top3.n 9,1,9,49
     PaintCanvas Attribute top3.n 9,1,12,1
     PaintCanvas Attribute bot3.n 12,2,12,49
     PaintCanvas Attribute bot3.n 9,49,12,49
     ; PaintPAL_Frame_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 112 3,3,3,19
     @3,3
     ?? "Output File Name:"
     PaintCanvas Attribute 112 3,3,3,19
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 112 6,3,6,17
     @6,3
     ?? "Justification:"
     PaintCanvas Attribute 112 6,3,6,17
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 112 7,3,7,16
     @7,3
     ?? "Proceduralize:"
     PaintCanvas Attribute 112 7,3,7,16
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 94 0,8,0,41
     @0,8
     ?? "  DataStar Query-To-PAL Converter"
     PaintCanvas Attribute 94 0,8,0,41
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 112 1,9,1,43
     @1,9
     ?? ""
     PaintCanvas Attribute 112 1,9,1,43
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 112 0,42,0,43
     @0,42
     ?? ""
     PaintCanvas Attribute 112 0,42,0,43
     ; PaintPAL_Static_Text_End

     Accept @3,20 Width 28
        "A8"
        Picture "*!"
        Tag "FILE.1"
        To outfile.a

     RadioButtons @6,17 Height 1 Width 32
        "Flush",
        "Right",
        "Left"
        Tag "JUST.2"
        To just.n

     RadioButtons @7,17 Height 1 Width 18
        "No",
        "Yes"
        Tag "PRO.2"
        To proc.n

     PushButton @10,8 Width 15
        "~D~o_It!"
        Default
        Value dsQueryToPal.l(outfile.a)  ;query conversion procedure
        Tag "OK.3"
        To butvar.l

     PushButton @10,28 Width 15
        "~C~ancel"
        Cancel
        Value False
        Tag "CANCEL.3"
        To butvar.l

  EndDialog
  QUITLOOP

  ENDWHILE

  RETURN
ENDPROC


; ===========================================================================
;       TITLE: AllChecks.l()
;      AUTHOR: (c) 1992 Micah J. Bleecher - DataStar International
;     CREATED: 10-10-92 : 11:36:24pm
;     RETURNS: Logical, True if all fields have a positive check mark status
; DESCRIPTION: Checks all query fields to determine if all have a positive
;              check mark (check, checkplus or groupby)
; ---------------------------------------------------------------------------
PROC AllChecks.l()

Private  firstcheck.a,       ;status of the first field
         retval.l,           ;return variable
         n                   ;numeric throw away

;GLOBAL  fieldorder.r        ;sequential order of fields
;        checkstatus.y       ;check mark status of the field
;        col.n               ;number of columns in the image

      firstcheck.a = checkstatus.y[fieldorder.r[2]]
      IF NOT IsBlank(firstcheck.a) THEN
         retval.l = TRUE

         FOR n FROM 2 To col.n

            IF firstcheck.a <> checkstatus.y[fieldorder.r[n]] THEN
               retval.l = FALSE
               QUITLOOP
            ENDIF

         ENDFOR
      ELSE
         retval.l = FALSE
      ENDIF

      RETURN retval.l

ENDPROC
; ======================================================================
;       TITLE: GetProcName.v()
;      AUTHOR: Micah J. Bleecher - DataStar International
;     CREATED: 10-12-92 - 09:58:04am
;     RETURNS: String of imput procedure name
; DESCRIPTION: Dialog box requesting user input for proc name
;
; ----------------------------------------------------------------------

PROC GetProcName.v()

Private  procname.v,  ;holds procedure name
         butvar.l,    ;button variable
         retval.v     ;return variable


  procname.v = ""
  butvar.l = FALSE

  ShowDialog "Enter Procedure Name"
     @3,15 Height 7 Width 49

     ; PaintPAL_Frame_Begin
     Frame Single From 0,1 To 2,45
     PaintCanvas Attribute 112 0,1,0,45
     PaintCanvas Attribute 112 0,1,2,1
     PaintCanvas Attribute 127 2,2,2,45
     PaintCanvas Attribute 127 0,45,2,45
     ; PaintPAL_Frame_End

     Accept @1,2 Width 43
        "A40"
        Tag "PROC"
        To procname.v

     PushButton @3,4 Width 14
        "~O~k"
        Ok
        Default
        Value True
        Tag "OK"
        To butvar.l

     PushButton @3,28 Width 14
        "~C~ancel"
        Cancel
        Value FALSE
        Tag "CANCEL"
        To butvar.l
  EndDialog

  IF NOT butvar.l THEN
   retval.v = butvar.l
  ELSE
   retval.v = procname.v
  ENDIF

  RETURN retval.v

ENDPROC

; ===========================================================================
;       TITLE: dsQueryToPal.u()
;      AUTHOR: (c) 1992 Micah J. Bleecher - DataStar International
;     CREATED: 10-10-92 : 10:35:36pm
;     RETURNS: Nothing
; DESCRIPTION: Converts interactive query images to PAL code
; ---------------------------------------------------------------------------
PROC dsQueryToPal.l(outfile.a)  ;name of output file

Private
         col.n,          ;number of columns in query image
         starttable.a,   ;query image 1
         blankrow.l,     ;flag, true if entire row is blank
         row.n,          ;image row numbers
         fieldvalues.y,  ;contents of fields
         checkstatus.y,  ;check mark status of fields
         fieldorder.r,   ;sequential order of fields
         allchecks.l,    ;true if checkmark status is same in all fields
         maxlen.n,       ;maximum length of field for output format
         retval.l,       ;return variable
         procname.v,     ;output procedure name
         queryimage.l,   ;query image present flag
         n,n1,n2         ;numeric throw aways

WHILE (True)

   IF NImages() = 0 THEN     ;check for no images
      Beep
      Message "There Are No Images Present"
      retval.l = FALSE
      QUITLOOP
   ENDIF

   IF Search(".",outfile.a) > 0 THEN   ;check for file extensions
      retval.l = FALSE
      Beep
      Message "Filename Cannot Have An Extension"
      SelectControl "FILE.1"
      QUITLOOP
   ENDIF

   MoveTo 1          ; First Image

   starttable.a = ""
   queryimage.l = FALSE
   WHILE Table() <> starttable.a    ;make sure there is at least 1
     starttable.a = Table()         ;query image
     IF ImageType() = "Query" THEN
       queryimage.l = TRUE
       QUITLOOP
     ENDIF
     DownImage
   ENDWHILE
   IF NOT queryimage.l THEN
      BEEP
      retval.l = FALSE
      Message "There Are No Query Images Present"
      QUITLOOP
   ENDIF

   outfile.a = outfile.a + ".SC"

   If IsFile(outfile.a) THEN    ;check for file name

      Beep

      ShowPopup Upper(outfile.a)+" Already Exists" CENTERED

           "~A~ppend" : "Append Current File Name"     : "APPEND",
        "~O~verwrite" : "Overwrite Current File Name"  :   "OVER",
        "~R~ename"    : "Rename Current File Name"     : "RENAME"
      EndMenu
      TO menuchoice.a

      IF NOT retval then
         retval.l = FALSE
         QUITLOOP
      ENDIF

      SWITCH

         CASE menuchoice.a =   "OVER" :  ;overwrite

           {Tools} {Delete} {Script}
            SELECT SubStr(outfile.a,1,Search(".",outfile.a)-1)
            IF MenuChoice() = "Cancel" THEN
             {Ok}
            ENDIF

         CASE menuchoice.a =  "RENAME":  ;rename

           SelectControl "FILE.1"
           retval.l = False
           QUITLOOP

      ENDSWITCH

   EndIF

   IF proc.n = 2 THEN    ;proceduralize output

     procname.v = GetProcName.v()
     IF procname.v = FALSE THEN
      retval.l = FALSE
      QUITLOOP
     ENDIF
     PRINT FILE outfile.a "PROC "+procname.v+"\n"
     PRINT FILE outfile.a "\n"
     PRINT FILE outfile.a ";Private\n"
     PRINT FILE outfile.a "\n"
     PRINT FILE outfile.a "\n"

   ENDIF

   PRINT FILE outfile.a "\n"
   PRINT FILE outfile.a ";  dsQueryToPAL: Begin Query \n"
   PRINT FILE outfile.a ";     Generated: "+
     Format("d2",Today())+" - "+Time()+"\n"
   PRINT FILE outfile.a ";   Description:\n"
   PRINT FILE outfile.a ";\n"


   MoveTo 1          ; First Image

   FOR n2 FROM 1 TO Nimages()

    IF ImageType() = "Query" THEN  ;process query images only

      starttable.a = Table()
      col.n = Nfields(Table())+1
      HOME
      CTRLHOME
      PRINT FILE outfile.a "\n"
      PRINT FILE outfile.a " {Ask} SELECT \""+inPathDouble.a(Table())+"\"\n"
      blankrow.l = TRUE
      row.n = 1
      WHILE (True)
         CTRLHOME

         DynArray fieldvalues.y[]
         DynArray checkstatus.y[]
            Array  fieldorder.r[col.n]
         maxlen.n = 0
         FOR n FROM 1 To col.n
            Message "Reading - Row: "+StrVal(row.n)+", Column: "+Strval(n)
            fieldvalues.y[Field()] = []
            checkstatus.y[Field()] = CheckMarkStatus()
             fieldorder.r[n] = Field()
            IF NOT IsBlank([] + CheckMarkStatus()) THEN
               maxlen.n = Max(Len(Field()),maxlen.n)
               blankrow.l = FALSE
            ENDIF
            RIGHT
         ENDFOR
            IF blankrow.l THEN
               QUITLOOP
            ELSE
            IF row.n > 1 THEN
               PRINT FILE outfile.a "  DOWN\n"
            ENDIF
            ENDIF

            allchecks.l = AllChecks.l()

            IF allchecks.l THEN
              PRINT FILE outfile.a "  CTRLHOME " +
              Upper(checkstatus.y[fieldorder.r[2]]) +"\n"
            ENDIF

            IF NOT IsBlank(fieldvalues.y[fieldorder.r[1]]) THEN
               PRINT FILE outfile.a "  \""+
               PadQuotes.a(Upper(fieldvalues.y[fieldorder.r[1]]))+"\"\n"
            ENDIF

            FOR n1 FROM 2 To col.n
               Message "Writing Row: "+StrVal(row.n)+", Column: "+Strval(n)
               IF NOT allchecks.l AND NOT
                  IsBlank(checkstatus.y[fieldorder.r[n1]]) THEN
               SWITCH
                  CASE just.n = 1 :  ;full justification

                     PRINT FILE outfile.a "  MoveTo"+
                     Spaces((maxlen.n)-(len(fieldorder.r[n1]))+1)+
                     "["+fieldorder.r[n1]+"]   "+
                     Upper(checkstatus.y[fieldorder.r[n1]])+"\n"

                  CASE just.n = 2 :  ;Right justification

                     PRINT FILE outfile.a
                     Spaces((maxlen.n)-(len(fieldorder.r[n1]))+3)+
                     "MoveTo ["+fieldorder.r[n1]+"]   "+
                     Upper(checkstatus.y[fieldorder.r[n1]])+"\n"

                  CASE just.n = 3 :   ;left justification

                     PRINT FILE outfile.a "MoveTo ["+fieldorder.r[n1]+"]   "+
                     Upper(checkstatus.y[fieldorder.r[n1]])+"\n"

               ENDSWITCH
               ENDIF

               IF NOT IsBlank(fieldvalues.y[fieldorder.r[n1]]) THEN
                  SWITCH

                     CASE just.n = 1 :  ;full justification

                        PRINT FILE outfile.a
                        Spaces((maxlen.n+7)-(len(fieldorder.r[n1]))+2)+
                        "["+fieldorder.r[n1]+"] = \""+
                        PadQuotes.a(fieldvalues.y[fieldorder.r[n1]])+"\"\n"

                     CASE just.n = 2 :  ;right justification

                        PRINT FILE outfile.a
                        Spaces((maxlen.n+7)-(len(fieldorder.r[n1]))+3)+
                        "["+fieldorder.r[n1]+
                        "] = \""+PadQuotes.a(fieldvalues.y[fieldorder.r[n1]])+"\"\n"

                     CASE just.n = 3 :  ;left justification

                        PRINT FILE outfile.a "["+fieldorder.r[n1]+"] = \""+
                        PadQuotes.a(fieldvalues.y[fieldorder.r[n1]])+"\"\n"

                  ENDSWITCH
               ENDIF
            ENDFOR
            ;DOWN
            row.n = row.n + 1
            blankrow.l = TRUE
      ENDWHILE
      HOME
      CTRLHOME
      ENDIF
      DOWNIMAGE
   ENDFOR
   CTRLHOME
   PRINT FILE outfile.a "\n"
   PRINT FILE outfile.a "; Do_It! \n"
   PRINT FILE outfile.a "; quExecute.l(True)\n"
   PRINT FILE outfile.a "; IF NOT retval THEN\n"
   PRINT FILE outfile.a ";    DEBUG\n"
   PRINT FILE outfile.a "; ENDIF\n"
   PRINT FILE outfile.a ";\n"
   PRINT FILE outfile.a ";== End Query ==\n"

   IF proc.n = 2 THEN  ;proceduralize output

     PRINT FILE outfile.a "\n"
     PRINT FILE outfile.a "ENDPROC\n"
     PRINT FILE outfile.a ";??\"\\004\"\n"
     IF Search("(",procname.v) = 0 THEN
       PRINT FILE outfile.a ";WRITELIB libname.a "+procname.v+"\n"
     ELSE
       PRINT FILE outfile.a ";WRITELIB libname.a "+
       SubStr(procname.v,1,(Search("(",procname.v)-1))+"\n"
     ENDIF

   ENDIF

   SelectControl "CANCEL.3"
   Message "Conversion Complete"

retval.l = true
QUITLOOP
ENDWHILE
Return retval.l
ENDPROC

dsQueryToPalDialog.u()
