;//////////////////////////////////////////////////////////////////////////// 
; Given Freely To The Public Domain In Appreciation For The Great Assistance
; And Pleasure I Have Derived As A Member Of The Borland PDOXDOS Forums.
; This code is provided 'as is' with no guarantees of workability or suitability 
; to purpose.                           
; 
; CREDITS TO .. Joseph LaCour whose code makes up a good portion of this program.
; His original work from which this program was derived was written for the
; Clipper Nanforum Library. 
;////////////////////////////////////////////////////////////////////////////

TITLE 'DrvStats'                   ; Andy Robinson November 1993
                                   ; Creates A Paradox .SC File Which Will Have
                                   ; The Name DrvState.SC.  When Played It
                                   ; Will Initialise A DynArray Having A Name  
                                   ; Of DriveStatus Which In Turn Will Have The 
                                   ; Following Elements.

;["STATUS"] = "Ready" Or 
;             "Invalid" Or 
;             "DoorOpen" Or 
;             "Unformatted" Or 
;             "Protected" Or
;             "Error"                                      

; Will also return the following errorlevels to DOS
;Ready         0
;Invalid       1
;DoorOpen      2
;Unformatted   3
;Protected     4
;Undetermined  5

CR           EQU 13
LF           EQU 10
Ready        EQU 00H
Invalid      EQU 01H
DoorOpen     EQU 02H
Unformatted  EQU 03H
Protected    EQU 04H
Undetermined EQU 05H

CODE SEGMENT

	ASSUME CS:CODE, DS:CODE
	ORG 5CH                          ; Dos Stores Coomand Line Param Here 
	Param LABEL BYTE

	ORG 100H                         ; Com File 

START:
  
  CMP [Param],00H                  ; No Drive Letter Supplied I Think ?
  JE Go_Ahead                      ; Skip Validity Assume A:

  MOV AH,44H                       ; Dos Function IOCTL (Is Drive Removable)
  MOV AL,08H
  MOV BL,[Param]                   ; Retrieve Drive Number  
  DEC BL                           ; A == 0, B == 1
  INT 21H                          ; Call INT
  CMP AX,0FH                       ; AL == 0FH For Invalid Drive
  JE  Done                         ; Get Out 

Go_Ahead:
  MOV Drive,BL                     ; Store Drive To Data Area

  MOV AH,00H                       ; BIOS Call Reset Drive Controller
  MOV DL,Drive                     ; Drive Number  
  INT 13H                          ; CALL INT

  CALL    _FTFLOPT                 ; TEST DISKETTE TYPE
DONE:

  MOV AH,3CH                       ; Create A New File Or Truncate Existing To 0
  MOV CX,00H                       ; Normal RW
  MOV DX,OFFSET FileName           
  INT 21H                          ; Return Handle IN AX
  
  MOV BX,AX                        ; Move Handle To BX   
  MOV AH,40H                       ; Dos Function Write To File
  MOV DX,OFFSET Line1              ; Array Declaration
  MOV CX,46                        ; Number Of Characters To Write
  INT 21H                          ; Write To File

  MOV AH,40H                       ; Dos Function Write To File
  CMP DriveStatus,Ready
  JNE IsInvalid  
  MOV DX,OFFSET Mess1 
  MOV CX,9
  JMP Write_Out 

IsInValid:
  CMP DriveStatus,InValid
  JNE IsDoorOpen  
  MOV DX,OFFSET Mess2 
  MOV CX,11
  JMP Write_Out

IsDoorOpen:
  CMP DriveStatus,DoorOpen
  JNE IsUnFormatted
  MOV DX,OFFSET Mess3 
  MOV CX,12
  JMP Write_Out

IsUnformatted:
  CMP DriveStatus,Unformatted
  JNE IsProtected
  MOV DX,OFFSET Mess4 
  MOV CX,15
  JMP Write_Out

IsProtected:
  CMP DriveStatus,Protected
  JNE NotDetermined
  MOV DX,OFFSET Mess5 
  MOV CX,13
  JMP Write_Out

NotDetermined:
  MOV DX,OFFSET Mess6 
  MOV CX,9

Write_Out:
  INT 21H                          ; Write To File

  MOV AH,3EH
  INT 21H                          ; Close File 

  MOV AH,4CH                       ; Return ErrorLevel
  MOV AL,DriveStatus
  INT 21H                          ; Back To DOS

;////////////////////////////////////////////////////////////////////////////
; Local subroutine - check boot sector                      

_ftflopt        proc    near

                push    di                           ; preserve
ftflopred:
                xor     dx,dx                        ; clear DX
                mov     dl,Drive                     ; drive number in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer addr in ES:BX
                mov     ax,0201h                     ; read one sector
                call    _ftint13                     ; call BIOS
                jnc     Flop1                        ; Read ok. Continue
                cmp     ah,80h                       ; drive not ready ?
                je      Flop_out                     ; Yes.
                cmp     ah,02h                       ; unformatted?
                je      Flop_for                     ; Yes
                mov     DriveStatus,Undetermined     ; otherwise, unknown
                jmp     short Flop_End               ; and exit
Flop1:
                xor     dx,dx                        ; clear DX
                mov     dl,Drive                     ; drive number in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer addr in ES:BX
                mov     ax,0301h                     ; write one sector
                call    _ftint13                     ; call BIOS
                jnc     Flop_OK                      ; Write ok. Disk s/b AOK
                cmp     ah,03h                       ; Write protected?
                jne     Flop_OK                      ; No disk AOK
                mov     DriveStatus,Protected
                jmp     short Flop_End
Flop_out:
                mov     DriveStatus,DoorOpen
                jmp     short Flop_End
Flop_for:
                mov     DriveStatus,Unformatted
                jmp     short Flop_End
Flop_OK:
                xor     ax,ax                        ; AX = 0
                MOV DriveStatus,Ready 
Flop_End:
                pop     di                           ; restore
                ret                                  ; near return

_ftflopt        endp
;//////////////////////////////////////////////////////////////////
;-----------------------------------------------------------;
; LOCAL SUBROUTINE - CALL BIOS INT 13 FOR READ SECTOR       ;
;-----------------------------------------------------------;

_FTINT13        PROC    NEAR
                PUSH    BX                           ; SAVE REGS
                PUSH    ES                           ;
                PUSH    AX                           ;
                INT     13H                          ; CALL BIOS (read sector)
                jnc     ftIntRet                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     ftIntRet                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
ftIntRet:       pop     bx                           ; restore regs
                pop     es                           ;
                pop     bx                           ;
                ret                                  ; near return

_ftint13        endp

;////////////////////////////////////////////////////////////////////////////
  DriveStatus DB 01H
  Drive       DB 00H
  FileName    DB 'DRVSTATE.SC' , 00H
  Line1       DB 'Dynarray DRIVESTATE[]',CR ,LF , 'DRIVESTATE["STATUS"] = '
  Mess1       DB '"Ready"' , CR ,LF
  Mess2       DB '"Invalid"' , CR ,LF
  Mess3       DB '"Dooropen"' , CR ,LF
  Mess4       DB '"Unformatted"' , CR ,LF
  Mess5       DB '"Protected"' , CR ,LF
  Mess6       DB '"Error"' , CR ,LF       

;///////////////////////////////////////////////////////////////////////////
  CODE ENDS

END START
;/////////////////////////////////////////////////////////////////////////////
