;Application Tool..: MenuBuilder 2.0  (C)1994
;
;Script Demo.......: EX5.SC
;
;Developer.........: DataNamics 
;                    Dave Gordon
;                    8505 Horizion Dr.
;                    Lincoln, NE.  68505
;
;Phone and Fax.....: (402) 484-8102

;-[Example Notes]-------------------------------------------------------------
;This example will look more like what you would use in your application.
;This Demo Includes MENU.IDLE() and HOT KEY Functions.
;

;-[Prep]---------------------------------------------------------------------
release procs all
release vars all
autolib="DNIMENU"         ;--Required by your application so that paradox can 
                          ;  find the requested procedure.

Proc BOX3D(SX,Y,Length,Width,COLOR,SHADOW.L,PUSH.L,DEPTH)
  Private SX,Y,Length,Width,COLOR,SHADOW.L,PUSH.L,X,BB,DEPTH,A,B,C,D,E,F,G,H,I,J
  
  If Y<0 Then Y=Int((79-Width-4)/2)
  EndIf
  If SX<0 Then SX=Int((24-Length-3)/2)
  EndIf
  
  If DEPTH<=1 Then
    A="" B="" C="" D="" E="" F=""  G=""  H=""  I=""  J=""
  Else
    A="" B="" C="" D="" E="" F=""  G=""  H=""  I=""  J=""
  EndIf
  
  If SHADOW.L Then
    PaintCanvas Attribute 8 SX+1,Y+1,SX+Length+2,Y+Width+4
  EndIf
  
  Style Attribute COLOR
  
  If PUSH.L=True Then
    @SX+0,Y ??" "+A+Fill(B,Width)+G+" "
    BB=" "+D+Spaces(Width)+" "
    For X From 1 To Length+1  @SX+X,Y ??bb
    EndFor
    @SX+Length+1,Y ??" "+H+Fill("",Width)+" "
    PaintCanvas Attribute ((Int(COLOR/16))*16)      SX,Y+1,SX,Y+Width+1
    PaintCanvas Attribute ((Int(COLOR/16))*16)      SX,Y+1,SX+Length+1,Y+1
    PaintCanvas Attribute ((Int(COLOR/16))*16)+15   SX+Length+1,Y+2,SX+Length+1,Y+Width+2
    PaintCanvas Attribute ((Int(COLOR/16))*16)+15   SX,Y+Width+2,SX+Length+1,Y+Width+2
  Else
    @SX+0,Y ??" "+Fill("",Width)+I+" "
    BB=" "+Spaces(Width)+D+" "
    For X From 1 To Length+1  @SX+X,Y ??bb
    EndFor
    @SX+Length+1,Y ??" "+J+Fill(B,Width)+F+" "
    PaintCanvas Attribute ((Int(COLOR/16))*16)     SX+Length+1,Y+2,SX+Length+1,Y+Width+2
    PaintCanvas Attribute ((Int(COLOR/16))*16)     SX,Y+Width+2,SX+Length+1,Y+Width+2
    PaintCanvas Attribute ((Int(COLOR/16))*16)+15  SX,Y+1,SX,Y+Width+1
    PaintCanvas Attribute ((Int(COLOR/16))*16)+15  SX,Y+1,SX+Length+1,Y+1
  EndIf
EndProc


Proc MENU.IDLE()
  Private L1,L2,Line,Y,X,L1,L2
  Canvas Off

  ;--Set the Backdrop
  LINE=""
  For Y From 1 To 39
    LINE=LINE+" "+Chr(250)
  EndFor
  LINE=LINE+"  "
  For X From 1 To 23
    @X,0 ??Line
  EndFor
  @0,0 ??SPACES(80)
  @24,0 ??SPACES(80)
  PaintCanvas Attribute 19 0,0,24,79

  ;--Build the Box.  
  BOX3D(4,7,13,61,112,True,False,1)
  Style Attribute 116
  L1="MenuBuilder 2.0"
  L2="(c)1994 DataNamics"
  @5,9 ??SPACES(Int((60-Len(L1))/2))+L1
  @6,9 ??SPACES(Int((60-Len(L2))/2))+L2
  BOX3D(8,10,1,19,112,False,True,1)
  Style Attribute 126
  @9,13 ??STRVAL(Today())+IIf(Month(Today())<10,"  "," ")+StrVal(Time())
  BOX3D(8,32,1,34,112,False,True,1)
  Style Attribute 126
  @9,35 ??"USER ID: "
  If Not IsBlank(UserName()) Then
    @9,44 ??UserName()
  Else
    @9,44 ??"Unknown User"
  EndIf
  BOX3D(11,10,5,56,112,False,True,1)
  Style Attribute 113
  @12,12 ??"                                                  "
  @13,12 ??"                X-Y-Z Accounting Package          "
  @14,12 ??"                 The Complete Solution            "
  @15,12 ??"                                                  "
  @16,12 ??"                 (C)1994 Software Inc.            "
  Canvas On
EndProc


;-[Start Program]------------------------------------------------------------
CURSOR OFF
MENU.INIT("EX5")                            ;--Initialize MenuBuilder, use 
					    ;  the EX5 menu table.
DNIMENU["HOT KEYS"]="-104,-105,-106,-45"    ;--Set Menu Hot Keys.

WHILE TRUE
  UserReq=MENU.EXEC("")         ;--Execute the Menu.
  Switch 
    Case UserReq="EXIT" or UserReq="-45":    ;ALT-X or EXIT 
      Quit "End of MenuBuilder Demo."

    Case UserReq="AcctGL" or UserReq="-104": ;ALT-F1 or GL
      Message "Start the General Ledger Module"
      BEEP BEEP
      SLEEP 2000
      MENU.SETLASTNODE("AcctGL")    ;--IF Hot Key Was Used, 
                                    ;  Make it look like it was a menu choice.
      
    Case UserReq="AcctAR" or UserReq="-105": ;ALT-F2 or AR
      Message "Start the Accounts Receivable Module"
      BEEP BEEP
      SLEEP 2000
      MENU.SETLASTNODE("AcctAR")

    Case UserReq="AcctAP" or UserReq="-106": ;ALT-F3 or AP
      Message "Start the Accounts Payable Module"
      BEEP BEEP
      SLEEP 2000
      MENU.SETLASTNODE("AcctAP")

    OtherWise:
      Message "Menu Choice is not Active."
  EndSwitch
ENDWHILE
                   



