; dlgLookup(row.n, col.n, lookupArray, searchString.a, lookupTitle.a)
; Creates a lookup dialog box for the user of the passed LookupArray
;
; ARGUMENTS:
;
;  row.n, col.n:    Row and column position for dialog box to appear on screen.
;                   Passing 999, 999 for the row.n and col.n parameters causes
;                   the dialog box to be centered.
;
;  lookupArray.a:   User defined array containing items that will be
;                   "looked up".
;
;  searchString.a:  Default array value, or a value to search for.
;
;  lookupTitle.a:   Title of the lookup array dialog box.
;
; RETURNS:          Number of the element selected or blanknum() if dialog was
;                   cancelled.
; Copyright (C) 1993 by Brickhouse Data Systems, Inc.
;
; Author:  Jonathan Matcho
;          Brickhouse Data Systems, Inc.
;          765 Park Avenue
;          Bound Brook, NJ  08805
;          Fax:  (908) 563-6844
;          CIS:  71760,2720
;
; This source is the sole property of Brickhouse.  The source may be used
; freely and incorporated into your own scripts and procedures as long as the
; above header (copyright notice, author, and company information) are left in
; the code.  You may embelish and enhance this procedure in any manner that you
; like, but this does not constitute authoring of the original source.

proc dlgLookup(row.n, col.n, lookupArray, searchString.a, lookupTitle.a)

private sysInfoBag,                    ; sysinfo dynarray
        screenHeight.n,                ; stores screen height
        screenWidth.n,                 ; stores screen width
        arrayElements.n,               ; arraysize(lookupArray)
        arrayHeight.n,                 ; # of available onscreen choices
        dialogHeight.n,                ; height of the dialog box
        dialogWidth.n,                 ; width of the dialog box
        largestElementLen.n,           ; length of widest lookupArray element
        element.n,                     ; temp var used to examine elements
        elementLen.n,                  ; temp var used to calc largest element
        buttonValue.l,                 ; value of button pressed
        pickedValue.n                  ; element # selected

  sysinfo to sysInfoBag
  screenHeight.n = sysInfoBag["ScreenHeight"]
  screenWidth.n  = sysInfoBag["ScreenWidth"]

  ; Calculate arrayHeight.n:
  arrayElements.n = arraysize(lookupArray)
  arrayHeight.n = arrayElements.n
  if arrayHeight.n > sysInfoBag["ScreenHeight"] - 6
     then arrayHeight.n = sysInfoBag["ScreenHeight"] - 6
  endif

  ; Calculate dialogHeight.n:
  dialogHeight.n  = arrayElements.n + 6
  if dialogHeight.n < 7
     then dialogHeight.n = 7
  endif
  if dialogHeight.n - 1 > screenHeight.n
     then dialogHeight.n = screenHeight.n - 1
  endif

  ; Calculate and set smallest possible width of dialog box and elements:
  largestElementLen.n = 0

  ; Minimum dialog box width:  2 + okButtonWidth + 2 + cancelButtonWidth + 2
  dialogWidth.n = 24

  ; adjust width according to lookup title:
  dialogWidth.n = max(24, len(lookupTitle.a) + 10)

  ; Calculate dialog box width when element sizes are greater than the minimum.
  ; Set default value (pickedValue.n).
  pickedValue.n = 0
  for element.n from 1 to arrayElements.n
    elementLen.n = len(lookupArray[element.n])
    dialogWidth.n = max(elementLen.n + 6, dialogWidth.n)
    largestElementLen.n = max(elementLen.n, largestElementLen.n)
    if search(searchString.a, lookupArray[element.n]) = 1 and pickedValue.n = 0
       then pickedValue.n = element.n  ; set only for first occurrence
    endif
  endfor

  if row.n = 999                       ; Handle row centring
     then row.n = int(screenHeight.n / 2) - int(dialogHeight.n / 2)
  endif

  if col.n = 999                       ; Handle column centering
     then
       ; Check if dialog is wider than the screen:
       if dialogWidth.n > screenWidth.n
          then col.n = 0
          else col.n = int((screenWidth.n - dialogWidth.n) / 2)
       endif
  endif

  buttonValue.l = false                ; To detect user pressing [Esc]

  SHOWDIALOG lookupTitle.a
    @row.n, col.n HEIGHT dialogHeight.n WIDTH dialogWidth.n

    PICKARRAY
      @1, (int(dialogWidth.n / 2) - int((largestElementLen.n + 2) / 2)) - 1
      HEIGHT arrayHeight.n
      WIDTH largestElementLen.n + 2
      COLUMNS 1
      lookupArray
      TAG "ArrayTag"
      TO pickedValue.n

    ; remember that dialogHeight starts at 0 and includes border
    PUSHBUTTON
      @(dialogHeight.n - 4), int(dialogWidth.n / 2) - 11
      WIDTH 8
      "~O~k"
      OK
      DEFAULT
      VALUE true
      TAG "OkTag"
      TO buttonValue.l

    PUSHBUTTON
      @(dialogHeight.n - 4), int(dialogWidth.n / 2) - 2
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE false
      TAG "CancelTag"
      TO buttonValue.l

  ENDDIALOG

  if buttonValue.l
     then return pickedValue.n
     else return blanknum()
  endif

endproc

; 
; Sample usage:

proc testLookup()
; collects selections until user presses [Esc]

  private testArray,
          element.n

  array testArray[5]
  testArray[1] = "Ride my bike"
  testArray[2] = "Go for a walk"
  testArray[3] = "Mow the lawn"
  testArray[4] = "Go back to work"
  testArray[5] = "Go to bed"

  element.n = dlgLookup(999, 999, testArray, "Mow", "Things to do today")
  if isblank(element.n)
     then message "User cancelled dialog box"
     else message testArray[element.n]
  endif

  sleep 1000

endproc

testLookup()
