CreateLib "GetTable"

proc gettable()
                            
   DynArray Dirs[]                           ;Set-up Variables                 
   HT=25                                                                       
   Tbl=""                                                                      
   NewPth=Directory()                                                          
   Pth=Directory()                                                             
   Drv=substr(Pth,1,1)                                                         
                                                                               
   DriveStr=""                               ; Add Drives to DriveStr          
   For I from 67 to 90                                                         
      If DriveStatus(Chr(i)) Then                                              
         DriveStr=DriveStr+Chr(i)                                              
      Endif                                                                    
   endFor                                                                      
                                                                               
   GetDirs("","","","")                      ; Inital Directory DynArray Setup 
                                                                               
   ShowDialog ""                             ; The Dialog Box                  
      Proc "GetDirs" Trigger "Select" Key 13                                   
         @ 0,20 Height Ht width 40                                             
         @ 0,1  ?? Format("W13",Tbl)                                           
         @ 0,16 ?? Format("W20",Pth)                                           
      PickTable                                                                
         @ 1,1 Height Ht-6 width 13                                            
         Pth                                                                   
         Tag "PicTable"                                                        
         To Tbl                                                                
      PickDynarray                                                             
         @ 1,16 Height Ht-6 width 20                                           
         Dirs                                                                  
         Tag "PicArray"                                                        
         To NewPth                                                             
      Pushbutton                                                               
         @ 21,4 Width 14                                                       
         "~O~k"                                                                
         OK                                                                    
         Value Pth+Tbl                                                         
         Tag "OKTag"                                                           
         To RetTbl                                                             
      Pushbutton                                                               
         @ 21,20 Width 14                                                      
         "~C~ancel"                                                            
         OK                                                                    
         Value ""                                                              
         Tag "CancelTag"                                                       
         To RetTbl                                                             
   EndDialog                                                                   
                                                                               
   If RetTbl<>"" then                        ;Return Path & Table or a Null    
      Return RetTbl                                                            
   else                                                                        
      Return ""                                                                
   endif                                                                       

endproc

Proc GetDirs(triggertype,Tagvalue,Eventvalue,Elementvalue)
   private String1,String2,I

   ;Table Selection, OK, or CANCEL
   Switch
      Case TagValue="PicTable"  : RetTbl=Pth+Tbl AcceptDialog 
      Case TagValue="OKTag"     : RetTbl=Pth+Tbl AcceptDialog
      Case TagValue="CancelTag" : RetTbl=""      AcceptDialog
      OtherWise                 : ;Must Have Been A Directory Selection 
   EndSwitch
        
   ;Directory or Drive Selection? 
   If SubStr(NewPth,1,1)="[" then   ;Drive selection
      Pth=SubStr(NewPth,3,1)+":\\"
      Release Vars DIRBLOB
   else                             ;Directory selection
      Pth=NewPth
   endif
    
   Drv=SubStr(Pth,1,1)
   NewPth=""
                                    ;Check for BLOb variable existence and 
                                    ;Directory Map File existence.
   If Not Isassigned(DIRBLOB) then  
      If not isFile(Drv+":\\PDOXDIRS.TXT") then
         ;Refresh Directory File Map
         Run Norefresh  "Dir "+Drv+":\\ /AD/B/S> "+DRV+":\\PDOXDIRS.TXT"
      Endif
      FileRead DRV+":\\PDOXDIRS.TXT" to DirBlob
   endif  

   DynArray Dirs[]
                                     ; Add Drives to DynArray        
   For I from 1 to Len(DriveStr)
      Dirs["[-"+Substr(DriveStr,i,1)+"-]"]
          ="[-"+SubStr(DriveStr,i,1)+"-]"
   EndFor
                                     ;Add Root Directory to DynArray
   If Pth<>Drv+":\\" then
      Dirs[DRV+":\\"]="."
   endif
                                     ;Add Parent Directory to DynArray
   String1=SubStr(Pth,1,Len(Pth)-1)
   String3=""
   While Match(String1,"..\\..",String2,String1)
         Retval=Match(Pth,".."+String1+"\\",String3)  
   EndWhile

   If String3<>"" then
      Dirs[String3]=".."
   endif   
                                          ;Routine to create sub-directory
                                          ;DynArray from BLOb variable.
   BegLoc=Search(Pth,DirBlob)
   While  BegLoc>0
      SubLoc=SearchFrom("\\",DirBlob,BegLoc+Len(Pth))               
      EndLoc=SearchFrom("\n",DirBlob,BegLoc+Len(Pth))               
      If SubLoc>0 and SubLoc<EndLoc then                            
         QuitLoop                                                   
      Endif                                                         
      DirVal=Substr(DirBlob,BegLoc+Len(Pth),EndLoc-BegLoc-Len(Pth)) 
      Dirs[Pth+DirVal+"\\"]=DirVal                                  
      BegLoc=SearchFrom(Pth,DirBlob,EndLoc)                         
   EndWhile 

   RefreshDialog
   Return False

EndProc

WriteLib "GetTable" GetDirs, GetTable

;====================================================================
; To setup [Alt][V] for VIEWing

autolib = "GetTable"
setkey -47 gettable() if retval<>"" then view retval endif

