;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure Dial
;Source File     : DIALER.SC
;Author          : Gary Praegitzer
;                  FaxComm Services
;                  1761 W. Euclid
;                  Stockton, CA   95204
;                  Phone: (209) 466-3755 (home)
;                  Fax  : (209) 466-1946
;
;Informant Issue : October 1991
;
;Description     : A PAL dialer. This routine dials a telephone number that
;                  is specified in your program. It does not shell to DOS to
;                  perform the dial operation. Once setup, the dialer can be
;                  called from any Paradox mode. Setup of the dialer, however,
;                  requires that you be in Main mode. The routine also 
;                  facilitates custom message windows to be presented to the 
;                  user.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

CREATELIB "Dialer"                           ; Create library "Dialer"

;****************************************************************************
;
;     Procedure Name: Dial_Setup()
;
;        Description: Initializes global variable default_port.a with
;                     default printer destination.
;
;                  *  Must be called from Main Mode
;
;*****************************************************************************

PROC Dial_Setup()

   IF SYSMODE() <> "Main"                    ; Paradox not in Main Mode
     THEN RETURN False                       ; RETURN False
   ENDIF

   {Report} {SetPrinter} {Override}          ; Get default printer
   {PrinterPort}                             ; destination and save to
   default_port.a = MENUCHOICE()             ; default_port.a

   Menu Esc

   RETURN True                               ; Procedure completed normally
                                             ; Return True
ENDPROC

;****************************************************************************
;
;     Procedure Name: Dial_Init()
;
;        Description: Redirects printer output to specified COM port
;
;                  *  Must be called from Main Mode
;
;****************************************************************************

PROC Dial_Init(port.a)

   IF SYSMODE() <> "Main"                    ; Paradox not in Main Mode
     THEN RETURN False                       ; Return False
   ENDIF

   SETPRINTER port.a                         ; Direct printer output to
                                             ; specified port
   RETURN True                               ; Procedure completed normally
                                             ; Return True
ENDPROC

;****************************************************************************
;
;     Procedure Name: Dial()
;
;        Description: Telephone dialer - Sends phone number to modem
;                     attached to selected COM port.
;
;                  *  Can be called in any Paradox mode
;
;                  *  Works with any Hayes Compatible modem
;
;         THIS PROCEDURE IS UNABLE TO DETECT IF THERE IS A MODEM CONNECTED
;         TO THE SELECTED COM PORT. THIS IS A PARADOX LIMITATION.
;
;****************************************************************************

PROC Dial(dialstring.a,coord.a,d_message1.a,d_message2.a)
   PRIVATE  key.n, row.n, width.n, x, printstr.a, comma.n,
            d_message.a, height.n, col.n     ;Declare private vars
   CURSOR OFF                                ; Turn off cursor
   OPEN PRINTER                              ; Open COM port

   printstr.a = "ATDT" + dialstring.a + ";\n"
   PRINT printstr.a                ; Dial number - semicolon puts modem
                                   ; back into command mode after dialing
                                   ; \n equals LF/CR

   WHILE CHARWAITING()                       ; Clear keyboard buffer
      key.n = GETCHAR()
   ENDWHILE

   comma.n = SEARCH(",",coord.a)

   IF comma.n <> 0
     THEN row.n = NUMVAL(SUBSTR(coord.a,1,comma.n - 1))
          col.n = NUMVAL(SUBSTR(coord.a,comma.n + 1,LEN(coord.a)))
   ENDIF

   IF row.n < 0
     THEN row.n = 0
   ENDIF
   IF col.n < 0
     THEN col.n = 0
   ENDIF

   d_message.a = "DIALING ... " + dialstring.a

   width.n = LEN(d_message.a)
   IF LEN(d_message1.a) > width.n
     THEN width.n = LEN(d_message1.a)
   ENDIF
   IF LEN(d_message2.a) > width.n
     THEN width.n = LEN(d_message2.a)
   ENDIF

   width.n = width.n + 6
   IF col.n + width.n >= 77
     THEN col.n = 77 - width.n
   ENDIF

   height.n = 3
   IF d_message1.a <> ""
     THEN height.n = height.n + 1
   ENDIF
   IF d_message2.a <> ""
     THEN height.n = height.n + 1
   ENDIF
   IF row.n + height.n >= 23
     THEN row.n = 23-height.n
   ENDIF

   CANVAS OFF
   PAINTCANVAS FILL CHR(176) ATTRIBUTE 15
   row.n + 1,col.n + 2,row.n + height.n + 1,width.n + col.n + 2
                                                  ; Dropshadow

   PAINTCANVAS FILL CHR(32) ATTRIBUTE 31
   row.n,col.n,row.n + height.n,width.n + col.n   ; Window

   STYLE ATTRIBUTE 31

   @ row.n + 1,INT(col.n + ((width.n - LEN(d_message.a))/2) + 1)
   ?? d_message.a
   IF d_message1.a <> ""
     THEN @ row.n + 3,INT(col.n + ((width.n - LEN(d_message1.a))/2) + 1)
          ?? d_message1.a
   ENDIF

   IF d_message2.a <> ""
     THEN IF d_message1.a <> ""
            THEN @ row.n + 4,INT(col.n + ((width.n - LEN(d_message2.a))/2) + 1)
                 ?? d_message2.a
            ELSE @ row.n + 3,INT(col.n + ((width.n - LEN(d_message2.a))/2) + 1)
                 ?? d_message2.a
          ENDIF
   ENDIF

   CANVAS ON
   FOR x FROM 1 TO 25000
      IF CHARWAITING()                       ; Read character from keyboard
        THEN key.n = GETCHAR()
             QUITLOOP
      ENDIF
   ENDFOR

   PRINT "ATH\n"                             ; Hang up modem
   PRINT "AT&F\n"                            ; Reset modem to factory defaults
   PRINT "ATZ0\n"
   CLOSE PRINTER                             ; Close COM port

   CURSOR NORMAL                             ; Reset cursor

   RETURN True                               ; Procedure completed normally
                                             ; Return True
ENDPROC

WRITELIB "Dialer" Dial,Dial_Init,Dial_Setup  ; Write procedures to library
