PROC Squiggle()
PRIVATE Direction,      ;1=up 2=right 3=down 4=left
        OldDirection,   ;Direct. last line segment
        DirectionCount, ;Counter for each direction
        NewHigh,        ;Next row for line segment
        NewWide         ;Next col for line segment

  ;turn grid position into character position
  High=High*PathHeight+1
  Wide=Wide*PathWidth +1

  IF SUBSTR(screen[High],Wide,1)<>" " THEN
    ; If there is already a Squiggle here,
    ; then don't connect to it.
    RETURN
  ENDIF

  Direction = INT(4*RAND())+1

  ; Find the direction of a squiggle to connect to
  FOR DirectionCount FROM 1 TO 4
    GetNewPoint()
    IF SUBSTR(screen[NewHigh],NewWide,1)<>" " THEN
      QUITLOOP
    ENDIF
    Direction = MOD(Direction,4) + 1
  ENDFOR
  IF DirectionCount=5 THEN
    ; Couldn't find anything to connect squiggle to
    RETURN
  ENDIF

  DrawLine(High,Wide,NewHigh,NewWide)
  ; Make squiggle turn as much a possible
  OldDirection=Direction

  WHILE TRUE
    Direction = INT(4*RAND())+1 
    FOR DirectionCount FROM 1 TO 4
      GetNewPoint()
      IF SUBSTR(screen[NewHigh],NewWide,1)=" " AND
         Direction<>OldDirection               THEN
        QUITLOOP
      ENDIF
      Direction = MOD(Direction,4) + 1
    ENDFOR
    IF DirectionCount=5 THEN
      ; Dead end, all directions contain squiggles
      RETURN 
    ENDIF
    OldDirection=Direction
    DrawLine(High,Wide,NewHigh,NewWide)
    ; Set new position to current position.
    High=NewHigh
    Wide=NewWide 
  ENDWHILE
ENDPROC

;***************************************************
; Calulate NewHigh and NewWide in current direction
PROC GetNewPoint()
  SWITCH
    CASE Direction=1:
      NewWide=Wide
      NewHigh=High-PathHeight
    CASE Direction=2:
      NewWide=Wide+PathWidth
      NewHigh=High
    CASE Direction=3:
      NewWide=Wide
      NewHigh=High+PathHeight
    CASE Direction=4:
      NewWide=Wide-PathWidth
      NewHigh=High
  ENDSWITCH
ENDPROC

;***************************************************
PROC PaintScreen()
PRIVATE ScreenLine
  CANVAS OFF
  FOR ScreenLine
    FROM 1 TO (MazeHeight+1)*PathHeight+1
    @ScreenLine-1+HeightMargin,WidthMargin
    ?? Screen[ScreenLine]
  ENDFOR
  CANVAS ON
ENDPROC

;***************************************************

PROC  DrawLine(HighStart,WideStart,HighEnd,WideEnd)
PRIVATE Count,      ;Count each char in line segment
        PrevChar,   ;Prev char to left or above
        CurrChar,   ;Current char to be replaced 
        NextChar,   ;Next char to right or below
        NewChar     ;Replacement character

; Make sure start and end are in order
IF HighStart>HighEnd THEN
  temp=HighStart
  HighStart=HighEnd
  HighEnd=temp
ENDIF
IF WideStart>WideEnd THEN 
  temp=WideStart
  WideStart=WideEnd
  WideEnd=temp
ENDIF
IF HighStart<>HighEnd THEN
  FOR Count FROM HighStart TO HighEnd
    IF WideStart=1 THEN
      ;Set the Previous Character, char to left
      PrevChar=" "
    ELSE
      PrevChar=SUBSTR(screen[Count],WideStart-1,1)
    ENDIF
    ;Set the currentchar
    CurrChar=SUBSTR(screen[Count],WideStart,1)
    IF WideStart=TotalWidth THEN
      ; Set the Next Char, char to right
      NextChar= " "
    ELSE
      NextChar=SUBSTR(screen[Count],WideStart+1,1)
    ENDIF

    SWITCH
      CASE CurrChar=" ": NewChar=""
      CASE CurrChar="":
        SWITCH
          CASE PrevChar="" AND
               NextChar="" AND
               Count=HighStart: NewChar=""
          CASE PrevChar="" AND
               NextChar="" AND
               Count=HighEnd:   NewChar=""
          CASE PrevChar="" AND
               NextChar="":    NewChar=""
          CASE PrevChar="" AND 
               NextChar=" " AND 
               Count=HighStart: NewChar=""
          CASE PrevChar="" AND
               NextChar=" " AND
               Count=HighEnd:   NewChar=""
          CASE PrevChar=" " AND
               NextChar="" AND
               Count=HighStart: NewChar=""
          CASE PrevChar=" " AND
               NextChar="" AND 
               Count=HighEnd:   NewChar=""
          OTHERWISE:            NewChar=""
        ENDSWITCH
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      OTHERWISE:         NewChar=CurrChar
    ENDSWITCH
    Screen[Count]=
      SUBSTR(Screen[Count],1,WideStart-1)+
      NewChar+
      SUBSTR(Screen[Count],WideStart+1,TotalWidth)
    @Count-1+HeightMargin,WidthMargin+WideStart-1
    ?? NewChar
  ENDFOR
ELSE
  FOR Count FROM WideStart TO WideEnd
    ;Set previous character, character above
    IF HighStart=1 THEN
      PrevChar=" "
    ELSE
      PrevChar=SUBSTR(screen[HighStart-1],Count,1)
    ENDIF
    ; Set current char
    CurrChar=SUBSTR(screen[HighStart],Count,1)
    IF HighStart=TotalHeight THEN
      ; Set next character, character below
      NextChar=" "
    ELSE
      NextChar=SUBSTR(screen[HighStart+1],Count,1)
    ENDIF

    SWITCH
      CASE CurrChar=" ": NewChar=""
      CASE CurrChar="":
        SWITCH
          CASE PrevChar="" AND
               NextChar="" AND
               Count=WideStart: NewChar=""
          CASE PrevChar="" AND
               NextChar="" AND
               Count=WideEnd:   NewChar=""
          CASE PrevChar="" AND
               NextChar="":    NewChar=""
          CASE PrevChar="" AND 
               NextChar=" " AND 
               Count=WideStart: NewChar=""
          CASE PrevChar="" AND
               NextChar=" " AND 
               Count=WideEnd:   NewChar=""
          CASE PrevChar=" " AND 
               NextChar="" AND 
               Count=WideStart: NewChar=""
          CASE PrevChar=" " AND
               NextChar="" AND
               Count=WideEnd:   NewChar=""
          OTHERWISE:            NewChar=""
        ENDSWITCH
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      CASE CurrChar="": NewChar=""
      OTHERWISE:         NewChar=CurrChar
    ENDSWITCH

    Screen[HighStart]=
      SUBSTR(Screen[HighStart],1,Count-1)+
      NewChar+
      SUBSTR(Screen[HighStart],Count+1,TotalWidth)
    @HighStart-1+HeightMargin,WidthMargin+Count-1
    ?? NewChar
  ENDFOR
ENDIF

ENDPROC

;***************************************************

PROC Maze()
PRIVATE Screen,         ;Line array simulates screen
        ScreenHeight,   ;Number of rows on screen
        ScreenWidth,    ;Number of columns on screen
        PathHeight,     ;Height of a path
        PathWidth,      ;Width of a path
        MazeHeight,     ;Number of paths High
        MazeWidth,      ;Number of paths Wide
        HalfHeight,     ;Half MazeHeight rounded up
        HalfWidth,      ;Half MazeWidth rounded up
        TotalWidth,     ;Maze width in characters
        TotalHeight,    ;Mase height in characters
        WidthMargin,    ;Left-hand screen Margin
        HeightMargin,   ;Margin on top of screen
        HeightCount,    ;Count maze grid rows
        WidthCount,     ;Count maze grid columns
        Positions,      ;Array of grid positions 
        POSITION,       ;Current postition
        PositionCount,  ;Counter for each position
        TotalPositions, ;Number of grid positions 
        High,           ;Actual grid position
        Wide,           ;Actual grid position
        SysInfoBag,     ;Dynarray holder for SysInfo
        h,              ;For loop Counter
        temp            ;Temp var to swap values

CURSOR OFF
CLEAR
ScreenHeight=25         ; 3.5 ScreenHeight
ScreenWidth =80         ; 3.5 ScreenWidth

IF VERSION()>3.5 THEN
  ;Use execute so program will compile in Pdox35
  EXECUTE "Sysinfo to SysInfoBag"
  ScreenHeight=SysInfoBag["ScreenHeight"]
  ScreenWidth =SysInfoBag["ScreenWidth"]
ENDIF


PathHeight=2            ; Chars per path
PathWidth=INT(ScreenWidth*PathHeight/ScreenHeight)-1

; How many paths Wide and High?
MazeWidth =INT((ScreenWidth -2)/PathWidth )-1
MazeHeight=INT((ScreenHeight-2)/PathHeight)-1

; Half number of paths Wide and High
HalfWidth =MazeWidth -INT(MazeWidth /2)
HalfHeight=MazeHeight-INT(MazeHeight/2)

; How many chars Wide and High?
TotalWidth =(MazeWidth +1)*PathWidth +1
TotalHeight=(MazeHeight+1)*PathHeight+1

; Center maze on screen
WidthMargin =INT((ScreenWidth -TotalWidth )/2)
HeightMargin=INT((ScreenHeight-TotalHeight)/2)

;Build border in screen array
ARRAY Screen[TotalHeight]
Screen[1]=            ""+FILL("",TotalWidth-2)+""
FOR HeightCount FROM 2 TO TotalHeight-1
  Screen[HeightCount]=""+SPACES(  TotalWidth-2)+""
ENDFOR
Screen[HeightCount]=  ""+FILL("",TotalWidth-2)+""
PaintScreen()  ;Show the border

ARRAY Positions[2*(MazeHeight+MazeWidth)]

HeightCount=0
WidthCount =0

; Fill array with grid points on outside edges
; of maze, then spiral in.
WHILE HeightCount<HalfHeight AND
      WidthCount<HalfWidth
  TotalPositions=0
  HeightCount=MIN(HeightCount+1,HalfHeight)   
  WidthCount= MIN(WidthCount +1,HalfWidth )  
  High=HeightCount
  FOR Wide FROM WidthCount TO MazeWidth-WidthCount  
    TotalPositions=TotalPositions+1
    Positions[TotalPositions]=CHR(High)+CHR(Wide)
  ENDFOR
  FOR High FROM HeightCount 
           TO MazeHeight-HeightCount 
    TotalPositions=TotalPositions+1
    Positions[TotalPositions]=CHR(High)+CHR(Wide)
  ENDFOR
  FOR Wide TO (WidthCount+1) STEP -1                 
    TotalPositions=TotalPositions+1
    Positions[TotalPositions]=CHR(High)+CHR(Wide)
  ENDFOR
  FOR High TO (HeightCount+1) STEP -1                
    TotalPositions=TotalPositions+1
    Positions[TotalPositions]=CHR(High)+CHR(Wide)
  ENDFOR

  ; Randomize array positions
  FOR PositionCount FROM 1 TO TotalPositions
   POSITION=INT(TotalPositions*RAND()+1)
   temp=Positions[PositionCount]
   Positions[PositionCount]=Positions[Position]
   Positions[Position]=temp
  ENDFOR

  ; Draw the squiggles
  FOR PositionCount FROM 1 TO TotalPositions
    High=ASC(SUBSTR(Positions[PositionCount],1,1))
    Wide=ASC(SUBSTR(Positions[PositionCount],2,1))
    Squiggle()
  ENDFOR
ENDWHILE

;Now make make the maze entrance and exit
h=INT(MazeHeight/2)*PathHeight

screen[h+1] =""+
             SUBSTR(screen[h+1],2,TotalWidth-2)+""

FOR HeightCount FROM 2 TO PathHeight
  screen[h+HeightCount]= " "+
    SUBSTR(screen[h+HeightCount],2,TotalWidth-2)+" "
ENDFOR

screen[h+HeightCount] = ""+
  SUBSTR(screen[h+HeightCount],2,TotalWidth-2)+""

paintscreen()   ; Show entire maze
ENDPROC

;***************************************************

Maze()
; Leave maze on screen until a key is pressed
x=GETCHAR()
