; -----------------------------------------------------
;                     Delete OK?
; -----------------------------------------------------
; by Steve Caple, Sacramento Paradox Users Group
; first published in Sep '90 "Paradox Informant"
; -----------------------------------------------------
; - proc to require confirmation for deleting records
;   in response to ex-dBASE user request for a SET
;   CONFIRM ON feature
; - can be called in any PAL program, or by a setkey
;   macro from interactive Paradox (proc must either be
;   explicity read or in a lib on the autolib path):
;              setkey -83 DeleteOK()
; - only intervenes if IN one of the edit modes (Edit,
;   CoEdit, or DataEntry) AND if NOT IN fieldview:
;   otherwise passed the delete on through
; - in tableview, highlights current row to be deleted
;
; 11/04/90 10:11am WSC - window() check
; -----------------------------------------------------
proc DeleteOK()
  private x,     ;utility variable
          Choice ;alpha variable for showmenu choice

  ;turn off canvas cursor display
  cursor off

  ;check to see if we ARE in an editing mode and we are
  ;NOT in fieldview
  if search(sysmode(),"CoEditDataEntry") > 0
       and
     not isfieldview() then

    ;if we're in tableview match the canvas cursor to
    ;the workspace cursor, then highlight the record
    ;to be deleted - a boon to LCD screen users!
    if not isformview() then
      synccursor
      paintcanvas reverse row(),0,row(),79
    endif

    ;signal & put up a centered reverse video message
    beep
    style reverse
    @ 2,0 ?? format("w80,ac",
      "Are you sure you want to delete this record?")
    style

    ;showmenu defaults to first choice if no default
    ;is defined - so make the first one the safe one
    showmenu
      "Oops!": "No - DO NOT delete this record",
      "Yes"  : "Yes - please delete this record"
    to Choice  ;possible values: Oops!, Yes and Esc

    if Choice = "Yes" then   ;only if Choice is Yes
      del                    ;do the delete -
      ; see if we got the "Can't delete master while
      ; detail records depend ..." message, if we did,
      ; show it to the user
      x = window()
      if not isblank(x) then
        beep
        style reverse
        @ 2,0 ?? format("w80,ac",x)
        style
        sleep 2000
      endif
     endif                    ;otherwise do nothing

  else  ;we are not in an editing mode, or if we
        ;are, we're also in fieldview

    del   ;so pass the delete on through

  endif

endproc

; that's all folks - write it to a library, put the
; library on your autolib path, establish the setkey
; shown at top, and try it out
