
; 
; DboxChecker Ver 1.0
; 
; (C) CopyRight 1993 Robert Scott
; This was created to help me Check Dialog boxes. 
;
; It can pull all the dbox info and send to to the screen or 
; file or printer
;
; All PUSHBUTTON,ACCEPT,CHECKBOX,RADIOBUTTON,PICKLISTs and Variables are 
; displayed 
; 
; for that Dialog Box. Things such as TAG, VALUE, TO and Title information.  
; It will also display any variables in the Dialog box
; E.g
; ?? Var  or ?? Sdir()
;
; It will not read text such as ?? "Text"
;   
; It's a quick way to verify what tag you used and the Value and so on
; for your dialog box procedures.   
; 
; 
; As I use PaintPAL for creating Dialog Boxes, it is set up for that format
;          
; Other Formats will result in an Error meesage or not read correctly  
;
;   VALUE "YES"
;   TAG "tg"
;   TO Var
;
;  Formats such as
;  VALUE "YES"  TAG "Tg"  TO Var  will not be read succesfully
;
;  It needs a lot more work so if you have any suggestions... 
; 
;  As always Comments are welcome
; 
; CIS 71603,3530
;
Libname = "dboxlib"
Createlib libname      

;----------------------------------------------------------------------------
;-------------------------------------------------------------------
; Get_Script
;
; This procedure displays the Scripts in the Current directory
; Select the script then OK or ENTER
; ---------->
PROC Get_script()
PRIVATE Script.list
  ; PaintPAL_Generated_Code_Begin(449724720)

  ; PaintPAL_Color_Setup_Begin
  GETCOLORS TO PaintPAL.OriginalPalette
  DYNARRAY PaintPAL.ColorDeviations[]
  PaintPAL.ColorDeviations[1036] = 121  ;Background Text
  PaintPAL.ColorDeviations[1056] = 112  ;Picklist Normal
  PaintPAL.ColorDeviations[1058] = 126  ;Picklist Selected
  PaintPAL.ColorDeviations[1059] = 113  ;Picklist Divider
  SETCOLORS FROM PaintPAL.ColorDeviations
  RELEASE VARS PaintPAL.ColorDeviations
  ; PaintPAL_Color_Setup_End

  SHOWDIALOG "Select Script"
     @3,14 HEIGHT 17 WIDTH 43

     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 1,4 TO 10,36
     PAINTCANVAS ATTRIBUTE 127 1,4,1,36
     PAINTCANVAS ATTRIBUTE 112 10,4,10,36
     PAINTCANVAS ATTRIBUTE 127 1,4,10,4
     PAINTCANVAS ATTRIBUTE 112 1,36,10,36
     ; PaintPAL_Frame_End

     ; PaintPAL_Static_Text_Begin
     PAINTCANVAS FILL " " ATTRIBUTE 112 0,5,0,15
     @0,5
     ?? Sdir()
     PAINTCANVAS ATTRIBUTE 112 0,5,0,15
     ; PaintPAL_Static_Text_End

     PICKFILE @2,5 HEIGHT 8 WIDTH 30
        COLUMNS 2
        Directory()+"*.sc"
        TAG "Script_list.tag"
        TO Script.list

     PUSHBUTTON @13,15 WIDTH 10
        "~O~k"
        OK
        DEFAULT
        VALUE "YES"
        TAG "Script.tag"
        TO Yesval
  ENDDIALOG

  ; PaintPAL_Color_Cleanup_Begin
  SETCOLORS FROM PaintPAL.OriginalPalette
  RELEASE VARS PaintPAL.OriginalPalette
  ; PaintPAL_Color_Cleanup_End

  ; PaintPAL_Generated_Code_End(449724720)
  IF Retval then
     If Search(".",Script.list) = 0 then
     Script.1 = Script.list + ".sc"
   Else   
     Script.1 = Script.List
   Endif
    If Option.var = 1 then  ; Print
        PrintAll = 1
    ENDIF
     
  
   Return
  ELSE
   quit
  Endif 
ENDPROC ; <-- Get_script
Writelib libname Get_Script
;------------------------------------
; Get_a_unused_tablename
; This procedure assigns an unused temp tablename to
; import the Script to be Parsed into
; From T1 to T9999999
;
PROC Get_a_unused_tablename()
Private File.a   ; Filename
       ,Ns       ; Counter , added to T to make filename 
       
File.a = "T1"     ; initialize 
Ns = 1
While true
 If isfile(file.a +".db") then
     ns = ns + 1
     file.a = "T" + strval(ns)
 Else
     quitloop
 Endif
Endwhile
Tablename.a = file.a
Return tablename.a
Endproc  ; Get_a_unused_tablename
WriteLib libname Get_a_unused_tablename

;---------------------------------------------------
; Determines if SHOWDIALOG is a Command or part of another 
; statement Returns true or false
PROC Showdialog.1(fg)
        
Private  fg  ; feild
        ,SCpos   ;     Semicolon ;
        ,SPpos   ;     Showdialog
        ,SMpos   ;     Message
        ,SQpos   ;     Quit
        ,SBpos   ;     Brackets (  
        ,Dsiag   ;     Varaible
       
       SCpos = search(";",fg)               ; Semi-colon position
       SPpos = Search(" Showdialog ",fg)    ; SHOWDIALOG Position
       SMpos = Search("Message",fg)       ; is it part of message commad
       SQpos = Search("Quit",fg)          ; a quit
       SBpos = Search("(",fg)               ; or part of a message.a( Showdailog..
       Dsiag = true      
       If SPpos < 15 then     ; Showdialog as a commad shound'nt be further out 
                              ; than 15 spaces ?
              If Scpos <> 0 then    ; If  ;
               If (SCpos < SPpos) then     
                  Dsiag = false
               Endif   
              Endif
               IF SMpos <> 0  then         ; message
                 IF (SMpos < SPpos) then
                   Dsiag = false
                 Endif  
               Endif 
               IF Sqpos <> 0 then          ;Quit
                   If (SQpos < SPpos) then
                     Dsiag = false 
                 Endif
               Endif
               IF SBPos <> 0 then          ;()
                  IF (SBpos < SPpos) then
                    Dsiag = false       
                  Endif
               Endif
          ELse
               Dsiag = false        
       ENDIF
       Return Dsiag
 
 ENDPROC
 Writelib libname Showdialog.1         

;------------------------------------------------------------
; Get_dbox_to_load
; Parses Script and extracts dialog box occurances and headers
; and line number
PROC Get_dbox_to_load(Scriptname) 
Private ct           ; counter
        ,pos.db      ; Line number   
        ,Recn.a      ; String var of recno()
        ,p.1         ; String var
        ,Pos.1       ; 1st pos
        ,Pos.2       ; 2nd pos
        ,Exitloop    ; While loop control var
        ,Scriptname  ; Script name
        ,dvbox.var   ; Dbox array var
Message "Searching "+Scriptname+ " for SHOWDIALOG Statements"
; Import Script as a table
Tablename.a = Get_a_unused_tablename()
{Tools} {ExportImport} {Import} {ASCII} {Text}  
 Select Scriptname
 Select Tablename.a ENTER
Dynarray pos.db[]
Dynarray Name.1[]
Dynarray Procname[]
Ct = 0
View tablename.a
moveto[TEXT]
ExitLoop = false
Locate Pattern ".."+" SHOWDIALOG "+".."   

IF NOT Retval then    ; not found Exit
Sound 400 100 Sound 500 100
DELETE tablename.a
Quit "NO SHOWDIALOGS found in "+Scriptname      
Endif

While (Exitloop <> true )

If retval then     
               ; Line number
     
       fg = []
    IF Showdialog.1(fg) then     
       CT = Ct +1
       Recn.a = strval(recno())               
       Pos.db[strval(ct)] = Recn.a 
       pos.1 = Search("\"",fg)                ; position first quote                
         If Substr("\"",pos.1+1,1) = "\"" then  ; If "", no title
           Name.1[Strval(CT)] = "\"\""
         ELSE
           p.1 = Substr([],Pos.1+1,LEN(fg))     ; Extract string from 1sr quote
           pos.2 = Search("\"",p.1)             ; position of 2nd quote
           Name.1[STRVAL(CT)] = Substr(p.1,1,pos.2-1)  ;Extract title
         ENDIF  
         DOWN  ; move odwn to next line
           Pos.proc =  Search(" PROC ",[])
           IF Pos.Proc <> 0 then ; look for PROC
             Procname[strval(ct)] = Strip_quotes(Substr([],pos.proc+5,len([])))    
           ELse
             Procname[strval(ct)] = "N/A"
           endif       
   ENDIF
 
 ELSE
  EXITLOOP = true   ; no more SHOWDIALOGS exit loop
 Endif
 DOWN
 Retval = true  ; set just in case
 Locate Next Pattern ".."+" SHOWDIALOG "+".."   ; locate next SHOWDIALOG
 ENDWHILE 
 ; Set up for Dialog box display
ARRAY Dbox_names[dynarraysize(Pos.db)]
For ct from 1 to dynarraysize(Pos.db) ; Convert to string
   Dbox_names[CT] = Strval(Pos.db[strval(ct)])
ENDFOR
  savevars dbox_names
ARRAY lineval.1[dynarraysize(Pos.db)]
For ct from 1 to dynarraysize(Pos.db)
  Lineval.1[ct] =
                Dbox_names[ct] +SPACES(6-LEN(dbox_names[ct])) ; Line number
                + "   "
                + Name.1[strval(ct)]                          ; Title

Endfor
Message ""

ENDPROC ; <-----Get_dbox_to_load
Writelib libname Get_dbox_to_load
;--------------------------------------------------------
; Strip_quotes
; This procedure will either extract a string from quotes 
;  "  \"String\" "   to "String"
; remove back spaces from string
; i.e "   String" to "String"
;
PROC Strip_quotes(string.1)
Private string.1    ; string
       ,pos.1
       ,p.1
       ,pos.2
 ;Global p.2        ; returned string
    pos.1 = Search("\"",string.1)   ; 1st quote
    If pos.1 <> 0 then              ; If quotes present
       p.1 = substr(string.1,pos.1+1,len(string.1)) ; 1st string
       pos.2 = search("\"",p.1)       ;2nd quote
       p.2 = Substr(p.1,1,pos.2-1)    ; string extracted from quotes
    Else
      For x from 1 to len(string.1)  ; No quotes in string so remove any 
                                     ; back spaces
        If Substr(string.1,x,1) <> " " then
         P.2 =  Substr(string.1,x,len(string.1))
         quitloop
        Endif
      Endfor
    Endif  
Return p.2
Endproc ; <---Strip_quotes
Writelib Libname Strip_quotes
;-------------------------------------------
;
;
PROC Get_Pushbutton_info(tablename,Linenum)
Private Linenum      ; Line Selected SHOWDIALOG begins at
       ,tablename    ; Temp table
       ,tagvar       ; dynarray
       ,valvar        ;dynarray
       ,idvar
       ,titlevar
       ,ToVar
       ,Endvar
       ,Dyn_push.var
Message "Searching for PUSHBUTTON Information"
Pushbutton.val = false
Dynarray Tagvar[]    ; TAG
Dynarray valvar[]    ; VALUE
Dynarray titlevar[]  ; Title  OK CANCEL Pushme etc
Dynarray ToVar[]     ; TO
Type.1 = ""
Moveto tablename
Moveto[text]
Moveto record numval(Linenum)  ; moveto Showdialog selected
Endvar = false
CT =0
Tag.1 = 0
val.1 = 0
to.1 = 0
While (Endvar <> true)
Down
IF SEARCH(" PUSHBUTTON ",[]) <> 0 then
      CT = CT +1
      Type.1 = "PUSHBUTTON"
      Down
      titlevar[strval(ct)] = strip_quotes([])
      Down
      While true
      IF SEARCH(" VALUE ",[]) <> 0 then
         string.1 = substr([],Search("Value",[])+5,len([]))
         valVar[strval(ct)] = Strip_quotes(string.1)
         Val.1 = val.1 + 1
         Down
         Quitloop
      ELSE   
         Down
      ENDIF
      Endwhile
      IF SEARCH(" TAG ",[]) <> 0 then
         TagVar[strval(ct)] = strip_quotes([])
         tag.1 = tag.1 +1
         Down
      ENDIF
      IF SEARCH(" TO ",[]) <> 0 then
         pos.1 =  Search(" To ",[]) 
         ToVar[strval(ct)] = Substr([],pos.1+4,len([]))
         to.1 = to.1 +1
      ENDIF
ENDIF             
If SEARCH("ENDDIALOG",[]) <> 0 then
ENDVAR = true
Endif 
Endwhile

; Counts for tags, value and To should be the same
; if not inform user
  Error.1 =false
If (tag.1 <> val.1) OR (tag.1 <> to.1) then
  Error.1 = true
Endif

Dynarray Pushbutton_array[]
For x from 1 to Dynarraysize(tagvar)
; Truncate length 
If len(titlevar[strval(x)]) > 20 then
   titlevar[strval(x)] = Substr(titlevar[strval(x)],1,20)
Endif   
If len(valvar[strval(x)]) > 20 then
   valvar[strval(x)] = Substr(valvar[strval(x)],1,20)
Endif   
If len(tagvar[strval(x)]) > 20 then
   tagvar[strval(x)] = Substr(tagvar[strval(x)],1,20)
Endif   

Pushbutton_array[strval(x)] = titlevar[strval(x)] + SPACES(20-LEN(titlevar[strval(x)]))
                     + valvar[strval(x)] + SPACES(20-LEN(valvar[strval(x)]))
                     + tagvar[strval(x)] + SPACES(20-LEN(tagvar[strval(x)]))
                     +tovar[strval(x)]  
Endfor                  
  
ENDPROC ; <---GET_Pushbutton_info
Writelib Libname GET_Pushbutton_info
;-----------------------------------------------
; Get_Accept_line_info
; Gets Accept line information
;
;-------------------------------
PROC Get_accept_line_info(tablename.a,Linenum)
Private Tablename.a
        ,linenum
        ,AtagVar
        ,Aidvar
        ,Typevar
        ,AtoVar
        ,Endvar
Message "Searching for ACCEPT line information"        
Dynarray ATagvar[]    ; TAG
Dynarray Typevar[]    ; Type  A10, N
Dynarray AToVar[]     ; TO
Accept.val = false
Moveto tablename.a
Moveto[text]
Moveto record numval(Linenum)
Endvar = false
CT =0
While (Endvar <> true)
Down
IF SEARCH(" ACCEPT ",[]) <> 0 then
      CT = CT +1
      Type.1 = "ACCEPT"
      Accept.val = true
      Down
      TypeVar[strval(ct)] = strip_quotes([])
      Down
      While true
      IF SEARCH(" TAG ",[]) <> 0 then
         ATagVar[strval(ct)] = strip_quotes([])
         Quitloop
      ENDIF
      DOWN
      Endwhile
      Down
      IF SEARCH(" TO ",[]) <> 0 then
         pos.1 =  Search(" To ",[]) 
         AToVar[strval(ct)] = Substr([],pos.1 +4,len([]))
         DOWN
      ENDIF
ENDIF
If SEARCH("ENDDIALOG",[]) <> 0 then
ENDVAR = true
Endif 
Endwhile
Dynarray Accept_array[]
For x from 1 to dynarraysize(Atagvar)
; Check length
If len(typevar[strval(x)]) > 10 then
   typevar[strval(x)] = Substr(typevar[strval(x)],1,10)
Endif   
If len(atagvar[strval(x)]) > 18 then
   atagvar[strval(x)] = Substr(atagvar[strval(x)],1,18)
Endif   
; load array
Accept_array[strval(x)] = Typevar[strval(x)] + SPACES(12-LEN(typevar[strval(x)]))
                     + Atagvar[strval(x)] + SPACES(18-LEN(Atagvar[strval(x)]))
                     +Atovar[strval(x)]  
Endfor                  

ENDPROC ; <-- Get_accept_line_info
Writelib libname Get_accept_line_info


Proc Get_Checkbox_info(tablename.a,linenum)
PRIVATE Tablename.a
       ,linenum
       ,CBTagvar
       ,CBnamevar
       ,CBToVar
       ,CBidvar
       ,CT
       ,CT1
       ,Endvar
       
Message "Searching for CHECKBOXES Information"
Dynarray CBTagvar[]    ; TAG
Dynarray CBnamevar[]    ; Checkbox name for a var
Dynarray CBToVar[]     ; TO
Dynarray CBidvar[]     ;
Checkbox.val = false
Moveto tablename.a
Moveto[text]
Moveto record numval(Linenum)
Endvar = false
CT =0
ct1=0
While (Endvar <> true)
Down
IF SEARCH(" CHECKBOXES ",[]) <> 0 then
      
      CT = CT +1
      Type.1  = "CHECKBOXES"
      Down
       Tag.a = strip_quotes([])  ; tag
      Down
      While true
      IF SEARCH(" TO ",[]) <> 0 then
         CT1 = CT1 +1
         CBTAGVAR[strval(ct1)] = tag.a
         Pos.1 = Search(" TO ",[])
         CBnamevar[strval(ct1)] = Strip_quotes(substr([],1,pos.1))
         CBTOvar[strval(ct1)] = strip_quotes(Substr([],pos.1+4,len([])))
         Down
      ELSE
        Quitloop
      ENDIF
      EndWhile
 ENDIF
If SEARCH("ENDDIALOG",[]) <> 0 then
ENDVAR = true
Endif 
Endwhile

Error.3 = false  ; set 

Dynarray CB_array[]
For x from 1 to dynarraysize(CBnamevar)
; check length
If len(CBtagvar[strval(x)]) > 20 then
   CBtagvar[strval(x)] = Substr(CBtagvar[strval(x)],1,20)
Endif   
If len(CBnamevar[strval(x)]) > 25 then
   CBnamevar[strval(x)] = Substr(CBnamevar[strval(x)],1,25)
Endif   

CB_array[strval(x)] = CBtagvar[strval(x)] + SPACES(20-LEN(CBtagvar[strval(x)]))
                     + CBnamevar[strval(x)] + SPACES(25-LEN(CBnamevar[strval(x)]))
                     + " "
                     +CBtovar[strval(x)]  
Endfor                  
  
ENDPROC ; <--- Get_CheckboX_info
Writelib libname Get_CheckboX_info


PROC Get_Radiobutton_info(tablename.a,linenum)
PRIVATE tablename.a
       ,Linenum
       ,RBTagvar
       ,RBtoVar
       ,RBidvar
       ,RBnamevar
       ,Endvar
       ,CT
       ,CT1
       ,tag.a
       ,CTX
       ,Pos.1
       ,p.1
Message "Searching for RADIOBUTTON information"
Dynarray RBTagvar[]    ; TAG
Dynarray RBnamevar[]   ; Radiobutton name for a var
Dynarray RBToVar[]     ; TO
Dynarray RBidvar[]     ;
Radiobutton.val = false
Moveto tablename.a
Moveto[text]
Moveto record numval(Linenum)
Endvar = false
CT =0
ct1=0
rbtag.1 = 0
rbto.1 = 0
While (Endvar <> true)
Down
IF SEARCH("RADIOBUTTONS",[]) <> 0 then
      CT = CT +1
      Type.1 = "RADIOBUTTONS"
      Radiobutton.val = true
      Down
      While true
        ct1 = ct1+1
        RBnamevar[strval(ct1)] = Strip_quotes([])
        Down
        If Search(" TAG ",[]) <> 0 then
          Quitloop
        Endif
      Endwhile
      IF SEARCH(" TAG ",[]) <> 0 then
         tag.a = strip_quotes([])
         rbtag.1 = rbtag.1 + 1
         For ctx from 1 to ct1
         RBTAGVAR[strval(ctx)] = tag.a
         Endfor
      Endif   
      Down
      IF SEARCH(" TO ",[]) <> 0 then
         rbto.1 = rbto.1 +1
         Pos.1 = Search(" TO ",[])
         p.1 = Strip_quotes(substr([],pos.1+4,Len([])))
         For ctx from 1 to ct1
         RBTOvar[strval(ctx)] = strval(ctx)+spaces(3-len(ctx)) + "    "+ p.1 
         Endfor
      ENDIF
 ENDIF
If SEARCH("ENDDIALOG",[]) <> 0 then
ENDVAR = true
Endif 
Endwhile
Error.4 = false

Dynarray RB_array[]
For x from 1 to dynarraysize(RBtagvar)
; check length
If len(RBtagvar[strval(x)]) > 20 then
   RBtagvar[strval(x)] = Substr(RBtagvar[strval(x)],1,20)
Endif   
If len(RBnamevar[strval(x)]) > 20 then
   RBnamevar[strval(x)] = Substr(RBnamevar[strval(x)],1,20)
Endif   

RB_array[strval(x)] = RBtagvar[strval(x)] + SPACES(20-LEN(RBtagvar[strval(x)]))
                     + RBnamevar[strval(x)] + SPACES(20-LEN(RBnamevar[strval(x)]))
                      +RBTOvar[strval(x)]  
Endfor                    
ENDPROC ; <--- Get_Radiobutton_info
Writelib libname Get_Radiobutton_info
;---------------------------------------
;  Gets Variables from Dbox
;  ?? Varname or ?? Sdir()
;  It will ignore text such as ?? "Text Example"
;-----------------------------------
 PROC Get_dialogBox_variables(tablename.a,linenum)
 Private ct
 Message "Searching for Variable Information"
Dynarray VarVar[]    ; Variable
Moveto tablename.a
Moveto[text]
Moveto record numval(Linenum)  ; moveto Showdialog selected
Endvar = false
CT =0
While (Endvar <> true)
Down
IF SEARCH(" ?? ",[]) <> 0 then   
       ; check to see if ?? "Text" or ?? variable
     Pos.1 = Search("\"",[])  ; test for quotes
     Pos.2 = Search("??",[])   ; position of ??
     IF Pos.1 = 0 then   ; no quotes in string
       ct = ct +1
       Type.1 = "Variables"
       VarVar[strval(ct)] = Strip_quotes(Substr([],pos.2+2,len([])))
         Pos.3 = Search(";",VarVar[strval(ct)])
         If pos.3 <> 0 then
            VarVar[strval(ct)] = Substr(varvar[strval(ct)],1,pos.3-1)
         Endif   
     Endif
     DOWN
ENDIF             
If SEARCH("ENDDIALOG",[]) <> 0 then
ENDVAR = true
Endif 
Endwhile
ENDPROC ;--- Get_dialogBox_variables(tablename.a,linenum)
Writelib "dboxlib"  Get_dialogBox_variables
;------------------------------------------------------------------
; This hgets PICKlist variables
PROC Get_Pick_functions(tablename.a,linenum)
 Private ct
         ,pickval
         ,picktag
         ,pickto
         ,x1
         ,pos.1
         ,pos.2

MESSAGE "Searching for PICKLIST information"         
MOVETO tablename.a
MOVETO[text]
MOVETO RECORD Numval(linenum)
Dynarray pickval[]
Dynarray picktag[]
Dynarray Pickto[]
CT = 0
Exitloop = false
While Exitloop <> true
 DOWN
 IF SEARCH("PICK",[]) <> 0 then
      CT = CT + 1
      Got_to_val = 0
      IF SEARCH("PICKFILE",[]) <> 0
       Then pickval[strval(ct)] = "PICKFILE"
      ENDIF
      IF SEARCH("PICKTABLE",[]) <> 0
       Then pickval[strval(ct)] = "PICKTABLE"
      ENDIF
      IF SEARCH("PICKARRAY",[]) <> 0
       Then pickval[strval(ct)] = "PICKARRAY"
      ENDIF
      IF SEARCH("PICKDYNARRAY",[]) <> 0
       Then pickval[strval(ct)] = "PICKDYNARRAY"
      ENDIF
      IF SEARCH("PICKDYNARRAYINDEX",[]) <> 0
       Then pickval[strval(ct)] = "PICKDYNARRAYINDEX"
      ENDIF 
      
  DOWN
    While true
       Pos.1 = SEARCH(" TAG ",[]) 
       IF Pos.1  <> 0 then
            pos.2 =  SEARCH(" TO ",[]) 
             If pos.2 = 0 then
                Pos.2 = len([])
                Picktag[strval(ct)] = Strip_quotes(substr([],pos.1+4,pos.2))
             Else
               Picktag[strval(ct)] = Strip_quotes(substr([],pos.1+4,pos.2))
               Pickto[strval(ct)] = Strip_quotes(substr([],pos.2+3,len([])))
               Got_to_val = 1
               quitloop
             Endif    
             Quitloop
         Else
             Down
         Endif  
     Endwhile     
     DOWN
     IF Got_to_val = 0 then
             pos.2 =  SEARCH(" TO ",[]) 
            Pickto[strval(ct)] = Strip_quotes(substr([],pos.2+3,len([])))
     Endif       
 ENDIF 
 IF SEARCH("ENDDIALOG",[]) <> 0 then
    Exitloop = true
 Endif
 ENDWHILE
  Dynarray Pick_array[]
  For x1 from 1 to dynarraysize(pickval)
     Pick_array[strval(x1)] = pickval[strval(x1)] + spaces(20-len(pickval[strval(x1)]))
                             +picktag[strval(x1)] +spaces(20-len(picktag[strval(x1)]))
                             + " "+pickto[strval(x1)]
  Endfor                            

 ENDPROC    
Writelib libname  Get_Pick_functions

;------------------------------------------------------------
; This produces a dialog box explaning what the potential format 
; problem was
;
  PROC DboxExplane()
     ; PaintPAL_Generated_Code_Begin(451412185)

     SHOWDIALOG "Explanation of Problem"
        @1,3 HEIGHT 19 WIDTH 67

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 112 1,3,1,59
        @1,3
        ?? "A Dialog box had a format that this Utility can't read."
        PAINTCANVAS ATTRIBUTE 112 1,3,1,59
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 112 3,2,4,61
        @3,2
        ?? "The format that this Utility is setup to read ,is like the"
        @4,2
        ?? "example below..."
        PAINTCANVAS ATTRIBUTE 112 3,2,4,61
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 8,2,8,17
        @8,2
        ?? "TAG \"Tag1\""
        PAINTCANVAS ATTRIBUTE 113 8,2,8,17
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 9,2,9,12
        @9,2
        ?? "TO varname"
        PAINTCANVAS ATTRIBUTE 113 9,2,9,12
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 7,2,7,16
        @7,2
        ?? "VALUE Valuevar"
        PAINTCANVAS ATTRIBUTE 113 7,2,7,16
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 112 11,11,11,52
        @11,11
        ?? " It is not setup to handle formats like.."
        PAINTCANVAS ATTRIBUTE 112 11,11,11,52
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 12,10,12,52
        @12,10
        ?? "VALUE Valuevar  TAG \"tag1\" TO Varname"
        PAINTCANVAS ATTRIBUTE 113 12,10,12,52
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 5,2,5,19
        @5,2
        ?? "PUSHBUTTON @10,10"
        PAINTCANVAS ATTRIBUTE 113 5,2,5,19
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 113 6,2,6,12
        @6,2
        ?? "\"Pushme\""
        PAINTCANVAS ATTRIBUTE 113 6,2,6,12
        ; PaintPAL_Static_Text_End

        ; PaintPAL_Static_Text_Begin
        PAINTCANVAS FILL " " ATTRIBUTE 112 10,8,10,55
        @10,8
        ?? "It reads PaintPAL generated Information easily."
        PAINTCANVAS ATTRIBUTE 112 10,8,10,55
        ; PaintPAL_Static_Text_End

        PAINTCANVAS ATTRIBUTE 126 10,17,10,24

        PUSHBUTTON @14,18 WIDTH 10
           "Ok"
           OK
           DEFAULT
           VALUE "YES"
           TAG "OKTAG"
           TO YESVAR
     ENDDIALOG

     ; PaintPAL_Generated_Code_End(451412185)
  ENDPROC
 Writelib "dboxlib" dboxexplane
;-------------------------------------------------------------
; DboxErrorHandler
;
; Given that the format may be different
; this Errorhandler with detect unassigned variables that will arise
; if TAG "Tag1" TO var formats are used and not
; TAG "tag1"
; TO var
;
PROC DboxErrorhandler()
Private Errorproc
       , Errorx
      
       Errorinfo to Errorx
       
       Return.a = 0 
      
      If Errorx["CODE"] = 43 OR
        Errorx["MESSAGE"] = "Printer not ready" then
        Sound 400 100 Sound 500 100
        Message "Printer not Responding - Cancelling Operation" sleep 1000
        Printtest = 1
        Return.a = 1
      Endif  
      
      IF Errorx["CODE"] = 34 OR
       Search("Run error:",Errorx["MESSAGE"]) <> 0 then
         Sound 400 100 Sound 500 100
 Message errormessage()+ " Line "+strval(errorx["LINE"])+ "   << Operation will Continue >>"
         
         Sleep 1000
         
         IF ToScreen = "Yes" Or ToFile = "Yes" then
         Print file filename.a " ERROR  -- Unable to read format of "+type.1+" \n"
         Endif
         
         If ToPrint = "Yes" then
         PRINT "ERROR -- Unable to read format of "+type.1+" \n"
         Endif
         
         MessageFlag = "Yes" ; error info dbox
         Return.a = 1
       Endif  
       Return Return.a
 ENDPROC   
 Writelib Libname dboxErrorhandler 

Proc Errormessage.1(Error.a,type.2)
 If Error.a then
 PRINT  "Error with "+type.2+" \n"
 MessageFlag = "Yes"
 Endif
Endproc
Writelib libname Errormessage.1 

Proc Errormessage.2(Error.a,type.2)
 If Error.a then
  PRINT FILE Filename.a "Error with "+type.2+" \n"
 MessageFlag = "Yes"
 Endif
Endproc
Writelib libname Errormessage.2 
; ----------------------------------------------------------------
;
; Prints out all information on Dialog boxs on
; Selected Script
Proc Print_all_dbox_info(tablename.a,Scriptname,Arrayname,dboxname)

Private Scriptname
       ,Arrayname   ; name of array containg linenumer
       ,dboxname    ;  dialogbox header
  IF NOT PRINTERSTATUS() THEN
      Sound 400 100 Sound 500 100 
      Message "Printer not Ready"
      sleep 1000
      DELETE Tablename.a
      QUIT
ENDIF

 OPEN PRINTER

PRINT  "   \n"
IF Printtest = 1 then ; test if Error procedure has been called
Delete tablename.a
QUIT                  ; PRINTerstatus not reliable in some cases
Endif
PRINT "        DboxChecker Ver 1.0  \n"
PRINT "        Date : "+strval(today())+ " Time : "+strval(time())+"\n"
PRINT "        Dialog Box Information \n"
PRINT " \n"

tot = Arraysize(arrayname)
FOR Loop_count from 1 to tot

selected_dbox = arrayname[Loop_count]       
Get_Pushbutton_info(tablename.a,selected_dbox)
Get_accept_line_info(tablename.a,selected_dbox)
Get_checkbox_info(tablename.a,selected_dbox)
Get_Radiobutton_info(tablename.a,Selected_dbox)
Get_Pick_functions(tablename.a,Selected_dbox)
Get_dialogBox_variables(tablename.a,Selected_dbox)
Message "Printing Dialog box information for box at line "+selected_dbox 

PRINT  "===================================================================== \n"
PRINT  "                SCRIPT : "+Scriptname +" \n"
PRINT  "                  LINE : "+Selected_dbox+"0\n"
PRINT  "        DialogBox Name : "+ dboxname[Loop_count]+" \n"
PRINT  "   Dialog Box Procedure: "+Procname[strval(loop_count)]+"\n"
IF ISASSIGNED(Pushbutton_array) then
IF dynarraysize(pushbutton_array) <> 0 then
  PRINT  "      \n"
  PRINT  "  PUSHBUTTONS \n"
  PRINT  "   \n"
  PRINT  "  Title.            Value.                Tag.                To." 
  PRINT  "     \n"
  Errormessage.1(Error.1,"PUSHBUTTON")
  FOR ct from 1 to dynarraysize(Pushbutton_array)
     PRINT  "  "+Pushbutton_array[strval(ct)]+"\n"
  ENDFOR
  PRINT  " \n"
Endif
ENDIF  

IF ISASSIGNED(Accept_array) then
IF Dynarraysize(Accept_array) <> 0 then
  PRINT  "  ACCEPT Lines \n"
  PRINT  "   \n"
  PRINT  "  Title.             Value.              Tag."
  PRINT  " \n"
  ;Errormessage.1(Error.2,"ACCEPT")
  FOR ct from 1 to dynarraysize(Accept_array)
     PRINT  "  "+Accept_array[strval(ct)]+" \n"
  ENDFOR
Endif
ENDIF

IF ISASSIGNED(CB_array) then
If dynarraysize(CB_array) <> 0 then
  PRINT  " \n"
  PRINT  "  CHECKBOXES \n"
  PRINT  "   \n"
  PRINT  "  Tag                 Title                   To "
  PRINT  " \n"
  Errormessage.1(Error.3,"CHECKBOXES")
  FOR ct from 1 to dynarraysize(CB_array)
    PRINT  "  "+CB_array[strval(ct)]+"\n"
  ENDFOR
Endif  
ENDIF

IF ISASSIGNED(RB_array) then
If Dynarraysize(RB_array) <> 0 then
  PRINT  " \n"
  PRINT  "  RADIOBUTTONS \n"
  PRINT  "   \n" 
  PRINT  "  Tag                  Title              Num    To\n"
  Errormessage.1(Error.4,"RADIOBUTTONS")
  FOR ct from 1 to dynarraysize(RB_array)
     PRINT  "   "+RB_array[strval(ct)]+"\n"
  ENDFOR
 Endif  
ENDIF  
IF ISASSIGNED(Pick_array) then
If Dynarraysize(pick_array) <> 0 then
  PRINT  " \n"
  PRINT  "  PICKLISTS \n"
  PRINT  "   \n" 
  PRINT  "  Picklist                TAG                      TO\n"
  
  FOR ct from 1 to dynarraysize(pick_array)
     PRINT  "   "+pick_array[strval(ct)]+"\n"
  ENDFOR
 Endif  
ENDIF  


IF ISASSIGNED(VarVar) then  
 If dynarraysize(VarVar) <> 0 then
  PRINT  " \n"
  PRINT  "  VARIABLES \n"
  PRINT  "   \n"
  FOR ct from 1 to dynarraysize(Varvar)
     PRINT  "   "+Varvar[strval(ct)]+" \n"
  ENDFOR
 Endif 
ENDIF  
  
  PRINT  " \n"
  ; Clean house for next dialog box
  RELEASE VARS Pushbutton_array
  RELEASE VARS Accept_array
  RELEASE VARS CB_ARRAY
  RELEASE VARS RB_array
  RELEASE VARS VarVar
  RELEASE VARS selected_dbox
ENDFOR
CLOSE Printer
ENDPROC ; <--- Print_all_dbox_info
Writelib libname Print_all_dbox_info  
;----------------------------------------
Proc Send_all_dbox_info(tablename.a,Scriptname,Arrayname,dboxname,filename.a)
Private Scriptname
       ,Arrayname   ; name of array containg linenumer
       ,dboxname    ;  dialogbox header
     
IF NOT Isassigned(filename.a)  then
Filename.a = "Dboxfile.sc"
Endif

PRINT FILE Filename.a  "        DboxChecker Ver 1.0  \n"
PRINT FILE Filename.a  "        Date : "+strval(today())+ " Time : "+strval(time())+"\n"
PRINT File Filename.a  "        Dialog Box Information \n"
PRINT File Filename.a  " \n"
tot = Arraysize(arrayname)
FOR Loop_count from 1 to tot

selected_dbox = arrayname[Loop_count]       
Message "Count : "+strval(Loop_count)+" of "+strval(arraysize(arrayname))+" Line : "+ arrayname[loop_count]

Get_Pushbutton_info(tablename.a,selected_dbox)
Get_accept_line_info(tablename.a,selected_dbox)
Get_checkbox_info(tablename.a,selected_dbox)
Get_Radiobutton_info(tablename.a,Selected_dbox)
Get_Pick_functions(tablename.a,Selected_dbox)
Get_dialogBox_variables(tablename.a,Selected_dbox)
Message "Sending  Dialog box information at line "+selected_dbox+" to "+filename.a 


PRINT FILE Filename.a  "==================================================================== \n"
PRINT FILE Filename.a  "                SCRIPT : "+Scriptname +" \n"
PRINT FILE Filename.a  "                  LINE : "+Selected_dbox+" \n"
PRINT FILE Filename.a  "        DialogBox Name : "+ dboxname[Loop_count]+" \n"
PRINT FILE Filename.a  "   Dialog Box Procedure: "+Procname[strval(loop_count)]+"\n"

IF ISASSIGNED(Pushbutton_array) then
 
  PRINT FILE Filename.a  "      \n"
  PRINT FILE Filename.a  "  PUSHBUTTONS \n"
  PRINT FILE Filename.a  "   \n"
  PRINT FILE Filename.a  "  Title.             Value.               Tag.               To." 
  PRINT FILE Filename.a  "     \n"
  Errormessage.2(Error.1,"PUSHBUTTONS")
  FOR ct from 1 to dynarraysize(Pushbutton_array)
     PRINT FILE Filename.a  "  "+Pushbutton_array[strval(ct)]+"\n"
  ENDFOR
  PRINT FILE Filename.a  " \n"
ENDIF  

IF ISASSIGNED(Accept_array) then
IF Dynarraysize(Accept_array) <> 0 then
  PRINT FILE Filename.a  "  ACCEPT Lines \n"
  PRINT FILE Filename.a  "   \n"
  PRINT FILE Filename.a  "  Type        Tag               To"
  PRINT FILE Filename.a  " \n"
 ; Errormessage.1(Accept_array,Accept.val,"ACCEPT")
  FOR ct from 1 to dynarraysize(Accept_array)
     PRINT FILE Filename.a  "  "+Accept_array[strval(ct)]+" \n"
  ENDFOR
Endif
ENDIF

IF ISASSIGNED(CB_array) then
If dynarraysize(CB_array) <> 0 then
  PRINT FILE Filename.a  " \n"
  PRINT FILE Filename.a  "  CHECKBOXES \n"
  PRINT FILE Filename.a  "   \n"
  PRINT FILE Filename.a  "  Tag                 Title                   To "
  PRINT FILE Filename.a  " \n"
  Errormessage.2(error.3,"CHECKBOXES")
  FOR ct from 1 to dynarraysize(CB_array)
    PRINT FILE Filename.a  "  "+CB_array[strval(ct)]+"\n"
  ENDFOR
Endif  
ENDIF

IF ISASSIGNED(RB_array) then
If Dynarraysize(RB_array) <> 0 then
  PRINT FILE Filename.a  " \n"
  PRINT FILE Filename.a  "  RADIOBUTTONS \n"
  PRINT FILE Filename.a  "   \n" 
  PRINT FILE Filename.a  "  Tag                 Title              Num     To\n"
  Errormessage.2(Error.4,"RADIOBUTTONS")
  FOR ct from 1 to dynarraysize(RB_array)
     PRINT FILE Filename.a  "   "+RB_array[strval(ct)]+"\n"
  ENDFOR
 Endif  
ENDIF  
IF ISASSIGNED(Pick_array) then
If Dynarraysize(pick_array) <> 0 then
  PRINT FILE filename.a  " \n"
  PRINT FILE filename.a  "  PICKLISTS \n"
  PRINT FILE filename.a  "   \n" 
  PRINT FILE filename.a  "  Picklist                TAG                      TO\n"
  
  FOR ct from 1 to dynarraysize(pick_array)
     PRINT FILE filename.a  "   "+pick_array[strval(ct)]+"\n"
  ENDFOR
 Endif  
ENDIF  

IF ISASSIGNED(VarVar) then  
 If dynarraysize(VarVar) <> 0 then
  PRINT FILE Filename.a  " \n"
  PRINT FILE Filename.a  "  VARIABLES \n"
  PRINT FILE Filename.a  "   \n"
  FOR ct from 1 to dynarraysize(Varvar)
     PRINT FILE Filename.a  "   "+Varvar[strval(ct)]+" \n"
  ENDFOR
 Endif 
ENDIF    
  PRINT FILE Filename.a  " \n"
  ; Clean house for next dialog box
  RELEASE VARS Pushbutton_array
  RELEASE VARS Accept_array
  RELEASE VARS CB_ARRAY
  RELEASE VARS RB_array
  RELEASE VARS VarVar
  RELEASE VARS selected_dbox

ENDFOR
ENDPROC ; <--- Send_all_dbox_info
Writelib libname Send_all_dbox_info  
;------------------------------------------------------------------
; Dialog box procedure for Option_box
PROC Dboxproc(ttype,tag.a,ev,ch)
  IF ttype = "UPDATE" AND Tag.a = "OK.tag" then
       IF All_option.var <> 1 then   ; not going to the printer
             IF isblank(Filename.a) then
                Sound 500 100 Sound 600 100
                Message "You must enter a File name"
                SELECTCONTROL "File.tag"
                Return false
             ENDIF
             If LEN(Filename.a) > 8 then
                Sound 500 100 Sound 600 100
                 message "File name is to long"
                SELECTCONTROL "File.tag"
                Return false
             Endif
             If Search(".",Filename.a) <> 0 then
                Sound 400 100 Sound 500 100
                message "File name cannot have an extension"
              SELECTCONTROL "File.tag"
              Return false
             Endif
             Filename = Filename.a + ".sc"
             If isfile(filename) then
              While true
               Sound 500 100 Sound 600 100
               Showpopup "Fix Duplicate Filename" Centered
              "INSERT":"Insert Generated Code into this file":"INS.a",
              "OVERWRITE":"Overwrite File":"OVR.a",
              "RENAME":"Rename new file":"REN.a"
              Endmenu
              To menusel
              If Not Retval then
               quitloop
              Endif
              Switch
                case menusel = "OVR.a":
                  ; ECHO OFF
                   menu{TOOLS}{DELETE}{Script}
                   SELECT Filename.a 
                   IF MenuChoice() = "Cancel" THEN
                    {Ok}
                   ENDIF
                  ; ECHO NORMAL
                Case menusel = "REN.a":
                   SELECTCONTROL "File.tag"
                   Return false
                case menusel = "INS.a":
                     message "Code will be inserted into ",Script.var
                Endswitch
               Quitloop
              Endwhile
            Endif
     ENDIF
     ENDIF
     Return true
 ENDPROC
 Writelib libname Dboxproc           
;---------------------------------------------------------------
; Option_dbox
; Presents options to user
; Print File Screen
;
PROC Option_dbox()
  Filename.a = "Dboxfile"
  All_option.var = 3
  ; PaintPAL_Generated_Code_Begin(451458521)

  SHOWDIALOG ""
     PROC "Dboxproc"
     TRIGGER "ALL"
     @4,5 HEIGHT 10 WIDTH 66

     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 1,5 TO 5,59
     PAINTCANVAS ATTRIBUTE 112 1,5,1,59
     PAINTCANVAS ATTRIBUTE 127 5,5,5,59
     PAINTCANVAS ATTRIBUTE 112 1,5,5,5
     PAINTCANVAS ATTRIBUTE 127 1,59,5,59
     ; PaintPAL_Frame_End

     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 2,23 TO 4,58
     PAINTCANVAS ATTRIBUTE 127 2,23,2,58
     PAINTCANVAS ATTRIBUTE 112 4,23,4,58
     PAINTCANVAS ATTRIBUTE 127 2,23,4,23
     PAINTCANVAS ATTRIBUTE 112 2,58,4,58
     ; PaintPAL_Frame_End

     ; PaintPAL_Static_Text_Begin
     PAINTCANVAS FILL " " ATTRIBUTE 116 0,27,0,34
     @0,27
     ?? "Options"
     PAINTCANVAS ATTRIBUTE 116 0,27,0,34
     ; PaintPAL_Static_Text_End

     RADIOBUTTONS @2,7 HEIGHT 3 WIDTH 13
        "Printer",
        "File",
        "Screen"
        TAG "Option.tag"
        TO All_Option.var

     ACCEPT @3,37 WIDTH 20
        "A25"
        TAG "File.tag"
        TO Filename.a

     LABEL @3,25
        "Filename :"
        FOR "File.tag"

     PUSHBUTTON @6,24 WIDTH 10
        "Ok"
        OK
        DEFAULT
        VALUE "YES"
        TAG "OK.tag"
        TO OK.var
  ENDDIALOG
    Filename.a = filename.a + ".sc"    
ENDPROC ; <--- Option_dbox
Writelib libname Option_dbox

;-------------------------------------------------------------
;  Main Procedure 
;
PROC GET_and_Display_dbox_info()
; Variable cleanup
Private tablename.a
        ,Errorproc
        ,SElected_dbox
        ,Script.1
        ,CB_Array
        ,RB_Array
        ,Pushbutton_array
        ,name.1
        ,Accept_Array
        ,YESval
        ,DYN_PUSH.var
        ,p.2
        ,tag.a
        ,CBvar
        ,Pos.1
        ,procname
        ,x
        ,Accept.val
        ,ct
        ,Donewith
        ,Yes.val
        ,String.1
        
        
IF SYSMODE() <> "Main" then
Sound 400 100 Sound 500 100
Quit "You must be in Main mode"
Endif

ToScreen = "No"  ;These flags are to
ToFile = "No"    ; allow an explanation dbox to appeer
ToPrint = "No"   ; if problems occur
; Gen Flag
Printtest = 0 
PrintALL = 0
MessageFlag = "No"



 Errorproc = "dboxErrorhandler"

Get_Script()
Get_dbox_to_load(script.1)
Option_dbox()
Switch
   Case  All_Option.var = 1 :   ; Print
     ToPrint = "Yes"
     Print_all_dbox_info(tablename.a,Script.1,Dbox_names,Name.1,)
     Delete tablename.a
   Case All_option.var = 2:      ; to File
     ToFile = "Yes"
     Send_all_dbox_info(Tablename.a,Script.1,dbox_names,Name.1,Filename.a) 
     Delete tablename.a
  Case All_option.var = 3:      ; Screen
     ToScreen = "Yes"
     Send_all_dbox_info(Tablename.a,Script.1,dbox_names,Name.1,filename.a) 
     Delete tablename.a
Endswitch  



IF MessageFlag = "Yes" then
   Sound 400 100 Sound 500 100
   Message  "Due to incompatible formats, information is incomplete"
   Dboxexplane()
Endif

If ToScreen = "Yes" then
 Editor Open Filename.a
 Quit
Endif 

If ToPrint = "Yes" then
Sound 400 100 Sound 500 100
Quit "Information at Printer"
Endif

If ToFile = "Yes" then
Sound 400 100 Sound 500 100
Quit "Task Completed"
Endif

ENDPROC ; <--- Get_and_display_dbox_info
Writelib libname Get_and_display_dbox_info
;----------------------------------------
; Setkey Alt D

Setkey -32 Get_and_display_dbox_info()

Autolib = "dboxlib"
Get_and_display_dbox_info()
