;       Graphics demo script for Paradox "PAL" - David C. Brink, February 1992.



PROC Call (Argument);                                 Run a standalone command.
  RUN NOREFRESH NORESTORE NOSHELL Argument
ENDPROC


PROC Batch(Argument);                                         Run a batch file.
  RUN NOREFRESH NORESTORE Argument
ENDPROC


;                                           Graphics-mode string input routine.
PROC GrfInp(Position)
  ANS = "";                               Clear work area to hold input string.
  KVAL = CHR(GETCHAR());                             Get first input keystroke.
  WHILE KVAL <> CHR(13);                              Do until carriage return.
    IF KVAL = CHR(8) THEN
      Call ("GSay /B:7 '"+KVAL+" ';");     Backspace: white out current column.
      ANS = SUBSTR(ANS,1,(LEN(ANS) - 1));                   Shorten the string.
    ELSE
      ANS = ANS + KVAL;                     Otherwise add keystroke to the end.
    ENDIF
    Call ("GSay " + Position + "'" + ANS + "';");   Display the updated string.
    KVAL = CHR(GETCHAR());                              Get the next keystroke.
  ENDWHILE
  Call ("VidInt 3");                                       Return to text mode.
  @ 24,11;                               Cursor movement forces screen refresh.
ENDPROC


;                      1) Pannable images, including full page document (MSDS);
PROC Pan ()
  Call ("Exhibit /P /Q /T:3 HANCOCK.GIF")
  Call ("Exhibit /P /Q /T:3 SAFETY.GIF")
ENDPROC


;                          2) Full-screen 256-color pictures, with key confirm;
PROC Big ()
  Call ("Exhibit /Q /T:4 CHEETAH.GIF")
  Call ("Exhibit /Q /K /T:4 FROG.GIF")
ENDPROC


;               3) Reduced full page document, with slow fade and string input;
PROC Mini ()
  Call ("Photo /B /D:3 /G /R SAFETY.GIF")
  Call ("GSay /B:0 /F:15 /H:11 /L:20 /V:20 'Enter your first name: ';")
  GrfInp("/H:34 /V:20 ");          Get user string input & return to text mode.
  Call ("GSay /B:7 /F:0 /T:2 /H:11 /V:24 'Your first name is "+ ANS+".';")
  @ 24,11 ?? "                                                            "
ENDPROC





;                                        4) Timed miniature 256-color pictures;
PROC Small ()
;                                                   Dummy PIPE lets us run VCR
;                                                          twice, remaining in
  Batch("VCR /R /T:4 FROG.GIF | VCR /T:4 CHEETAH.GIF");          graphics mode.
;                                                              DOS treats this
;                                                     like an in-line BAT file.
ENDPROC


;             5) Mixed color and gray-scale images, including signature window;
PROC Sign ()
  Batch("SIGN FROG.GIF FROG.GIF CHEETAH.GIF CHEETAH.GIF HANCOCK.GIF")
ENDPROC


;              6) Rescaled cheetahs, converted to 16 colors, with string input;
PROC Cats ()
  Call ("Exhibit /E /R CHEETAH.GIF")
  Call ("GSay  /B:15 /F:0 /H:57 /V:7 '   Full Size   ';")
  Call ("Photo /A /H:05 /R /V:35 CHEETAH.GIF")
  Call ("GSay  /B:15 /F:0 /H:17 /V:7 '  One Quarter  ';")
  Call ("Photo /N /H:55 /R /S /V:270 CHEETAH.GIF")
  Call ("GSay  /B:15 /F:0 /H:57 /V:19 /T:1 ' One Sixteenth ';")
  Call ("GSay  /F:15 /B:0 /H:11 /V:20 ' Enter your Last Name: ';")
  GrfInp("/H:33 /V:20 ");          Get user string input & return to text mode.
  Call ("GSay /B:7 /F:0 /T:2 /H:11 /V:24 'Your last name is "+ ANS+".';")
  @ 24,11 ?? "                                                           "
ENDPROC


;                                               7) Cycle through above options.
PROC All ()
  WHILE KVAL <> "N"
    Pan   ()
    Big   ()
    Mini  ()
    Small ()
    Sign  ()
    Cats  ()
    Call  ("GSay /B:0 /F:15 /H:21 /L:1 /T:4 /V:24 'Want to go again?';")
    KVAL = UPPER(CHR(GETCHAR()))
    @ 24,21 ?? "                   "
  ENDWHILE
ENDPROC

;                                                               Mainline logic.
CLEAR
@ 0, 3 ??  "               Database Graphics Toolkit (DGT) - Demo Disk"
@ 2, 3 ??  " Copyright (C) 1989-92, Blackhawk Data Corporation. All rights reserved."
@ 4, 3 ??  "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *"
@ 6, 8 ??  "1) Pannable images, including full page document (MSDS);"
@ 8, 8 ??  "2) Full-screen 256-color pictures, with key confirm;"
@ 10,8 ??  "3) Reduced full page document, with slow fade and string input;"
@ 12,8 ??  "4) Timed miniature 256-color pictures;"
@ 14,8 ??  "5) Mixed color and gray-scale images, including signature window;"
@ 16,8 ??  "6) Rescaled cheetahs, converted to 16 colors, with string input;"
@ 18,8 ??  "7) Cycle through above options."
@ 20,3 ??  "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *"
@ 22,11 ?? "Pick a number or type Q to QUIT: "
ANS  = ""
KVAL = ""
WHILE KVAL <> "Q"
  @ 22,44
  KVAL = UPPER(CHR(GETCHAR()))
  SWITCH
    CASE KVAL = "1":    Pan   ()
    CASE KVAL = "2":    Big   ()
    CASE KVAL = "3":    Mini  ()
    CASE KVAL = "4":    Small ()
    CASE KVAL = "5":    Sign  ()
    CASE KVAL = "6":    Cats  ()
    CASE KVAL = "7":    All   ()
  ENDSWITCH
ENDWHILE
RETURN


; When viewing multiple images, you may wish to use a batch file similar to the
; following, to make sure that successive iterations of the viewer programs
; (Exhibit, Photo and VCR) are always loaded at the same physical address:

; Text for SIGN.BAT:

;         @ECHO OFF
;         VCR /C /L /H:00 /R /V:000     %1
;         GSAY/F:1 /B:14 /H:08 /V:06 '  #1  ';
;         VCR /C /G /H:40 /R /V:000     %2
;         GSAY/F:2 /B:13 /H:66 /V:06 '  #2  ';
;         VCR /C /L /H:40 /R /V:200     %3
;         GSAY/F:4 /B:11 /H:66 /V:18 '  #3  ';
;         VCR /C /G /H:00 /R /V:200     %4
;         GSAY/F:5 /B:10 /H:08 /V:18 '  #4  ';
;         VCR /C /G /H:20 /R /V:145 /S  %5
;         GSAY/F:3 /B:12 /H:37 /V:14 '  #5  ';
;         VCR /T:5 /R
