/* Graphics demo for Microsoft QuickC - J Brink, Blackhawk Data Corp, 5/91 */
/* #include <stdio.h> */
#include <string.h>
#include <dGT.h>

char _far * response;
char temp[80];
char video [80];

void pan()	 /* 1) Pannable images, including full page document (MSDS); */
{
  EXHIBIT("/F:GIF /T:3 /P /Q /O:190583 DGTDEMO.EXE");
  EXHIBIT("/F:GIF /O:158720 /P /T:3 /Q DGTDEMO.EXE");
}			void pan();

void full()	     /* 2) Full-screen 256-color pictures, with key confirm; */
{
  EXHIBIT("/F:GIF /O:217182 /R /T:4 /Q DGTDEMO.EXE");
  EXHIBIT("/F:GIF /O:195222 /K /T:4 /Q DGTDEMO.EXE");
}			void full();

void mini()		 /* 3) Reduced document, with fade and string input; */
{
  PHOTO("/F:GIF /O:158720 /G /B /D:3 /R /Q DGTDEMO.EXE");
  response=GSAY("/B:0 /F:15 /G /H:11 /L:40 /T:5 /V:20 \'Enter your first name: \';");
  PHOTO("/D:3 /R");
  strcpy (temp,"/B:15 /F:0 /H:11 /L:40 /T:3 /V:24 \'Your first name is ");
  strncat(temp, response, strlen(response));
  strncat(temp,".\';",3);
  GSAY	 (temp);
  GSAY	 ("/B:15 /F:0 /H:11 /L:40 /V:24 \'                                                            \';");
}			void mini();

void small()			   /* 4) Timed miniature 256-color pictures; */
{
  strcpy (temp, video);
  strncat(temp," /F:GIF /O:195222 /T:4 /R /Q /V:26 DGTDEMO.EXE",46);
  VCR (temp);					      /* Display color frog. */
  strcpy (temp, video);
  strncat(temp," /F:GIF /O:217182 /T:4  /Q  /V:26  DGTDEMO.EXE",46);
  VCR (temp);					   /* Display color cheetah. */
}			void small();

void sign()			    /* 5) Mixed color and gray-scale images; */
{
  strcpy (temp, video);
  strncat(temp," /F:GIF /D:0 /L /Q /C /R /H:00 /V:00  /O:195222 DGTDEMO.EXE",59);
  VCR (temp);					      /* Display color frog. */
  GSAY("/F:1 /B:14 /H:08 /V:06 '  #1  ';");
  strcpy (temp, video);
  strncat(temp," /F:GIF /D:0 /G /Q /C /R /H:40 /V:00  /O:195222 DGTDEMO.EXE",59);
  VCR (temp);					       /* Display gray frog. */
  GSAY("/F:2 /B:13 /H:66 /V:06 '  #2  ';");
  strcpy (temp, video);
  strncat(temp," /F:GIF /D:0 /L /Q /C /R /H:40 /V:200 /O:217182 DGTDEMO.EXE",59);
  VCR (temp);					   /* Display color cheetah. */
  GSAY("/F:4 /B:11 /H:66 /V:18 '  #3  ';");
  strcpy (temp, video);
  strncat(temp," /F:GIF /D:0 /G /Q /C /R /H:00 /V:200 /O:217182 DGTDEMO.EXE",59);
  VCR (temp);					    /* Display gray cheetah. */
  GSAY("/F:5 /B:10 /H:08 /V:18 '  #4  ';");
  strcpy (temp, video);
  strncat(temp," /F:GIF /D:0 /G /Q /R /S /H:20 /V:145 /C /O:190583 DGTDEMO.EXE",64);
  VCR (temp);					       /* Display signature. */
  GSAY("/F:3 /B:12 /H:37 /V:14 '  #5  ';");
  VCR("/T:5 /R");					  /* Restore screen. */
}			void sign();

void cats()			 /* 6) Rescaled cheetahs, with string input; */
{
  EXHIBIT ("/F:GIF /O:217182 /E /R /Q DGTDEMO.EXE");
  GSAY("/B:15 /F:0 /H:57 /V:7 \'   Full Size   \';");
  PHOTO("/F:GIF /O:217182 /A /H:05 /V:35 /R /Q DGTDEMO.EXE");
  GSAY("/B:15 /F:0 /H:17 /V:7 \'  One Quarter  \';");
  PHOTO("/F:GIF /O:217182 /N /S /H:55 /V:270 /R /Q DGTDEMO.EXE");
  GSAY("/B:15 /F:0 /H:57 /T:2 /V:19 \' One Sixteenth \';");
  response=GSAY("/B:15 /F:0 /G /H:11 /L:40 /T:5 /V:19 \'Enter your last name: \';");
  EXHIBIT("/R");
  strcpy (temp,"/B:15 /F:0 /H:11 /L:40 /T:3 /V:24 \'Your last name is ");
  strncat(temp, response, strlen(response));
  strncat(temp,".\';",3);
  GSAY	 (temp);
  GSAY	 ("/B:15 /F:0 /H:11 /L:40 /V:24 \'                                                            \';");
}			void cats();

void main( int prmct,	char * parm[] )
{
  char choice;
  char done = 0;
  char _far * string;

  LASRTRAX(""); 		  /* Activate LasrTrax screen-print routine. */
  BLINK(" OFF");				    /* Disable screen blink. */
  CLRSC("240"); 			    /* Clear screen to bright white. */
  COLOR(",,15");			     /* Fix border (overscan) color. */
  if ( prmct > 1 )	    /* Get run-time command-line parameters, if any. */
    strcpy ( video, parm [1] );
  else
    strcpy ( video, " " );
  GSAY("/B:15 /F:0 /H:3 /V:00 \'                Database Graphics Toolkit (dGT) - Demo Disk         V3.00\';");
  GSAY("/B:15 /F:0 /H:3 /V:02 \'  Copyright (C) 1989-92, Blackhawk Data Corporation. All rights reserved.\';");
  GSAY("/B:15 /F:0 /H:3 /V:04 \'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\';");
  GSAY("/B:15 /F:0 /H:3 /V:06 \'     1) Pannable images, including full page document (MSDS);\';");
  GSAY("/B:15 /F:0 /H:3 /V:08 \'     2) Full-screen 256-color pictures, with key confirm;\';");
  GSAY("/B:15 /F:0 /H:3 /V:10 \'     3) Reduced full page document, with slow fade and string input;\';");
  GSAY("/B:15 /F:0 /H:3 /V:12 \'     4) Timed miniature 256-color pictures;\';");
  GSAY("/B:15 /F:0 /H:3 /V:14 \'     5) Mixed color and gray-scale images, including signature window;\';");
  GSAY("/B:15 /F:0 /H:3 /V:16 \'     6) Rescaled cheetahs, converted to 16 colors, with string input;\';");
  GSAY("/B:15 /F:0 /H:3 /V:18 \'     7) Cycle through above options.\';");
  GSAY("/B:15 /F:0 /H:3 /V:20 \'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\';");

  while( !done )					  /* Mainline logic */
  {
    string = GSAY("/B:15 /F:0 /G /H:11 /L:1 /U /V:22 \'Pick a number or type Q to QUIT:\';");
    choice = string[0];
    switch(choice)
    {
      case '1':
	pan();	 /* 1) Pannable images, including full page document (MSDS); */
	break;
      case '2':
	full();      /* 2) Full-screen 256-color pictures, with key confirm; */
	break;
      case '3':
	mini(); 	 /* 3) Reduced document, with fade and string input; */
	break;
      case '4':
	small();		   /* 4) Timed miniature 256-color pictures; */
	break;
      case '5':
	sign(); 		    /* 5) Mixed color and gray-scale images; */
	break;
      case '6':
	cats(); 		 /* 6) Rescaled cheetahs, with string input; */
	break;
      case '7':
	while(choice)			  /* 7) Cycle through above options. */
	{
	  pan();
	  full();
	  mini();
	  small();
	  sign();
	  cats();
	  string=GSAY("/F:15 /B:0 /G /H:21 /L:1 /T:5 /U /V:24 \'Want to go again? \';");
	  choice = strcmpi(string,"N");
	  GSAY("/B:15 /F:0 /H:21 /V:24 \'                    \';");
	}
	break;
      case 'Q':
	done=1;
	break;
    }
  }
  LASRTRAX(""); 			     /* Unload screen print utility. */
  VIDINT(" 3"); 				       /* Reset text screen. */
}
