*		      Graphics demo program for Clipper 5.0 - J Brink, May 1991.
*	 (Summer '87 usage is identical, except for minor cosmetic differences).

*					      Database Structure for GRAFIX.DBF:

*		KEY	   Character	10	    Record ID.
*		FORMAT	   Character	 3	    Image format.
*		SIZE	   Numeric     6,0	    Image size.
*		IMAGE	   Memo        [10]	    Physical image.


*		  Load an image into a memo field with code something like this:

*	DIR  = "H:\320X200\"
*	SEEK   SEARCHKEY			  //  Suppose SEARCHKEY = "FROG"
*	SPEC = DIR+KEY+"."+FORMAT	 //  SPEC might be "H:\320X200\FROG.GIF"
*	FIELD->IMAGE=MEMOREAD(SPEC)	   //  Copy image file directly to memo.
*	HNDL = FOPEN(SPEC,0)	      //  Open the file for low-level functions.
*	FIELD->SIZE=FSEEK(HNDL,0,2)  //  Jump to end of file to get true length.
*	HNDL = FCLOSE(HNDL)				 // Free up file handle.

*		Note - Clipper memo files are limited in size to 64K; to support
*		     larger images you will need an alternate memo-file handler,
*		       such as FlexFile(TM) from Ganahl Software (305/566-1796).

*		 Update - January 1992 - dGT can be overlaid with either Blinker
*		     or WarpLink -- see OVERLAY.DOC in the CLIPPER subdirectory.

*								 Initialization.

STATIC	PAN,	BIG,	MINI,	SMALL,	SIGN,	CATS,	SETUP
PUBLIC	HNDL,	OFS,	SIZ,	STRING, CHOICE, SPEC,	DONE:=.F.

*				      Open database - SHARED allows dual access.
USE    GRAFIX INDEX GRAFIX SHARED
*					Open database file for low-level access.
HNDL = FOPEN("GRAFIX.DBF",0)
SET    DEVICE TO SCREEN
SET    SCOREBOARD OFF
SET    STATUS OFF
SET    COLOR TO N/W,N/W,W
*								   Display menu.
CLEAR  SCREEN

@ 0, 0 SAY  "                  Database Graphics Toolkit (DGT) - Demo Disk"
@ 2, 0 SAY  "    Copyright (C) 1989-91, Blackhawk Data Corporation. All rights reserved."
@ 4, 0 SAY  "   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *"
@ 6, 0 SAY  "        1) Pannable images, including full page document (MSDS);"
@ 8, 0 SAY  "        2) Full-screen 256-color pictures, with key confirm;"
@ 10,0 SAY  "        3) Reduced full page document, with slow fade and string input;"
@ 12,0 SAY  "        4) Timed miniature 256-color pictures;"
@ 14,0 SAY  "        5) Mixed color and gray-scale images, including signature window;"
@ 16,0 SAY  "        6) Rescaled cheetahs, converted to 16 colors, with string input;"
@ 18,0 SAY  "        7) Cycle through above options."
@ 20,0 SAY  "   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *"

*								 Mainline logic.
Do WHILE .NOT. DONE
  CHOICE = GSAY("/B:7 /F:0 /G /H:11 /L:1 /T:5 /U /V:22 'Pick a number or type Q to QUIT: ';")
  Do CASE
    Case CHOICE = '1';		Do PAN
    Case CHOICE = '2';		Do BIG
    Case CHOICE = '3';		Do MINI
    Case CHOICE = '4';		Do SMALL
    Case CHOICE = '5';		Do SIGN
    Case CHOICE = '6';		Do CATS
    Case CHOICE = '7';		STRING = 'Y'
      Do WHILE STRING = 'Y'
	Do PAN; 		Do BIG; 		Do MINI
	Do SMALL;		Do SIGN;		Do CATS
	STRING = GSAY("/B:7 /F:0 /G /H:21 /L:1 /T:5 /U /V:24 'Want to go again? ';")
      ENDDO
    Case CHOICE = 'Q';		DONE = .T.
  ENDCASE
ENDDO
*					     End of job - do wrap-up processing.
SET    COLOR TO
CLEAR  SCREEN
CLOSE  ALL
RETURN


*								    Subroutines:

*			1) Pannable images, including full page document (MSDS);

STATIC PROCEDURE PAN
*					    Get database record and memo offset.
  Do SETUP with "HANCOCK", 20
*				      Invoke EXHIBIT with option /P for PANNING.
  EXHIBIT("/P /T:3 &SPEC.")
*					    Get database record and memo offset.
  Do SETUP with "SAFETY", 20
*				      Invoke EXHIBIT with option /P for PANNING.
  EXHIBIT("/P /T:3 &SPEC.")
  RETURN



*			    2) Full-screen 256-color pictures, with key confirm;

STATIC PROCEDURE BIG
*					    Get database record and memo offset.
  Do SETUP with "CHEETAH", 20
*						 Invoke EXHIBIT in default mode.
  EXHIBIT("/P /R /T:4 &SPEC.")
*					    Get database record and memo offset.
  Do SETUP with "FROG", 20
*						 Invoke EXHIBIT in default mode.
  EXHIBIT("/K /T:4 &SPEC.")
  RETURN



*		 3) Reduced full page document, with slow fade and string input;

STATIC PROCEDURE MINI
*					    Get database record and memo offset.
  Do SETUP with "SAFETY", 20
*				 Invoke PHOTO with /B for BIG & /D for DISSOLVE.
  PHOTO  ("/B /D:3 /G /R &SPEC.")
*				       Get graphics-mode string input from user.

  STRING=GSAY("/B:0 /F:15 /G /H:11 /L:40 /T:5 /V:20 'Enter your first name: ';")

*							      Restore text mode.
  PHOTO  ("/D:3 /R")
*				    Display user's input from database variable.

  GSAY	 ("/B:7 /F:0  /H:11 /T:2 /V:24 'Your first name is "+STRING+".';")

*								Clear text line.
  @24,11 SAY "                                                            "
  RETURN



*					  4) Timed miniature 256-color pictures;

STATIC PROCEDURE SMALL
*					    Get database record and memo offset.
  Do SETUP with "FROG", 20
*						     Invoke VCR in default mode.
  VCR	 ("/R /T:4 &SPEC.")
*					    Get database record and memo offset.
  Do SETUP with "CHEETAH", 20
*						     Invoke VCR in default mode.
  VCR	 ("/T:4 &SPEC.")
  RETURN



*	       5) Mixed color and gray-scale images, including signature window;

STATIC PROCEDURE SIGN
*					    Get database record and memo offset.
  Do SETUP with "FROG", 20
*					   Invoke VCR with /L for LEVEL palette.
  VCR	 ("/C /L /H:00 /R /V:000 &SPEC.")
*					       Invoke VCR with /G for GRAYSCALE.
  VCR	 ("/C /G /H:40 /R /V:000 &SPEC.")
*					    Get database record and memo offset.
  Do SETUP with "CHEETAH", 20
*					   Invoke VCR with /L for LEVEL palette.
  VCR	 ("/C /L /H:40 /R /V:200 &SPEC.")
*					       Invoke VCR with /G for GRAYSCALE.
  VCR	 ("/C /G /H:00 /R /V:200 &SPEC.")
*					    Get database record and memo offset.
  Do SETUP with "HANCOCK", 20
*					    Invoke VCR with /S for SHORT window.
  VCR	 ("/C /G /H:20 /R /S /V:145 &SPEC.")
*					     Write color ID numbers over images.
  GSAY	 ("/F:1 /B:14 /H:08 /V:06 '  #1  ';")
  GSAY	 ("/F:2 /B:13 /H:66 /V:06 '  #2  ';")
  GSAY	 ("/F:4 /B:11 /H:66 /V:18 '  #3  ';")
  GSAY	 ("/F:5 /B:10 /H:08 /V:18 '  #4  ';")
  GSAY	 ("/F:3 /B:12 /H:37 /V:14 '  #5  ';")
*						   Hold 5 seconds, then restore.
  VCR	 ("/T:5 /R")
  RETURN



*		6) Rescaled cheetahs, converted to 16 colors, with string input;

STATIC PROCEDURE CATS
*					    Get database record and memo offset.
  Do SETUP with "CHEETAH", 20
*			      Invoke EXHIBIT with /E for EGA (16-color palette).
  EXHIBIT("/E /R &SPEC.")
*						 Display message over the image.
  GSAY	 ("/B:15 /F:0 /H:57 /V:7 '   Full Size   ';")
*						 Invoke PHOTO with /A for AUDIT.
  PHOTO  ("/A /H:05 /V:35 /R &SPEC.")
*						 Display message over the image.
  GSAY	 ("/B:15 /F:0 /H:17 /V:7 '  One Quarter  ';")
*			       Invoke PHOTO with /N for NARROW and /S for SHORT.
  PHOTO  ("/N /S /H:55 /V:270 /R &SPEC.")
*						 Display message over the image.
  GSAY	 ("/B:15 /F:0 /H:57 /T:2 /V:19 ' One Sixteenth ';")
*				       Get graphics-mode string input from user.

  STRING=GSAY("/B:0 /F:15 /G /H:11 /L:40 /T:5 /V:20 'Enter your last name: ';")

*							      Restore text mode.
  EXHIBIT("/T:2 /R")
*			     Display user's string input from database variable.

  GSAY	 ("/B:7  /F:0  /H:11  /T:2  /V:24  'Your last name is "+STRING+".';")

*								Clear text line.
  @24,11 SAY "                                                            "
  RETURN



STATIC PROCEDURE SETUP (RECID,RECOFS)
*					      Read record into current workarea.
  SEEK	 RECID
*				      Point to memo field within current record.
  FPTR = HEADER()+((RECNO()-1)*RECSIZE())+RECOFS

  FPTR = FSEEK(HNDL,FPTR,0)
*					   Read memo field value (block number).
  OFS = FREADSTR(HNDL,10)
*						   Get image offset as a string.
  OFS = ALLTRIM(STR(512*VAL(ALLTRIM(OFS))))
*						     Get image size as a string.
  SIZ = ALLTRIM(STR(SIZE))

  SPEC = "/F:"+FORMAT+" /Q /O:"+OFS+","+SIZ+" GRAFIX.DBT"
  RETURN
