/****************************************************************************
*                                                                           
* FILE: TFLDIPL.H
*
* DESCRIPTION:  This file contains the calss definetion fot TFieldInputLine.
*
****************************************************************************/
//
// tell turbo vision that wee will be using class TInputLine
//
#define Uses_TInputLine


//
// include turbo vision
//
#include  <tv.h>
//
// we will also need the types and classes defeined by the Database Framework
//
#include  <envdef.h>

//
// here are the messages that the field input box use to load or to store
// the field's value into the record buffer associated with the table BCursor.
// These messages are sent from the dialog box that the field input line is
// placed on.
//
const cmLoadFieldValue   = 1000;
const cmStoreFieldValue  = 1001;
const cmHasValueChanged  = 1002;

/****************************************************************************
*
*        CLASS: TFieldInputLine
*
*     INHERITS: TInputLine
*
*  DESCRIPTION: This class associates a field in a cursor to a turbo vision
*               input line.  The data in the input line can be placed into
*               the cursors field, or can be set with the fields value.
*
****************************************************************************/
class TFieldInputLine : public TInputLine
{
private:
  //
  // what field handle is this input line associated with
  //
  FIELDNUMBER whatField;
  //
  // what cursor is this field found in
  //
  BCursor     *whatCursor;


protected:
  //
  // a buffer, similiar to the data member of TInputLine, to hold the 
  // original field value
  //
  char *originalValue; 

  //
  // a function to load the field value from the record buffer
  //
  void loadFieldValue();

  //
  // a function to save the field value in the record buffer
  //
  void storeFieldValue();

  //
  // a function to test if the field value has changed
  //
  Boolean didValueChange();

public:

  //
  // classes constructor
  //
  TFieldInputLine(const TRect &bounds, int aMaxLen, BCursor *aCursor, 
    FIELDNUMBER aFieldHandle);
  //
  // destructor
  //
  ~TFieldInputLine();

  //
  // the event handler for the class
  //
  virtual void handleEvent(TEvent &event);
};
