/****************************************************************************
*                                                                           
* FILE: TFLDIPL.CPP
*
* DESCRIPTION:  This file contains the class TFieldInputLine's member 
*               functions.
*
****************************************************************************/
#define Uses_TEvent

//
// include the class def for this class
//
#include  <alloc.h>
#include  <string.h>
#include  "tfldipl.h"
#include  "brecord.h"
#include  "bcursor.h"

/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: TFieldInputLine
*
* DESCRIPTION:  this is the constructor
*               
* RETURNS: NONE
*
****************************************************************************/
TFieldInputLine::TFieldInputLine(const TRect &bounds, int aMaxLen, 
  BCursor *aCursor, FIELDNUMBER aFieldHandle): TInputLine(bounds, aMaxLen)
{
  //
  // save the associated field handle and cursor
  //
  whatField   = aFieldHandle;
  whatCursor  = aCursor;

  //
  // create a buffer to hold the fields origional information
  //
  originalValue = (char *)calloc(aMaxLen, sizeof(char));
}

/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: ~TFieldInputLine
*
* DESCRIPTION:  destructor
*               
* RETURNS: NONE
*
****************************************************************************/
TFieldInputLine::~TFieldInputLine()
{
  //
  // free the memory used by the data member origionalValue
  //
  free(originalValue);
}

/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: handleEvent
*
* DESCRIPTION:  this is the classes event handler
*               
* RETURNS: NONE
*
****************************************************************************/
void TFieldInputLine::handleEvent(TEvent &event)
{
  //
  // act like the base class
  //
  TInputLine::handleEvent(event);

  //
  // is this one of our special boradcast events?
  //
  if(event.what == evBroadcast)
  {
    switch(event.message.command)
    {
      //
      // load field value command
      //
      case cmLoadFieldValue:
        loadFieldValue();
        break;

      //
      // store field value command
      //
      case cmStoreFieldValue:
        storeFieldValue();
        break;

      //
      // test to see if the input line's value has been changed by the user
      //
      case cmHasValueChanged:
        if(didValueChange())
        {
          //
          // this will call clearEvent()
          //
          break;
        }
        //
        // if the value did not change, do not clear the event. 
        //

      //
      // none of the above
      //
      default:
        return;
    }

    clearEvent(event);
  }
}

/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: loadFieldValue
*
* DESCRIPTION:  This function takes the field value out of the record buffer
*               and sets the input line's contents to the field's value.
*               
* RETURNS: NONE
*
****************************************************************************/
void TFieldInputLine::loadFieldValue()
{
  char    buffer[256];
  BOOL    isNull;
  BRecord *genericRec;

  //
  // get the pointer to the generic record buffer in the cursor
  //
  genericRec = whatCursor->genericRec;

  //
  // get the field as as an ASCII value
  //
  genericRec->getField(whatField, buffer, sizeof(buffer), isNull);

  if(isNull == TRUE)
  {
    //
    // set the input line to blank
    //
    setData("");
  }
  else
  {
    setData(buffer);
  }

  //
  // save this value in the origional value buffer
  //
  getData(originalValue);
}

/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: storeFieldValue
*
* DESCRIPTION:  This function takes the value of the input line and places
*               it into the record buffer.
*               
* RETURNS: NONE
*
****************************************************************************/
void TFieldInputLine::storeFieldValue()
{
  char    buffer[256];
  BRecord *genericRec;

  //
  // get the pointer to the generic record buffer in the cursor
  //
  genericRec = whatCursor->genericRec;

  //
  // get the input line's contents
  //
  getData(buffer);
  //
  // save this value in the origional value buffer
  //
  strcpy(originalValue, buffer);

  //
  // store the value in the record buffer
  //
  if(!strlen(buffer))
  {
    genericRec->clearNull(whatField);
  }
  else
  {
    genericRec->putField(whatField, buffer);
  }
}


/****************************************************************************
*          
* CLASS: TFieldInputLine
*                                                                
* MEMBER FUNCTION: didValueChange
*
* DESCRIPTION:  This function tests to see if the user has changed the value 
*               if the input line since the field was last loaded.
*               
* RETURNS: True if the value has changed.  False otherwise.
*
****************************************************************************/
Boolean TFieldInputLine::didValueChange()
{
  //
  // compare the strings in data and origionalValue
  //
  if(strcmp(data, originalValue))
  {
    //
    // if they are different, then the value has changed
    //
    return(True);
  }

  //
  // return the values are the same
  //
  return(False);
}




