/****************************************************************************
*                                                                           
* FILE: TCURDLG.H
*
* DESCRIPTION:  This file contains the class def for TCursorDialog.  It
*               is a class that combines a TDialog from Turbo Vision and
*               a BCursor from the Database Framework.
*
****************************************************************************/
//
// the class is based off of a TDialog in Turbo Vision.
//                      
#define Uses_TDialog  


//
// include Turbo vision defs.
//
#include  <tv.h>
//
// include the BCursor .H file
//
#include  <bcursor.h> 


/****************************************************************************
*
*        CLASS: TCursorDialog
*
*     INHERITS: TDialog from TV.
*
*  DESCRIPTION: This class incorporates a Turbo Vision TDialog and a BCursor
*               from the Database Framework.
*              
*
****************************************************************************/
class TCursorDialog : public TDialog
{
protected:
  //
  // a pointer to the encapsulated BCursor that is associated to the
  // class.
  //
  BCursor *theCursor;

public:
  //
  // the classes constructor,  it is based on the constructor of TDialog.
  //
  TCursorDialog(const TRect &bounds, const char *aTitle, BCursor *aCursor);

  //
  // a function that will load field values into controls of type
  // TFieldInputLine
  //
  void loadFieldValues();

  //
  // a function that will store the contents TFieldInputLine controls
  // into the BRecord of the cursor
  //
  void storeFieldValues();

  //
  // a function that will ask all field input lines if their values have
  // changed since they were loaded
  //
  Boolean hasRecordValuesChanged();

};




