/****************************************************************************
*                                                                           
* FILE: TCURDLG.CPP
*
* DESCRIPTION:  This file contains the class TCursorDialog member functions.
*
****************************************************************************/
#define Uses_TView

//
// include the .H file that contains the definetion of the class
//
#include  "tcurdlg.h"
#include  "tfldipl.h" 
#include  <string.h>



/****************************************************************************
*          
* FUNCTION: hasValueChanged
*
* DESCRIPTION: This function is called from TCursorDialog::firstThat() to
*              broadcast a cmHasValueChanged to all controls on the 
*              dialog box.  See the member function hasRecordValuesChanged()
*              of TCursorDialog for the functions use.
*               
* RETURNS:  True if a controls value has changed or False if not values have
*           changed.
*
****************************************************************************/
Boolean hasValueChanged(TView *thisView, void *param)
{
  //
  // get rid of the warning that param is never used
  //
  param = param;

  //
  // send the message cmHasValueChanged to the the view.  If the return
  // value of the message function is not null, then the view was a 
  // TFieldInputLine, and the value was changed by the user.
  //
  if(message(thisView, evBroadcast, cmHasValueChanged, NULL))
  {
    //
    // return that it changed
    //
    return(True);
  }

  //
  // return that the value did not change
  //
  return(False);
}


/****************************************************************************
*          
* FUNCTION: sendFieldMessage
*
* DESCRIPTION:  This function is called from TCursorDialog::forEach() to
*               broadcast a either a cmLoadFieldValue or cmStoreFieldValue
*               to all controls on the dialog box.  See the member functions
*               loadFieldValues() and storeFieldValues() of TCursorDialog
*               for the functions use.
*               
* RETURNS: NONE
*
****************************************************************************/
void sendFieldMessage(TView *thisView, void *param)
{
  int messageToSend;

  messageToSend = *(int *)param;
  message(thisView, evBroadcast, messageToSend, NULL);
}


/****************************************************************************
*          
* CLASS: TCursorDialog
*                                                                
* MEMBER FUNCTION: TCursorDialog (constructor)
*
* DESCRIPTION:  This is the function that is called when a class of this type
*               is consturcted.  Since the class is based on a TDialog and
*               a TWindowInit, thier constructors must also be called.
*               
* RETURNS: NONE
*
****************************************************************************/
TCursorDialog::TCursorDialog(const TRect &bounds, const char *aTitle, 
  BCursor *aCursor): 
    TDialog(bounds, aTitle), TWindowInit(TCursorDialog::initFrame)
{
  //
  // save the pointer to the encapuslated cursor object
  //
  theCursor = aCursor;
}

/****************************************************************************
*          
* CLASS: TCursorDialog
*                                                                
* MEMBER FUNCTION: loadFieldValues
*
* DESCRIPTION:  this function uses the forEach() member funtion to send
*               the message cmLoadFieldValue to all the controls on the 
*               dialog.  This message is used buy the TFieldInputLine 
*               controls to take the value from the generic record buffer
*               and display the value in the input line.  The forEach()
*               function takes a pointer to a function that table a pointer
*               to a TView and a pointer to its paramters.  This function
*               is sendFieldMessage().  The second parameter to 
*               sendFieldMessage is a pointer to the command to send.
*               
* RETURNS: NONE
*
****************************************************************************/
void TCursorDialog::loadFieldValues()
{
  //
  // iterate over all the controls on the dialog box and send the 
  // cmLoadField value to them.  This can be done using the forEach member
  // function of TGroup.
  //

  forEach(sendFieldMessage, (void *)&cmLoadFieldValue);
}

/****************************************************************************
*          
* CLASS: TCursorDialog
*                                                                
* MEMBER FUNCTION: storeFieldValues
*
* DESCRIPTION:  this function uses the forEach() member funtion to send
*               the message cmStoerFieldValue to all the controls on the 
*               dialog.  This message is used buy the TFieldInputLine 
*               controls to take the value input line and place it into
*               the the generic record buffer.  The forEach()
*               function takes a pointer to a function that table a pointer
*               to a TView and a pointer to its paramters.  This function
*               is sendFieldMessage().  The second parameter to 
*               sendFieldMessage is a pointer to the command to send.
*               
* RETURNS: NONE
*
****************************************************************************/
void TCursorDialog::storeFieldValues()
{
  //
  // iterate over all the controls on the dialog box and send the 
  // cmStoreField value to them.  This can be done using the forEach member
  // function of TGroup.
  //
  forEach(sendFieldMessage, (void *)&cmStoreFieldValue);
}

/****************************************************************************
*          
* CLASS: TCursorDialog
*                                                                
* MEMBER FUNCTION: hasRecordValuesChanged
*
* DESCRIPTION:  This function sends a message, cmHasValueChanged to all the
*               controls on the dialog. If one of the controls responds True,
*               then the contents of the record has changed.  See function
*               hasValueChanged.
*               
* RETURNS: True if the record has changed. Flase if not.
*
****************************************************************************/
Boolean TCursorDialog::hasRecordValuesChanged()
{
  if(firstThat(hasValueChanged, NULL))
  {
    return(True);
  }

  return(False);
}


