; DB-to-PM.sc
;----------------------------------------------------------------------------
; Database to Pagemaker Structure Lister
; For use with the DB-to-PM.PM5 template for displaying graphical linking
;     structures of application database components
; Author: Gary Mugford - Mugford Info Services (905) 793-0219
;         10-27-93 11:31pm   all rights reserved
; Standard Weasel Disclaimer: This software combination works on my system.
;                             There is no warranty that this software will work
;                             on your system. Indeed, use this software at your
;                             own risk, the total responsibility for its use is
;                             ALL yours.
; This software is presumed to use Paradox (C) Borland International and is 
; designed to interface eventually to Pagemaker (C) Aldus Publishing operating
; in Microsoft Corp.'s ubiquitous Windows 3.1 environment.
;----------------------------------------------------------------------------

; let's start fresh
setdir directory() reset release vars all release procs all altspace "DE"

; Get list of database tables in THIS directory
message "Compiling list of databases ... "
menu {Tools} {Info} {Inventory} {Tables} {}     ; Might want to modify for RDA

; Find out how many of tables were found. If none, exit this script
REX.n=nrecords("list")
if REX.n=0 then quit                   ; Might want to write messaging code
           else array TABLE.r[REX.n]
endif

; Scan in the list of table names to an array
view "List"
scan
   TABLE.r[recno()]=[Name]
endscan
altspace "DE"

; Loop through the array, processing each database
for COUNTER.n from 1 to REX.n
   message "Exporting ... "+TABLE.r[COUNTER.n]
   if upper(TABLE.r[COUNTER.n])="DB-TO-PM" or
      upper(TABLE.r[COUNTER.n])="LIST"              ; Skip temporary tables
      then loop
   endif
   menu {Tools} {Info} {Structure} select TABLE.r[COUNTER.n]
                                                    ; Copy stored report object
   menu {Tools} {Copy} {JustFamily} {Db-to-pm} {struct} {Replace}
   menu {Report} {Output} {Struct} {R} {File} typein TABLE.r[COUNTER.n]+".TXT"
        enter
        if upper(menuchoice())="CANCEL"             ; Overwrite ensuring
           then {Replace}
        endif
   clearall altspace "DE"                           ; keep it clean
endfor
beep beep beep                                      ; all done!

;----------------------------------------------------------------------------
; IF you are running Paradox under Windows, you can minimize or exit Paradox
; right now and launch PageMaker 5.0. Load the DB-to-PM.PM5 file from where-
; ever it is stored and save it to the application directory you ran the 
; DB-to-PM script in, under whatever name you think is appropriate.
; -1- Highlight the XXXXXX's in the top line and replace them with your
;     project title.
; -2- Using the place function, bring in the various ????????.TXT files into
;     your PM file. During import, make sure you click on the READ TAGS option.
;     This will ensure that PM will read the DBTITLE and FIELDZ tags and format
;     the incoming text accordingly. I HIGHLY recommend putting them all into 
;     place, sizing them as wide as the text indicates is necessary. i.e. Only 
;     make the text block as wide as the section containing the longest field 
;     name. (no need to be too exact and working with greeked text is perfectly
;     acceptable)
; -3- Once all the files have been brought in, move them around until you have
;     them placed roughly as you want them. Then start drawing lines to 
;     represent the links. A hint is to use 2-pt lines to denote Valchecks
;     validity lookups, 1-pt lines to denote look-up and fill secondary fields
;     and dotted lines to represented duplicated fields (obviously in de-normal-
;     ized situations). This part of it is a jigsaw puzzle, and you're all on
;     your own in terms of producing a useful (and/or pleasing) document.
; 
; NOTE: The files kicked out of this script produce tags in PageMaker under-
;       standible format. If you want to use with with Word for Windows or
;       WordPerfect, just change the start of the lines in the report to 
;       reflect the style-tags format of your chosen DTP engine.
;
;                                               REGARDS, Gary
