;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Copyright 1990 David F. Kelton.  All rights reserved.
;P.O. Box 325 Whitehall, PA 18052
;You are free to use, copy and distribute:
;wdemo.u(),stripper.u(),locator.u(),help.u(),prmptmsg.u() and the tables and
;forms for noncommercial use as long as no fees are charged for use, copying,
;or distribution that exceed $5.00.
;This demo was written specifically for the BORDB Libs and the intention is
;that it remain in the public domain.  This is strictly a demo of some
;Paradox techniques and is not intended for commercial use.
;NOTE: Steve Caple has a similar routine although I have never seen it.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

LibName.a = "Paradox"             ;Set library name to var.

CREATELIB LibName.a               ;Create library named Paradox.

CURSOR OFF
msg1.a=" . . . "
msg2.a=" Working"
n=80-(LEN(msg1.a)+LEN(msg2.a))
STYLE ATTRIBUTE 159               ;working message used while creating lib.
@0,7 ?? msg1.a+SPACES(n)
STYLE ATTRIBUTE 30
@0,0 ?? msg2.a

PROC wdemo.u()
  PRIVATE procname.a,frm1.n,frm2.n,frm3.n         ;Declare variables private.
  procname.a="wdemo.u"  CANVAS OFF                ;For error trapping purposes.
  IF MONITOR()= "Color" THEN                      ;Determine Monitor type.
   frm1.n = 1  frm2.n = 2 frm3.n = 3              ;Set vars for picking color
  ELSE frm1.n = 11  frm2.n = 12 frm3.n = 13 ENDIF ;or monochrome forms.
  COEDIT "Customer" PICKFORM frm2.n               ;Select "SplashScreen" form.
  ECHO NORMAL ECHO OFF                    ;Displays current workspace on canvas.
  STYLE ATTRIBUTE SYSCOLOR(0)             ;Set Prompt lines to System color.
  @0,0 ?? "[Esc] Returns Without Saving Record - [F2] To Save and Return - [F1] For Help   "
  @1,0 ?? "Press [Ins] to Add Record - [F6] To Add Account Number - [Ctrl-Z] To Zoom       "
  CANVAS ON                              ;Turn canvas on.
  n=GETCHAR()                                     ;Freeze canvas until keypress.
  CANVAS OFF PICKFORM frm1.n                      ;Hide effects of form change.
  WHILE (TRUE)                                    ;Perform commands in loop.
    CANVAS ON                                     ;Turn Canvas On
    IMAGERIGHTS UPDATE                            ;Allow changes to non-key fields.
    PROMPT                                        ;Restore control to Paradox.
    WAIT RECORD                                   ;Interact with table.
    PROMPT "[Esc] Returns Without Saving Record - [F2] To Save and Return - [F1] For Help",
    "Press [Ins] to Add Record - [F6] To Add Account Number - [Ctrl-Z] To Zoom"
    UNTIL 13,15,26,27,-24,-44,-59,-60,-64,-71,-72,-73,-79,-80,-81,-82,-83
    SWITCH
     CASE retval =  26:CANVAS OFF locator.u()    ;Ctrl-Z search proc.
     CASE retval =  27:CLEAR UNDO DO_IT! CLEARALL RETURN ;Esc key.
     CASE retval = -59:help.u(frm1.n,frm3.n)     ;[F1] Form help proc.
     CASE retval = -60:CLEAR DO_IT! CLEARALL RETURN ;[F2] when finished.
     CASE retval = -64:stripper.u()              ;[F6] strpping procedure.
     CASE retval = -82:IMAGERIGHTS MOVETO [Name] KEYPRESS -82 ;[Ins] new record.
     CASE retval = -83:deleter.u()
     OTHERWISE:IF NOT ISBLANK([Acct#]) THEN KEYPRESS RETVAL ELSE BEEP ENDIF
    ENDSWITCH
  ENDWHILE
ENDPROC
WRITELIB LibName.a wdemo.u
RELEASE PROCS wdemo.u
? FORMAT("w79,al"," Demo Wait Table Procedure")

PROC stripper.u()
  PRIVATE strip.y,name.a,n,a1,a2,a3,procname.a ;Declare variables private.
  procname.a="stripper.u"                      ;For error trapping purposes.
  IF NOT ISBLANK([Name]) THEN                  ;Test field for entry.
    IF ISBLANK([Acct#]) THEN                   ;Test for blank field.
      ARRAY strip.y[4]                         ;Define array with 4 elements.
      strip.y[1]="-"                           ;Set array element to hyphen.
      strip.y[2]=" "                           ;Set array element to space.
      strip.y[3]="."                           ;Set array element to period.
      strip.y[4]="'"                           ;Set array element to apostrophe.
      name.a=UPPER([Name])                     ;Set var to uppercase name.
      FOR n FROM 1 TO 4                        ;Four iterations of stripping.
       WHILE MATCH(name.a,"..\""+strip.y[n]+"\"..",a1,a2) name.a=a1+a2 ENDWHILE
      ENDFOR                                   ;End For loop.
      IF MATCH(name.a,"..,..",a1,a2) THEN      ;Segment name by comma.
        a1=SUBSTR(a1,1,4)                      ;Four characters last name.
        name.a=SUBSTR((a1+a2),1,6)    ;Pad lname with fname characters to max 6.
      WHILE(LEN(name.a)<6) name.a=name.a+"x" ENDWHILE ;If <6 chars pad with x's
        CANVAS OFF                    ;Freeze canvas.
        newname.a=[Name]              ;NOTE: could use CopyToArray
        IMAGERIGHTS                   ;Allows Key Field edit.
        KEYPRESS -83 MOVETO [Acct#]   ;Delete new record, fieldmove.
        FOR n FROM 1 TO 99            ;Allows 99 acct# occurrences.
          IF n <10 THEN               ;Test value of counter variable.
            a3="0"+STRVAL(n)          ;If n is 1-9 add a prefix of zero,
          ELSE                        ;convert counter to string.
            a3=STRVAL(n)              ;If n is =>10 convert counter to string.
          ENDIF
          LOCATE name.a+a3            ;Locate acct# (parsed name + appended num)
          IF retval=FALSE THEN        ;If acct# does not exist.
            KEYPRESS -82              ;Insert new record.
            [Name]=newname.a          ;NOTE: could use CopyFromArray
            IMAGERIGHTS               ;Allows Key Field edit.
            [Acct#]=name.a+a3         ;Enter new acct#.
            LOCKRECORD UNLOCKRECORD   ;Keep record from flying away.
            CANVAS ON QUITLOOP        ;Quit FOR loop when acct3 assigned.
          ELSE
            LOOP                      ;Continue FOR loop until acct# can,
          ENDIF                       ;be assigned.
        ENDFOR
      ENDIF
    ELSE prmptmsg.u(2,2) ENDIF        ;Alerts user that name must be entered.
  ELSE prmptmsg.u(1,2) ENDIF          ;Alerts user that acct# already assigned.
ENDPROC
WRITELIB LibName.a stripper.u
RELEASE PROCS stripper.u
? FORMAT("w79,al"," Stripping Procedure")

PROC locator.u()
  PRIVATE sv.a,procname.a,syscol.n
  procname.a="locator.u" syscol.n=SYSCOLOR(0) ;Set variable to color attribute
  WHILE (TRUE)                                ;number of system prompt.
    PROMPT                                    ;Restore control to Paradox.
    IF ISBLANK([Acct#]) THEN RETURN "" ELSE MOVETO [Acct#] ENDIF
    STYLE ATTRIBUTE syscol.n                  ;Set color for promptlines.
    @0,0 CLEAR EOL @ 1,0 CLEAR EOL            ;Clear promptlines.
    CURSOR NORMAL                             ;Restore cursor.
    @0,0 ?? FORMAT("w80,al","  Searching Customer Records") ;Promptline message.
    @1,0 ?? FORMAT("w80,al","  Enter Account Number ---->")
    CANVAS ON
    @ 1,31 ??
    ACCEPT "A8" PICTURE "*!" TO sv.a          ;Value to locate in uppercase.
    IF RETVAL = FALSE THEN                    ;If user presses [Esc]
     CANVAS OFF RETURN
    ENDIF
    CURSOR OFF
    sv.a = sv.a+".."                          ;Append wildcards for search.
    LOCATE PATTERN sv.a                       ;Locate acct#.
    IF RETVAL = TRUE THEN                     ;Found acct#.
     CANVAS OFF RETURN
    ELSE
     prmptmsg.u(3,2) CANVAS OFF RETURN        ;Acct# not found message.
    ENDIF
  ENDWHILE
ENDPROC
WRITELIB LibName.a locator.u
RELEASE PROCS locator.u
? FORMAT("w79,al"," Locater Procedure")

PROC help.u(frm1.n,frm3.n)
  PRIVATE procname.a                     ;Declare variables private.
  procname.a="help.u"                    ;For error trapping purposes.
  CANVAS OFF PICKFORM frm3.n             ;Hide effects of form change.
  ECHO NORMAL ECHO OFF                   ;Displays current workspace on canvas.
  STYLE ATTRIBUTE SYSCOLOR(0)            ;
  @0,0 ?? "[Esc] Returns Without Saving Record - [F2] To Save and Return - [F1] For Help   "
  @1,0 ?? "Press [Ins] to Add Record - [F6] To Add Account Number - [Ctrl-Z] To Zoom       "
  CANVAS ON                              ;Turn canvas on.
  n=GETCHAR()                            ;Freeze canvas until keypress.
  CANVAS OFF PICKFORM frm1.n CANVAS ON   ;Hide effects of form change.
  RETURN                                 ;Return to calling proc.
ENDPROC
WRITELIB LibName.a help.u
RELEASE PROCS help.u
? FORMAT("w79,al"," Help Procedure")

PROC prmptmsg.u(n1,n2)                   ;Receive parameters.
  PRIVATE n,n1,n2,procname.a             ;Declare variables private.
  procname.a="prmptmsg.u"                ;For error trapping purposes.
  WHILE (TRUE)
    @0,0 CLEAR EOL @1,0 CLEAR EOL        ;Clear promptlines.
    BEEP SLEEP 250 BEEP                  ;Alert user of problem.
    STYLE ATTRIBUTE 79                   ;Color message white on red.
    SWITCH
      CASE n1=1:
       @0,0 ?? FORMAT("w80,ac","PROBLEM - The Name Field is Empty !")
      CASE n1=2:
       @0,0 ?? FORMAT("w80,ac","PROBLEM - The Account# is Already Assigned!")
      CASE n1=3:
       @0,0 ?? FORMAT("w80,ac","PROBLEM - Match Not Found!")
    ENDSWITCH
    IF n2=2 THEN @1,0 ?? FORMAT("w80,ac","To Return - Press Any Key") ENDIF
    STYLE
    n = GETCHAR()                        ;Freeze canvas until keypress.
    QUITLOOP                             ;Return to calling proc.
  ENDWHILE
ENDPROC
WRITELIB LibName.a prmptmsg.u
RELEASE PROCS prmptmsg.u
? FORMAT("w79,al"," Prompt Message")

PROC deleter.u()
  PRIVATE choice.a
  BEEP SLEEP 250 BEEP
  SHOWMENU
    "Cancel":"Do Not Delete This Record - Return To Form",
    "Delete":"I Want To Delete This Record"
  TO choice.a
  SWITCH
    CASE choice.a = "Cancel":RETURN
    CASE choice.a = "Delete":
      IMAGERIGHTS KEYPRESS -83 IMAGERIGHTS READONLY RETURN
  ENDSWITCH
ENDPROC
WRITELIB LibName.a deleter.u
RELEASE PROCS deleter.u
? FORMAT("w79,al"," Deleter Utility")

PROC standby.u()
 PRIVATE msg1.a,msg2.a,msg3.a,n
 CANVAS OFF
 msg1.a=" Preparing SmartKey Demo "
 msg2.a=" STANDBY "
 msg3.a=". . . "
 n=LEN(msg1.a)-(LEN(msg2.a)+LEN(msg3.a))
 STYLE ATTRIBUTE 158
 @0,LEN(msg2.a) ?? msg3.a+SPACES(n)
 STYLE ATTRIBUTE 30
 @0,0 ?? msg2.a
 @1,0 ?? msg1.a
 STYLE
 CANVAS ON
ENDPROC
WRITELIB LibName.a standby.u
RELEASE PROCS standby.u
? FORMAT("w79,al"," Standby Message")

INFOLIB LibName.a                 ;Display List table showing procs in lib.