;2222222222222222222222222222222222222222222222222222222222222222222
;[                                                                     ]
;[   Copyright Mark Horrocks, 1991. All rights reserved.               ]
;[   28 Parkside Cres, Leanyer, NT 0812                                ]
;[   Australia.                                                        ]
;[   Phone  country code 061, (089) 27 66 11.                          ]
;[   Compuserve member number 100033,2533.                             ]
;[   This script may be freely used or distributed provided this       ]
;[   notice is retained. (ShareWare).                                  ]
;[                                                                     ]
;[   The purpose of this procedure is to copy all Paradox ValCheck     ]
;[   settings from one table to another.  The tables need not have     ]
;[   identical structures. If any common field names are found, the    ]
;[   the ValChecks, except "Required!" are copied from table 1 to      ]
;[   table 2.  This is a missing command in PAL. Save files by using   ]
;[   Create and then copy the Val Checks from any table with similar   ]
;[   field names, instead of using dummy tables.                       ]
;[   Will not remove existing ValChecks from non matching fields so    ]
;[   you can repeat the command to copy ValChecks off several tables.  ]
;[   Returns true if executed correctly, false if aborted on error.    ]
;=======================================================================

  Proc CopyValCheck(TableName1, TableName2)

  Private
  error_handler,
  x,                        ; position of 1st string separator
  y,                        ; position of 2nd string separator
  n_fields.v,               ; number of fields in table 1
  field_names.a,            ; array of field names in table 1
  picture.a,                ; array of picture settings
  lowvalue.a,               ; array of low value settings
  highvalue.a,              ; array of high value settings
  default.a,                ; array of default settings
  table_lookup.a,           ; array of table lookup settings
  TabName.v,                ; name of lookup table
  fill_fields.v,            ; table lookup menu selection
  fill_help.v               ; table lookup menu selection

  If IsRuntime() then
     beep Message "Can not use under runtime"
     Sleep 2000 Return False
  Endif

  If SysMode() <> "Main" then
     beep Message "Must be in Main mode"
     Sleep 2000 Return False
  Endif

  If not IsTable(TableName1) then
     beep Message TableName1 + " not found"
     Sleep 2000 Return False
  Endif

  If not IsTable(TableName2) then
     beep Message TableName2 + " not found"
     Sleep 2000 Return False
  Endif

  Lock TableName1 FL, TableName2 FL
  If not Retval then
    beep Message "Can't lock tables, try again later"
    Sleep 2000 Return False
  Endif

  errorproc = "errorhandler"

  Proc Errorhandler()
  Private ErrorProc
  If errorcode() = 33 then           ; if field name not found, increment the
   i = i + 1                         ; field names array and go to next field
   return 0
  EndIf
  EndProc

  ErrorHandler()

  View TableName2                     ; target table
  View TableName1                     ; source table

  Menu {Tools} {Info} {Structure} Select TableName1
                                      ; View table1 structure

  Moveto[Field Name]
  n_fields.v = NRecords(Table())      ; # of fields in table

  Array field_names.a[n_fields.v]     ; Declare array for field names

  For i from 1 to n_fields.v          ; Copy field names to the array
     field_names.a[i] = []
     Down
  EndFor

  Moveto TableName1                   ; Return to table
  Moveto [#]                          ; Go to far left column
  EditKey

  Array picture.a[n_fields.v]         ; Declare array to hold pictures
  For i From 1 to n_fields.v          ; for each field
     Moveto Field field_names.a[i]    ; move to the field
     Menu {ValCheck} {Define} Enter {Picture}   ; select valcheck menu
     If not IsBlank(MenuChoice()) then
        picture.a[i] = MenuChoice()   ; set the picture
        Enter
     Else Menu Esc
     Endif
  Endfor                              ; Save pictures in array

  Array lowvalue.a[n_fields.v]        ; lowvalue array
  For i from 1 to n_fields.v
     Moveto Field field_names.a[i]
     Menu {ValCheck} {Define} Enter {LowValue}
     If not IsBlank(MenuChoice()) then     ; if we have a lowvalue check
        lowvalue.a[i] = MenuChoice()       ; save it
        Enter
     Else Menu Esc
     Endif
  EndFor

  Array highvalue.a[n_fields.v]        ; highvalue array
  For i from 1 to n_fields.v
     Moveto Field field_names.a[i]
     Menu {ValCheck} {Define} Enter {HighValue}
     If not IsBlank(MenuChoice()) then
        highvalue.a[i] = MenuChoice()
        Enter
     Else Menu Esc
     Endif
  EndFor

  Array default.a[n_fields.v]          ; default array
  For i from 1 to n_fields.v
     Moveto Field field_names.a[i]
     Menu {ValCheck} {Define} Enter {Default}
       If not IsBlank(MenuChoice()) then
          default.a[i] = MenuChoice()
          Enter
       Else Menu Esc
       Endif
  EndFor

 ;=====================================================================
 ; For the table lookup settings, we need to keep 2 menu choices a well
 ; as the table name.  They are JustCurrentField or AllCorrespondingFields
 ; and FillNoHelp or HelpandFill.
 ; Because Paradox has no 3 dimensional arrays, I used a work around.
 ; I have assigned the menu settings to the same array element as the lookup
 ; table name. The 3 items are separated by using the character "|".
 ;=========================================================================

  Array table_lookup.a[n_fields.v]     ; table lookup array
  For i from 1 to n_fields.v
     Moveto Field field_names.a[i]
     Menu {ValCheck} {Define} Enter {TableLookUp}
       If not IsBlank(MenuChoice()) then
                                       ; if we have a lookup table
          table_lookup.a[i] = MenuChoice()
                                       ; save it
          Enter
          table_lookup.a[i] = table_lookup.a[i] + "|" + MenuChoice()
          Enter
                                       ; JustCurrentField? setting
          table_lookup.a[i] = table_lookup.a[i] + "||" + MenuChoice()
          Enter                        ; save help type
       Else Menu Esc
       Endif
  EndFor

  ClearImage

  Moveto TableName2

  For i from 1 to n_fields.v
     Moveto Field field_names.a[i]
                                       ; Move to field (or ErrorProc)
     If (IsAssigned(picture.a[i])) and (not IsBlank(picture.a[i])) then
        Menu {ValCheck} {Define} Enter {Picture}
                                       ; if we have a picture
        CtrlBackspace                  ; Clear any defined picture
        Typein picture.a[i]            ; Typein the saved picture
        Enter
     EndIf

     If (IsAssigned(lowvalue.a[i])) and (not IsBlank(lowvalue.a[i])) then
       Menu {ValCheck} {Define} Enter {LowValue}
       CtrlBackspace                   ; lowvalue
       Typein lowvalue.a[i]
       Enter
     Endif

     If (IsAssigned(highvalue.a[i])) and (not IsBlank(highvalue.a[i])) then
       Menu {ValCheck} {Define} Enter {HighValue}
       CtrlBackspace                   ; if we have a high value
       Typein highvalue.a[i]           ; clear enter the new one
       Enter
     Endif

     If (IsAssigned(default.a[i])) and (not IsBlank(default.a[i])) then
       Menu {ValCheck} {Define} Enter {Default}
       CtrlBackspace
       Typein default.a[i]             ; if we have a default
       Enter                           ; clear and enter the new one
     Endif

;===========================================================================
     ; Flow for table lookup assignment
     ; I have used Search() to find the positions of the string separators
     ; and then SubStr() to retrieve the lookup table name and two menu
     ; settings for the val check
     ;
     ; If we have a lookup table
     ; get the length of the table name string
     ; retrieve the table name
     ; find the position of the second separator
     ; retrieve the two menu settings using Len() for the whole string
     ; If the lookup table is in the directory
     ; Set the lookup ValCheck.
;===========================================================================

     If (IsAssigned(table_lookup.a[i])) and
        (not IsBlank(table_lookup.a[i])) then
                                            ; if we have a lookup table
          x = Search("|", table_lookup.a[i])
                                            ; get the table name length
          TabName.v = Substr(table_lookup.a[i], 1, x-1)
                                            ; get the table name
          y = Search("||", table_lookup.a[i])
                                            ; position of second separator
          fill_fields.v = Substr(table_lookup.a[i], x+1, y-(x+1))  ;
          fill_help.v = Substr(table_lookup.a[i], y+2, len(table_lookup.a[i]))
                                            ; retrieve menu settings
            If IsTable(TabName.v) then
               Menu {ValCheck} {Define} Enter {TableLookup}
               CtrlBackspace                ; clear current setting
               Typein TabName.v Enter       ; enter lookup table name
               Select fill_fields.v         ; [JustCurrentField] [AllCorrFields]
               Select fill_help.v           ; [HelpandFill] ?
            Endif
     Endif
  EndFor

  Do_It!

  If IsTable("Struct") then
      Delete "Struct"
  Endif

  ClearImage
  Reset
  Return True
  EndProc

CopyValCheck("Debits", "Temp")
