; COMMLIB -- This is a script that installs general procedures in a
;   library called COMMLIB.

createlib lib_dir+"commlib"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; STARTUP --
;   Set things up for AIMS.  Called upon entry.

proc startup()
  private user_name, passwd, times_tried, user_sname, access_permission,
          access_region, access_market, printer_type, session_id, x
  reset

  x = aims_login()
  if not x then exit endif

  autolib = lib_dir+"menulib"
  menu_top()
  unlockem("\"ACCESS\" PFL")

  autolib = lib_dir+"commlib"
  aims_logout()
  exit
endproc

writelib lib_dir+"commlib" startup
release procs startup

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; AIMS_LOGIN --
;   Attempt to let a user log in to AIMS.  Set user personality variables.
; Returns: TRUE if logon successful, FALSE otherwise.

proc aims_login()

  outline("Account Information Management System")
  @ 6,10 ?? "ENTER YOUR REGISTERED NAME: "
  @ 8,10 ?? "       ENTER YOUR PASSWORD: "
  @ 6,40

  password "KEVIN"
  if not lockem("\"ACCESS\" PFL, \"ACCESS\" WL, \"ACCESS\" PWL, \"USAGELOG\" WL, \"USAGELOG\" PWL") then
    message "COULDN'T LOCK ACCESS TABLE OR USAGE LOG -- TRY AGAIN LATER"
    beep
    sleep 3000
    return FALSE
  endif

  times_tried = 0

  while TRUE
    times_tried = times_tried + 1

    @ 6,40 ?? spaces(20)
    @ 8,40 ?? spaces(20)

    user_name = ""
    style attribute 31
    @ 6,40
    accept "A30" picture "*!" required to user_name

    style attribute 31
    @ 8,40
    passwd = upper(get_pass())

    view "access"
    locate user_name, passwd
    clearall

    if retval then
      quitloop
    else
      message "Incorrect user name or password"
      beep
      sleep 3000
      if times_tried = 3 then
        reset
        Menu {Tools} {More} {Protect} {ClearPasswords}
        return FALSE
      endif
    endif
  endwhile
  release procs get_pass

  view "access"
  locate user_name, passwd
  user_name         = [User name]
  user_sname        = [User short name]
  access_permission = [Permission]
  access_region     = [Region]
  access_market     = [Market]
  printer_type      = [Default printer]
  clearall

  Menu {Tools} {More} {Protect} {ClearPasswords}

  ; Post "login" action to session log.
  coedit "usagelog"
  end
  if isblank([Session ID]) then
    session_id = 1
  else
    session_id = [Session ID] + 1
    down
  endif
  [Session ID]      = session_id
  [Login date]      = today()
  [Login time]      = time()
  [User name]       = user_name
  [User short name] = user_sname
  [Permission]      = access_permission
  [Region]          = access_region
  [Market]          = access_market
  do_it!
  clearall

  ; PFL lock on ACCESS keeps anyone from running batch while there is a user
  ; in the system.  Note that it is not removed.
  unlockem("\"ACCESS\" WL, \"ACCESS\" PWL, \"USAGELOG\" WL, \"USAGELOG\" PWL")

  return TRUE
endproc

writelib lib_dir+"commlib" aims_login
release procs aims_login

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; AIMS_LOGOUT --
;   Post logout to usage log.

proc aims_logout()
  if not lockem("\"USAGELOG\" WL, \"USAGELOG\" PWL") then
    message "COULDN'T LOCK USAGE LOG -- LOGOUT WILL NOT BE POSTED"
    beep
    sleep 3000
    return
  endif

  ; Post "logout" action to session log.
  clearall
  coedit "usagelog"
  right
  locate session_id
  if retval then
    [Logout time] = time()
  endif
  do_it!
  clearall

  unlockem("\"USAGELOG\" WL, \"USAGELOG\" PWL")
endproc

writelib lib_dir+"commlib" aims_logout
release procs aims_logout

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; OUTLINE -- Paint a standard border about the screen and put the title
; in the appropriate spot.  Leave two lines at the top for PARADOX menus.
; If there is no title, do not put title box in place.
proc outline(title)
  private center
  center = int((80-len(title))/2)

  clear
  style intense
  paintcanvas attribute 31 0,0,24,79
  @ 2, 0
  text
ͻ
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
ͼ
  endtext

  if not title = "" then
    if (center > 0) then
      @ 3, center
      ?? title
    endif

    @ 4,1  ?? ""
    @ 4,40 ?? ""
  endif

endproc

writelib lib_dir+"commlib" outline
release procs outline

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GET_PERIOD() sets global variables DATE1 and DATE2 to the starting
; and ending dates of a period.  It assumes a blank screen which has been
; OUTLINE'd and starts writing to the PAL canvas at 6,4.  Calling procedure
; is expected to provide defaults in DATE1 and DATE2.

proc get_period()
  private datea, dateb
  datea = date1
  dateb = date2

  @ 6,4
  ?? "Start date:"
  @ 7,4
  ?? "End date:"

  @ 6,17
  accept "D" default datea to date1
  if not retval then
    return FALSE
  endif

  @ 7,17
  accept "D" default dateb to date2
  if not retval then
    return FALSE
  endif

  return TRUE
endproc

writelib lib_dir+"commlib" get_period
release procs get_period

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; NEXT_MONDAY(date) returns the date of next monday based on the date
; passed to it.

proc next_monday(date)
  private day_of_week, result
  day_of_week = dow(date)
  switch
    case day_of_week = "Mon" : result = date+7
    case day_of_week = "Tue" : result = date+6
    case day_of_week = "Wed" : result = date+5
    case day_of_week = "Thu" : result = date+4
    case day_of_week = "Fri" : result = date+3
    case day_of_week = "Sat" : result = date+2
    case day_of_week = "Sun" : result = date+1
  endswitch
  return(result)
endproc

writelib lib_dir+"commlib" next_monday
release procs next_monday

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; FLASHIT -- Put a prompt on the upper left corner (0,0) of the screen.
;     Also displays a WAIT in flash mode on the upper right corner.  For
;     annunciation purposes.
proc flashit(string)
  style intense
  @ 0,0 ?? string
  clear eol
  style intense, blink
  @ 0,76 ?? "WAIT"
  style intense
  @ 1,0 clear eol
endproc

writelib lib_dir+"commlib" flashit
release procs flashit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; CLEAR_QUERIES() --  Procedure to clear any query images from workspace.
;     If the current image is a query image, the routine will terminate
;     with the first non-query image as the current image.  If the current
;     image is a non-query image, that image is returned to when the routine
;     terminates.  (Note: this procedure appeared previously in both EDITLIB
;     and INFOLIB.  Moved 12/13/88 -- BD)
;
;   Parameters: None.
;   Return codes: None.

proc clear_queries()
  private old_image

  if nimages() > 0 then
    old_image = imageno()

    moveto 1
    while imagetype() = "Query"
      clearimage
      old_image = old_image - 1
    endwhile

    if old_image >= 1 then
      moveto old_image
    endif
  endif
endproc

writelib lib_dir+"commlib" clear_queries
release procs clear_queries

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; PRINTER_READY -- Tests to see if the printer (LPT1) is ready to print and
;   signals the user if it is not.  If either the printer is ready or the
;   user makes it ready and signals to continue with printing, then the
;   procedure returns TRUE.  If the user signals to abort printing, the
;   procedure returns FALSE.
;
; Assumptions:   Standard screen border from outline(), etc.
; Parameters:    None
; Return codes:  TRUE if printer ready.

proc printer_ready()
  private choice

  flashit("Testing Printer ...")

;  Replace printer status check with always ready status.  This at the
;  request of Graham Anderson for PC-Anywhere compatibility.
;  while not printerstatus()

  while not TRUE
    @ 0,0 clear eol
    @ 1,0 clear eol
    message("Printer not ready")
    beep
    showmenu
      "Continue" : "Re-try printing report",
      "Abort" : "Return to menu and do not print report"
    to choice
    working()
    if choice = "Abort" or choice = "Esc" then
      return FALSE
    endif
    flashit("Testing Printer ...")
  endwhile
  @ 0,0 clear eol

  flashit("Printing report ...")
  return TRUE
endproc

writelib lib_dir+"commlib" printer_ready
release procs printer_ready

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; PRINT_REPORT -- Prints the specified report on the specified table with
;   the specified setup string.  Printer_type is the global variable that
;   holds the printer type.
;   Needs to be in VIEW mode.

proc print_report(tabname,repno,fmt)
  private curr_img, rsetup, rlength, rwidth

  curr_img = imageno()

  view "setup"
  locate printer_type, fmt
  if not retval then
    rsetup = ""
    rlength = 66
    rwidth = 80
  else
    rsetup  = [setup]
    rwidth  = [width]
    rlength = [length]
  endif
  clearimage

  if printer_ready() then
    Menu {Report} {Change}  select tabname  select repno  enter
    Menu {Setting} {Setup} {Custom} {LPT1} select rsetup
    Menu {Setting} {PageLayout} {Width} select rwidth
    Menu {Setting} {PageLayout} {Length} select rlength
    Menu {Output} {Printer}
    Menu {Cancel} {Yes}
  endif

  if not curr_img = 0 then
    moveto curr_img
  endif
endproc

writelib lib_dir+"commlib" print_report
release procs print_report

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; DEAD_STUB -- For menu selections or procedures not yet implemented.

proc dead_stub()
  private x

  clear
  style intense
  paintcanvas attribute 31 0,0,24,79
  @ 2, 0
  text
ͻ
  NOT YET IMPLEMENTED STUB                                                    
                                                                              
  This particular function has not been implemented for this version of       
  the Account Information Management System (AIMS).  Look for this feature    
  in an upcoming release.                                                     
                                                                              
  If you have questions regarding the operation of the AIMS database          
  application please refer to the AIMS user documentation or contact your     
  system administrator.                                                       
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
  PLEASE HIT ANY KEY TO CONTINUE                                              
                                                                              
ͼ
  endtext

  while not charwaiting()
  endwhile
  x = getchar()  ; Flush buffer

endproc
writelib lib_dir+"commlib" dead_stub
release procs dead_stub

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Confirm --
;   Prompts the user with a No/Yes menu to confirm an action.  Returns
;   TRUE if the user selects Yes (agrees to continue), FALSE otherwise.
proc confirm(action)
  private choice
  showmenu
    "No"  : "Do not " + lower(substr(action,1,1)) + substr(action,2,255),
    "Yes" : action
  to choice
  working()
  return choice = "Yes"
endproc

writelib lib_dir+"commlib" confirm
release procs confirm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; PICTURE_LOOKUP --
;     This procedure converts the current field's PICTURE clause into a
;     series of records and allows user to select one, just like a
;     HelpAndFill.
;
;   Assumed:
;     Called in Edit mode.  Calling procedure must re-position on workspace,
;     go back to appropriate mode, form, record & field.
;     In the PICTURE valcheck the field choices are separated by a comma.
;     The field choices may also be surrounded by curly braces.
;
;     Valid example #1: "Y,N"
;     Valid example #2: "{ACTIVE},{CANCEL},{HOLD},{OPEN}"
;
;   Parameters:
;     fldnam -- the name of the field, from field()
;     pic -- the picture string.
;
;   Side effects:
;     The ANSWER table is used.
;
;   Returns:
;     If the user makes a selection the value will be returned, else a null
;     string will be returned.

proc picture_lookup(fldnam, pic)
  private fldtyp, choice, x, y, val

  flashit("")
  fldtyp = fieldtype()
  pic = pic + ","
  do_it!

  ; Make sure field type specifies key field.
  if not substr(fldtyp,len(fldtyp),1) = "*" then
    fldtyp = fldtyp + "*"
  endif

  ; Create dummy lookup table to put choices in.
  create "lookup" fldnam : fldtyp

  ; Add choices.  X always represents the last character of the current
  ; choice.  Since PIC is created with a trailing comma, there is always
  ; a comma at the end of every choice.
  coedit "lookup"
  while not isblank(pic)
    x = search(",", pic)
    choice = substr(pic,1,x-1)
    pic = substr(pic,x+1,255)

    ; Kill leading and trailing spaces and curly braces, if any.
    y = search("{", choice)
    if not y=0 then
      choice = substr(choice,y+1,255)
    endif

    y = search("}", choice)
    if not y=0 then
      choice = substr(choice,1,y-1)
    endif

    []=choice
    down
  endwhile
  do_it!

  firstshow
  home
  wait table
    prompt "Select a value ...", "F2-Select   Esc-Exit"
  until "F2", "Esc"
  working()

  if retval = "F2" then
    ctrlhome right
    val = []
  else
    val = "Esc"
  endif

  clearimage
  return val
endproc

writelib lib_dir+"commlib" picture_lookup
release procs picture_lookup

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; LOOKUP_SELECT_WITH_SEARCH --
;   This procedure mimics a WAIT command in lookup help.  Unfortunately,
;   although you can enter into lookup help from within a WAIT, you cannot
;   enter into a WAIT from within lookup help.  Thus if the programmer wishes
;   to provide the user access to the lookup help table, and a WAIT is not
;   currently in effect, he/she must call this procedure.  THIS PROCEDURE
;   WILL FUNCTION ONLY ON LOOKUP HELP TABLES.
;
;   Please note that the procedure turns echo to normal in order to display
;   the lookup table, and turns echo off upon exit.  This is different from
;   the WAIT command which leaves the echo status unchanged.
;
;   The procedure will return the ASCII value of the key that was pressed
;   which caused the wait to be left (either Esc or Do_It!).  As with the
;   WAIT comand, control will be passed back to the caller BEFORE the key
;   is acted upon.
;
;   Canibalized from the Data Entry Toolkit.
;   Contains Licensed Material Copyright (C) 1987 Ansa Software
;
;   Modified 3/4/91 by Brett D'Ambrosio to provide incremental search
;   capability.  Once the F1 key is pressed, any letters keys pressed
;   go into an incremental search pattern.  When the user has arrived at
;   the desired record, he/she can press F2 to select it.
;
;   Also modified to be self sufficient.  Call this procedure when F1 is
;   pressed in any field (Edit/CoEdit mode only).
;
;   Modified 7/14/91 by Brett D'Ambrosio to work in VIEW mode as well,
;   providing that necessary tables are lockable.  In order to work the
;   variable LOCKSTR must be defined before calling.  Note that it is
;   *slow* in VIEW mode.
;
;   Modified 8/28/91 to allow the use of Zoom within lookup.
;
;   REVISIT -- Also maybe lock the lookup table first?
;

proc lookup_select_with_search()
  private ch, first_time, curr_val, in_view_mode, curr_tab, curr_fld

  if not sysmode() = "Main" then
    in_view_mode = FALSE
    prompt "LOOKUP HELP -- Select a value",
           "F2-Select   Esc-Quit   CtrlZ-Zoom   A-Z-Incremental search"
  else
    if nimagerecords() = 0 then
      message "There is no value to lookup.  You must add a record using Insert first."
      beep
      sleep 3000
      return
    endif

    in_view_mode = TRUE
    if isassigned(lockstr) then
      lockem(lockstr)
      if not retval then
        return
      endif
    endif
    curr_tab = table()
    curr_fld = field()
    coeditkey
    imagerights readonly
    prompt "LOOKUP HELP","Esc-Quit   CtrlZ-Zoom   A-Z-Incremental search"
  endif

  curr_val = strval([])
  help
  if not helpmode()="LookupHelp" then
    esc
    message "There is no lookup help for this field"
    beep
    sleep 3000

  else
    ; Perform lookup help with incremental search feature.
    if not isblank(curr_val) then
      zoom
      ctrlbackspace
      typein curr_val
      enter
    endif

    echo normal
    retval=0
    first_time = TRUE

    while true
      retval=getchar()
      ch = upper(chr(max(retval,1)))
      switch
        case retval=-60 or retval=27 or retval=0:
          quitloop

        case retval=-80 or retval=-72 :
          ; Up or down arrow -- reset incremental search.
          first_time = TRUE
          keypress retval

        case 0 < search(ch,"ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789") :
          zoom
          if first_time then
            ctrlbackspace
            first_time = FALSE
          else
            backspace
            backspace
          endif
          typein ch+".."
          enter

        case retval=-59 :
          ; F1 key pressed again
          beep

        case retval=26 :
          ; Zoom key pressed
          first_time = TRUE
          zoom
          ctrlbackspace
          x = getchar()
          while not (x=-60 or x=0 or x=13 or x=27)
            keypress x
            x = getchar()
          endwhile
          if x=13 or x=-60 then
            enter
          else
            esc
          endif

        otherwise :
          keypress retval
      endswitch
    endwhile

    echo off
    synccursor
    ; CtrlBreak functions the same as Esc.  Return the code for Esc unless
    ; Do_It! is pressed and we're not in view mode.
    if retval=0 or in_view_mode
       then retval=27
    endif
    keypress retval
  endif

  prompt

  if in_view_mode then
    if isassigned(lockstr) then
      unlockem(lockstr)
    endif
    imagerights
    do_it!
    moveto curr_tab
    moveto field curr_fld
  endif
endproc

writelib lib_dir+"commlib" lookup_select_with_search
release procs lookup_select_with_search

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; LOOKUP_WITH_ADD --
;   This procedure mimics a HelpAndFill, but provides the ability to add
;   records to the lookup table.

proc lookup_with_add(looktab, fldnam)
  private choice, tkey

  flashit("")
  do_it!

  view looktab
  firstshow

  while TRUE
    firstshow
    echo normal
    wait table
      prompt "Select or add a value ...", "F2-Select   F4-Add   Esc-Exit"
    until "F2", "F4", "Esc"
    working()
    echo off

    switch
      case retval = "Esc" :
        val = "Esc"
        quitloop

      case retval = "F2" :
        ctrlhome right
        val = []
        quitloop

      case retval = "F4" :
        coeditkey
        ins

        while not sysmode() = "Main"
          echo normal
          wait record
            prompt "Please fill in all relevant fields ...",
                   "F2-Completed   Esc-Cancel"
          until "F2", "Esc"
          working()
          echo off

          if retval="Esc" then
            del
            do_it!
            loop
          endif

          ctrlhome right
          tkey = []
          do_it!
          locate tkey
        endwhile
    endswitch
  endwhile

  clearimage
  return val
endproc

writelib lib_dir+"commlib" lookup_with_add
release procs lookup_with_add

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; PASS --
;   Determine if current user has sufficient access rights to perform calling
;   function.  If so return TRUE.  If not, alert the user and return FALSE.

proc pass(needed_level)
  private have, need

  switch
    case access_permission = "PRG" : have = 6
    case access_permission = "COR" : have = 5
    case access_permission = "EXC" : have = 4
    case access_permission = "ROS" : have = 3
    case access_permission = "REG" : have = 2
    case access_permission = "MKT" : have = 1
  endswitch

  switch
    case needed_level = "PRG" : need = 6
    case needed_level = "COR" : need = 5
    case needed_level = "EXC" : need = 4
    case needed_level = "ROS" : need = 3
    case needed_level = "REG" : need = 2
    case needed_level = "MKT" : need = 1
  endswitch

  if have >= need then
    return TRUE
  else
    message "You need "+needed_level+" access to perform this function."
    beep
    sleep 3000
  endif

  return FALSE
endproc

writelib lib_dir+"commlib" pass
release procs pass

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; ERROR_HANDLER --
;   System error handler.  Paradox executes this procedure in case of a
;   run-time error.  The proc writes identification information and a
;   SAVEVARS dump to a temporary file in the user directory.  This file
;   is then appended to the ERRORLOG.TXT file in the main AIMS directory.

proc error_handler()
  private errorproc, ec, em, errfile, tdisk, x

  ec = errorcode()
  em = errormessage()
  errfile = privdir()+"ERRORLOG.TMP"

  ; Correctable errors.
  switch
    case ec = 43 :
      message "Printer not ready.  Please correct and press any key to continue."
      beep
      while not charwaiting()
      endwhile
      x = getchar()
      return 0   ; Resume execution

    case ec = 23 :
      ; Invalid field value.
      return 1   ; Skip field assignment statement.
  endswitch


  ; If the user has Programmer clearance or a "2020" username bypass the
  ; error handler, and allow user to go into debug mode.

  if not isassigned(access_permission) then
    return 2   ; Debugger
  endif

  if access_permission = "PRG" or user_name = "2020" then
    return 2   ; Debugger
  endif

  echo off
  clear
  style intense
  paintcanvas attribute 31 0,0,24,79
  @ 2, 0
  text
ͻ
  SYSTEM ERROR                                                                
                                                                              
  An AIMS system error occurred.  A file detailing the nature of the error    
  will be stored to assist the system administrator and/or programmer in      
  tracking down the problem.  Please call the system administrator for        
  assistance and to report the error.                                         
                                                                              
  We apologize for any inconvenience.                                         
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
  PLEASE HIT ANY KEY TO WRITE ERROR DESCRIPTION FILE AND EXIT THE SYSTEM.     
                                                                              
ͼ
  endtext

  ; Wait for user to press key.
  while not charwaiting()
  endwhile

  message "Writing error description file ..."
  ; Make sure there is disk space to write out error files.
  if ec=41 then
    message(em)
    exit
  endif

  ; Assign date and time variables for error file.
  run "del "+errfile
  print file errfile "\n"
  print file errfile "--------------------------------------------------------------------------\n"
  print file errfile "ERROR #:"+strval(ec)+" -- "+em+"\n"
  print file errfile "Date: "+strval(today())+"  Time: "+time()+"\n"
  print file errfile "\n"

  print file errfile "System:\n"
  print file errfile "    Free RAM: "+format("w15,ec",memleft())+"\n"
  tdisk=upper(substr(directory(),1,1))
  if drivestatus(tdisk) then
    print file errfile "    Current drive: "+tdisk+":, available space: "+format("w15,ec",drivespace(tdisk))+"\n"
  endif
  print file errfile "\n"
  print file errfile "Directories:\n"
  print file errfile "    Current: ",upper(directory()),"\n"
  print file errfile "    Private: ",upper(privdir()),"\n"
  print file errfile "\n"
  print file errfile "Paradox:\n"
  print file errfile "    Version: "+format("w4.1",version())+"\n"
  if isruntime() then
    print file errfile "    (Runtime version)\n"
  endif
  print file errfile "    Mode: "+sysmode()+"\n"
  print file errfile "    Network: "+nettype()+"\n"
  print file errfile "    Current username: "+username()+"\n"
  print file errfile "    Error username: "+erroruser()+"\n"
  print file errfile "    Retry Period: ",retryperiod(),"\n"
  print file errfile "\n"

  if imageno()=0 then
    print file errfile "No images on workspace.\n"

  else
    moveto 1
    for x from 1 to nimages()
      print file errfile "Current Image: ",imageno()," of ",nimages(),"\n"
      print file errfile "    Name: ",table(),"  Type: ",imagetype(),"\n"
      switch
        case imagetype()="Display"  :
          if field()="#" then right endif
          print file errfile "        Record: ",recno()," of ",nrecords(table()),"\n"
          print file errfile "        Field: [",field(),"]  ",fieldno(field(),table())," of ",nfields(table())
          if fieldno(field(),table())<=nkeyfields(table()) then
            print file errfile " (Key Field)"
          endif
          print file errfile "\n"
          print file errfile "        Table Rights: "
          if tablerights(table(),"All") then
            print file errfile "ALL "
          else
            if tablerights(table(),"ReadOnly") then print file errfile "ReadOnly " endif
            if tablerights(table(),"Update") then print file errfile "Update " endif
            if tablerights(table(),"Entry") then  print file errfile "Entry " endif
            if tablerights(table(),"InsDel") then  print file errfile "InsDel " endif
          endif
          print file errfile "\n"

          print file errfile "        Field Rights: "
          if fieldrights(table(),field(),"All") then
            print file errfile  "ALL "
          else
            if fieldrights(table(),field(),"ReadOnly") then  print file errfile  "ReadOnly " endif
          endif
          print file errfile "\n"

        case imagetype()="Query" :

      endswitch
      print file errfile "\n"
      downimage
    endfor
  endif
  print file errfile "\n"

  ; exit any mode other than main
  reset

  ; Save variables
  savevars all

  ; Append to main error file.
  run "type "+errfile+" >> "+main_dir+"ERRORLOG.TXT"
  run "type "+privdir()+"savevars.sc >> "+main_dir+"ERRORLOG.TXT"

  message "Exiting system ..."
  exit

endproc

writelib lib_dir+"commlib" error_handler
release procs error_handler

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GET_PASS --
;   Get password from user, print only asterisks when characters typed in.
;   Adapted for use from GetPassword() supplied by Borland.

proc get_pass()
  private pass, char

  pass = ""
  char = getchar()
  while (char <> 13 or isblank(pass)) and char <> 27
    switch
      case char = asc("CtrlBackspace") :
        @ row(), col()-len(pass)
        ?? spaces(len(pass))
        @ row(), col()-len(pass)
        pass = ""
      case char > 31 and len(Pass) < 6 :           ;Acceptable character
        ?? "*"
        pass = pass+chr(char)
       case char = 8 and match(pass,"..@",pass) :   ;Backspace
        @ row(), col()-1
        ?? spaces(1)
        @ row(), col()-1
      case char = 13 :
        message "Please enter a password"
      otherwise :                                  ;Illegal character
        beep
    endswitch
    char = getchar()
  endwhile

  if char = 27 then
    return ""
  else
    return pass
  endif
endproc

writelib lib_dir+"commlib" get_pass
release procs get_pass

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; WAITING --
;   This procedure displays "WAITING ..." message in lower left of screen.

proc waiting()
  style
  @ 0,0 clear eol
  @ 1,0 clear eol
  style intense
  @ 0,69 ?? "Waiting "
  style intense, blink
  ?? "..."
  style
endproc

writelib lib_dir+"commlib" waiting
release procs waiting

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; WORKING --
;   This procedure displays "WORKING ..." message in lower left of screen.

proc working()
  style
  @ 0,0 clear eol
  @ 1,0 clear eol
  style intense
  @ 0,69 ?? "Working "
  style intense, blink
  ?? "..."
  style
endproc

writelib lib_dir+"commlib" working
release procs working

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; LOCKEM --
;   This procedure attempts to lock tables specified in the lock string
;   passed to it (a list of table names and lock types).  The lock is tried
;   for the period defined with SetRetryPeriod.  If it fails, the user is
;   given the opportunity of continuing to try or quitting.

proc lockem(lockstr)
  private choice

  message "Locking tables"

  while TRUE
    execute "lock "+lockstr
    if not retval then
      message "Cannot lock a table in use by: "+erroruser()
      showmenu
        "Try again" : "Continue trying to lock the table",
        "Quit"      : "Quit trying to lock the table, return to what you were doing"
      to choice
      working()
      if choice = "Quit" or choice = "Esc" then
        return FALSE
      endif
    else
      return TRUE
    endif
  endwhile
endproc

writelib lib_dir+"commlib" lockem
release procs lockem

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; UNLOCKEM --
;   This procedure unlocks the tables in the lock string passed to it.

proc unlockem(lockstr)
  message "Unlocking tables"
  execute "unlock "+lockstr
endproc

writelib lib_dir+"commlib" unlockem
release procs unlockem

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; DO_IT_RIGHT --
;   Copyright (C) 1990 as an unpublished work by Brett D'Ambrosio,
;   20/20 Systems Corporation, 5949 Avon Drive, Bethesda, MD 20814.
;   202-943-5340

;   This procedure replaces the proverbial do_it! from queries with a
;   monitored do_it!.  If the query does not execute successfully an error
;   is generated.  Also, if global variable debug_flag exists and is set to
;   TRUE, then the script will pause for the programmer to examine the query.

proc do_it_right()
  private currimage
  if isassigned(debug_flag) and debug_flag then
    debug
  endif

  if not (sysmode() = "Main" and imagetype() = "Query") then
    ; Not a query do_it!, so just do it. (pun poor, but intended)
    do_it!
    return
  endif

  ; This is a query, so check results of do_it!
  do_it!

  currimage = imagetype()
  if currimage = "None" or currimage = "Query" then
    ; Query failed.  Notify programmer.
    message "Query failed"
    debug
  endif
endproc

writelib lib_dir+"commlib" do_it_right
release procs do_it_right

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; ISSUE_SEQ_NO --
;   Copyright (C) 1990 as an unpublished work by Brett D'Ambrosio,
;   20/20 Systems Corporation, 5949 Avon Drive, Bethesda, MD 20814.
;   202-943-5340

;   This procedure generates a number that always increases based on the
;   system clock.  The number it generates is an integer in the form
;   YYMMDDHHMMSS that corresponds to a string manipulation of the current
;   date and time.  To the extent that all machines have accurate real-time
;   clocks, these numbers will be unique accross all users.  (Novell sets the
;   time on a remote workstation every time that workstation connects to the
;   network, so this is not a TERRIBLE assumption.)  It really isn't even
;   that important as the main purpose of the sequential number is to prevent
;   key conflicts in multi-record boxes.  The numbers NEED to be different
;   only when all other key fields are the same in two records in a multi-
;   table box.  This method is faster than accessing a common table.
;   To protect against the occasional failures of this method, a random
;   number less than one is added to the integer to make sure the number is
;   unique.

proc issue_seq_no()
  private x, y
  x = format("d11",today())
  y = substr(x,1,2)+substr(x,4,2)+substr(x,7,2)
  x = time()
  y = y+substr(x,1,2)+substr(x,4,2)+substr(x,7,2)
  return numval(y)+rand()
endproc

writelib lib_dir+"commlib" issue_seq_no
release procs issue_seq_no

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; FIELDVIEW_SIMULATE --
;   This procedure allows the use of "Ins" and "Del" keys within fieldview()
;   and within a WAIT statement.  Paradox automatically terminates fieldview
;   when the WAIT is exited, hence the isfieldview() command cannot be used
;   to switch the functionality of the Ins and Del keys between 2 modes.

proc fieldview_simulate()
  prompt "FIELDVIEW -- Press ENTER to terminate",""
  fieldview
  echo normal
  while isfieldview()
    temp = getchar()
    keypress temp
  endwhile
  echo off
  prompt
endproc

writelib lib_dir+"commlib" fieldview_simulate
release procs fieldview_simulate

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GIMME_SOME() --
;   Take as many words as fit in a string of parameter WRAPLEN length off the
;   front of global variable TXT.  Used for word wrapping.

proc gimme_some(wraplen)
  private x, result

  result = ""

  while not isblank(txt)
    x = search(" ",substr(txt,2,255))
    if x=0 then
      x = len(txt)
    endif
    if len(result)+x > wraplen then
      quitloop
    endif
    result = result + substr(txt,1,x)
    txt = substr(txt,x+1,255)
  endwhile

  return result
endproc

writelib lib_dir+"commlib" gimme_some
release procs gimme_some

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






