; SampCode.SC - Script to generate Sample.LIB containing the following
;               procedures, which are part of the example application.
;
; This script has been placed into the public domain.  (See SHARE.TXT for
; definitions of public domain, shareware, and freeware.)  Other files that
; accompany this script may or may not be copyrighted.

CreateLib "Sample" Size 50

;--------------------------------------------------------------------
Proc Sample_FieldHelp()
;Description:
;  A demonstration of how to provide field-level prompts.
;Created: 5/22/93 CLJ (based on an idea by Bill Yock).
;Parameters: None
;Usage: Assigned as the Arrive Field event in a Workshop edit session.
;Input & Assumptions:
;  none
;Output & Ramifications:
;  Returns nothing.
;  Modifies nothing.
;Notes:
;  As written, this proc does not discern which is the current table.
;  (This sample only has one.)  You might want to embed the Switch statement
;  within another switch statement that checks the value of Table().  On the
;  other hand, if your tables have many fieldnames in common, you might not.
;Globals: none
;Private (none)
   Switch
     Case Field()= "Mail ID":     Message "This ID number is automatically assigned."
     Case Field()= "First Name":  Message "Enter the person's first name and/or middle initial."
     Case Field()= "Last Name":   Message "Enter the person's last name."
     Case Field()= "Title":       Message "Enter the person's title or department."
     Case Field()= "Street 1":    Message "Enter the street address or PO box."
     Case Field()= "Street 2":    Message "Additional street address or PO box information."
     Case Field()= "City":        Message "The name of the city or town."
     Case Field()= "State":       Message "Enter the state or province name."
     Case Field()= "Postal Code": Message "Enter the U.S. zip code or international postal code."
     Case Field()= "Country":     Message "Enter the country name.  Leave blank for U.S.A."
     Case Field()= "Phone":       Message "Enter the phone no./area code as: ###/###-####.  Use Alt-D to dial it."
     Case Field()= "Updated":     Message "This date is automatically reset whenever you change a record."
     Case Field()= "Comment":     Message "Press Ctrl-F to enter/edit this comment."
     Case Field()= "Active":      Message "Enter Y for yes, N for No."
     Case Field()= "Labels Needed":Message "Enter the number of labels to be printed."
   EndSwitch
EndProc

WriteLib "Sample" Sample_FieldHelp
Release Procs     Sample_FieldHelp

;--------------------------------------------------------------------
PROC Sample_FillBillboard(W)
;Description:
;  Demonstrates a nested call to the CLAW_Progress(Completed_N) function.
;Created: 5/6/93 CLJ
;Parameters: None
;Usage: Called by Sample_GaugeDemo(), below.
Private A,L,N,V
,CLAW_Progress_Y  ; must be private to distinguish from 1st status gauge
   ; Establish the parameters for this display
   DynArray CLAW_Progress_Y[]
   CLAW_Progress_Y["TITLE"]  = "Painting Billboard"
   CLAW_Progress_Y["TARGET"] = 23   ; number of steps
   CLAW_Progress_Y["ROW"]    = 8    ; screen position for status gauge
   CLAW_Progress_Y["COL"]    = 24   ;   "       "      "    "      "
   For S1 from 1 to 5 ; bounce around among the character string
     For S2 from 1 to 5
       S=S2*5+S1-5    ; postition of next character to display
       CLAW_Progress(S1*4+S2-4) ; show our status
       A = SubStr(" The CLAW - Version 1.0  ",S,1) ; the character to display
       If A<>" " Then
         Sleep 250
         SetCanvas W
         For S3 from 25 to 31 ; cycle thru bright colors on blue background
           Style Attribute S3
           @ 4,S+1 ?? A
           Sleep 15
         EndFor
         Sound 100 20 ; click
       EndIf
     EndFor
   EndFor
   CLAW_ProgressClear() ; erase the status gauge
   Return True
ENDPROC
WriteLib "Sample" Sample_FillBillboard
Release Procs Sample_FillBillboard

;--------------------------------------------------------------------
PROC Sample_GaugeDemo()
;Description:
;  Demonstrates the CLAW_Progress(Completed_N) function with nested calls.
;Created: 5/6/93 CLJ
;Parameters: None
;Usage: Called directly from an application menu option.
Private A,L,N,V
,CLAW_Progress_Y
,Billboard_W
   ; set up the "billboard" window (off screen)
   Window Create Floating @25,25 Height 10 Width 30 To Billboard_W
   Paintcanvas Attribute 30 0,0,9,29 ; yellow on blue

   DynArray CLAW_Progress_Y[]
   CLAW_Progress_Y["TITLE"]  = "Billboard Sequence"
   CLAW_Progress_Y["TARGET"] = 4     ; number of steps
   CLAW_Progress_Y["ROW"]    = 2     ; screen position for status gauge
   CLAW_Progress_Y["COL"]    = 25    ;   "       "      "    "      "
   CLAW_Progress(1)                  ; 25% done (1/4)
   Sleep 1000
   Sample_MoveBillboard(Billboard_W) ; nested status example
   Sleep 1000
   CLAW_Progress(2)                  ; 50% done (2/4)
   SetCanvas Billboard_W
   Style Attribute 30
   @ 2,2 ?? "Introducing..."
   Sleep 1000
   CLAW_Progress(3)                  ; 75% done (3/4)
   Sample_FillBillboard(Billboard_W) ; another nested status example
   Sleep 1000
   CLAW_Progress(4)                  ; 100% done (4/4)
   SetCanvas Billboard_W
   Paintcanvas Attribute 128+30 0,0,9,29
   Sleep 1000
   CLAW_Chime2()
   Sleep 1000
   CLAW_ProgressClear()              ; erase the status gauge
   Window Select Billboard_W         ; erase the billboard
   Window Close
   Return True
ENDPROC ; Sample_GaugeDemo
WriteLib "Sample"  Sample_GaugeDemo
Release Procs Sample_GaugeDemo

;--------------------------------------------------------------------
PROC Sample_MailingLabels()
;Description:
;  Print a strip (or strips) of multiple mailing labels for the same
;  address(es).
;Parameters: None
;Usage: Called by main menu
;Input & Assumptions:
;  Assumes that [Sample->Labels Needed] is already set to the number of
;  labels needed (each record).
;Output & Ramifications:
;  Returns nothing.
;  Modifies nothing.
;Notes:
;Globals:
;
Private A,L,N,V
   ClearAll
   View "Sample"
   Scan
     If IsBlank([Labels Needed]) Or [Labels Needed]<1 Then Loop EndIf
     For n from 1 to [Labels Needed]
       Print [First Name]+" "+[Last Name]+"\n"
       LineCount_S = 1
       If Not IsBlank([Title]) Then
         Print [Title]+"\n"
         LineCount_S = LineCount_S + 1
       EndIf
       If Not IsBlank([Street 1]) Then
         Print [Street 1]+"\n"
         LineCount_S = LineCount_S + 1
       EndIf
       If Not IsBlank([Street 2]) Then
         Print [Street 2]+"\n"
         LineCount_S = LineCount_S + 1
       EndIf
       Print [City]+", "+[State]+"  "+[Postal Code]+"\n"
       LineCount_S = LineCount_S + 1
       For s from LineCount_S+1 to 6
         Print "\n"
       EndFor
     EndFor
   EndScan
   ClearAll
   If IsAssigned(CLAW_Labels_Y["RESET"]) Then
     Print CLAW_Labels_Y["RESET"]
   EndIf
   Return True
ENDPROC ; Sample_MailingLabels
WRITELIB "Sample" Sample_MailingLabels
RELEASE PROCS Sample_MailingLabels


;--------------------------------------------------------------------
PROC Sample_MailinglistStartup()
;Description:
;  Setup proc for the Mailing List Edit Session.  Establishes the global
;  parameters required for dialing the phone via modem.  Also calls
;  CLAW_FullScreenSetup() (since we cannot directly attach two procs to
;  the same event, we do it by call one from within the other).
;Created: 5/5/93 CLJ
;Parameters: None
;Usage: Called by Edit Session (setup event proc)
;Globals:
;  CLAW_Phone_Y["AREACODE"]  (created)
;  CLAW_Phone_Y["PORT"]      (created)
;Private: none

;DynArray CLAW_Phone_Y[]
;???   CLAW_Phone_Y["AREACODE"] = "714"      ; local area code
;???   CLAW_Phone_Y["PORT"]     = 2          ; serial port with modem
   CLAW_FullScreenStartup()
EndProc
WriteLib "Sample" Sample_MailinglistStartup
Release Procs Sample_MailinglistStartup

;--------------------------------------------------------------------
PROC Sample_MoveBillboard(W)
;Description:
;  Demonstrate the CLAW_Progress(Completed_N) function.
;Created: 5/6/93  6:24:46
;Parameters: None
;Usage: Called by Sample_GaugeDemo(), above.
Private A,L,N,V
,CLAW_Progress_Y  ; must be private to distinguish from 1st status gauge
   ; Establish the parameters for this display
   DynArray CLAW_Progress_Y[]
   CLAW_Progress_Y["TITLE"]  = "Erecting Billboard"
   CLAW_Progress_Y["TARGET"] = 20   ; number of steps
   CLAW_Progress_Y["ROW"]    = 6    ; screen position for status gauge
   CLAW_Progress_Y["COL"]    = 24   ;   "       "      "    "      "
   For S from 1 to 20  ; move the billboard window in 20 increments
     CLAW_Progress(S)
     Sleep 100
     ; move left by one space and either up or down
     Window Move W to 8+Abs(15-S),26-S
     Sound 600 50 ; click
   EndFor
   CLAW_ProgressClear()
   Return True
ENDPROC
WriteLib "Sample" Sample_MoveBillboard
Release Procs Sample_MoveBillboard

;--------------------------------------------------------------------
PROC Sample_MusicalInterlude()
;Description:
;  Play some music
;Created: 5/23/93 CLJ
;Parameters: None
;Usage: Called by ???
;Input & Assumptions:
;
;Output & Ramifications:
;  Returns nothing.
;  Modifies the contents of nothing.
;Notes:
;Globals:
Private CLAW_Music_Y
   CLAW_MusicSetup()
   CLAW_PlayMusicalNote("HE",1/8,False)
   CLAW_PlayMusicalNote("HD#",1/8,False)
   CLAW_PlayMusicalNote("HE",1/8,False)
   CLAW_PlayMusicalNote("HD#",1/8,False)
   CLAW_PlayMusicalNote("HE",1/8,False)
   CLAW_PlayMusicalNote("HD#",1/8,False)
   CLAW_PlayMusicalNote("HB",1/8,False)
   CLAW_PlayMusicalNote("HD",1/8,False)
   CLAW_PlayMusicalNote("HC",1/8,False)
   CLAW_PlayMusicalNote("HA",1/4,False)

   CLAW_PlayMusicalNote("B",1/8,False)
   CLAW_PlayMusicalNote("D",1/8,False)
   CLAW_PlayMusicalNote("C",1/8,False)
   CLAW_PlayMusicalNote("A",1/4,False)

   CLAW_PlayMusicalNote("HB",1/8,False)
   CLAW_PlayMusicalNote("HD",1/8,False)
   CLAW_PlayMusicalNote("HC",1/8,False)
   CLAW_PlayMusicalNote("HA",1/4,False)

   CLAW_PlayMusicalNote("E",1/8,False)
   CLAW_PlayMusicalNote("D#",1/8,False)
   CLAW_PlayMusicalNote("E",1/8,False)
   CLAW_PlayMusicalNote("D#",1/8,False)
   CLAW_PlayMusicalNote("E",1/8,False)
   CLAW_PlayMusicalNote("D#",1/8,False)
   CLAW_PlayMusicalNote("B",1/8,False)
   CLAW_PlayMusicalNote("D",1/8,False)
   CLAW_PlayMusicalNote("C",1/8,False)
   CLAW_PlayMusicalNote("A",1/4,False)

   CLAW_PlayMusicalNote("LA",1/8,False)
   CLAW_PlayMusicalNote("LE",1/8,False)
   CLAW_PlayMusicalNote("LA",1/8,False)
   CLAW_PlayMusicalNote("LC",1/8,False)
   CLAW_PlayMusicalNote("LE",1/8,False)
   CLAW_PlayMusicalNote("LA",1/8,False)
   CLAW_PlayMusicalNote("LE",7/8,False)

   Return True
ENDPROC ;         Sample_MusicalInterlude
WriteLib "Sample" Sample_MusicalInterlude
Release Procs     Sample_MusicalInterlude


;--------------------------------------------------------------------
Proc Sample_Number()
;Description:
; Proc to assign a mailing list no. This proc is attached to the
; mailing lists edit session as an arrive-record event proc.
; It uses the [Next mailing list] field in the control table to get
; next number to assign.
;Parameters: None
;Usage: Called as the arrive-record event proc
;Input & Assumptions:
;  Assumes that the edit session has been defined with the Control table on the
;  workspace as well as the Sample mailing list table.
;Output & Ramifications:
;  none
;Notes:
;Globals: none
;
Private s
,MailID_N
,LineNo_S
,WasFormView_L
   Echo Off
   Switch
     Case Upper(Table())="SAMPLE":
       ImageRights
       If IsBlank([Mail ID]) Then       ; customer record needs a number
         [Mail ID] = "NEW"; something to appease Paradox so that it doesn't try
                         ; to close up an empty record
         PostRecord
         If RetVal=False Then; a "NEW" record was left lying around, so use it instead
           Del; remove this conflicting record
         EndIf
         WasFormView_L = IsFormView()
         If WasFormView_L Then
           FormKey; go to table view
         EndIf
         MoveTo "Control"
         For s from 1 to 100
           LockRecord
           If Retval or ErrorCode() = 55 Then; was not previously locked
             ; or was already locked by us
             Retval = True
             QuitLoop; continue
           EndIf
           Sleep 10
         EndFor; try again
         If Not Retval Then
           Beep Message "Cannot assign a mailing list number."
           Return 2; quit the edit session
         EndIf
         ; Control table record is now locked
         MailID_N = [Next Mail ID]+1
         [Next Mail ID] = MailID_N
         UnLockRecord
         MoveTo "Sample"
         If WasFormView_L Then
           FormKey; go back to form view
         EndIf
         MoveTo [Mail ID]; set up for the following locate
         Locate "NEW"
         [] = SubStr(Format("W6,EZ",MailID_N),2,6); set the next number with leading zeros
         Right
       EndIf
       [Updated] = Today() ; establish a last updated date
;     Case Upper(Table())="MYDETAILTABLE":
;       If IsBlank([Line No]) Then; the detail record has not been numbered
;         Imagerights
;         MoveTo [Line No]; find highest number assigned so far
;         LineNo_S = ImageCMax()
;         If LineNo_S = "Error" Then LineNo_S = 0 EndIf
;         [] = Int(LineNo_S+1); set the next number
;         Right; move to next field
;       EndIf
   EndSwitch
   Return 0; okay to proceed with the edit session
EndProc
WriteLib "Sample" Sample_Number
Release Procs Sample_Number


;--------------------------------------------------------------------
Proc Sample_Status()
;Description:
;  Display statistics about the size of the mailing list database.
;Parameters: None
;Usage: Called by application menu
;Input & Assumptions:
;  no assumptions
;Output & Ramifications:
;  displays data on screen
;Notes:
;Globals: none
;
Private
 StatWindow
,StatWindowSpecs
,Event_Y
   ClearAll
   DynArray StatWindowSpecs[]         ; (used in following Window Create)
   StatWindowSpecs["HasFrame"] = False
   Window Create Floating
     @ 5,10                           ; where to place the window
     Width 60 Height 11               ; size of the window
     Attributes StatWindowSpecs       ; (from above) no border around window
     To StatWindow                    ; window handle
   PaintCanvas Attribute 111 0,0,10,59  ; white on brown
   Style Attribute 111
   Text

 Current status of the mailing list database
 
 Listings on file ...............................
 Active Listings on file ........................
 Next Mailing List ID Number ....................
 

 Press any key to continue...
   EndText
   Style Attribute 110 ; yellow on brown
   @ 3,50 ?? NRecords("Sample")
   View "Sample"
   Active_N = 0
   Scan
     If [Active]="Y" Then
       Active_N = Active_N + 1
     EndIf
   EndScan
   ClearImage
   @ 4,49 ?? Format("W9,AL",Int(Active_N))
   View "Control"
   @ 5,50 ?? [Next Mail ID]
   ClearAll
   GetEvent Key "All" Mouse "Down" to Event_Y; wait for a keypress or mouse click
   Window Close
ENDPROC ; Sample_Status
WRITELIB "Sample" Sample_Status
RELEASE PROCS Sample_Status



;--------------------------------------------------------------------
PROC Sample_SubTitle()
;Description:
;  Set SubTitle Variable
;Created: 5/4/92 CLJ
;Parameters: None
;Usage: Called by Report Print Objects (setup proc)
;Input & Assumptions:
; none
;Output & Ramifications:
; creates a global
;Notes:
;Globals:
; CLAW_SubTitle_A
;Private: none
  CLAW_SubTitle_A = "Active Listings"
EndProc
WriteLib "Sample" Sample_SubTitle
Release Procs Sample_SubTitle

;--------------------------------------------------------------------------
Proc MA_MAILING_LABELS_OPTIONS()
;Description:
;  Clear the quantity of labels needed field in the mailing list table
;  and then fill it with 1's for the records of a given status (if any).
;Created: 5/23/93 by The CLAW(tm)
;Parameters: None
;Usage: Called by Workshop application main menu
;Input & Assumptions:
;Output & Ramifications:
;  Returns True if successful, False if cancelled.
;  Modifies the contents of SAMPLE.DB.
;Notes:
;Globals:
Private PPO_Item
,Choice_A
   ;Multi-Action Object #1
   CLAW_Chime1()

   ;Multi-Action Object #2
   DynArray PPO_Item[]
   PPO_Item["Type"] = "OK/CNCL"
   PPO_Item["Name"] = "MAILING LABELS BLANK"
   If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
     Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf
   If Retval=False Then Return False EndIf

   ;Multi-Action Object #3
   DynArray PPO_Item[]
   PPO_Item["Type"] = "QUERY"
   PPO_Item["Name"] = "MAILING LABEL BLANK"
   If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
     Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf

   ;Multi-Action Object #4
   CLAW_Chime4()

   ;Multi-Action Object #5
   DynArray PPO_Item[]
   PPO_Item["Type"] = "OK/CNCL"
   PPO_Item["Name"] = "MAILING LABELS ACTIVE"
   If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
     Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf
   If Retval=False Then Return False EndIf

   ShowPopup "Label Quantities" Centered
     "Active":    "Active entries only":           "Active",
     "Inactive":  "Inactive entries only":         "Inactive",
     "California":"Active entries in Calif. only": "Calif"
   EndMenu
   To Choice_A
   If Retval=False Then Return False EndIf

   Switch
   Case Choice_A = "Active":
     ;Multi-Action Object #6
     DynArray PPO_Item[]
     PPO_Item["Type"] = "QUERY"
     PPO_Item["Name"] = "MAILING LABEL ACTIVE"
     If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
       Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf

   Case Choice_A = "Inactive":
     ;Multi-Action Object #7
     DynArray PPO_Item[]
     PPO_Item["Type"] = "QUERY"
     PPO_Item["Name"] = "MAILING LABEL INACTIVE"
     If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
       Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf

   Case Choice_A = "Calif":
     ;Multi-Action Object #8
     DynArray PPO_Item[]
     PPO_Item["Type"] = "QUERY"
     PPO_Item["Name"] = "MAILING LABEL CALIF"
     If IsAssigned(PPO_MstrObj[PPO_Item["Type"]+"-RUN"]) Then
       Execproc PPO_MstrObj[PPO_Item["Type"]+"-RUN"] EndIf
   EndSwitch
   Return True
EndProc ;MA_MAILING_LABELS_OPTIONS
WriteLib "Sample" MA_MAILING_LABELS_OPTIONS
Release Procs MA_MAILING_LABELS_OPTIONS
