;DEMO.SC - Modified startup script for the sample application that
;              demonstrates the CLAW features.

If DirExists("CFG")=0 Then ; directory is missing, files in wrong place
  ; create the needed subdirs and move the files
  Run "MAKECFG.BAT"
EndIf

; The following three lines are as generated by the Application Workshop
Autolib = SDIR()+"WORKSHOP\\WSRUN,CLAW,SAMPLE"
PPP_AppStartUp_U() ; initialize the Workshop system
PP_Splash_W = PPP_AppDisplaySplash_W("SAMPLE")

; Here is the main menu that we added
CLAW_Chime1() ; make some noise
While True ; keep looping back for more choices
  ShowPopup " Demonstration " @ 6,43
    "Introduction"     : "Important information about using this demo.": "INTRO",
    "Sample App"       : "Run the sample Workshop application."   : "SAMPLE",
    "Utilities"        : "Play the CLAW utilities script."        : "UTIL",
    Separator,
    "Tips"             : "Some non-obvious uses for the CLAW."    : "TIPS",
    "Register"         : "Print out the CLAW registration form."  : "REG"
  EndMenu To Module_A

  ; See if the user hit escape or clicked outside of the popup menu
  If Retval=False Then Quitloop Endif

  ; Take the appropriate action
  Switch
  Case Module_A = "SAMPLE":
    ; more code taken from the startup script generated by the Workshop
    Autolib = SDIR()+"WORKSHOP\\WSRUN,CLAW,SAMPLE"
    PPP_AppStartUp_U() ; initialize the Workshop system
    PPP_AppLoadPPOAPP_L(Module_A,False) ; Note the use of the Module_A variable
    If Not RetVal Then Loop "" EndIf
    PP_Splash_W = PPP_AppDisplaySplash_W("SAMPLE")
    ; Now, actually run the application
    CLAW_RunMenu(""); was: PPP_AppPullDownMenu_U()
    ; Note: CLAW_RunMenu("") knows how to return to here when a "Return"
    ; object is encountered.
  Case Module_A = "UTIL":
    If IsAssigned(PP_Splash_W) Then
      Window Select PP_Splash_W
      Window Close
      Release Vars PP_Splash_W
    EndIf
    SetCanvas Default
    Play "CLAWUTIL"
  Case Module_A = "REG":
    Run "Copy REGISTER.TXT PRN:"
  Case Module_A = "INTRO":
    DynArray Attributes_Y[]
    Attributes_Y["HASFRAME"]= False
    Window Create Floating @0,0 Height 25 Width 80 Attributes Attributes_Y To Intro_W
    Clear
    Style Attribute 30
    @0,0 ?? Format("W80,AC","The CLAW Features Walk-Through")
    Style
    @1,0
    Text
Ŀ
 Welcome to "The CLAW" -- Core Library for the Application Workshop.          
                                                                              
 During the next 10 minutes or so, you'll be taken on a whirl-wind tour of    
 the CLAW's features.  This tour will be in two stages:                       
                                                                              
 1. You'll run an actual Workshop application, which was developed explicitly 
    to show off the CLAW.                                                     
                                                                              
 2. You'll run the CLAW utilities script and see exactly the functions that   
    are provided for manipulating your Workshop applications and environment. 
                                                                              
 To start, press any key to return from this screen to the DEMO menu.  Then   
 select the second option to play the Sample Application.  Select each menu   
 option, in order, to see what the CLAW has to offer.                         
                                                                              
 When you are finished going through the Sample Application, pull down the    
 Exit menu and select "To Startup Script" to return to the DEMO menu.  (Note: 
 being able to do this is one of CLAW's features.)  Next, select the          
 Utilities option, and peruse the CLAW utilities menu.  (Choose Help for      
 descriptions.)                                                               

    EndText
    Style Attribute 30
    @ 24,27 ?? " Press any key to continue. "
    Style
    GetEvent Key "ALL" Mouse "DOWN" To Event_Y
    If Event_Y["TYPE"]="MOUSE" Then ; catch the release too
      GetEvent Mouse "UP" To Event_Y
    EndIf
    Window Close
    Setcanvas Default
  Case Module_A = "TIPS":
    DynArray Attributes_Y[]
    Attributes_Y["HASFRAME"]= False
    Window Create Floating @0,0 Height 25 Width 80 Attributes Attributes_Y To Intro_W
    Clear
    Style Attribute 30
    @0,0 ?? Format("W80,AC","Tips for Using the CLAW")
    Style
    @1,0
    Text
Ŀ
 The CLAW has many uses which may not be obvious from this short demonstra-   
 tion, but they are fully covered by the printed manual that you will         
 receive when you register.  The manual also lists a number of general        
 techiniques for using the Workshop that have no particular link with         
 the CLAW.  Some of these tips are:                                           
                                                                              
 Create "Sticky" Menus     - Turn a terminal sub-menu into a persistent       
                             pop-up menu so that your user does not have      
                             to keep traversing the entire menu tree.         
                                                                              
 Divide an Application     - Use the ability to return to the startup script  
 into Sub-Applications       as a means of letting the user jump between one  
                             sub-application or "module" and another.         
                             Note: these modules do not necessarily need to   
                             be Workshop applications.                        
                                                                              
 Launch a Workshop         - Embed a Workshop application inside another,     
 Application from Another    larger PAL application.  Delegate the easy tasks 
 PAL System                  to the Workshop, and rest assured that you will  
                             be able to maintain control.                     

    EndText
    Style Attribute 30
    @ 24,27 ?? " Press any key to continue. "
    Style
    GetEvent Key "ALL" Mouse "DOWN" To Event_Y
    If Event_Y["TYPE"]="MOUSE" Then ; catch the release too
      GetEvent Mouse "UP" To Event_Y
    EndIf
    Window Close
    Setcanvas Default
  EndSwitch
EndWhile
DynArray Attributes_Y[]
Attributes_Y["HASFRAME"]= False
Window Create Floating @0,0 Height 25 Width 80 Attributes Attributes_Y To Intro_W
Clear
Style Attribute 30
@0,0 ?? Format("W80,AC","Thank You")
Style
@1,0
Text
Ŀ
 Thank you for taking the time to evaluate this product.  Whether or not      
 you decided that this product is for you, we'd like to hear your comments.   
 Please print out the registration form (REGISTER.TXT) and send it in with    
 your ideas and suggestions.                                                  
                                                                              
 Coming Attractions...                                                        
                                                                              
 The CLAW version 1.1      - An immediate follow-on upgrade is planned to     
                             include some refinements and extra features      
                             already in the works.  Registered users of       
                             version 1.0 will be able to upgrade for just     
                             a nominal handling fee.                          
                                                                              
 The CLAW version 2.0      - Look for a major upgrade by the end of 1993      
                             to include dozens of new utilities and ready-    
                             to-call procs.                                   
                                                                              
 Subs/4 version 1.0        - A subscription tracking system written with the  
                             Application Workshop.  Use it as is, or as a     
                             starting point for similar applications.         

EndText
Style Attribute 30
CLAW_Chime4()
@ 24,27 ?? " Press any key to continue. "
Style
GetEvent Key "ALL" Mouse "DOWN" To Event_Y
If Event_Y["TYPE"]="MOUSE" Then ; catch the release too
  GetEvent Mouse "UP" To Event_Y
EndIf
Window Close
Setcanvas Default
Clear
ClearAll
