
; PROC setting_main()
; PROC "setting_main_handler"
; PROC setting_main_handler(triggertype, eventrecord, cyclenumber)
; PROC setting_insert()
; PROC setting_delete()
; PROC setting_edit()
; PROC "setting_edit_handler"
; PROC setting_edit_handler(triggertype, eventrecord, cyclenumber)
; PROC edit_done()
; PROC edit_cancel()
; PROC init_comment_edit()
; PROC edit_comment_text()
; PROC setting_lookup(editmode)
; PROC setting_copy()
; PROC setting_exit()
; PROC setting_save_exit()
; PROC setting_toggle_form()
; PROC setting_view_form(formnum)
; PROC setting_menu()
; PROC setting_edit_menu()
; PROC setting_popup_picklist(fieldname)
; PROC "setting_popup_picklist_handler"
; PROC setting_popup_picklist_handler(triggertype, tagvalue, eventvalue, elementvalue)
; PROC setting_toggle(str)

;
; Author   : Larry Bradshaw
; Date     : 10/10/92
;

PROC setting_main()
  PRIVATE module,
  promptstr

  MESSAGE "Initializing Criteria Selection Set Environment"
  module = "setting_main"
    ;
  promptstr = "[F10]Menu [F7]Toggle form [F9]Edit [F2]Use & Exit [Esc]Cancel "
  ECHO OFF
  find_tbl("d\\cis_msg",TRUE)
  find_tbl("d\\crit_set",TRUE)
  setting_view_form("2")
  MOVETO [name]
;  LOCATE settings["NAME"]          ;return to the last one we were on...
                                    ;only if we saved it in criteria assignment module...
  setting_menu()
  ECHO NORMAL
  WAIT TABLE
    PROC "setting_main_handler"
    MESSAGE "MENUSELECT"
    KEY "F7", "F9", "Esc", "F2", "Zoom", "Ins", "Del"
    MOUSE "DOWN"
    IDLE
  ENDWAIT
  ECHO OFF

  ClearImage
  PROMPT
  MESSAGE ""
  SHOWPULLDOWN
  ENDMENU
  ECHO NORMAL ECHO OFF
  displaymainmenu()
    ;
ENDPROC
WRITELIB libname setting_main
RELEASE  PROCS   setting_main



;
; Author   : David J. Harmon from specifications provided by CDS, Inc.
; Date
; modified : 10/1992, 11/21/92, 01/11/92 by L. Bradshaw
;
PROC setting_main_handler(triggertype, eventrecord, cyclenumber)
  PRIVATE eventretval
    ;
  eventretval = 0
  IF IsFieldView() THEN
    Do_It!
  ENDIF
  IF triggertype = "EVENT" THEN
    triggertype = eventrecord["TYPE"]
  ENDIF
  SWITCH

    CASE triggertype = "MOUSE":
      IF eventrecord["DOUBLECLICK"] = TRUE THEN
        IF [name]="Standard" THEN
          g_d_box("SETTINGS EDIT","The Standard settings record/"+
          "is used by everyone as the default/"+
          "settings record.//"+
          "No one is allowed to edit this record.",
          TRUE,FALSE)
          RETURN rejectevent
        ELSE
          IF eventrecord["BUTTONS"]="RIGHT"  THEN; edit this setting...
            eventretval=setting_edit()
            RETURN eventretval
          ELSE
            IF eventrecord["BUTTONS"]="LEFT"  THEN; apply this setting...
              setting_save_exit()
              RETURN eventretval
            ENDIF
          ENDIF
        ENDIF
      ELSE
        IF eventrecord["ACTION"]="DOWN" OR
          eventrecord["ACTION"]="MOVE" THEN
          RETURN 0
        ENDIF
      ENDIF
      RETURN 1

    CASE triggertype = "MESSAGE":
      SWITCH
        CASE eventrecord["MESSAGE"] = "MENUSELECT":
          IF NOT IsBlank(eventrecord["MENUTAG"]) THEN
            EXECPROC eventrecord["MENUTAG"]
                        ;executes the proc named the same as the tag associated with
                        ;the menu pick in the showpulldown menu
          ENDIF
      ENDSWITCH

    CASE triggertype = "KEY":
      eventretval = 1
      SWITCH
        CASE eventrecord["KEYCODE"] = ASC("F2") :

          setting_save_exit()

        CASE eventrecord["KEYCODE"] = ASC("F7") :
          setting_toggle_form()

        CASE eventrecord["KEYCODE"] = ASC("F9") :
          IF [name]="Standard" THEN
            g_d_box("SETTINGS EDIT","The Standard settings record/"+
            "is used by everyone as the default/"+
            "settings record.//"+
            "No one is allowed to edit this record.",
            TRUE,FALSE)
          ELSE
            eventretval=setting_edit()
          ENDIF

        CASE eventrecord["KEYCODE"] = ASC("Zoom"):
          win_zoom(FIELD(),FieldType())

        CASE eventrecord["KEYCODE"] = ASC("Ins"):
          setting_insert()

        CASE eventrecord["KEYCODE"] = ASC("Del"):
          setting_delete()

        CASE eventrecord["KEYCODE"] = ASC("Esc"):
          eventretval = 2

      ENDSWITCH

    CASE triggertype = "IDLE":
      PROMPT promptstr + STRVAL(TODAY()) + " " + TIME()
  ENDSWITCH

  RETURN eventretval
    ;
ENDPROC
WRITELIB libname setting_main_handler
RELEASE  PROCS   setting_main_handler


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_insert()
  PRIVATE oldform

  ECHO OFF
  oldform = FORM()
  find_tbl("d\\crit_set",TRUE)
  setting_view_form(oldform)

  MESSAGE "INSERTING..."
  if sysmode()="CoEdit" then return ;do not allow inserts in coedit mode
  else
    CoEditKey
  endif
  Ins
  [Name]              = cis_set["USERNAME"]+" NEW SETTING***"
  ;have to assign [aa key] here too!
  [date_time]         = STRVAL(TODAY())+" "+TIME()
  [aa key]=SUBSTR([name],1,20)
  POSTRECORD NOPOST LEAVELOCKED
  IF RETVAL = TRUE THEN
    MESSAGE "Record inserted and posted successfully"
    UnLockRecord
  ELSE
    IF IsBlank([name]) THEN
      [aa key]=STRVAL(RAND()*RECNO())
    ELSE
      [aa key]=SUBSTR([name],1,15)+STRVAL(RAND()*RECNO())
    ENDIF
    POSTRECORD NOPOST LEAVELOCKED
    IF RETVAL <> TRUE THEN
      IF LEN([name])>15 THEN
        [aa key]=SUBSTR([name],1,9)+SUBSTR([name],11,5)+STRVAL(RAND()*RECNO())
      ELSE
        [aa key]=SUBSTR([name],1,9)+STRVAL(RAND()*RECNO())
      ENDIF
      POSTRECORD NOPOST LEAVELOCKED
      UnLockRecord
    ELSE
      MESSAGE "Record inserted and posted successfully"
      UnLockRecord
    ENDIF
  ENDIF

  Do_It!
  eventretval=setting_edit()

  ECHO NORMAL
    ;
ENDPROC
WRITELIB libname setting_insert
RELEASE  PROCS   setting_insert


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_delete()
    ;
  IF [name]="Standard" THEN
    g_d_box("SETTINGS EDIT","The Standard settings record/"+
    "is used by everyone as the default/"+
    "settings record.//"+
    "No one is allowed to delete this record.",
    TRUE,FALSE)
  ELSE
    ECHO OFF
    MESSAGE "DELETING SETTING "+[name]
    CoEditKey
    DEL
    Do_It!
    MESSAGE ""
    ECHO NORMAL
  ENDIF
    ;
ENDPROC
WRITELIB libname setting_delete
RELEASE  PROCS   setting_delete


;
; Author   : David J. Harmon from specifications provided by CDS, Inc.
; Revised  : Larry L. Bradshaw  11/27/92,  12/7/92
; Date
;
PROC setting_edit()
  PRIVATE oldform,
  winattrs,
  lookuptable,   ;added 11/27/92 to reduce mem req.
  lookupfield,
  promptstr,
  save_rec,
  fieldeditmode

  MESSAGE "Initializing Settings Editing."

  ECHO OFF

  WHILE TRUE
    ECHO OFF

    WINDOW SELECT windows_up["d\\crit_set_hdl"]
    oldform = FORM()

    MOVETO "d\\crit_set"

    DYNARRAY winattrs[]
    DYNARRAY fieldeditmode[]
    CopyToArray save_rec

    fieldeditmode["Name"]               = "EDIT"
    fieldeditmode["Comment"]            = "EDIT"
    fieldeditmode["Date_Time"]          = ""
    fieldeditmode["Forum"]              = "LOOKUP"
    fieldeditmode["Message number"]     = "LOOKUP"
    fieldeditmode["Date"]               = "LOOKUP"
    fieldeditmode["Time"]               = "LOOKUP"
    fieldeditmode["Reply message number"]  = "LOOKUP"
    fieldeditmode["Subject"]            = "LOOKUP"
    fieldeditmode["From last"]          = "LOOKUP"
    fieldeditmode["To last"]            = "LOOKUP"
    fieldeditmode["From cis id"]        = "LOOKUP"
    fieldeditmode["To cis id"]          = "LOOKUP"
    fieldeditmode["To Group"]           = "LOOKUP"
    fieldeditmode["From Group"]         = "LOOKUP"

    promptstr = "[F10] Menu  [F2] Finish edit  [F6] Pick list                  "
    setting_view_form("3")
    windows_up["d\\crit_set_FORMHDL"]=GETWINDOW()
    windows_up["d\\crit_set_IMAGENO"]=ImageNo()

    winattrs["HASFRAME"] = FALSE
    winattrs["MAXIMIZED"] = TRUE
    WINDOW SETATTRIBUTES windows_up["d\\crit_set_FORMHDL"] FROM winattrs
    CoEditKey
    setting_edit_menu()
    ImageRights READONLY
    ECHO NORMAL

    WAIT RECORD
      PROC "setting_edit_handler"
      MESSAGE "MENUSELECT", "CLOSE"
      TRIGGER "ARRIVEFIELD"
      KEY "F2", "F6", "F35", 6           ;no "Zoom"  ....
      MOUSE "DOWN"
      IDLE
    ENDWAIT

    ECHO OFF
    ImageRights

    Do_It!
    setting_view_form(oldform)
    setting_menu()
    ECHO NORMAL
    RETURN 0

  ENDWHILE
  ECHO NORMAL
    ;
  RETURN 0
ENDPROC
WRITELIB libname setting_edit
RELEASE  PROCS   setting_edit

;
; Author   : David J. Harmon from specifications provided by CDS, Inc.
; Date
; modified : 10/1992, 11/21/92, 01/11/92 by L. Bradshaw
;
PROC setting_edit_handler(triggertype, eventrecord, cyclenumber)
  PRIVATE eventretval,
  editmode
    ;

  IF IsFieldView() THEN
    Do_It!
  ENDIF

  eventretval = 0
  IF triggertype = "EVENT" THEN
    triggertype = eventrecord["TYPE"]
  ENDIF

  SWITCH

    CASE triggertype = "MOUSE":
      IF eventrecord["DOUBLECLICK"]=TRUE THEN
;        debug ;triggertype = mouse?   eventrecord["action"]?
;
;        for us,  debug statements inside of waitprocs case elements are the
;        only way to really debug event driven apps..... L. Bradshaw 1/16/92
;
;
        IF IsAssigned(fieldeditmode[FIELD()]) THEN
          ImageRights UPDATE
          IF UPPER(FIELD())="COMMENT" THEN
            MESSAGE "Switching to Editor"
            edit_comment_text()
;            setting_edit_menu()               ;re-instate menu here....  no - do it in edit_comment_text...
            RETURN rejectevent
          ENDIF
          setting_lookup(fieldeditmode[FIELD()])
        ENDIF
      ELSE
        IF eventrecord["ACTION"]="DOWN" OR
          eventrecord["ACTION"]="MOVE" THEN
          RETURN 0
        ENDIF
        ;handle fieldview here...
        ;
      ENDIF
      RETURN 1  ;rejectevent

    CASE triggertype = "ARRIVEFIELD":
      IF UPPER(FIELD())="AA KEY" THEN
        KEYPRESS eventrecord["KEYCODE"]
        IF fieldeditmode[FIELD()]="EDIT" THEN
          ImageRights UPDATE
        ENDIF
      ELSE
        editmode = fieldeditmode[FIELD()]
        SWITCH
          CASE editmode = "EDIT"  :
            IF UPPER(FIELD())="NAME" THEN
              ImageRights                    ;have to handle duplicate keys
            ELSE
              ImageRights UPDATE
            ENDIF
          OTHERWISE               : ImageRights READONLY
        ENDSWITCH
      ENDIF

    CASE triggertype = "MESSAGE":
      SWITCH
        CASE eventrecord["MESSAGE"] = "MENUSELECT":
          SWITCH

            CASE eventrecord["MENUTAG"] = "lookup_button":
              setting_lookup(fieldeditmode[FIELD()])

            OTHERWISE:
              IF NOT IsBlank(eventrecord["MENUTAG"]) THEN
                EXECPROC eventrecord["MENUTAG"]
              ENDIF
          ENDSWITCH

        CASE eventrecord["MESSAGE"] = "CLOSE":
          eventretval = 2

      ENDSWITCH


    CASE triggertype = "KEY":
      eventretval = 1
      SWITCH
        CASE eventrecord["KEYCODE"] = ASC("F2"): eventretval = 2
          setting_save_exit()

        CASE eventrecord["KEYCODE"] = ASC("F6"):
          IF UPPER(FIELD())="COMMENT" THEN
            ImageRights UPDATE
            MESSAGE "Switching to Editor"
            edit_comment_text()
            RETURN rejectevent
;            setting_edit_menu()     ;re-instate menu here.... no - do it in edit_comment_text
          ELSE
            setting_lookup(fieldeditmode[FIELD()])
          ENDIF

        CASE eventrecord["KEYCODE"] = ASC("F35") OR
          eventrecord["KEYCODE"] = 6:  ;fieldview...

          IF UPPER(FIELD())="COMMENT" THEN
            ImageRights UPDATE
            MESSAGE "Switching to Editor"
            edit_comment_text()
;            setting_edit_menu()      ;re-instate menu here....
            RETURN rejectevent
          ENDIF

      ENDSWITCH

    CASE triggertype = "IDLE":
      PROMPT promptstr + STRVAL(TODAY()) + " " + TIME()
      RETURN 1
  ENDSWITCH

;  editmode = fieldeditmode[FIELD()]
;  SWITCH
;    CASE editmode = "EDIT"  : ImageRights UPDATE
;    OTHERWISE               : ImageRights READONLY
;  ENDSWITCH

  RETURN eventretval
    ;
ENDPROC
WRITELIB libname setting_edit_handler
RELEASE  PROCS   setting_edit_handler

PROC setting_save_rec()
  ImageRights
  IF SYSMODE()="CoEdit" THEN
    IF IsBlank([name]) THEN
      [aa key]=STRVAL(TODAY())+" "+TIME()
    ELSE
      [aa key]=SUBSTR([name],1,20)
    ENDIF
    POSTRECORD NOPOST LEAVELOCKED
    IF RETVAL = TRUE THEN
      MESSAGE "Record posted successfully"
      UnLockRecord
    ELSE
      IF IsBlank([name]) THEN
        [aa key]=STRVAL(RAND()*RECNO())
      ELSE
        [aa key]=SUBSTR([name],1,15)+STRVAL(RAND()*RECNO())
      ENDIF
      POSTRECORD NOPOST LEAVELOCKED
      IF RETVAL <> TRUE THEN
        [aa key]=STRVAL(RAND()*RECNO())
        POSTRECORD NOPOST LEAVELOCKED
        UnLockRecord
      ELSE
        MESSAGE "Record posted successfully"
        UnLockRecord
      ENDIF
    ENDIF
  ENDIF
  ImageRights READONLY
  MESSAGE ""
ENDPROC
WRITELIB libname setting_save_rec
RELEASE  PROCS   setting_save_rec

;  -------------------------------------------------------------------
;  Script - EDITMEMO.SC - data entry for table with a memo field
;  utils from Dan Paolini
;
;  Heavily modified by L. Bradshaw :  10/23/92,  11/19/92
;  -------------------------------------------------------------------

PROC edit_done()
  Do_It!
  setting_edit_menu()
  ECHO OFF
  RETURN rejectevent
ENDPROC
WRITELIB libname edit_done
RELEASE  PROCS   edit_done

;  -------------------------------------------------------------------
;  Script - EDITMEMO.SC - data entry for table with a memo field
;  utils from Dan Paolini
;
;  Heavily modified by L. Bradshaw :  10/23/92,  11/19/92
;  -------------------------------------------------------------------
PROC edit_cancel()
  Menu {CANCEL} {YES}
  setting_edit_menu()
  ECHO OFF
  RETURN rejectevent
ENDPROC
WRITELIB libname edit_cancel
RELEASE  PROCS   edit_cancel



;  -------------------------------------------------------------------
;  Script - EDITMEMO.SC - data entry for table with a memo field
;  utils from Dan Paolini
;
;  Heavily modified by L. Bradshaw :  10/23/92,  11/19/92
;  -------------------------------------------------------------------
PROC init_comment_edit()

;  Initialization procedure for EditMemo script

  SHOWPULLDOWN
    "~D~ONE" : "Save changes & exit Comment text editing." : "EDIT_DONE",
    "~C~ANCEL" : "Cancel changes & exit Comment text editing." : "EDIT_CANCEL"
              ;these menu tags correspond to proc names .....
  ENDMENU
;  Define window attributes for field view

  DYNARRAY fldview_attribs[]
  fldview_attribs["CanClose"] = FALSE
  fldview_attribs["CanMaximize"] = FALSE
  fldview_attribs["CanMove"] = FALSE
  fldview_attribs["CanResize"] = FALSE
  fldview_attribs["HasShadow"] = FALSE
  fldview_attribs["OriginRow"] = 6    ;next 4 lines create a full-width window
  fldview_attribs["OriginCol"] = 0    ;occupying 18 lines at bottom of screen
  fldview_attribs["Height"] = 18
  fldview_attribs["Width"] = 80
  fldview_attribs["Title"] = "COMMENT TEXT"

;  Define window attributes for form view
  ECHO OFF
  FieldView
  field_view = GETWINDOW()
  WINDOW SETATTRIBUTES field_view FROM fldview_attribs
  ECHO NORMAL
ENDPROC
WRITELIB libname init_comment_edit
RELEASE  PROCS   init_comment_edit

;  -------------------------------------------------------------------
;  Script - EDITMEMO.SC - data entry for table with a memo field
;  utils from Dan Paolini
;
;  Heavily modified by L. Bradshaw :  10/23/92,  11/19/92
;  -------------------------------------------------------------------

PROC edit_comment_text()
  PRIVATE eventarray, fldview_attribs,field_view
;  Manages memo field edit
  init_comment_edit()
  PROMPT "Edit memo using Editor keys.  Press [Alt-F5] or [Ctrl-F] when done.",""
  ECHO NORMAL

  WHILE IsFieldView()        ;loop while still in field view
    GETEVENT ALL TO eventarray
    IF eventarray["Type"] = "MESSAGE"  THEN
      IF eventarray["MESSAGE"]="MENUSELECT"  THEN
        IF NOT IsBlank(eventarray["MENUTAG"]) THEN
          EXECPROC eventarray["MENUTAG"]
          RETURN RETVAL
        ENDIF
      ENDIF
    ENDIF
    IF eventarray["Type"] <> "KEY" THEN
      LOOP
    ENDIF;reject all events which
         ;aren't key events
    key_code = eventarray["KeyCode"]

    IF (key_code = 15) OR      ;illegal keys - Ctrl-O, Alt-O, F1, F2, F10
      (key_code = -18) OR      ;alt-E
      (key_code = -24) OR (key_code = -59) OR
      (key_code = -60) OR (key_code = -68) THEN
      BEEP LOOP
    ENDIF
    KEYPRESS key_code    ;force keypress on the entered key
  ENDWHILE

;  All done

  MESSAGE "Returning to Entry/Update Form"
  ECHO OFF
  IF ISWINDOW(field_view) THEN
    WINDOW SELECT field_view
    WINDOW CLOSE
  ENDIF
  setting_edit_menu()               ;re-instate menu here....

  RETURN rejectevent
ENDPROC
WRITELIB libname edit_comment_text
RELEASE  PROCS   edit_comment_text
?? ""


;
; Author   : Larry Bradshaw
; Date     : 10/14/92
;

PROC setting_lookup(editmode)
;
  SWITCH

    ;add other cases as desired....

    CASE editmode = "LOOKUP"    :
      setting_popup_picklist(FIELD())

    OTHERWISE:
      BEEP
  ENDSWITCH
    ;
ENDPROC
WRITELIB libname setting_lookup
RELEASE  PROCS   setting_lookup

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_copy()
  PRIVATE newsetting
    ;
  ECHO OFF
  MESSAGE "COPYING SETTING..."
  CoEditKey
  CopyToArray newsetting
  a1=[name]
  Ins
  CopyFromArray newsetting
  [Name] = cis_set["USERNAME"]+" Copied SETTING***"
  [aa key]=SUBSTR(a1,1,15)+STRVAL(INT((RAND()*RECNO())/(MONTH(TODAY())/3)))
  Do_It!
  MESSAGE ""
  ECHO NORMAL
    ;
ENDPROC
WRITELIB libname setting_copy
RELEASE  PROCS   setting_copy

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_exit()
    ;
  eventretval = 2
    ;
ENDPROC
WRITELIB libname setting_exit
RELEASE  PROCS   setting_exit

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_save_exit()
  PRIVATE oldform,aok,tbl1,count
    ;
  ECHO OFF
  tbl1=TABLE()
  oldform = FORM()
  IF SYSMODE()="CoEdit" THEN
    setting_save_rec()
;      "Cancel & Exit"        : "Delete these choices and exit." : "setting_cancel"
  ENDIF
  MESSAGE "LOADING "+[name]+" SELECTED SETTINGS"
  ECHO OFF
  FormKey
  if sysmode()<>"CoEdit" then
     CoEditKey
     [date_time] = STRVAL(TODAY())+" "+TIME()  ;always stamp last date&time used..
     Do_It!                                    ;may want to lock prior to assignment in multi-user environments....
  endif
  MOVETO [forum]                              ;first field in table....
; Structure of "E:\\CIS_APP\\D\\CRIT_SET"
; "Aa key"                    :  "A20*",
; "Name"                      :  "A40*",
; "Date_time"                 :  "A20",
; "Forum"                     :  "A40",        1
; "Message number"            :  "A100",       2
; "Date"                      :  "A100",       3
; "reply message number"      :  "A100",       4
; "Subject"                   :  "A100",       5
; "From last"                 :  "A100",       6
; "From cis id"               :  "A100",       7
; "From group"                :  "A100",       8
; "To last"                   :  "A100",       9
; "To cis id"                 :  "A100",       10
; "To group"                  :  "A100",       11
; "Comment"                   :  "M1"
  FOR count FROM 1 TO 11     ;NFIELDS(TABLE())-1     ; -1, don't record #
    settings[FIELD()] = []                           ;or name or date_time.. or comment...
    Right
  ENDFOR
  eventretval = 2                            ;Done w/browse or edit, so leave....
  find_tbl(tbl1,FALSE)
  setting_view_form(oldform)

  ECHO NORMAL
    ;
ENDPROC
WRITELIB libname setting_save_exit
RELEASE  PROCS   setting_save_exit


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_toggle_form()
    ;
  ECHO OFF
  setting_view_form(IIF(FORM()="2", "4", "2"))
  ECHO NORMAL
    ;
ENDPROC
WRITELIB libname setting_toggle_form
RELEASE  PROCS   setting_toggle_form


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_view_form(formnum)
  PRIVATE winattrs
    ;
  find_tbl("d\\crit_set",TRUE)
  DYNARRAY winattrs[]
  PICKFORM formnum
  winattrs["HASFRAME"]    = FALSE
  winattrs["MAXIMIZED"]   = TRUE
  winattrs["ECHO"]        = TRUE
  WINDOW SETATTRIBUTES GETWINDOW() FROM winattrs
;  WINDOW SELECT        GETWINDOW()
;  SETCANVAS            GETWINDOW()
    ;
ENDPROC
WRITELIB libname setting_view_form
RELEASE  PROCS   setting_view_form


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_menu()
  PRIVATE module
  module = "setting_menu"
    ;
  SHOWPULLDOWN
    "~S~ettings"                    : "" : ""
    SUBMENU
      "Insert setting"        : "" : "setting_insert",
      "Delete setting"        : "" : ""
      SUBMENU
        "No, don't delete this setting" : "" : "",
        "Yes, delete this setting"      : "" : "setting_delete"
      ENDSUBMENU
      ,
      "Edi~t~ setting"        : "" : "setting_edit",
      "Copy setting"          : "" : "setting_copy",
      separator,
      "Use setting and Exit"  : "" : "setting_save_exit",
      "Cancel and Exit"       : "" : "setting_exit"
    ENDSUBMENU
    ,

    "~O~ptions"                     : "" : ""
    SUBMENU
      "Toggle form"           : "" : "setting_toggle_form"
    ENDSUBMENU
  ENDMENU
    ;
ENDPROC
WRITELIB libname setting_menu
RELEASE  PROCS   setting_menu

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_edit_menu()
    ;
  SHOWPULLDOWN
    "~F~ile"                : "" : ""
    SUBMENU
      "Save & Exit"          : "Save these choices and exit." : "SETTING_SAVE_EXIT",
      "Cancel & Exit"        : "Delete these choices and exit." : "SETTING_CANCEL"
    ENDSUBMENU
    ,

    "~L~ookup"              : "" : "lookup_button"
  ENDMENU
    ;
ENDPROC
WRITELIB libname setting_edit_menu
RELEASE  PROCS   setting_edit_menu


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_cancel()
  IF SYSMODE()="CoEdit" THEN
    ImageRights
    CopyFromArray save_rec
    Do_It!
    eventretval=2                ;done & leave nested waitproc
  ENDIF
ENDPROC
WRITELIB libname setting_cancel
RELEASE  PROCS   setting_cancel


;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_popup_picklist(fieldname)
  PRIVATE oldwindow,
  picklist,
  changed,
  currentlen,
  maxlen,
  dbox_width,
  cl,
  db_start_row,
  db_start_col,
  title1,
  selectedlist,
  oldwindow,
  totallen,
  parsestr,
  s1,
  s2,
  button,
  checked,
  tablename,
  newstr

  tablename="d\\cis_msg"
    ;
  ECHO OFF
  MESSAGE "BUILDING "+UPPER(FIELD())+" LIST, PLEASE WAIT"

  oldwindow   = GETWINDOW()
  changed     = FALSE
  maxlen      = NUMVAL(SUBSTR(TYPE([]),2,3))
  currentlen  = 0
  totallen    = 0
  title1="SELECTION SET OF ALL "+UPPER(FIELD())

  dbox_width=LEN(title1)+10
  frame_width=dbox_width-3
; now figure the centerline for the dynarray picklist....
  cl=INT(dbox_width/2)-11
  db_start_row=4
  db_start_col=40-(INT(dbox_width/2))

  MOVETO tablename
  MOVETO FIELD fieldname

  DYNARRAY selectedlist[]
  DYNARRAY picklist[]
  SCAN FOR NOT IsBlank([])
    IF NOT IsAssigned(picklist[[]]) THEN
      picklist[[]]= []
    ENDIF
  ENDSCAN
  WINDOW SELECT oldwindow

  parsestr = []
  WHILE MATCH(parsestr, ".. or ..", s1, s2)
    s1 = SUBSTR(s1, 2, LEN(s1)-2)
    IF IsAssigned(picklist[s1]) AND NOT IsBlank(picklist[s1]) THEN
      picklist[s1] = setting_toggle(s1)
    ENDIF
    parsestr = s2
  ENDWHILE
  s1 = SUBSTR(parsestr, 2, LEN(parsestr)-2)
  IF IsAssigned(picklist[s1]) AND NOT IsBlank(picklist[s1]) THEN
    picklist[s1] = setting_toggle(s1)
  ENDIF

  MESSAGE ""
    ; PaintPAL_Generated_Code_Begin(424256135)
;  debug
  SHOWDIALOG title1
    PROC "setting_popup_picklist_handler"
    TRIGGER "SELECT"

    @db_start_row, db_start_col HEIGHT 17 WIDTH dbox_width

        ; PaintPAL_Frame_Begin
    FRAME SINGLE FROM 0,0 TO 12,frame_width
    PaintCanvas ATTRIBUTE 112 0,0,0,frame_width
    PaintCanvas ATTRIBUTE 112 0,0,12,0
    PaintCanvas ATTRIBUTE 127 12,1,12,frame_width
    PaintCanvas ATTRIBUTE 127 0,frame_width,12,frame_width
        ; PaintPAL_Frame_End

    PICKDYNARRAY
      @1,cl HEIGHT 11 WIDTH 21
      COLUMNS 1
      picklist
      TAG "selection"
    TO checked

    PUSHBUTTON
      @13,2 WIDTH 10
      "~O~k"
      OK
      DEFAULT
      VALUE "ok"
      TAG "okbutton"
    TO button

    PUSHBUTTON
      @13,12 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "cancel"
      TAG "cancelbutton"
    TO button
ENDDIALOG

    ; PaintPAL_Generated_Code_End(424256135)

newstr = ""
IF RETVAL AND changed THEN
  IF UPPER(fieldname)="DATE" OR
    UPPER(fieldname)="MESSAGE NUMBER" OR
    UPPER(fieldname)="REPLY MESSAGE NUMBER"
    THEN
    FOREACH idx in selectedlist
      newstr = newstr + IIF(IsBlank(newstr),"", " or ") + idx     ;no quotes around non-ascii field values...
    ENDFOREACH
  ELSE
    FOREACH idx in selectedlist
      newstr = newstr + IIF(IsBlank(newstr),"", " or ") + "\"" + idx + "\""
    ENDFOREACH
  ENDIF
  ImageRights
  [] = newstr
ENDIF

ECHO NORMAL
    ;
ENDPROC
WRITELIB libname setting_popup_picklist
RELEASE  PROCS   setting_popup_picklist

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_popup_picklist_handler(triggertype, tagvalue, eventvalue, elementvalue)
  PRIVATE pickstr
    ;
  changed = TRUE
  picklist[checked] = setting_toggle(checked)
;  RESYNCCONTROL
;  REFRESHCONTROL
;  "selection"
  REFRESHDIALOG
  RETURN TRUE
    ;
ENDPROC
WRITELIB libname setting_popup_picklist_handler
RELEASE  PROCS   setting_popup_picklist_handler

;
; Author   : Larry Bradshaw
; Date-Time: 10-14-92
;
PROC setting_toggle(str)
  PRIVATE pickstr,
  n
    ;
  n = DYNARRAYSIZE(selectedlist)

  IF IsAssigned(selectedlist[str]) THEN
    totallen = totallen - (LEN(str) + 2 + IIF(n > 1, 4, 0))
    RELEASE VARS selectedlist[str]
    RETURN str
  ELSE
    IF (totallen + (LEN(str) + 2 + IIF(n >= 1, 4, 0))) > maxlen THEN
      BEEP
      MESSAGE "Pick list limit reached..."
      RETURN str
    ELSE
      totallen = totallen + (LEN(str) + 2 + IIF(n >= 1, 4, 0))
      selectedlist[str] = ""
      RETURN FORMAT("W18", str) + ""
    ENDIF
  ENDIF
    ;
ENDPROC
WRITELIB libname setting_toggle
RELEASE  PROCS   setting_toggle


