
;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC print_f()
  PRIVATE p_choice

  IF NOT IsAssigned(cis_set["DUMMY_TBL"]) OR
    IsEmpty(cis_set["DUMMY_TBL"])
    THEN
    RETURN
  ENDIF
  p_choice="Preview"

  WHILE p_choice<>"Return"
    print_menu()
    SWITCH
      CASE p_choice="Preview" :
        find_tbl(cis_set["DUMMY_TBL"],TRUE)
        MESSAGE("Processing report for preview on screen")
        previewonscreen()

      CASE p_choice="Print" :
        sendtoprinter()

      CASE p_choice="View" :
        ans_wait()

    ENDSWITCH

  ENDWHILE

ENDPROC
WRITELIB libname print_f
RELEASE  PROCS   print_f



;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC sendtoprinter()
  REPORT cis_set["DUMMY_TBL"] cis_set["REPORT_NUM"]
ENDPROC

? TIME()+"    sendtoprinter  " CLEAR EOL
WRITELIB libname sendtoprinter
RELEASE PROCS sendtoprinter

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC previewonscreen()
  PRIVATE aa
  aa=PrivDir()+w_table("PR")
  Menu {report} {Output}
  SELECT cis_set["DUMMY_TBL"]
  SELECT cis_set["REPORT_NUM"]
  {File}
  SELECT aa
  aa=aa+".rpt"
  RUN "readme "+aa
  delete_file.u(aa)
ENDPROC

? TIME()+"    previewonscreen " CLEAR EOL
WRITELIB libname previewonscreen
RELEASE PROCS previewonscreen

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC delete_file.u(aa)
  IF IsFile(aa) THEN
    RUN "echo sss>"+aa
    RUN "del "+aa
  ENDIF
ENDPROC
WRITELIB libname delete_file.u
RELEASE PROCS    delete_file.u


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC print_menu()
  ; Display the main pulldown menu.
  SHOWPOPUP "PRINTING MENU" CENTERED
    "Preview" : "Preview on screen." : "Preview",
    "Print"   : "Print Report" : "Print",
    "View"    : "View Answer Table" : "View",
    separator,
    "Return"  : "Return to top menu" : "Return"
  ENDMENU
  TO p_choice
ENDPROC
WRITELIB libname print_menu
RELEASE  PROCS   print_menu


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC ans_wait()
  PRIVATE wait_quit.l, w_prompt1.a, sav1, g, y, x,
  w_prompt2.a, wpuntilview.v,
  wpchoice.a, rsn, rsnm, del1
  wpuntilview.v = ""
  SHOWPULLDOWN
  ENDMENU
  find_tbl(cis_set["DUMMY_TBL"],FALSE)
  copyform "D\\Cis_Msg" "F" cis_set["DUMMY_TBL"] "F"
  pickform "F"  ;may want to not allow movement, sizing of this form!
  ECHO NORMAL
  WHILE TRUE
    WINDOW ECHO windows_up[cis_set["DUMMY_TBL"]+"_HDL"] TRUE
    promptstr="[ESC] or [F2] to Exit  "+cis_set["REPORTNAME"]+" : "+STRVAL(NImageRecords())+" Records."
    prompt promptstr
    WAIT TABLE
;     PROMPT w_prompt1.a
    UNTIL "F10", "F8", "F9", "PgUp", "PgDn", "CoEditKey",
      "Esc", "Zoom", "Dos", "DosBig", "F35", "FieldView", "LockKey",
      "KeyLookup", "F2", "F3", "F4", "F1", "Ins", "Zoom",
      "F9", "F6", "F7", "Del", "Undo", "Enter",-35

      wpuntilview.v = RETVAL
      SWITCH

        CASE wpuntilview.v = "PgUp" OR
          wpuntilview.v = "PgDn" OR
          wpuntilview.v = "FieldView" :
          KEYPRESS wpuntilview.v

        CASE wpuntilview.v = "Esc" OR
          wpuntilview.v = "F2":
          echo off
          ClearImage
          find_tbl(cis_set["DUMMY_TBL"],TRUE)
          displaymainmenu()
          promptstr="         CIS Demo Application          Press F10 for Menu  "
          prompt promptstr+time()
          echo normal
          echo off
          RETURN

        CASE wpuntilview.v = "Zoom":
          win_zoom(FIELD(),FieldType())

        OTHERWISE:  BEEP

      ENDSWITCH

    ENDWHILE
  ENDPROC
  WRITELIB libname  ans_wait
  RELEASE  PROCS    ans_wait
  ?? ""

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
  PROC split_msg_text(txt,iht)
    lent=LEN(txt)+4
    DYNARRAY msg_txt[]
    x=1
    a="" b=""
    WHILE MATCH(txt,"../..",a,b)
      EXECUTE "msg_txt["+STRVAL(x)+"]=a"
      txt=b
      x=x+1
    ENDWHILE
    EXECUTE "msg_txt["+STRVAL(x)+"]=txt"
    x=x+1
    IF x>2 THEN
      IF 6+x<23 THEN
        iht=iht+x
      ENDIF
    ENDIF
    lm=0
    lm=LEN(top)+4
    IF x=1 THEN
      IF lm>lent THEN
        len1=lent
      ELSE
        len1=lm
      ENDIF
      EXECUTE "msg_txt["+STRVAL(x)+"]=txt"
    ELSE
      FOREACH y in msg_txt
        len1=LEN(msg_txt[y])+4
        IF lm<len1 THEN
          lm=len1
        ENDIF
      ENDFOREACH
    ENDIF
    IF lm<76 THEN
      wd=lm
    ELSE
      wd=60
    ENDIF
    RETURN iht
  ENDPROC
  WRITELIB libname split_msg_text
  RELEASE  PROCS   split_msg_text



;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
; Procedure   : G_D_Box()
; Description :
;    Creates a simple dialog box displaying information about the
;    application.  It uses the SHOWDIALOG command to create the box
;    with  a single button which, when pressed, clears the box.
; Called by   :
; --------------------------------------------------------------------------
  PROC g_d_box(top,txt,okflag,cflag)
    PRIVATE ht,top,wd, text1, text2, text3, lm, wd, x, y, cx, cy
    text1="" text2="" text3="" CANCEL="" okbutton=""
    ht=split_msg_text(txt,7)
    IF wd<=21 THEN
      wd=22
      indent=INT((wd-lm)/2)+2
    ELSE
      indent=1
    ENDIF
  ;calc cx and cy - centered x and centered y
    cx=16-ht
    cy=39-INT((lm/2))

  ;
  ; calc indentation if any
;  Sound 200  100
;  Sound 900  180
;  Sound 300  150
;  Sound 2000 150
;;  Sound 1000 150
;;  Sound 700  100
;;  Sound 1000 150
;;  Sound 700  100
;  Sound 1000 150
    SOUND 1600 10
    SOUND 2500 15
    SOUND 3500 10

    SWITCH
      CASE  x=2 : msg_dialog1(top,okflag,cflag)
      CASE  x=3 : msg_dialog2(top,okflag,cflag)
      CASE  x=4 : msg_dialog3(top,okflag,cflag)
      CASE  x=5 : msg_dialog4(top,okflag,cflag)
      CASE  x=6 : msg_dialog5(top,okflag,cflag)
      CASE  x=7 : msg_dialog6(top,okflag,cflag)
      CASE  x=8 : msg_dialog7(top,okflag,cflag)
      CASE  x=9 : msg_dialog8(top,okflag,cflag)
      CASE  x=10 : msg_dialog9(top,okflag,cflag)
      CASE  x=11 : msg_dialog10(top,okflag,cflag)
;  case  x=12 : msg_dialog11(top,okflag,cflag)
;  case  x=13 : msg_dialog11(top,okflag,cflag)
    ENDSWITCH
    STYLE
  ENDPROC
  WRITELIB libname g_d_box
  RELEASE  PROCS     g_d_box


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
  PROC msg_dialog1(top,okflag,cflag)
    SWITCH
      CASE okflag AND cflag:
        SHOWDIALOG top
          @ cx, cy
          HEIGHT ht
          WIDTH  wd
          STYLE ATTRIBUTE 127
;          paintcanvas attribute 112 ht,0,ht,wd     Would like to chisel it ... not that simple.
;          paintcanvas attribute 112 wd,ht,wd,0     apparently do not have acess to the border with paintcanvas...
          @1,indent ?? msg_txt["1"]
          PUSHBUTTON
            @ ht-4, wd-21
            WIDTH 5
            "~O~K"
            DEFAULT
            OK
            VALUE "OKButtonPressed"
            TAG "OKButton"
          TO okbutton
          PUSHBUTTON
            @ht-4,wd-15 WIDTH 9
            "~C~ancel"
            CANCEL
            VALUE "CancelButtonPressed"
            TAG ""
          TO CANCEL
      ENDDIALOG

    CASE okflag:

      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 15
        @1,indent ?? msg_txt["1"]
        PUSHBUTTON
          @ ht-4, wd-10
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
    ENDDIALOG

  CASE cflag:


    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 112
      @1,indent ?? msg_txt["1"]
      PUSHBUTTON
        @ht-4,wd-10 WIDTH 9
        "~C~ancel"
        DEFAULT
        CANCEL
        VALUE "CancelButtonPressed"
        TAG ""
      TO CANCEL
  ENDDIALOG

ENDSWITCH

ENDPROC
WRITELIB libname msg_dialog1
RELEASE  PROCS     msg_dialog1

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog2(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 9
        @1,indent ?? msg_txt["1"]
        @2,indent ?? msg_txt["2"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 14
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 116
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog2
RELEASE  PROCS     msg_dialog2


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog3(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 116
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 31
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 79
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog3
RELEASE  PROCS     msg_dialog3




;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog4(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 79
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 47
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 111
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog4
RELEASE  PROCS     msg_dialog4


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog5(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 95
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 3
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog5
RELEASE  PROCS     msg_dialog5


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog6(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 127
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        @6,indent ??  msg_txt["6"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 127
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      @6,indent ??  msg_txt["6"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    @6,indent ??  msg_txt["6"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog6
RELEASE  PROCS     msg_dialog6

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog7(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 127
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        @6,indent ??  msg_txt["6"]
        @7,indent ??  msg_txt["7"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 127
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      @6,indent ??  msg_txt["6"]
      @7,indent ??  msg_txt["7"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    @6,indent ??  msg_txt["6"]
    @7,indent ??  msg_txt["7"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog7
RELEASE  PROCS     msg_dialog7

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog8(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 127
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        @6,indent ??  msg_txt["6"]
        @7,indent ??  msg_txt["7"]
        @8,indent ??  msg_txt["8"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 127
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      @6,indent ??  msg_txt["6"]
      @7,indent ??  msg_txt["7"]
      @8,indent ??  msg_txt["8"]
      PUSHBUTTON
        @ ht-4, wd-21
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    @6,indent ??  msg_txt["6"]
    @7,indent ??  msg_txt["7"]
    @8,indent ??  msg_txt["8"]
    PUSHBUTTON
      @ht-4,wd-15 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog8
RELEASE  PROCS     msg_dialog8

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog9(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 127
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        @6,indent ??  msg_txt["6"]
        @7,indent ??  msg_txt["7"]
        @8,indent ??  msg_txt["8"]
        @9,indent ??  msg_txt["9"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 127
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      @6,indent ??  msg_txt["6"]
      @7,indent ??  msg_txt["7"]
      @8,indent ??  msg_txt["8"]
      @9,indent ??  msg_txt["9"]
      PUSHBUTTON
        @ ht-4, wd-10
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    @6,indent ??  msg_txt["6"]
    @7,indent ??  msg_txt["7"]
    @8,indent ??  msg_txt["8"]
    @9,indent ??  msg_txt["9"]
    PUSHBUTTON
      @ht-4,wd-10 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog9
RELEASE  PROCS     msg_dialog9

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_dialog10(top,okflag,cflag)
  SWITCH
    CASE okflag AND cflag:
      SHOWDIALOG top
        @ cx, cy
        HEIGHT ht
        WIDTH  wd
        STYLE ATTRIBUTE 127
        @1,indent ??  msg_txt["1"]
        @2,indent ??  msg_txt["2"]
        @3,indent ??  msg_txt["3"]
        @4,indent ??  msg_txt["4"]
        @5,indent ??  msg_txt["5"]
        @6,indent ??  msg_txt["6"]
        @7,indent ??  msg_txt["7"]
        @8,indent ??  msg_txt["8"]
        @9,indent ??  msg_txt["9"]
        @10,indent ??  msg_txt["10"]
        PUSHBUTTON
          @ ht-4, wd-21
          WIDTH 5
          "~O~K"
          DEFAULT
          OK
          VALUE "OKButtonPressed"
          TAG "OKButton"
        TO okbutton
        PUSHBUTTON
          @ht-4,wd-15 WIDTH 9
          "~C~ancel"
          CANCEL
          VALUE "CancelButtonPressed"
          TAG ""
        TO CANCEL
    ENDDIALOG

  CASE okflag:

    SHOWDIALOG top
      @ cx, cy
      HEIGHT ht
      WIDTH  wd
      STYLE ATTRIBUTE 127
      @1,indent ??  msg_txt["1"]
      @2,indent ??  msg_txt["2"]
      @3,indent ??  msg_txt["3"]
      @4,indent ??  msg_txt["4"]
      @5,indent ??  msg_txt["5"]
      @6,indent ??  msg_txt["6"]
      @7,indent ??  msg_txt["7"]
      @8,indent ??  msg_txt["8"]
      @9,indent ??  msg_txt["9"]
      @10,indent ??  msg_txt["10"]
      PUSHBUTTON
        @ ht-4, wd-10
        WIDTH 5
        "~O~K"
        DEFAULT
        OK
        VALUE "OKButtonPressed"
        TAG "OKButton"
      TO okbutton
  ENDDIALOG

CASE cflag:
  SHOWDIALOG top
    @ cx, cy
    HEIGHT ht
    WIDTH  wd
    STYLE ATTRIBUTE 127
    @1,indent ??  msg_txt["1"]
    @2,indent ??  msg_txt["2"]
    @3,indent ??  msg_txt["3"]
    @4,indent ??  msg_txt["4"]
    @5,indent ??  msg_txt["5"]
    @6,indent ??  msg_txt["6"]
    @7,indent ??  msg_txt["7"]
    @8,indent ??  msg_txt["8"]
    @9,indent ??  msg_txt["9"]
    @10,indent ??  msg_txt["10"]
    PUSHBUTTON
      @ht-4,wd-10 WIDTH 9
      "~C~ancel"
      DEFAULT
      CANCEL
      VALUE "CancelButtonPressed"
      TAG ""
    TO CANCEL
ENDDIALOG

ENDSWITCH


ENDPROC
WRITELIB libname msg_dialog10
RELEASE  PROCS     msg_dialog10


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC find_tbl(testable,loctn)
  PRIVATE k,win_attrib,hdl,all_windows
  hdl="_HDL"
  windows_up["NIMAGES"]=NImages()
  IF NOT IsAssigned(windows_up[testable]) OR
    windows_up["NIMAGES"]=0 OR
    windows_up[testable]="FALSE"
    THEN
    VIEW testable   ;what if the table DOES NOT EXIST!>!>!
    i1=ImageNo()
    WINDOW HANDLE IMAGE i1 TO wh
    windows_up[testable]=TRUE
    windows_up[testable+"_HDL"]=wh
    windows_up[testable+"_IMGNO"]=i1
    windows_up[testable+"_IMGTYPE"]=IMAGETYPE()
    windows_up[testable+"_FORM"]=FALSE
    windows_up[testable+"_FORMHDL"]=0
    windows_up["NIMAGES"]=NImages()
    WINDOW LIST TO all_windows
    windows_up["NWINDOWS"]=ARRAYSIZE(all_windows)
    find_tbl_set_attrib(testable,hdl,loctn)
    RETURN
  ELSE
    IF ISWINDOW(windows_up[testable+"_HDL"]) THEN
      find_tbl_set_attrib(testable,hdl,loctn)
      WINDOW SELECT windows_up[testable+"_HDL"]
      SETCANVAS windows_up[testable+"_HDL"]
      RETURN
    ELSE;have to find the table & reset hdl...
      IF windows_up[testable+"_FORM"]=TRUE THEN
        IF IsAssigned(windows_up[testable+"_FORMHDL"]) AND
          ISWINDOW(windows_up[testable+"_FORMHDL"])   THEN
          find_tbl_set_attrib(testable,hdl,loctn)
          WINDOW SELECT windows_up[testable+"_FORMHDL"]
          SETCANVAS windows_up[testable+"_FORMHDL"]
          RETURN
        ELSE
          IF ISWINDOW(windows_up(testable+"_HDL")) THEN
            windows_up[testable+"_FORM"]=FALSE
            windows_up[testable+"_FORMHDL"]=0
            WINDOW SELECT windows_up[testable+"_HDL"]
            SETCANVAS windows_up[testable+"_HDL"]
          ENDIF
        ENDIF
      ELSE;PROBABLY HAVE TO ADD RETVAL CHECKS IN HERE>>>>
        windows_up[testable]=FALSE
        FOR k FROM 1 TO windows_up["NIMAGES"]  ;search workspace for it...
          MOVETO k
          IF SEARCH(testable,TABLE()) > 0 THEN
            windows_up[testable]=TRUE
            IF IsFormView() THEN
              windows_up[testable+"_FORM"]=TRUE
              i1=ImageNo()
              WINDOW HANDLE IMAGE i1 TO wh
              windows_up[testable+"_FORMHDL"]=wh
            ELSE
              windows_up[testable]=TRUE
              i1=ImageNo()
              WINDOW HANDLE IMAGE i1 TO wh
              windows_up[testable+"_HDL"]=wh
              windows_up[testable+"_IMGNO"]=i1
              windows_up[testable+"_IMGTYPE"]=IMAGETYPE()
              windows_up[testable+"_FORM"]=FALSE
              windows_up[testable+"_FORMHDL"]=0
            ENDIF
            find_tbl_set_attrib(testable,hdl,loctn)
            RETURN
          ENDIF
        ENDFOR
        IF windows_up[testable]=FALSE THEN;not on the workspace...
          VIEW testable
          i1=ImageNo()
          WINDOW HANDLE IMAGE i1 TO wh
          windows_up[testable]=TRUE
          windows_up[testable+"_HDL"]=wh
          windows_up[testable+"_IMGNO"]=i1
          windows_up[testable+"_IMGTYPE"]=IMAGETYPE()
          windows_up[testable+"_FORM"]=FALSE
          windows_up[testable+"_FORMHDL"]=0
          windows_up["NIMAGES"]=NImages()
          find_tbl_set_attrib(testable,hdl,loctn)
          RETURN
        ENDIF
      ENDIF
    ENDIF
  ENDIF
  find_tbl_set_attrib(testable,hdl,loctn)
  RETURN
ENDPROC
WRITELIB libname find_tbl
RELEASE  PROCS   find_tbl

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC find_tbl_set_attrib(testable,hdl,loctn)
  PRIVATE win_attrib
  WINDOW GETATTRIBUTES windows_up[testable+hdl]  TO win_attrib
  win_attrib["CANCLOSE"]=FALSE
  win_attrib["CANMAXIMIZE"]=FALSE
  win_attrib["CANMOVE"]=FALSE
  win_attrib["CANVAS"]=TRUE
  win_attrib["ECHO"]=TRUE             ;You will want to modify these
  win_attrib["CANRESIZE"]=FALSE       ;to suit your needs and tastes.
  win_attrib["MAXIMIZED"]=TRUE        ;
  win_attrib["ORIGINCOL"]=5
  win_attrib["ORIGINROW"]=1
  WINDOW SETATTRIBUTES windows_up[Testable+"_HDL"] FROM win_attrib

  IF loctn THEN
    WINDOW MOVE windows_up[Testable+"_HDL"] TO 300,500
  ENDIF

  WINDOW ECHO   windows_up[testable+"_HDL"] TRUE
  WINDOW SELECT windows_up[testable+"_HDL"]
;  setcanvas     windows_up[testable+"_HDL"]

ENDPROC
WRITELIB libname   find_tbl_set_attrib
RELEASE  PROCS     find_tbl_set_attrib


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC remove_querys.u()
  IF NImages() =0 THEN
    RETURN
  ENDIF
  MOVETO 1
  WHILE IMAGETYPE() = "Query" ClearImage
  ENDWHILE
ENDPROC

WRITELIB libname remove_querys.u
RELEASE PROCS remove_querys.u

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC delete_table.u(table_name)
  proc.a="delete_table.u("+table_name+")"
  IF IsTable(table_name) THEN
;    cleartbl(table_name)
    IF NRecords(table_name)>0 THEN
      EMPTY table_name
    ENDIF
    DELETE table_name
  ENDIF
ENDPROC
WRITELIB libname delete_table.u
RELEASE  PROCS     delete_table.u
?? ""



;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC w_table(char_id)
  dtbl=TIME()
  dummytbl=char_id+SUBSTR(dtbl,1,2)+SUBSTR(dtbl,4,2)+SUBSTR(dtbl,7,2)
  PrivTables dummytbl
  RETURN dummytbl
ENDPROC

? TIME()+"    w_table " CLEAR EOL
WRITELIB libname w_table
RELEASE PROCS w_table


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC win_zoom(fld,ftype)
  PRIVATE alen, search_text, w
                                ;built onto ezzoom concepts
                                ;from Ensemble Corp but in Pdox 4.0
  IF fld="#" THEN
    RETURN FALSE
  ENDIF
  RETVAL=MATCH(FieldType(),"@..",ftype,e_len)
  WHILE TRUE                              ;always take alpha input...
    search_text=""
    search_text=search_entry()
    IF IsBlank(search_text) THEN
      RETURN FALSE
    ENDIF
    Zoom CtrlBackspace TYPEIN search_text Enter
    w=WINDOW()
    IF LEN(w)=0 THEN
      RETURN TRUE
    ELSE
      g_d_box("Zoom result message",w,TRUE,FALSE)
    ENDIF
    BEEP
  ENDWHILE
ENDPROC
WRITELIB libname   win_zoom
RELEASE PROCS      win_zoom

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC search_entry()
  PRIVATE ht,top, okbutton, text1, text2, text3, CANCEL, okbutton, cl
  text1="" text2="" text3="" CANCEL="" okbutton=""
  rname1="" cl=""
  SHOWDIALOG "SEARCH OBJECT ENTRY" @ 5, 5
    HEIGHT 5 WIDTH 70
    @1,5 ?? "Enter what to search for : "
    ACCEPT @1,35 WIDTH 30 "A30" PICTURE "*!"
      TAG "sname" TO sname1
    PUSHBUTTON
      @2,23 WIDTH 12 "~O~K" OK DEFAULT VALUE "OKP" TAG "OKB"  TO okb
    PUSHBUTTON
      @2,33 WIDTH 9 "~C~ancel" CANCEL VALUE "CBP"  TAG "CBP"  TO cl
ENDDIALOG
IF cl="CBP" THEN
  sname1=""
  RETURN sname1
ELSE
  RETURN sname1
ENDIF

ENDPROC
WRITELIB libname search_entry
RELEASE  PROCS     search_entry


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC llb_error.v()
;
;  built on WaitPlus Errorproc;  Revised for 4.0
;
  PRIVATE ERRORPROC

  SWITCH

    CASE SEARCH("Can't lock record in display only form",ERRORMESSAGE())>0 :
      RETURN 1                ; Step over the offending command.

    CASE  ERRORCODE() = 44 :
      g_d_box("CENTRAL MEMORY POOL INVASION/",STRVAL(MEMLEFT())+"k +"+STRVAL(RMEMLEFT())+"K Code pool mem left!/"+
      "Skipping selected operation./Contact technical support.",TRUE,TRUE)
      RETURN 2
                ;out of memory condition within a
                ;ForEach loop causes Resource limit exceeded error rather
                ;than memory pool invasion error...


    CASE  ERRORCODE() = 41 :
      g_d_box("DISK SPACE LOW",STRVAL(DriveSpace("G"))+"/bytes available./"+
      "Attempting to continue./Contact technical support.",TRUE,TRUE)
      RETURN 0   ;was return 1!!

    CASE  ERRORCODE() = 43 :
      g_d_box("ERROR"," Printer appears to be inaccessible./Please check Power, Online indicator.",TRUE,TRUE)
      IF CANCEL="CancelButtonPressed"
        THEN
        RETURN 0
      ELSE
        RETURN 2
      ENDIF

    CASE  ERRORCODE() = 11 :
      g_d_box("ERROR","Either you have/already logged on/elsewhere or there is/"+
      "a network problem./Contact technical support!",TRUE,TRUE)
      IF UPPER(cis_set["USERNAME"])<>"SUPERVIS" THEN
        ;exit all users back to DOS or Novell Menu....
        IF SYSMODE()="CoEdit" THEN
          Do_It!
        ENDIF
        EXIT
      ELSE
        QUIT
      ENDIF

    CASE  ERRORCODE() = 15 :
      g_d_box("Network Problem"," FATAL ERROR/",
      "PARADOX.NET FILE CONFLICT!",TRUE,TRUE)
      llb_error_doc()  ; Log the error to the ERRORLOG.SC file and the printer.
      IF UPPER(cis_set["USERNAME"])<>"SUPERVIS" THEN
        ;exit all users back to DOS or Novell Menu....
        IF SYSMODE()="CoEdit" THEN
          Do_It!
        ENDIF
        EXIT
      ENDIF


    CASE  ERRORCODE() = 6 :
      g_d_box("Problem","/FILE CORRUPTED/"+ERRORMESSAGE(), TRUE,TRUE)
      llb_error_doc(); Log the error to the ERRORLOG.SC file and the printer.
      IF UPPER(cis_set["USERNAME"])<>"SUPERVIS" THEN
        ;exit all users back to DOS or Novell Menu....
        IF SYSMODE()="CoEdit" THEN
          Do_It!
        ENDIF
        EXIT
      ENDIF


;    CASE  ERRORCODE() = 65 : ;for now,  just let it fall thru...


    CASE  ERRORCODE() = 27 :
      g_d_box("Error","Retry count consumed and/file still not available./Aborting this attempt.",TRUE,TRUE)
      llb_error_doc()  ; Log the error to the ERRORLOG.SC file and the printer.
      RETURN 2


    OTHERWISE:

      IF WINDOW()<>"" THEN
        g_d_box("Error","/"+WINDOW()+"/Check the log/file errorlog.sc/for the ascii report.",TRUE,TRUE)
      ELSE
        g_d_box("An error has occured","/"+ERRORMESSAGE()+"/Check the log/file errorlog.sc/for the ascii report.",TRUE,TRUE)
      ENDIF
      llb_error_doc()  ; Log the error to the ERRORLOG.SC file and the printer.
      IF UPPER(cis_set["USERNAME"])<>"SUPERVIS" THEN
        ;exit all users back to DOS or Novell Menu....
        IF SYSMODE()="CoEdit" THEN
          Do_It!
        ENDIF
        EXIT
      ENDIF
  ENDSWITCH
ENDPROC
WRITELIB libname   llb_error.v
RELEASE PROCS      llb_error.v


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC llb_error_doc()
  PRIVATE aa, ab, x, line1,af,efile1,l1
  efile1="errorlog.sc"
  af="Documenting /"+ERRORMESSAGE()+"/"
  MESSAGE af
  ERRORINFO TO error_docs
  aa=FILL(CHR(219),79)+"\n" ad="     "

  IF IsFile(efile1) THEN
    FILEWRITE append efile1 FROM aa
  ELSE
    FILEWRITE efile1 FROM aa
  ENDIF
  aa=FILL("",79)+"\n" ad="     "
  IF IsAssigned(error_docs) THEN
    ab=FORMAT("W80,AC","Error Docs")
    FILEWRITE append efile1 FROM ab+"\n"
    FILEWRITE append efile1 FROM "Error               "+TIME()+"           "+STRVAL(TODAY())+"\n"
    FOREACH x in error_docs
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(error_docs[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(cis_set) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","CIS DEMO SYSTEM GLOBAL CONTROL SET")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in cis_set
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(cis_set[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(windows_up) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","OPEN WINDOWS SET")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in windows_up
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(windows_up[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(settings) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","QUERY CRITERIA SET")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in settings
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(settings[x])+"\n"
    ENDFOREACH
  ENDIF


  IF IsAssigned(required_tables) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","REQUIRED TABLES SET")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in required_tables
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(required_tables[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(required_files) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","REQUIRED FILES SET")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in required_files
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(required_files[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(eventarray) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","EVENTARRAY ")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in eventarray
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(eventarray[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(eventrecord) THEN
    FILEWRITE append efile1 FROM aa
    ab=FORMAT("W80,AC","EVENTRECORD")
    FILEWRITE append efile1 FROM ab+"\n"
    FOREACH x in eventrecord
      l1=20-LEN(x)
      IF l1<0 THEN
        l1=1
      ENDIF
      ac=SPACES(l1)        ;assumes no tags over 20 chars  ;; spaces is more efficient than Fill
      FILEWRITE append efile1 FROM ad+x+ac+":   "+STRVAL(eventrecord[x])+"\n"
    ENDFOREACH
  ENDIF

  IF IsAssigned(cis_set) AND IsAssigned(cis_set["USERNAME"]) AND
    UPPER(cis_set["USERNAME"])="SUPERVIS"
    THEN
    DEBUG    ;land here as the supervisor on a Novell LAN,  rather than exiting...
  ENDIF
ENDPROC
WRITELIB libname   llb_error_doc
RELEASE PROCS      llb_error_doc
?? ""
