;**************************************************************************
;* Description : Paradox Developer's Conference Paradox 4.0 Application   *
;*                                                                        *
;* Written by:  Larry Bradshaw,  Commonwealth Data Systems,  Inc.         *
;*              Reston,  VA         (703)  264-7730                       *
;*                                                                        *
;* 12/11/92                                                               *
;*                                                                        *
;* Code may not be reproduced or utilized elsewhere,  regardless          *
;* of modifications,  unless above author credits  are included           *
;* in both source code and application documentation.                     *
;*                                                                        *
;* This demo system is offered "AS IS" with no warranty or assurances     *
;* of suitablity to a purpose or of code reliability or usefullness.      *
;* We do not accept any responsibility for use of this system whatsoever. *
;*                                                                        *
;* It is intended to act as an invitation to developers to work in 4.0,   *
;* and is meant to be modified by others and built upon and cussed and    *
;* discussed freely in any Paradox forum or gathering.                    *
;*                                                                        *
;* This system contains deliberate,  glaring omissions of features and    *
;* functions meant to invite modification.  Some are easily remedied      *
;* using the samples provided herein and some are not....                 *
;*                                                                        *
;* Portions of this application are based on concepts and code originated *
;* by others.  They are credited in the headers for each program          *
;* to which they contributed,  or which was built upon their ideas, to    *
;* the best of our ability to do so.                                      *
;*                                                                        *
;* This system contains deliberate,  glaring omissions of features and    *
;* functions meant to invite modification.  Some are easily remedied      *
;* using the samples provided herein and some are not....                 *
;*                                                                        *
;**************************************************************************


; PROC main()
; PROC "cset_waitproc"
; PROC log_off()
; PROC init()
; PROC displaymainmenu()
; PROC exit_no()
; PROC reports()
; PROC import_cis()
; PROC clear_all_images()
; PROC displayabout()
; PROC msg_rept()
; PROC deleterecord()
; PROC cset_waitproc(evtype,evrec,cyclenum)

CLEAR
RELEASE PROCS ALL
;RELEASE VARS ALL
ClearAll
RESET
ALTSPACE {Desktop} {Empty}
ECHO NORMAL      ; display the empty desktop
ECHO OFF         ; then turn echo off to freeze the screen display


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;

PROC main()
  PRIVATE menuitemselected,
  exitapplication,
  windows_up,
  cis_set,
  msg_win.da,
  main_branch,
  sht,
  idlecount,
  promptstr,
  acceptevent,
  rejectevent,
  rejecteventexit,
  a1,a2,a3,a2_old,
  splash_win.da
  ERRORPROC="LLB_ERROR.V"
  SHOWPULLDOWN
  ENDMENU
  init()  ;initialize variables proc
  exitapplication = FALSE
  displaymainmenu()
  find_tbl("d\\crit_set",TRUE)  ;must have at least one table on the workspace to do wait workspace..
  promptstr="         CIS Demo Application          Press F10 for Menu  "
  PROMPT promptstr+TIME()
  
  WHILE (exitapplication <> TRUE)        ; wait workspace here w/IDLE for
    ECHO NORMAL                          ; speeds up event driven wait
    WAIT WORKSPACE
      PROC "cset_waitproc"
      TRIGGER "DEPARTROW","TOUCHRECORD","ARRIVEROW","ARRIVETABLE",
      "POSTRECORD","VALCHECK","ARRIVEFIELD","DEPARTFIELD"
      MESSAGE "MENUSELECT"
      KEY     "F9","F2","Ins","Del","Dos","DosBig",-31,-18,
      "LockKey","F1","F4","F3","Zoom",
      "F6", "F35", 6
      IDLE
      MOUSE "DOWN"
    ENDWAIT
  ENDWHILE
  CLEARPULLDOWN
  ALTSPACE {desktop} {empty}
  
ENDPROC
WRITELIB libname main
RELEASE  PROCS   main
?? ""

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC log_off()
  RELEASE PROCS ALL
  RELEASE VARS ALL
  ClearAll
  RESET
;  ALTSPACE {Desktop} {Empty}
  ECHO NORMAL      ; display the empty desktop
  ECHO OFF         ; then turn echo off to freeze the screen display
  EXIT
ENDPROC
WRITELIB libname   log_off
RELEASE  PROCS     log_off
?? ""


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC init()
  PRIVATE required_tables, required_files, nn
  AUTOLIB = "l\\MAIN"
  ERRORPROC="llb_error.v"
  idlecount=0
  acceptevent = 0             ; set mnemonics for return values
  rejectevent = 1
  rejecteventexit = 2
  sht=23
  MESSAGE "Initializing Application/Controls"
  DYNARRAY windows_up[]
  DYNARRAY settings[]
;    settings["NAME"]="Standard"  ;only initialize name if we use it later....
                                  ;not used in this demo...
  DYNARRAY cis_set[]
  cis_set["REPORTNAME"]="None"
  cis_set["USERNAME"]=UPPER(UserName())
;  cis_set["TODAY"]=today()   ;not now.... maybe tomorrow...
  IF VERSION()<4 THEN
    g_d_box("PARADOX 4.0 REQUIRED!","//Paradox 4.0 is required to run/CIS DEMO Database///press Ok to exit!",
    TRUE,FALSE)
    log_off()
  ENDIF
  ;            available memory (assume 4MB req'd to run).
  IF MEMLEFT()<500000 THEN
    g_d_box("500KB REQUIRED!","//500KB of RAM is required to run/CIS DEMO Database///press Ok to exit!",
    TRUE,FALSE)
  ENDIF
  ;
  ; dynarray of required tables here...
  ; verify existence of all tables prior to continuing...
  ; exit if any do not exist!!
  ;
  DYNARRAY required_tables[]
  required_tables["SET"]="D\\CRIT_SET"
  required_tables["MSG"]="D\\CIS_MSG"
  required_tables["MSG"]="D\\CIS_DUP"
  FOREACH nn in required_tables
    IF NOT IsTable(required_tables[nn]) THEN
      g_d_box("TABLES MISSING",required_tables[nn]+" : /Is Missing./Demo Criteria Selection Database/REQUIRES THIS TABLE/"+
      "press Ok to EXIT!",TRUE,FALSE)
      EXIT
    ENDIF
  ENDFOREACH
;
;  RELEASE VARS required_tables  ;have to add required tables to ERRORPROC
;
  DYNARRAY required_files[]
  required_files["Main_Library"]="l\\main.lib"  ;add others later
  FOREACH nn in required_files
    IF NOT IsFile(required_files[nn]) THEN
      g_d_box("FILES MISSING",required_files[nn]+" : "+nn+"/Is Missing./Demo Criteria Selection Database/REQUIRES THIS FILE/"+
      "press Ok to EXIT!",TRUE,FALSE)
      EXIT
    ENDIF
  ENDFOREACH
  ;  RELEASE VARS required_files
  ;
  ;  after all required files have been verified as existing,
  ;  proceed with initialization of critical global control parameters
  ;
  MESSAGE ""
ENDPROC
WRITELIB libname init
RELEASE  PROCS   init
?? ""



;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC displaymainmenu()
  SHOWPULLDOWN
  ENDMENU;clear the pdox menu 1st
  SHOWPULLDOWN
    ""      : "Program Information."                    : "ALtSpace"
    SUBMENU
      separator,
      "About" : "About this application."                : "DisplayAbout"
    ENDSUBMENU
    ,
    "Import "  : "Import Compuserve PDOXDOS Messages" : "IMPORT_CIS",
    "Reports"  : "Compuserve PDOXDOS Message Database Reports" : "REPORTS"
    SUBMENU
      "~M~essages" : "CIS Messages REPORT."                 : "MSG_REPT",
      "~S~ettings" : "Report Selection Criteria subsystem." : "SETTING_MAIN"
    ENDSUBMENU
    ,
    "Exit"   : "Exit application."                : "EXIT_BYE"
    SUBMENU
      "No"  : "Do not exit application."          : "EXIT_NO",
      "Yes" : "Exit this application."            : "LOG_OFF"
    ENDSUBMENU
  ENDMENU
  
ENDPROC
WRITELIB libname displaymainmenu
RELEASE  PROCS   displaymainmenu
?? ""

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC exit_no()
  
ENDPROC;exit_no
WRITELIB libname exit_no
RELEASE PROCS exit_no
?? ""


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC reports()
  
ENDPROC;reports
WRITELIB libname reports
RELEASE PROCS    reports
?? ""



;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC import_cis()
  PRIVATE exitcontrol
  IF NOT IsFile("\\tap5\\pdoxdos.msg") THEN
    g_d_box("NONE FOUND","No Compuserve PdoxDos messages/waiting import!",TRUE,FALSE)
    RETURN 0
  ENDIF
  ECHO OFF
  delete_table.u("t\\bordb_in")
  MESSAGE "Copying PdoxDos.msg from \\TAP5"
  RUN norefresh "copy \\tap5\\pdoxdos.msg t\\pdoxdos.msg"
  MESSAGE "Archiving PdoxDos.msg in \\TAP5\\pdoxdos.arv"
  RUN norefresh "type  \\tap5\\pdoxdos.msg >> \\tap5\\pdoxdos.arv"
  MESSAGE "Deleting PdoxDos.msg from \\TAP5"
  RUN norefresh "del  \\tap5\\pdoxdos.msg"
  MESSAGE "Importing text now"
  Menu {tools} {exportimport} {import} {ascii} {text}
  SELECT "t\\pdoxdos.msg"
  SELECT "t\\bordb_in"
  exitcontrol=TRUE
  first_pass_parse()
  IF exitcontrol THEN
    g_d_box("DONE!","PdoxDos.msg imported/and parsed into CIS_MSG.db",TRUE,FALSE)
  ELSE
    g_d_box("CANCELLED","PdoxDos.msg import/parse was Cancelled",TRUE,FALSE)
  ENDIF
  clear_all_images()
  Refresh
  find_tbl("d\\cis_msg",TRUE)
  ECHO NORMAL
ENDPROC;import_cis
WRITELIB libname import_cis
RELEASE PROCS    import_cis
?? ""

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC clear_all_images()
  FirstShow
  WHILE NImages()>0
    ClearImage
  ENDWHILE
  DYNARRAY windows_up[]  ;releases prior variable usage;  all window hdls, flags..
ENDPROC
WRITELIB libname clear_all_images
RELEASE  PROCS   clear_all_images

; --------------------------------------------------------------------------
; Procedure   : DisplayAboutBox()
; Description :
;    Creates a simple dialog box displaying information about the
;    application.  It uses the SHOWDIALOG command to create the box
;    with  a single button which, when pressed, clears the box.
; Called by   : Main(),
;
; Borrowed from sample code provided with Paradox 4.0
; Modified 10/11/92 by L. Bradshaw,  CDS Inc.
;
; --------------------------------------------------------------------------

PROC displayabout()
  
; Create a dialog box with the following dimensions...
  SHOWDIALOG "Demo Application - PDC - Jan '93"
    @ 5, 10
    HEIGHT 12
    WIDTH 60
    
    @ 1, 0 ?? FORMAT("W58,AC", "Criteria Selection Demonstration")
    @ 3, 0 ?? FORMAT("W58,AC", "Paradox 4.0")
    @ 5, 0 ?? FORMAT("W58,AC", "Commonwealth Data Systems, Inc.")
    @ 6, 0 ?? FORMAT("W58,AC", "      (703)  264-7730          ")
    
    
    PUSHBUTTON
      @ 8, 23
      WIDTH 12
      "~O~K"
      OK
      VALUE "OKButtonPressed"
      TAG "OKButton"
    TO okbutton
    
ENDDIALOG

ENDPROC
WRITELIB libname displayabout
RELEASE  PROCS     displayabout
?? ""


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC msg_rept()
  PRIVATE nn
  ECHO OFF
  MESSAGE "Querying out messages."
  Menu {ask} SELECT "d\\cis_msg" Check
  FOREACH nn in settings
    IF NOT IsBlank(settings[nn]) THEN
      MOVETO FIELD nn
      TYPEIN settings[nn]
    ENDIF
  ENDFOREACH
  Do_It!
  remove_querys.u()
  MESSAGE ""
  IF IsEmpty("answer") THEN
    g_d_box("NONE FOUND","No records match the selected criteria!",TRUE,FALSE)
  ELSE
    cis_set["DUMMY_TBL"]="Answer"
    cis_set["REPORT_NUM"]=1
    COPYREPORT "d\\cis_msg" "1" "answer" "1"
    print_f()
  ENDIF
  delete_table.u("answer")
ENDPROC;Msg_rept
WRITELIB libname  msg_rept
RELEASE PROCS     msg_rept
?? ""


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC deleterecord()
  ImageRights
  ECHO NORMAL
  ECHO OFF
  SHOWDIALOG "Delete Record"
    @ 6, 10
    HEIGHT 7
    WIDTH 54
    
    @ 1, 4 ?? "Are you sure you want to delete this record?"
    
    PUSHBUTTON
      @ 3, 30 WIDTH 12
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "CancelButton"
    TO cancelbutton
    
    PUSHBUTTON
      @ 3, 11 WIDTH 12
      "~O~K"
      OK
      VALUE "OK"
      TAG "OKButton"
    TO okbutton
    
ENDDIALOG

IF RETVAL = TRUE THEN
  IF SYSMODE()<>"CoEdit" THEN
    CoEditKey
  ENDIF
  DEL                                 ; attempt to delete the record
  IF NOT IsBlank(WINDOW()) THEN; error?
    MESSAGE("DELETE UNSUCCESSFUL "+WINDOW())
  ENDIF
ENDIF
;   imagerights update
ECHO NORMAL
promptstr="         CIS Demo Application          Press F10 for Menu  "
ENDPROC
WRITELIB libname deleterecord
RELEASE  PROCS   deleterecord
?? ""


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC cset_waitproc(evtype,evrec,cyclenum)
  PRIVATE time1
  IF evrec["TYPE"]<>"IDLE" THEN
    IF MATCH(TIME(),"..:..:..",a,b,c) THEN
      a2_old=NUMVAL(b)
    ENDIF
  ENDIF
  SWITCH
    CASE evrec["TYPE"] = "IDLE":
      time1=TIME()
      PROMPT promptstr+time1
      IF MATCH(time1,"..:..:..",a,b,c) THEN
        a1=NUMVAL(a)
        a2=NUMVAL(b)
        a3=NUMVAL(c)
        IF IsAssigned(a2_old) THEN
          IF a2-a2_old>5 OR a2-a2_old<-5 THEN
            g_d_box("IDLE","Idle for 5 minutes!",TRUE,FALSE)
            IF MATCH(time1,"..:..:..",a,b,c) THEN
              a2_old=NUMVAL(b)
            ENDIF
          ENDIF
        ELSE
          IF MATCH(TIME(),"..:..:..",a,b,c) THEN
            ;  left to get correct current minute
            a2_old=NUMVAL(b)
          ENDIF
        ENDIF
      ENDIF
      
      RETURN acceptevent      ; idle
      
    CASE evrec["TYPE"] = "MOUSE":
      
      IF SYSMODE()<>"CoEdit" THEN
        IF evrec["DOUBLECLICK"] = TRUE THEN
          DYNARRAY avrec[]
          avrec["TYPE"]="KEY"
          avrec["KEYCODE"]=-67
          
          ret1=cset_waitproc("EVENT",avrec,cyclenum)
          RETURN ret1
        ENDIF
      ENDIF
      
      
    CASE evtype = "EVENT":
      
      SWITCH
        CASE evrec["TYPE"] = "KEY":
;          ret1=key_hdlr()
          RETURN rejectevent
          
        CASE evrec["TYPE"] = "MESSAGE":
          mtag = evrec["MENUTAG"]
          EXECPROC mtag
          IF RETVAL=rejecteventexit THEN
            clear_all_images()
            find_tbl("d\\cis_msg",TRUE)
            displaymainmenu()
            promptstr="         CIS Demo Application          Press F10 for Menu  "
            RETURN rejectevent
          ELSE
            RETURN RETVAL
          ENDIF
      ENDSWITCH
      
    CASE evtype = "ARRIVETABLE":
      
      IF HelpMode() <> "LookupHelp" THEN
        RETURN acceptevent            ; arrivetable
      ELSE
        RETURN rejectevent            ; arrivetable
      ENDIF
      
      
    CASE evtype = "ARRIVEROW":
      
      RETURN acceptevent               ; arriverow
      
    CASE evtype = "DEPARTFIELD":
;      ret1=field_hdlr()
;      RETURN ret1                ;use a field handler to control all field events...
      RETURN acceptevent
      
    CASE evtype = "ARRIVEFIELD":
      RETURN acceptevent
      
    CASE evtype = "TOUCHRECORD":
      RETURN acceptevent
      
    CASE evtype = "DEPARTROW":
      RETURN acceptevent            ; touchrecord
      
    CASE evtype = "VALCHECK":
      
      IF IsValid() THEN
        RETURN acceptevent
      ELSE
        Right  ; causes errormessage to appear (assuming echo normal)
        RETURN rejectevent
      ENDIF
      
    CASE evtype = "POSTRECORD":
;      IF SYSMODE()="CoEdit" THEN
        ;  ret1=prec_hdlr()         ;->  use a post record handler proc to control all record postings....
;        RETURN ret1
;      ELSE
      RETURN acceptevent
;      ENDIF
      
      
  ENDSWITCH
  RETURN acceptevent           ; end of waitproc
  
ENDPROC
WRITELIB libname cset_waitproc
RELEASE  PROCS   cset_waitproc
?? ""


