AUTOLIB="l\\main"
libname="l\\main"


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
; Slider Dialog Box & Proc borrowed from Kallista's Desktop utility suite.
; Modified for demo by Larry Bradshaw.
;                      1/07/94
;
; Define the dialog proc, which, since the dialog is primarily for display,
; will do most of the work.
; ---------------------------------------------------------------------------
PROC parsemsgproc( eventtype, tagvalue, eventvalue, almostalwaysnull )

  SWITCH
      ; ---------------------------------------------------------------------
      ; If "EVENT" then the event was IDLE, so continue parsing messages
      ; ---------------------------------------------------------------------
    CASE eventtype = "EVENT" :

      IF displaymsg THEN
        displaymsg = FALSE
        REFRESHDIALOG
;        REPAINTDIALOG
      ELSE
        MOVETO "t\\bordb_in"
        percentdone = RECNO()
        each_pass_parse()
        IF RECNO()=messages.n THEN;at the end!
          Do_It!
          ACCEPTDIALOG
          REFRESHDIALOG
        ENDIF
        displaymsg = TRUE
      ENDIF

      ; ---------------------------------------------------------------------
      ; If event was CANCEL, then cancel the dialog to jump out of the loop
      ; ---------------------------------------------------------------------
    CASE eventtype = "CANCEL" :
      CANCELDIALOG

  ENDSWITCH

ENDPROC
WRITELIB libname parsemsgproc
RELEASE  PROCS   parsemsgproc

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
; Borrowed from Kallista's Desktop utility suite.
; Modified for demo by Larry Bradshaw.
;                      1/07/94
;
; Display the dialog and process until completion or interruption
; ---------------------------------------------------------------------------
PROC first_pass_parse()
  PRIVATE topics, key_words, nn, string1.a,msg_number,forum_number,forum_title,
  n,y, date_in, time_in,ll, i, j, a, b, c, fstr, f_first_name, f_last_name, f_group_name,
  tstr,t_from_first, t_from_last, t_group_name, t_cis_id, rest_of_str,
  f_mi, t_mi, reply_msg_number,displaymsg,messages.n

  start_time=TIME()
  displaymsg=FALSE
  messages.n=NRecords("t\\bordb_in")
  find_tbl("d\\cis_dup",FALSE)
  find_tbl("d\\cis_msg",FALSE)
;  EMPTY "d\\cis_msg"                  ;uncomment to empty prior to each load.
  find_tbl("t\\bordb_in",FALSE)
  MOVETO [text]
  CoEditKey

  SHOWDIALOG "CIS Message Parser"
    PROC "ParseMsgProc" IDLE TRIGGER "CANCEL","ARRIVE"
      @5,10 HEIGHT 12 WIDTH 60

      @1,20  ?? "Start  : "+ start_time
      @2,20 ??  "Current: "+ TIME()
      SLIDER
        @3,4 HORIZONTAL LENGTH 50
        MIN 0 MAX messages.n
        ARROWSTEP 1 PAGESTEP 1
        TAG "PercentDone"
      TO percentdone
      @4,4  ?? " 0          25          50          75        100"
      @6,21 ?? "Percent Complete"

      PUSHBUTTON
        @8,23 WIDTH 10
        "Cancel" CANCEL
        VALUE FALSE
        TAG "Cancel" TO exitcontrol

  ENDDIALOG

ENDPROC
WRITELIB libname first_pass_parse
RELEASE  PROCS   first_pass_parse


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
; At least one CIS from or to name does not parse out correctly....
;
; No messages are omitted,  nor are any records lost to the best of
; our knowledge....
;
;
PROC each_pass_parse()
  init_vars()
  MOVETO [t\bordb_in->text]

  init_vars()
  IF MATCH([],"#: .. ../..",msg_number,forum_number,forum_title) THEN
    Down
    date_time()
    Down
  ENDIF

  IF MATCH([],"Sb: #..",message_subject) OR
    MATCH([],"Sb: ..",message_subject)
    THEN
    IF NUMVAL(SUBSTR(message_subject,1,1))<>"Error"
      THEN; this is a reply to another message number <MAYBE>!
      kk=MATCH(message_subject,"..-..",reply_msg_number,message_subject)
    ENDIF
    Down
  ENDIF

  IF MATCH([],"Sb: ..Announce..") THEN
    reply_msg_number=""
    message_subject="Announcement"
    Down
  ENDIF

  IF MATCH([],"Fm: ..",from_str) THEN
    IF MATCH(from_str,"..(X)..",set1,set2) THEN
      setn=set1+set2
    ELSE
      setn=from_str
    ENDIF
    r.l=MATCH(setn,"..@@@@@@,@@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,t5,bstr)
    IF NOT r.l THEN
      r.l=MATCH(setn,"..@@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,bstr)
      IF NOT r.l THEN
        r.l=MATCH(setn,"..@@@@@@,@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,bstr)
        IF NOT r.l THEN
          r.l=MATCH(setn,"..@@@@@@,@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,bstr)
          IF NOT r.l THEN
            r.l=MATCH(setn,"..@@@@@@,@..",astr,f1,f2,f3,f4,f5,f6,t1,bstr)
          ENDIF
        ENDIF
      ENDIF
    ENDIF
    IF NOT r.l THEN
      t.l=MATCH(setn,"..@@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,bstr)
      IF NOT t.l THEN
        t.l=MATCH(setn,"..@@@@@@,@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,bstr)
        IF NOT t.l THEN
          t.l=MATCH(setn,"..@@@@@@,@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,bstr)
          IF NOT t.l THEN
            t.l=MATCH(setn,"..@@@@@@,@..",astr,f1,f2,f3,f4,f5,f6,t1,bstr)
          ENDIF
        ENDIF
      ENDIF
      IF NOT t.l THEN
        a.l=MATCH(setn,"..@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,t1,t2,t3,t4,bstr)
        IF NOT a.l THEN
          a.l=MATCH(setn,"..@@@@@,@@@..",astr,f1,f2,f3,f4,f5,t1,t2,t3,bstr)
          IF NOT a.l THEN
            a.l=MATCH(setn,"..@@@@@,@@..",astr,f1,f2,f3,f4,f5,t1,t2,bstr)
            IF NOT a.l THEN
              a.l=MATCH(setn,"..@@@@@,@..",astr,f1,f2,f3,f4,f5,t1,bstr)
            ENDIF
          ENDIF
        ENDIF
        IF a.l THEN
          f_cis_id=f1+f2+f3+f4+f5+","+t1+t2+t3+t4
        ENDIF
      ELSE
        f_cis_id=f1+f2+f3+f4+f5+f6+","+t1+t2+t3+t4
      ENDIF
    ELSE
      f_cis_id=f1+f2+f3+f4+f5+f6+","+t1+t2+t3+t4+t5
    ENDIF

    IF a.l OR r.l OR t.l THEN
      b1=MATCH(astr,"..(..)..",str1["1"],f_group_name,str3["1"])
      b2=MATCH(astr,"..[..]..",str1["2"],f_group_name,str3["2"])
      b3=MATCH(astr,"..<..>..",str1["3"],f_group_name,str3["3"])
      b4=MATCH(bstr,"..(..)..",str1["4"],f_group_name,str3["4"])
      b5=MATCH(bstr,"..[..]..",str1["5"],f_group_name,str3["5"])
      b6=MATCH(bstr,"..<..>..",str1["6"],f_group_name,str3["6"])
    ELSE
      b1=MATCH(setn,"..(..)..",str1["1"],f_group_name,str3["1"])
      b2=MATCH(setn,"..[..]..",str1["2"],f_group_name,str3["2"])
      b3=MATCH(setn,"..<..>..",str1["3"],f_group_name,str3["3"])
      IF IsAssigned(str1["1"]) THEN
        b4=MATCH(str1["1"],"..(..)..",str1["4"],f_group_name,str3["4"])
      ENDIF
      IF IsAssigned(str1["2"]) THEN
        b4=MATCH(str1["2"],"..(..)..",str1["5"],f_group_name,str3["5"])
      ENDIF
      IF IsAssigned(str1["3"]) THEN
        b4=MATCH(str1["3"],"..(..)..",str1["6"],f_group_name,str3["6"])
      ENDIF
    ENDIF

;        b1=MATCH(astr,"..(..)..",str1["1"],f_group_name,str1["b1"])
;        b2=MATCH(astr,"..[..]..",str1["2"],f_group_name,str1["b2"])
;        b3=MATCH(astr,"..<..>..",str1["3"],f_group_name,str1["b3"])
;        b4=MATCH(bstr,"..(..)..",str1["4"],f_group_name,str1["b4"])
;        b5=MATCH(bstr,"..[..]..",str1["5"],f_group_name,str1["b5"])
;        b6=MATCH(bstr,"..<..>..",str1["6"],f_group_name,str1["b6"])
    IF DYNARRAYSIZE(str1)>0 THEN
      FOREACH nn in str1
        IF IsAssigned(str3[nn]) THEN
          str1[nn]=str1[nn]+str3[nn]  ;re-join split string
        ENDIF
        WHILE MATCH(str1[nn]," ..",akstr1) str1[nn]=akstr1
        ENDWHILE
        WHILE MATCH(str1[nn],".. ",akstr1) str1[nn]=akstr1
        ENDWHILE
        c1=MATCH(str1[nn],".. .. ..",f_first,f_middle,f_last)
        IF NOT c1 THEN
          c2=MATCH(str1[nn],".. ..",f_first,f_last)
          IF NOT c2 THEN
            f_last=str1[nn]
          ENDIF
        ENDIF
      ENDFOREACH
    ELSE
      IF a.l OR t.l OR r.l THEN
        str1["1"]=astr+bstr
      ELSE
        str1["1"]=setn
      ENDIF
      WHILE MATCH(str1["1"]," ..",akstr1) str1["1"]=akstr1
      ENDWHILE
      WHILE MATCH(str1["1"],".. ",akstr1) str1["1"]=akstr1
      ENDWHILE
      c1=MATCH(str1["1"],".. .. ..",f_first,f_middle,f_last)
      IF NOT c1 THEN
        c2=MATCH(str1["1"],".. ..",f_first,f_last)
        IF NOT c2 THEN
          f_last=str1["1"]
        ENDIF
      ENDIF
    ENDIF
    Down
  ENDIF

  r.l=FALSE
  a.l=FALSE
  t.l=FALSE
  astr="" bstr="" set1="" set2=""
  f1="" f2="" f3="" f4="" f5="" f5="" t1="" t2="" t3="" t4="" t5="" f6=""

  IF MATCH([],"To: ..",to_str) THEN

    r.l=FALSE a.l=FALSE t.l=FALSE astr="" bstr="" set1="" set2="" setn=""
    f1="" f2="" f3="" f4="" f5="" f6="" t1="" t2="" t3="" t4="" t5=""
    IF MATCH(to_str,"..(X)..",set1,set2)  THEN
      setn=set1+set2
    ELSE
      setn=to_str
    ENDIF
    r.l=MATCH(setn,"..@@@@@@,@@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,t5,bstr)
    IF NOT r.l THEN
      r.l=MATCH(setn,"..@@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,bstr)
      IF NOT r.l THEN
        r.l=MATCH(setn,"..@@@@@@,@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,bstr)
        IF NOT r.l THEN
          r.l=MATCH(setn,"..@@@@@@,@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,bstr)
          IF NOT r.l THEN
            r.l=MATCH(setn,"..@@@@@@,@..",astr,f1,f2,f3,f4,f5,f6,t1,bstr)
          ENDIF
        ENDIF
      ENDIF
    ENDIF
    IF NOT r.l THEN
      t.l=MATCH(setn,"..@@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,t4,bstr)
      IF NOT t.l THEN
        t.l=MATCH(setn,"..@@@@@@,@@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,t3,bstr)
        IF NOT t.l THEN
          t.l=MATCH(setn,"..@@@@@@,@@..",astr,f1,f2,f3,f4,f5,f6,t1,t2,bstr)
          IF NOT t.l THEN
            t.l=MATCH(setn,"..@@@@@@,@..",astr,f1,f2,f3,f4,f5,f6,t1,bstr)
          ENDIF
        ENDIF
      ENDIF
      IF NOT t.l THEN
        a.l=MATCH(setn,"..@@@@@,@@@@..",astr,f1,f2,f3,f4,f5,t1,t2,t3,t4,bstr)
        IF NOT a.l THEN
          a.l=MATCH(setn,"..@@@@@,@@@..",astr,f1,f2,f3,f4,f5,t1,t2,t3,bstr)
          IF NOT a.l THEN
            a.l=MATCH(setn,"..@@@@@,@@..",astr,f1,f2,f3,f4,f5,t1,t2,bstr)
            IF NOT a.l THEN
              a.l=MATCH(setn,"..@@@@@,@..",astr,f1,f2,f3,f4,f5,t1,bstr)
            ENDIF
          ENDIF
        ENDIF
        IF a.l THEN
          t_cis_id=f1+f2+f3+f4+f5+","+t1+t2+t3+t4
        ENDIF
      ELSE
        t_cis_id=f1+f2+f3+f4+f5+f6+","+t1+t2+t3+t4
      ENDIF
    ELSE
      t_cis_id=f1+f2+f3+f4+f5+f6+","+t1+t2+t3+t4+t5
    ENDIF
    IF a.l OR r.l OR t.l THEN
      b1=MATCH(astr,"..(..)..",str2["1"],t_group_name,str4["1"])
      b2=MATCH(astr,"..[..]..",str2["2"],t_group_name,str4["2"])
      b3=MATCH(astr,"..<..>..",str2["3"],t_group_name,str4["3"])
      b4=MATCH(bstr,"..(..)..",str2["4"],t_group_name,str4["4"])
      b5=MATCH(bstr,"..[..]..",str2["5"],t_group_name,str4["5"])
      b6=MATCH(bstr,"..<..>..",str2["6"],t_group_name,str4["6"])
    ELSE
      b1=MATCH(setn,"..(..)..",str2["1"],t_group_name,str4["1"])
      b2=MATCH(setn,"..[..]..",str2["2"],t_group_name,str4["2"])
      b3=MATCH(setn,"..<..>..",str2["3"],t_group_name,str4["3"])
      IF IsAssigned(str2["1"]) THEN
        b4=MATCH(str2["1"],"..(..)..",str2["4"],t_group_name,str4["4"])
      ENDIF
      IF IsAssigned(str2["2"]) THEN
        b4=MATCH(str2["2"],"..(..)..",str2["5"],t_group_name,str4["5"])
      ENDIF
      IF IsAssigned(str2["3"]) THEN
        b4=MATCH(str2["3"],"..(..)..",str2["6"],t_group_name,str4["6"])
      ENDIF
    ENDIF
    IF DYNARRAYSIZE(str2)>0 THEN
      FOREACH nn in str2
        IF IsAssigned(str4[nn]) THEN
          str2[nn]=str2[nn]+str4[nn]  ;re-join split string if req'd.
        ENDIF
        akstr2=""
        WHILE MATCH(str2[nn]," ..",akstr2) str2[nn]=akstr2
        ENDWHILE
        WHILE MATCH(str2[nn],".. ",akstr2) str2[nn]=akstr2
        ENDWHILE
        c1=MATCH(str2[nn],".. .. ..",t_first,t_middle,t_last)
        IF NOT c1 THEN
          c2=MATCH(str2[nn],".. ..",t_first,t_last)
          IF NOT c2 THEN
            t_last=str2[nn]
          ENDIF
        ENDIF
      ENDFOREACH
    ELSE
      akstr2=""
      IF a.l OR r.l OR t.l THEN
        str2["1"]=astr+bstr
      ELSE
        str2["1"]=setn
      ENDIF
      WHILE MATCH(str2["1"]," ..",akstr2) str2["1"]=akstr2
      ENDWHILE
      WHILE MATCH(str2["1"],".. ",akstr2) str2["1"]=akstr2
      ENDWHILE
      c1=MATCH(str2["1"],".. .. ..",t_first,t_middle,t_last)
      IF NOT c1 THEN
        c2=MATCH(str2["1"],".. ..",t_first,t_last)
        IF NOT c2 THEN
          t_last=str2["1"]
        ENDIF
      ENDIF
    ENDIF
    Down
  ENDIF
  insert_data()

ENDPROC
WRITELIB libname each_pass_parse
RELEASE  PROCS   each_pass_parse

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC init_vars()
  date_in=BLANKDATE()
  time_in =""
  msg_number =BLANKNUM()
  forum_number =""
  forum_title  =""
  f_middle=""
  f_first =""
  f_last  =""
  f_cis_id     =""
  f_group_name =""
  t_first =""
  t_middle=""
  t_last  =""
  t_cis_id     =""
  t_group_name =""
  message_subject=""
  reply_msg_number=BLANKNUM()
  msg_number=9999999999
  forum_title="BOGUS TITLE"
  DYNARRAY str1[]
  DYNARRAY str2[]
  DYNARRAY str3[]
  DYNARRAY str4[]
  r.l=FALSE a.l=FALSE t.l=FALSE astr="" bstr="" set1="" set2="" setn=""
  f1="" f2="" f3="" f4="" f5="" f6="" t1="" t2="" t3="" t4="" t5=""
ENDPROC
WRITELIB libname init_vars
RELEASE  PROCS   init_vars

;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC date_time()
  PRIVATE y,z,dd,hh,ss,mm
  y=MATCH([],"..-..-..",dd,mm,yr)
  IF y THEN
    dd=SUBSTR(dd,LEN(dd)-1,2)
    dd=dd+"-"+mm+"-"+SUBSTR(yr,1,2)
    IF DateVal(dd)<>"Error" THEN
      date_in=DateVal(dd)
    ENDIF
  ENDIF
  z=MATCH([],"..:..:..",hh,mm,ss)
  IF z THEN
    hh=SUBSTR(hh,LEN(hh)-1,2)
    ss=SUBSTR(ss,1,2)
    time_in=hh+":"+mm+":"+ss
    ;can also do conversion to other time formats here
  ENDIF
ENDPROC
WRITELIB libname date_time
RELEASE  PROCS   date_time


;
; Author    :   Larry Bradshaw
; Date      :   10/14/92
;
PROC insert_data()
  MOVETO [d\cis_msg->forum]
  End
  Down
  msg_num=RECNO()
  [date]=date_in
  [time]=time_in
  IF NUMVAL(msg_number)<>"Error" THEN
    [message number]=NUMVAL(msg_number)
  ENDIF
  IF NOT IsBlank(reply_msg_number) THEN
    IF NUMVAL(reply_msg_number)<>"Error" THEN
      [reply message number]=NUMVAL(reply_msg_number)
    ENDIF
  ENDIF
  [forum]=forum_number
  [forum title]=UPPER(forum_title)
  [from first] =UPPER(f_first)
  [from last]  =UPPER(f_last)
  [from middle]=UPPER(f_middle)
  [from cis id]=f_cis_id
  WHILE MATCH([from cis id]," ..",a) [from cis id]=a
  ENDWHILE
  [from group]=UPPER(f_group_name)
  [to first]  =UPPER(t_first)
  [to middle] =UPPER(t_middle)
  [to last]   =UPPER(t_last)
  [to cis id]=t_cis_id
  WHILE MATCH([to cis id]," ..",a) [to cis id]=a
  ENDWHILE
  [to group]=UPPER(t_group_name)
  [subject] =UPPER(message_subject)
  MOVETO [t\bordb_in->text]
  [d\cis_msg->message text]=[]+"\n"
  WHILE SUBSTR([],1,2)<>"#:"
    [d\cis_msg->message text]=[d\cis_msg->message text]+[]+"\n"
    IF RECNO()<messages.n THEN
      Down
    ELSE
      QUITLOOP
    ENDIF

;    FOREACH nn in topics
;      IF MATCH([],".."+nn+"..") THEN
;        [d\cis_msg->topics]=[d\cis_msg->topics]+nn+" "
;      ENDIF
;    ENDFOREACH
;    FOREACH nn in key_words
;      IF MATCH([],".."+nn+"..") THEN
;        [d\cis_msg->key words]=[d\cis_msg->key words]+nn+" "
;      ENDIF
;    ENDFOREACH
  ENDWHILE
  MOVETO "d\\cis_msg"
  POSTRECORD NOPOST LEAVELOCKED
  ;if postrecord failed,  then assume this is a duplicate record and
  ;stuff into the CIS_DUP table.
  IF NOT RETVAL THEN
    CopyToArray dup_record   ;there is a better way to copy records in 4.0...
    DEL
    MOVETO "d\\cis_dup"
    End
    Down
    CopyFromArray dup_record
    message "Duplicate found and saved"
  else
    message "Message parsed and saved"
  ENDIF
  MOVETO [t\bordb_in->text]
ENDPROC
WRITELIB libname insert_data
RELEASE  PROCS   insert_data
